# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Csr(Resource):
    """
    Certificate signing request object

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str csr_name: Name used to locate CSR object
    :param str distinguished_name: Distinguished name of certificate to be
     created
    :param str csr_string: Actual CSR string created
    :param str pfx_blob: PFX certifcate of created certificate
    :param str password: PFX password
    :param str public_key_hash: Hash of the certificates public key
    :param str hosting_environment: Hosting environment
    """

    _required = []

    _attribute_map = {
        'csr_name': {'key': 'properties.name', 'type': 'str', 'flatten': True},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str', 'flatten': True},
        'csr_string': {'key': 'properties.csrString', 'type': 'str', 'flatten': True},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'str', 'flatten': True},
        'password': {'key': 'properties.password', 'type': 'str', 'flatten': True},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str', 'flatten': True},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, csr_name=None, distinguished_name=None, csr_string=None, pfx_blob=None, password=None, public_key_hash=None, hosting_environment=None):
        super(Csr, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.csr_name = csr_name
        self.distinguished_name = distinguished_name
        self.csr_string = csr_string
        self.pfx_blob = pfx_blob
        self.password = password
        self.public_key_hash = public_key_hash
        self.hosting_environment = hosting_environment
