# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AddressResponse(Model):
    """
    Describes main public ip address and any extra vips

    :param str service_ip_address: Main public vip
    :param str internal_ip_address: VNET internal ip address of the
     hostingEnvironment (App Service Environment) if it is in internal
     load-balancing mode
    :param list outbound_ip_addresses: IP addresses appearing on outbound
     connections
    :param list vip_mappings: Additional vips
    """

    _required = []

    _attribute_map = {
        'service_ip_address': {'key': 'serviceIpAddress', 'type': 'str'},
        'internal_ip_address': {'key': 'internalIpAddress', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'outboundIpAddresses', 'type': '[str]'},
        'vip_mappings': {'key': 'vipMappings', 'type': '[VirtualIPMapping]'},
    }

    def __init__(self, service_ip_address=None, internal_ip_address=None, outbound_ip_addresses=None, vip_mappings=None):
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings
