# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientScriptForConnect(Model):
    """Client script details for file / folder restore.

    :param script_content: File content of the client script for file / folder
     restore.
    :type script_content: str
    :param script_extension: File extension of the client script for file /
     folder restore - .ps1 , .sh , etc.
    :type script_extension: str
    :param os_type: OS type - Windows, Linux etc. for which this file / folder
     restore client script works.
    :type os_type: str
    :param url: URL of Executable from where to source the content. If this is
     not null then ScriptContent should not be used
    :type url: str
    :param script_name_suffix: Mandatory suffix that should be added to the
     name of script that is given for download to user.
     If its null or empty then , ignore it.
    :type script_name_suffix: str
    """

    _attribute_map = {
        'script_content': {'key': 'scriptContent', 'type': 'str'},
        'script_extension': {'key': 'scriptExtension', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'script_name_suffix': {'key': 'scriptNameSuffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClientScriptForConnect, self).__init__(**kwargs)
        self.script_content = kwargs.get('script_content', None)
        self.script_extension = kwargs.get('script_extension', None)
        self.os_type = kwargs.get('os_type', None)
        self.url = kwargs.get('url', None)
        self.script_name_suffix = kwargs.get('script_name_suffix', None)
