# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Vault(Resource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The Azure Resource Manager resource ID for the key vault.
    :vartype id: str
    :param name: The name of the key vault.
    :type name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :param location: The supported Azure location where the key vault should
     be created.
    :type location: str
    :param tags: The tags that will be assigned to the key vault.
    :type tags: dict
    :param properties: Properties of the vault
    :type properties: :class:`VaultProperties
     <azure.keyvault.models.VaultProperties>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
    }

    def __init__(self, name, location, properties, tags=None):
        super(Vault, self).__init__(name=name, location=location, tags=tags)
        self.properties = properties
