# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AccessPolicyEntry(Model):
    """An array of 0 to 16 identities that have access to the key vault. All
    identities in the array must use the same tenant ID as the key vault's
    tenant ID.

    :param tenant_id: The Azure Active Directory tenant ID that should be
     used for authenticating requests to the key vault.
    :type tenant_id: str
    :param object_id: The object ID of a user or service principal in the
     Azure Active Directory tenant for the vault.
    :type object_id: str
    :param application_id:  Application ID of the client making request on
     behalf of a principal
    :type application_id: str
    :param permissions: Permissions the identity has for keys and secrets
    :type permissions: :class:`Permissions
     <azure.keyvault.models.Permissions>`
    """ 

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'Permissions'},
    }

    def __init__(self, tenant_id=None, object_id=None, application_id=None, permissions=None):
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions
