/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.cli.CommandLine;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.ImagePath;
import org.sikuli.script.RunTime;
import org.sikuli.script.Sikulix;
import org.sikuli.util.CommandArgs;
import org.sikuli.util.CommandArgsEnum;
import org.sikuli.util.JythonHelper;

public class Runner {
    static final String me = "Runner: ";
    static final int lvl = 3;
    static final RunTime runTime = RunTime.get();
    public static Map<String, String> endingTypes = new HashMap<String, String>();
    public static Map<String, String> typeEndings = new HashMap<String, String>();
    public static Map<String, String> runnerTypes = new HashMap<String, String>();
    public static String ERUBY = "rb";
    public static String EPYTHON = "py";
    public static String EJSCRIPT = "js";
    public static String EASCRIPT = "script";
    public static String ESSCRIPT = "ps1";
    public static String EPLAIN = "txt";
    public static String EDEFAULT = EPYTHON;
    public static String CPYTHON = "text/python";
    public static String CRUBY = "text/ruby";
    public static String CJSCRIPT = "text/javascript";
    public static String CASCRIPT = "text/applescript";
    public static String CSSCRIPT = "text/powershell";
    public static String CPLAIN = "text/plain";
    public static String RPYTHON = "jython";
    public static String RRUBY = "jruby";
    public static String RJSCRIPT = "JavaScript";
    public static String RASCRIPT = "AppleScript";
    public static String RSSCRIPT = "PowerShell";
    public static String RRSCRIPT = "Robot";
    public static String RDEFAULT = RPYTHON;
    private static String[] runScripts = null;
    private static String[] testScripts = null;
    private static int lastReturnCode = 0;
    private static String beforeJSjava8 = "load(\"nashorn:mozilla_compat.js\");";
    private static String beforeJS = "importPackage(Packages.org.sikuli.script); importClass(Packages.org.sikuli.basics.Debug); importClass(Packages.org.sikuli.basics.Settings);";
    static JythonHelper pyRunner;
    static Class cIDE;
    static Method mShow;
    static Method mHide;
    static Object rbRunner;
    static Object txtRunner;
    static ScriptEngine jsRunner;

    static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static String[] evalArgs(String[] args) {
        String cmdValue;
        CommandArgs cmdArgs = new CommandArgs("SCRIPT");
        CommandLine cmdLine = cmdArgs.getCommandLine(CommandArgs.scanArgs(args));
        if (cmdLine == null || cmdLine.getOptions().length == 0) {
            Runner.log(-1, "Did not find any valid option on command line!", new Object[0]);
            cmdArgs.printHelp();
            System.exit(1);
        }
        if (cmdLine.hasOption(CommandArgsEnum.HELP.shortname())) {
            cmdArgs.printHelp();
            System.exit(1);
        }
        if (cmdLine.hasOption(CommandArgsEnum.LOGFILE.shortname()) && !Debug.setLogFile((cmdValue = cmdLine.getOptionValue(CommandArgsEnum.LOGFILE.longname())) == null ? "" : cmdValue)) {
            System.exit(1);
        }
        if (cmdLine.hasOption(CommandArgsEnum.USERLOGFILE.shortname()) && !Debug.setUserLogFile((cmdValue = cmdLine.getOptionValue(CommandArgsEnum.USERLOGFILE.longname())) == null ? "" : cmdValue)) {
            System.exit(1);
        }
        if (cmdLine.hasOption(CommandArgsEnum.DEBUG.shortname())) {
            cmdValue = cmdLine.getOptionValue(CommandArgsEnum.DEBUG.longname());
            if (cmdValue == null) {
                Debug.setDebugLevel(3);
                Settings.LogTime = true;
                if (!Debug.isLogToFile()) {
                    Debug.setLogFile("");
                }
            } else {
                Debug.setDebugLevel(cmdValue);
            }
        }
        runTime.setArgs(cmdArgs.getUserArgs(), cmdArgs.getSikuliArgs());
        Runner.log(3, "commandline: %s", cmdArgs.getArgsOrg());
        runTime.printArgs();
        if (cmdLine.hasOption(CommandArgsEnum.INTERACTIVE.shortname()) && !cmdLine.hasOption(CommandArgsEnum.RUN.shortname()) && !cmdLine.hasOption(CommandArgsEnum.TEST.shortname())) {
            Runner.runTime.interactiveRunner = cmdLine.getOptionValue(CommandArgsEnum.INTERACTIVE.longname());
            Runner.runTime.runningInteractive = true;
            return null;
        }
        String[] runScripts = null;
        Runner.runTime.runningTests = false;
        if (cmdLine.hasOption(CommandArgsEnum.RUN.shortname())) {
            runScripts = cmdLine.getOptionValues(CommandArgsEnum.RUN.longname());
        } else if (cmdLine.hasOption(CommandArgsEnum.TEST.shortname())) {
            runScripts = cmdLine.getOptionValues(CommandArgsEnum.TEST.longname());
            Runner.log(-1, "Command line option -t: not yet supported! %s", Arrays.asList(args).toString());
            Runner.runTime.runningTests = true;
            System.exit(1);
        }
        return runScripts;
    }

    public static int run(String givenName) {
        return Runner.run(givenName, new String[0]);
    }

    public static int run(String givenName, String[] args) {
        String savePath = ImagePath.getBundlePathSet();
        int retVal = new RunBox(givenName, args, false).run();
        if (savePath != null) {
            ImagePath.setBundlePath(savePath);
        }
        lastReturnCode = retVal;
        return retVal;
    }

    public static int runTest(String givenName) {
        return Runner.runTest(givenName, new String[0]);
    }

    public static int runTest(String givenName, String[] args) {
        String savePath = ImagePath.getBundlePath();
        int retVal = new RunBox(givenName, args, true).run();
        ImagePath.setBundlePath(savePath);
        return retVal;
    }

    public static int getLastReturnCode() {
        return lastReturnCode;
    }

    public static int runScripts(String[] args) {
        runScripts = Runner.evalArgs(args);
        String someJS = "";
        int exitCode = 0;
        if (runScripts != null && runScripts.length > 0) {
            boolean runAsTest = Runner.runTime.runningTests;
            for (String givenScriptName : runScripts) {
                if (lastReturnCode == -1) {
                    Runner.log(3, "Exit code -1: Terminating multi-script-run", new Object[0]);
                    break;
                }
                someJS = runTime.getOption("runsetup", "");
                if (!someJS.isEmpty()) {
                    Runner.log(3, "Options.runsetup: %s", someJS);
                    new RunBox().runjs(null, null, someJS, null);
                }
                RunBox rb = new RunBox(givenScriptName, runTime.getArgs(), runAsTest);
                exitCode = rb.run();
                someJS = runTime.getOption("runteardown", "");
                if (!someJS.isEmpty()) {
                    Runner.log(3, "Options.runteardown: %s", someJS);
                    new RunBox().runjs(null, null, someJS, null);
                }
                if (exitCode == -999) {
                    exitCode = lastReturnCode;
                }
                lastReturnCode = exitCode;
            }
        }
        return exitCode;
    }

    public static File getScriptFile(File fScriptFolder) {
        if (fScriptFolder == null) {
            return null;
        }
        File[] content = FileManager.getScriptFile(fScriptFolder);
        if (null == content) {
            return null;
        }
        File fScript = null;
        for (File aFile : content) {
            for (String suffix : endingTypes.keySet()) {
                if (!aFile.getName().endsWith("." + suffix)) continue;
                fScript = aFile;
                break;
            }
            if (fScript != null) break;
        }
        return fScript;
    }

    protected static boolean initpy() {
        if (pyRunner == null) {
            pyRunner = JythonHelper.get();
            if (pyRunner == null) {
                return false;
            }
            pyRunner.exec("# -*- coding: utf-8 -*- ");
            pyRunner.exec("import org.sikuli.basics.SikulixForJython");
            pyRunner.exec("from sikuli import *");
        }
        return true;
    }

    public static ScriptEngine initjs() {
        ScriptEngineManager jsFactory = new ScriptEngineManager();
        ScriptEngine jsr = jsFactory.getEngineByName("JavaScript");
        if (jsr != null) {
            Runner.log(3, "ScriptingEngine started: JavaScript (ending .js)", new Object[0]);
        } else {
            runTime.terminate(1, "ScriptingEngine for JavaScript not available", new Object[0]);
        }
        if (RunTime.Type.IDE.equals((Object)Runner.runTime.runType)) {
            try {
                cIDE = Class.forName("org.sikuli.ide.SikuliIDE");
                mHide = cIDE.getMethod("hideIDE", new Class[0]);
                mShow = cIDE.getMethod("showIDE", new Class[0]);
            }
            catch (Exception ex) {
                Runner.log(-1, "initjs: getIDE", new Object[0]);
            }
        }
        return jsr;
    }

    public static String prologjs(String before) {
        String after = before;
        if (after.isEmpty()) {
            if (runTime.isJava8()) {
                after = after + beforeJSjava8;
            }
            after = after + beforeJS;
        } else {
            String commands = runTime.extractResourceToString("JavaScript", "commands.js", "");
            if (commands != null) {
                after = after + commands;
            }
        }
        return after;
    }

    public static Object[] runBoxInit(String givenName, File scriptProject, URL uScriptProject) {
        String gitScripts = "https://github.com/RaiMan/SikuliX-2014/tree/master/TestScripts/";
        String givenScriptHost = "";
        String givenScriptFolder = "";
        String givenScriptScript = "";
        String givenScriptType = "sikuli";
        String givenScriptScriptType = RDEFAULT;
        Boolean givenScriptExists = true;
        URL uGivenScript = null;
        Object uGivenScriptFile = null;
        String givenScriptName = givenName;
        String[] parts = null;
        boolean isInline = false;
        if ((givenName = givenName.trim()).toLowerCase().startsWith(RASCRIPT.toLowerCase())) {
            givenScriptScriptType = RASCRIPT;
            givenScriptName = null;
            givenScriptScript = givenName.substring(RASCRIPT.length() + 1);
            isInline = true;
        } else if (givenName.toLowerCase().startsWith(RSSCRIPT.toLowerCase())) {
            givenScriptScriptType = RSSCRIPT;
            givenScriptName = null;
            givenScriptScript = givenName.substring(RSSCRIPT.length() + 1);
            isInline = true;
        } else if (givenName.toLowerCase().startsWith(RRSCRIPT.toLowerCase())) {
            givenScriptScriptType = RRSCRIPT;
            givenScriptName = null;
            givenScriptScript = givenName.substring(RRSCRIPT.length() + 1);
            isInline = true;
        } else if (givenName.toLowerCase().startsWith("git*")) {
            givenName = givenName.length() == 4 ? gitScripts + "showcase" : gitScripts + givenName.substring(4);
        }
        if (!isInline) {
            boolean fromNet = false;
            String scriptLocation = givenName;
            String content = "";
            int isNet = givenName.indexOf("://");
            if (-1 < isNet && (givenName = givenName.substring(isNet + 3)).indexOf(":") == -1) {
                givenName = givenName.replaceFirst("/", ":");
            }
            if (givenName.indexOf(":") > 5) {
                parts = givenName.split(":");
                if (parts.length > 1 && !parts[1].isEmpty()) {
                    fromNet = true;
                    givenScriptHost = parts[0];
                    givenScriptName = new File(parts[1]).getName();
                    String fpFolder = new File(parts[1]).getParent();
                    if (null != fpFolder && !fpFolder.isEmpty()) {
                        givenScriptFolder = FileManager.slashify(fpFolder, true);
                    }
                }
                scriptLocation = givenName;
                givenScriptExists = false;
            }
            if (fromNet) {
                if (givenScriptHost.contains("github.com")) {
                    givenScriptHost = "https://raw.githubusercontent.com";
                    givenScriptFolder = givenScriptFolder.replace("tree/", "");
                } else {
                    givenScriptHost = "http://" + givenScriptHost;
                }
                if (givenScriptName.endsWith(".zip")) {
                    scriptLocation = givenScriptHost + givenScriptFolder + givenScriptName;
                    if (0 < FileManager.isUrlUseabel(scriptLocation)) {
                        runTime.terminate(1, ".zip from net not yet supported\n%s", scriptLocation);
                    }
                } else {
                    for (String suffix : endingTypes.keySet()) {
                        String dlsuffix = "";
                        if (suffix != "js") {
                            dlsuffix = ".txt";
                        }
                        givenScriptScript = givenScriptName + "/" + givenScriptName + "." + suffix;
                        scriptLocation = givenScriptHost + "/" + givenScriptFolder + givenScriptScript;
                        givenScriptScriptType = runnerTypes.get(suffix);
                        if (0 < FileManager.isUrlUseabel(scriptLocation)) {
                            content = FileManager.downloadURLtoString(scriptLocation);
                            break;
                        }
                        if (!dlsuffix.isEmpty()) {
                            givenScriptScript = givenScriptName + "/" + givenScriptName + "." + suffix + dlsuffix;
                            scriptLocation = givenScriptHost + "/" + givenScriptFolder + givenScriptScript;
                            if (0 < FileManager.isUrlUseabel(scriptLocation)) {
                                content = FileManager.downloadURLtoString(scriptLocation);
                                break;
                            }
                        }
                        scriptLocation = givenScriptHost + "/" + givenScriptFolder + givenScriptName;
                    }
                    if (content != null && !content.isEmpty()) {
                        givenScriptType = "NET";
                        givenScriptScript = content;
                        givenScriptExists = true;
                        try {
                            uGivenScript = new URL(givenScriptHost + "/" + givenScriptFolder + givenScriptName);
                        }
                        catch (Exception ex) {
                            givenScriptExists = false;
                        }
                    } else {
                        givenScriptExists = false;
                    }
                }
                if (!givenScriptExists.booleanValue()) {
                    Runner.log(-1, "given script location not supported or not valid:\n%s", scriptLocation);
                } else {
                    String header = "# ";
                    String trailer = "\n";
                    if (RJSCRIPT.equals(givenScriptScriptType)) {
                        header = "/*\n";
                        trailer = "*/\n";
                    }
                    header = header + scriptLocation + "\n";
                    if (Debug.is() > 2) {
                        FileManager.writeStringToFile(header + trailer + content, new File(Runner.runTime.fSikulixStore, "LastScriptFromNet.txt"));
                    }
                }
            } else {
                String scriptName;
                boolean sameFolder = givenScriptName.startsWith("./");
                if (sameFolder) {
                    givenScriptName = givenScriptName.substring(2);
                }
                if (givenScriptName.startsWith("JS*")) {
                    givenScriptName = new File(Runner.runTime.fSxProjectTestScriptsJS, givenScriptName.substring(3)).getPath();
                }
                if (givenScriptName.startsWith("TEST*")) {
                    givenScriptName = new File(Runner.runTime.fSxProjectTestScripts, givenScriptName.substring(5)).getPath();
                }
                if ((scriptName = new File(givenScriptName).getName()).contains(".")) {
                    parts = scriptName.split("\\.");
                    givenScriptScript = parts[0];
                    givenScriptType = parts[1];
                } else {
                    givenScriptScript = scriptName;
                }
                if (sameFolder && scriptProject != null) {
                    givenScriptName = new File(scriptProject, givenScriptName).getPath();
                } else if (sameFolder && uScriptProject != null) {
                    givenScriptHost = uScriptProject.getHost();
                    givenScriptFolder = uScriptProject.getPath().substring(1);
                } else if (scriptProject == null && givenScriptHost.isEmpty()) {
                    String fpParent = new File(givenScriptName).getParent();
                    scriptProject = fpParent == null || fpParent.isEmpty() ? null : new File(givenScriptName).getParentFile();
                }
            }
        }
        Object[] vars = new Object[]{givenScriptHost, givenScriptFolder, givenScriptName, givenScriptScript, givenScriptType, givenScriptScriptType, uGivenScript, uGivenScriptFile, givenScriptExists, scriptProject, uScriptProject};
        return vars;
    }

    public static void runjsEval(String script) {
        new RunBox().runjsEval(script);
    }

    public static int runjs(File fScript, URL uGivenScript, String givenScriptScript, String[] args) {
        return new RunBox().runjs(fScript, uGivenScript, givenScriptScript, args);
    }

    public static int runas(String givenScriptScript) {
        return Runner.runas(givenScriptScript, false);
    }

    public static int runrobot(String code) {
        File script = new File(ImagePath.getBundlePath());
        File fRobotWork = new File(script.getAbsolutePath() + ".robot");
        FileManager.deleteFileOrFolder(fRobotWork);
        fRobotWork.mkdir();
        String sName = script.getName().replace(".sikuli", "");
        File fPyCode = new File(script, sName + ".py");
        String pyCode = FileManager.readFileToString(fPyCode);
        int prefix = pyCode.indexOf("\"\"\")");
        if (prefix < 0) {
            Runner.log(-1, "runRobot: invalid robot text structure", new Object[0]);
            return -1;
        }
        pyCode = pyCode.substring(prefix + 4).trim();
        int refLib = code.indexOf("./inline/");
        String sLib = "";
        File fInline = null;
        String fpInline = "";
        if (!pyCode.isEmpty()) {
            if (refLib < 0) {
                Runner.log(-1, "runRobot: invalid robot text structure", new Object[0]);
                return -1;
            }
            sLib = code.substring(refLib + 9);
            sLib = sLib.substring(0, sLib.indexOf("\n")).trim();
        } else {
            if (refLib > -1) {
                Runner.log(-1, "runRobot: invalid robot text structure", new Object[0]);
                return -1;
            }
            refLib = code.indexOf("./jar/");
            if (refLib > -1) {
                sLib = code.substring(refLib + 6);
                fInline = new File((sLib = sLib.substring(0, sLib.indexOf("\n")).trim()) + ".jar");
                if (!fInline.isAbsolute()) {
                    fInline = new File(fRobotWork, sLib + ".jar");
                }
                runTime.addToClasspath(fInline.getAbsolutePath());
                sLib = "";
            }
        }
        if (!sLib.isEmpty()) {
            fInline = new File(fRobotWork, sLib + ".py");
            FileManager.writeStringToFile(pyCode, fInline);
            fpInline = FileManager.slashify(fInline.getAbsolutePath(), false);
            code = code.replace("./inline/" + sLib, fpInline);
        }
        File fRobot = new File(fRobotWork, sName + ".robot");
        FileManager.writeStringToFile(code, fRobot);
        if (!Runner.initpy()) {
            Runner.log(-1, "Running Python scripts:init failed", new Object[0]);
            return -999;
        }
        pyRunner.exec("from sikuli import *;");
        pyRunner.exec("import robot.run;");
        pyRunner.exec(String.format("robot.run(\"%s\", outputdir=\"%s\");", fRobot, fRobotWork));
        return 0;
    }

    public static int runas(String givenScriptScript, boolean silent) {
        if (!Runner.runTime.runningMac) {
            return -1;
        }
        String prefix = silent ? "!" : "";
        String osascriptShebang = "#!/usr/bin/osascript\n";
        givenScriptScript = osascriptShebang + givenScriptScript;
        File aFile = FileManager.createTempFile("script");
        aFile.setExecutable(true);
        FileManager.writeStringToFile(givenScriptScript, aFile);
        String retVal = runTime.runcmd(new String[]{prefix + aFile.getAbsolutePath()});
        String[] parts = retVal.split("\n");
        int retcode = -1;
        try {
            retcode = Integer.parseInt(parts[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (retcode != 0) {
            if (silent) {
                Runner.log(3, "AppleScript:\n%s\nreturned:\n%s", givenScriptScript, runTime.getLastCommandResult());
            } else {
                Runner.log(-1, "AppleScript:\n%s\nreturned:\n%s", givenScriptScript, runTime.getLastCommandResult());
            }
        }
        return retcode;
    }

    public static int runps(String givenScriptScript) {
        if (!Runner.runTime.runningWindows) {
            return -1;
        }
        File aFile = FileManager.createTempFile("ps1");
        FileManager.writeStringToFile(givenScriptScript, aFile);
        String[] psDirect = new String[]{"powershell.exe", "-ExecutionPolicy", "UnRestricted", "-NonInteractive", "-NoLogo", "-NoProfile", "-WindowStyle", "Hidden", "-File", aFile.getAbsolutePath()};
        String[] psCmdType = new String[]{"cmd.exe", "/S", "/C", "type " + aFile.getAbsolutePath() + " | powershell -noprofile -"};
        String retVal = runTime.runcmd(psCmdType);
        String[] parts = retVal.split("\\s");
        int retcode = -1;
        try {
            retcode = Integer.parseInt(parts[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (retcode != 0) {
            Runner.log(-1, "PowerShell:\n%s\nreturned:\n%s", givenScriptScript, runTime.getLastCommandResult());
        }
        return retcode;
    }

    public static int runpy(File fScript, URL uGivenScript, String givenScriptScript, String[] args) {
        new RunBox();
        return RunBox.runpy(fScript, uGivenScript, givenScriptScript, args);
    }

    public static int runrb(File fScript, URL uGivenScript, String givenScriptScript, String[] args) {
        new RunBox();
        return RunBox.runrb(fScript, uGivenScript, givenScriptScript, args);
    }

    public static int runtxt(File fScript, URL uGivenScript, String givenScriptScript, String[] args) {
        new RunBox();
        return RunBox.runtxt(fScript, uGivenScript, givenScriptScript, args);
    }

    static {
        endingTypes.put(EPYTHON, CPYTHON);
        endingTypes.put(ERUBY, CRUBY);
        endingTypes.put(EJSCRIPT, CJSCRIPT);
        endingTypes.put(EPLAIN, CPLAIN);
        for (String k : endingTypes.keySet()) {
            typeEndings.put(endingTypes.get(k), k);
        }
        runnerTypes.put(EPYTHON, RPYTHON);
        runnerTypes.put(ERUBY, RRUBY);
        runnerTypes.put(EJSCRIPT, RJSCRIPT);
        pyRunner = null;
        rbRunner = null;
        txtRunner = null;
        jsRunner = null;
    }

    static class RunBox {
        String jsScript;
        RunTime runTime = RunTime.get();
        boolean asTest = false;
        String[] args = new String[0];
        String givenScriptHost = "";
        String givenScriptFolder = "";
        String givenScriptName = "";
        String givenScriptScript = "";
        String givenScriptType = "sikuli";
        String givenScriptScriptType = RDEFAULT;
        URL uGivenScript = null;
        URL uGivenScriptFile = null;
        boolean givenScriptExists = true;

        public RunBox() {
        }

        public static int runtxt(File fScript, URL script, String scriptName, String[] args) {
            Runner.log(-1, "Running plain text scripts not yet supported!", new Object[0]);
            return -999;
        }

        public static int runrb(File fScript, URL script, String scriptName, String[] args) {
            Runner.log(-1, "Running Ruby scripts not yet supported!", new Object[0]);
            return -999;
        }

        public static int runpy(File fScript, URL script, String scriptName, String[] args) {
            int retval;
            String fpScript = fScript == null ? script.toExternalForm() : fScript.getAbsolutePath();
            if (!Runner.initpy()) {
                Runner.log(-1, "Running Python scripts:init failed", new Object[0]);
                return -999;
            }
            if (args == null || args.length == 0) {
                args = RunTime.get().getArgs();
            }
            String[] newArgs = new String[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i + 1] = args[i];
            }
            pyRunner.setSysArgv(newArgs);
            newArgs[0] = fpScript;
            if (fScript == null) {
                ImagePath.addHTTP(fpScript);
                retval = pyRunner.exec(scriptName) ? 0 : -1;
                ImagePath.removeHTTP(fpScript);
            } else {
                if (null == ImagePath.getBundlePathSet()) {
                    ImagePath.setBundlePath(fScript.getParent());
                } else {
                    ImagePath.add(fScript.getParent());
                }
                retval = pyRunner.execfile(fpScript);
            }
            return retval;
        }

        public void runjsEval(String script) {
            if (script.isEmpty()) {
                return;
            }
            String initSikulix = "";
            if (jsRunner == null) {
                jsRunner = Runner.initjs();
                initSikulix = Runner.prologjs(initSikulix);
            }
            try {
                if (!initSikulix.isEmpty()) {
                    initSikulix = Runner.prologjs(initSikulix);
                    jsRunner.eval(initSikulix);
                }
                Runner.log(3, "JavaScript: eval: %s", script);
                this.jsScript = script;
                Thread evalThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            mHide.invoke(null, (Object[])new Class[0]);
                            jsRunner.eval(RunBox.this.jsScript);
                            mShow.invoke(null, (Object[])new Class[0]);
                        }
                        catch (Exception ex) {
                            Runner.log(-1, "not possible:\n%s", ex);
                            try {
                                mShow.invoke(null, (Object[])new Class[0]);
                            }
                            catch (Exception e) {
                                Sikulix.terminate(901);
                            }
                        }
                    }
                };
                evalThread.start();
            }
            catch (Exception ex) {
                Runner.log(-1, "init not possible:\n%s", ex);
            }
        }

        public int runjs(File fScript, URL script, String scriptName, String[] args) {
            String initSikulix = "";
            if (jsRunner == null) {
                jsRunner = Runner.initjs();
                initSikulix = Runner.prologjs(initSikulix);
            }
            try {
                if (null != fScript) {
                    File innerBundle = new File(fScript.getParentFile(), scriptName + ".sikuli");
                    if (innerBundle.exists()) {
                        ImagePath.setBundlePath(innerBundle.getCanonicalPath());
                    } else {
                        ImagePath.setBundlePath(fScript.getParent());
                    }
                } else if (script != null) {
                    ImagePath.addHTTP(script.toExternalForm());
                    String sname = new File(script.toExternalForm()).getName();
                    ImagePath.addHTTP(script.toExternalForm() + "/" + sname + ".sikuli");
                }
                if (!initSikulix.isEmpty()) {
                    initSikulix = Runner.prologjs(initSikulix);
                    jsRunner.eval(initSikulix);
                    initSikulix = "";
                }
                if (null != fScript) {
                    jsRunner.eval(new FileReader(fScript));
                } else {
                    jsRunner.eval(scriptName);
                }
            }
            catch (Exception ex) {
                Runner.log(-1, "not possible:\n%s", ex);
            }
            return 0;
        }

        RunBox(String givenName, String[] givenArgs, boolean isTest) {
            Object[] vars = Runner.runBoxInit(givenName, RunTime.scriptProject, RunTime.uScriptProject);
            this.givenScriptHost = (String)vars[0];
            this.givenScriptFolder = (String)vars[1];
            this.givenScriptName = (String)vars[2];
            this.givenScriptScript = (String)vars[3];
            this.givenScriptType = (String)vars[4];
            this.givenScriptScriptType = (String)vars[5];
            this.uGivenScript = (URL)vars[6];
            this.uGivenScriptFile = (URL)vars[7];
            this.givenScriptExists = (Boolean)vars[8];
            RunTime.scriptProject = (File)vars[9];
            RunTime.uScriptProject = (URL)vars[10];
            this.args = givenArgs;
            this.asTest = isTest;
        }

        int run() {
            if (RASCRIPT.equals(this.givenScriptScriptType)) {
                return Runner.runas(this.givenScriptScript);
            }
            if (RSSCRIPT.equals(this.givenScriptScriptType)) {
                return Runner.runps(this.givenScriptScript);
            }
            if (RRSCRIPT.equals(this.givenScriptScriptType)) {
                return Runner.runrobot(this.givenScriptScript);
            }
            int exitCode = 0;
            Runner.log(3, "givenScriptName:\n%s", this.givenScriptName);
            if (-1 == FileManager.slashify(this.givenScriptName, false).indexOf("/") && RunTime.scriptProject != null) {
                this.givenScriptName = new File(RunTime.scriptProject, this.givenScriptName).getPath();
            }
            if (this.givenScriptName.endsWith(".skl")) {
                Runner.log(-1, "RunBox.run: .skl scripts not yet supported.", new Object[0]);
                return -9999;
            }
            if ("NET".equals(this.givenScriptType)) {
                if (RJSCRIPT.equals(this.givenScriptScriptType)) {
                    exitCode = this.runjs(null, this.uGivenScript, this.givenScriptScript, this.args);
                } else if (RPYTHON.equals(this.givenScriptScriptType)) {
                    exitCode = RunBox.runpy(null, this.uGivenScript, this.givenScriptScript, this.args);
                } else {
                    Runner.log(-1, "running from net not supported for %s\n%s", this.givenScriptScriptType, this.uGivenScript);
                }
            } else {
                File fScript = Runner.getScriptFile(new File(this.givenScriptName));
                if (fScript == null) {
                    return -9999;
                }
                fScript = new File(FileManager.normalizeAbsolute(fScript.getPath(), true));
                if (null == RunTime.scriptProject) {
                    RunTime.scriptProject = fScript.getParentFile().getParentFile();
                }
                Runner.log(3, "Trying to run script:\n%s", fScript);
                if (fScript.getName().endsWith(EJSCRIPT)) {
                    exitCode = this.runjs(fScript, null, this.givenScriptScript, this.args);
                } else if (fScript.getName().endsWith(EPYTHON)) {
                    exitCode = RunBox.runpy(fScript, null, this.givenScriptScript, this.args);
                } else if (fScript.getName().endsWith(ERUBY)) {
                    exitCode = RunBox.runrb(fScript, null, this.givenScriptScript, this.args);
                } else if (fScript.getName().endsWith(EPLAIN)) {
                    exitCode = RunBox.runtxt(fScript, null, this.givenScriptScript, this.args);
                } else {
                    Runner.log(-1, "Running not supported currently for:\n%s", fScript);
                    return -9999;
                }
            }
            return exitCode;
        }
    }
}

