/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.natives.OSUtil;
import org.sikuli.script.App;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;

public class WinUtil
implements OSUtil {
    @Override
    public void checkLibAvailability() {
        RunTime.loadLibrary("WinUtil");
    }

    @Override
    public App.AppEntry getApp(int appPID, String appName) {
        String thePID;
        String theName;
        String theWindow;
        int nl;
        String cmd;
        String[] parts;
        if (appPID == 0) {
            return null;
        }
        App.AppEntry app = null;
        Object filter = appPID < 0 ? appName : Integer.valueOf(appPID);
        String name = "";
        String execName = "";
        String options = "";
        Integer pid = -1;
        if (filter instanceof String) {
            name = (String)filter;
            if (name.startsWith("!")) {
                execName = name = name.substring(1);
            } else {
                if (name.startsWith("\"")) {
                    parts = name.substring(1).split("\"");
                    if (parts.length > 1) {
                        options = name.substring(parts[0].length() + 3);
                        name = "\"" + parts[0] + "\"";
                    }
                } else {
                    parts = name.split(" ");
                    if (parts.length > 1) {
                        options = name.substring(parts[0].length() + 1);
                        name = parts[0];
                    }
                }
                execName = name.startsWith("\"") ? new File(name.substring(1, name.length() - 1)).getName().toUpperCase() : new File(name).getName().toUpperCase();
            }
        } else if (filter instanceof Integer) {
            pid = (Integer)filter;
        } else {
            return app;
        }
        Debug.log(3, "WinUtil.getApp: %s", filter);
        if (pid < 0) {
            cmd = "!tasklist /V /FO CSV /NH /FI \"SESSIONNAME eq Console\"";
            cmd = "!tasklist /V /FO CSV /NH /FI \"SESSIONNAME eq Console\"";
        } else {
            cmd = "!tasklist /V /FO CSV /NH /FI \"PID eq " + pid.toString() + "\"";
        }
        String result = RunTime.get().runcmd(cmd);
        String[] lines = result.split("\r\n");
        if ("0".equals(lines[0].trim())) {
            for (nl = 1; nl < lines.length; ++nl) {
                parts = lines[nl].split("\"");
                if (parts.length < 2) continue;
                theWindow = parts[parts.length - 1];
                theName = parts[1];
                thePID = parts[3];
                if (!name.isEmpty()) {
                    if ((!theName.toUpperCase().contains(execName) || theWindow.contains("N/A")) && !theWindow.contains(name)) continue;
                    return new App.AppEntry(theName, thePID, theWindow, "", "");
                }
                try {
                    if (Integer.parseInt(thePID) != pid) continue;
                    return new App.AppEntry(theName, thePID, theWindow, "", "");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        } else {
            Debug.logp(result, new Object[0]);
        }
        if (!options.isEmpty()) {
            return new App.AppEntry(name, "", "", "", options);
        }
        if (app == null) {
            cmd = String.format("!tasklist /V /FO CSV /NH /FI \"IMAGENAME eq %s\"", execName);
            result = RunTime.get().runcmd(cmd);
            lines = result.split("\r\n");
            if ("0".equals(lines[0].trim())) {
                for (nl = 1; nl < lines.length; ++nl) {
                    parts = lines[nl].split("\"");
                    if (parts.length < 2) continue;
                    theWindow = parts[parts.length - 1];
                    theName = parts[1];
                    thePID = parts[3];
                    if (theWindow.contains("N/A")) continue;
                    app = new App.AppEntry(theName, thePID, theWindow, "", "");
                    break;
                }
            }
        }
        return app;
    }

    @Override
    public Map<Integer, String[]> getApps(String name) {
        String cmd;
        HashMap<Integer, String[]> apps = new HashMap<Integer, String[]>();
        if (name == null || name.isEmpty()) {
            cmd = "!tasklist /V /FO CSV /NH /FI \"SESSIONNAME eq Console\"";
            cmd = "!tasklist /V /FO CSV /NH /FI \"SESSIONNAME eq Console\"";
        } else {
            cmd = String.format("!tasklist /V /FO CSV /NH /FI \"IMAGENAME eq %s\"", name);
        }
        String result = RunTime.get().runcmd(cmd);
        String[] lines = result.split("\r\n");
        if ("0".equals(lines[0].trim())) {
            for (int nl = 1; nl < lines.length; ++nl) {
                String[] parts = lines[nl].split("\"");
                if (parts.length < 3) continue;
                String theWindow = parts[parts.length - 1];
                String thePID = parts[3];
                String theName = parts[1];
                Integer pid = -1;
                try {
                    pid = Integer.parseInt(thePID);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (pid == -1) continue;
                if (theWindow.contains("N/A")) {
                    pid = -pid.intValue();
                }
                apps.put(pid, new String[]{theName, theWindow});
            }
        } else {
            Debug.logp(result, new Object[0]);
        }
        return apps;
    }

    @Override
    public int isRunning(App.AppEntry app) {
        if (app.pid > 0) {
            return 1;
        }
        if (app.name.isEmpty()) {
            return -1;
        }
        if (this.getWindow(app.name, 0) != null) {
            return 1;
        }
        App.AppEntry ae = this.getApp(app.pid, app.name);
        if (ae != null && ae.pid > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int open(String appName) {
        int pid = this.openApp(appName);
        return pid < 1 ? -1 : pid;
    }

    @Override
    public int open(App.AppEntry app) {
        int pid;
        if (app.pid > -1) {
            return this.switchApp(app.pid, 0);
        }
        String cmd = app.execName;
        if (!app.options.isEmpty()) {
            cmd = cmd + " " + app.options;
        }
        return (pid = this.openApp(cmd)) < 1 ? -1 : pid;
    }

    @Override
    public int switchto(String appName) {
        return this.switchApp(appName, 0);
    }

    @Override
    public int switchto(String appName, int winNum) {
        return this.switchApp(appName, winNum);
    }

    @Override
    public int switchto(int pid, int num) {
        return this.switchApp(pid, num);
    }

    @Override
    public int switchto(App.AppEntry app, int num) {
        if (app.pid > -1) {
            String wname = app.window;
            if (wname.startsWith("!")) {
                wname = wname.substring(1);
            }
            return this.switchto(wname, 0);
        }
        if (app.window.startsWith("!")) {
            String token = app.window.substring(1);
            if (!token.isEmpty()) {
                return this.switchto(token, 0);
            }
            App.AppEntry newApp = this.getApp(app.pid, app.name);
            if (newApp == null) {
                return this.switchto(app.execName, 0);
            }
            return this.switchto(newApp.window, 0);
        }
        return this.switchto(app.execName, num);
    }

    @Override
    public int close(String appName) {
        return this.closeApp(appName);
    }

    @Override
    public int close(int pid) {
        return this.closeApp(pid);
    }

    @Override
    public int close(App.AppEntry app) {
        if (app.pid > -1) {
            return this.closeApp(app.pid);
        }
        if (app.window.startsWith("!")) {
            String token = app.window.substring(1);
            if (!token.isEmpty()) {
                this.switchto(app.window.substring(1), 0);
                RunTime.pause(1);
                new Screen().type("\ue014", "\ue022");
                return 0;
            }
            app = this.getApp(app.pid, app.name);
        }
        if (app != null) {
            if (app.pid > -1) {
                return this.closeApp(app.pid);
            }
            return this.closeApp(app.execName.replaceAll("\"", ""));
        }
        return -1;
    }

    public native int switchApp(String var1, int var2);

    public native int switchApp(int var1, int var2);

    public native int openApp(String var1);

    public native int closeApp(String var1);

    public native int closeApp(int var1);

    @Override
    public Rectangle getWindow(String appName) {
        return this.getWindow(appName, 0);
    }

    @Override
    public Rectangle getWindow(int pid) {
        return this.getWindow(pid, 0);
    }

    @Override
    public Rectangle getWindow(String appName, int winNum) {
        long hwnd = WinUtil.getHwnd(appName, winNum);
        return this._getWindow(hwnd, winNum);
    }

    @Override
    public Rectangle getWindow(int pid, int winNum) {
        long hwnd = WinUtil.getHwnd(pid, winNum);
        return this._getWindow(hwnd, winNum);
    }

    @Override
    public Rectangle getFocusedWindow() {
        Rectangle rect = WinUtil.getFocusedRegion();
        return rect;
    }

    @Override
    public native void bringWindowToFront(Window var1, boolean var2);

    private static native long getHwnd(String var0, int var1);

    private static native long getHwnd(int var0, int var1);

    private static native Rectangle getRegion(long var0, int var2);

    private static native Rectangle getFocusedRegion();

    private Rectangle _getWindow(long hwnd, int winNum) {
        Rectangle rect = WinUtil.getRegion(hwnd, winNum);
        return rect;
    }
}

