/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.servlet;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.robotframework.javalib.util.StdStreamRedirecter;
import org.robotframework.remoteserver.servlet.RemoteServerServlet;

public class ServerMethods {
    private Log log;
    private RemoteServerServlet servlet;
    private static List<String> genericExceptions = Arrays.asList("AssertionError", "AssertionFailedError", "Exception", "Error", "RuntimeError", "RuntimeException", "DataError", "TimeoutError", "RemoteError");
    String[] logLevelPrefixes = new String[]{"*TRACE*", "*DEBUG*", "*INFO*", "*HTML*", "*WARN*"};

    public ServerMethods(RemoteServerServlet servlet) {
        this.log = LogFactory.getLog(ServerMethods.class);
        this.servlet = servlet;
    }

    public String[] get_keyword_names() {
        try {
            String[] names = this.servlet.getLibrary().getKeywordNames();
            if (names == null || names.length == 0) {
                throw new RuntimeException("No keywords found in the test library");
            }
            String[] newNames = Arrays.copyOf(names, names.length + 1);
            newNames[names.length] = "stop_remote_server";
            return newNames;
        }
        catch (Throwable e) {
            this.log.warn("", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> run_keyword(String keyword, Object[] args, Map<String, Object> kwargs) {
        StdStreamRedirecter redirector;
        HashMap<String, Object> result;
        block26: {
            result = new HashMap<String, Object>();
            redirector = new StdStreamRedirecter();
            redirector.redirectStdStreams();
            try {
                result.put("status", "PASS");
                Object retObj = "";
                if (keyword.equalsIgnoreCase("stop_remote_server")) {
                    retObj = this.stopRemoteServer();
                } else {
                    try {
                        retObj = this.servlet.getLibrary().runKeyword(keyword, args, kwargs);
                    }
                    catch (Exception e) {
                        if (this.illegalArgumentIn(e)) {
                            for (int i = 0; i < args.length; ++i) {
                                args[i] = this.arraysToLists(args[i]);
                            }
                            retObj = this.servlet.getLibrary().runKeyword(keyword, args, kwargs);
                        }
                        throw e;
                    }
                }
                if (retObj == null || retObj.equals("")) break block26;
                result.put("return", retObj);
            }
            catch (Throwable e) {
                block27: {
                    try {
                        boolean fatal;
                        result.put("status", "FAIL");
                        Throwable thrown = e.getCause() == null ? e : e.getCause();
                        result.put("error", this.getError(thrown));
                        result.put("traceback", ExceptionUtils.getStackTrace(thrown));
                        boolean continuable = this.isFlagSet("ROBOT_CONTINUE_ON_FAILURE", thrown);
                        if (continuable) {
                            result.put("continuable", true);
                        }
                        if (!(fatal = this.isFlagSet("ROBOT_EXIT_ON_FAILURE", thrown))) break block27;
                        result.put("fatal", true);
                    }
                    catch (Throwable throwable) {
                        String stdOut = StringUtils.defaultString(redirector.getStdOutAsString());
                        String stdErr = StringUtils.defaultString(redirector.getStdErrAsString());
                        if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
                            StringBuilder output = new StringBuilder(stdOut);
                            if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                                if (!stdOut.endsWith("\n")) {
                                    output.append("\n");
                                }
                                boolean addLevel = true;
                                for (String prefix : this.logLevelPrefixes) {
                                    if (!stdErr.startsWith(prefix)) continue;
                                    addLevel = false;
                                    break;
                                }
                                if (addLevel) {
                                    output.append("*INFO*");
                                }
                            }
                            result.put("output", output.append(stdErr).toString());
                        }
                        redirector.resetStdStreams();
                        throw throwable;
                    }
                }
                String stdOut = StringUtils.defaultString(redirector.getStdOutAsString());
                String stdErr = StringUtils.defaultString(redirector.getStdErrAsString());
                if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
                    StringBuilder output = new StringBuilder(stdOut);
                    if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                        if (!stdOut.endsWith("\n")) {
                            output.append("\n");
                        }
                        boolean addLevel = true;
                        for (String prefix : this.logLevelPrefixes) {
                            if (!stdErr.startsWith(prefix)) continue;
                            addLevel = false;
                            break;
                        }
                        if (addLevel) {
                            output.append("*INFO*");
                        }
                    }
                    result.put("output", output.append(stdErr).toString());
                }
                redirector.resetStdStreams();
            }
        }
        String stdOut = StringUtils.defaultString(redirector.getStdOutAsString());
        String stdErr = StringUtils.defaultString(redirector.getStdErrAsString());
        if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
            StringBuilder output = new StringBuilder(stdOut);
            if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                if (!stdOut.endsWith("\n")) {
                    output.append("\n");
                }
                boolean addLevel = true;
                for (String prefix : this.logLevelPrefixes) {
                    if (!stdErr.startsWith(prefix)) continue;
                    addLevel = false;
                    break;
                }
                if (addLevel) {
                    output.append("*INFO*");
                }
            }
            result.put("output", output.append(stdErr).toString());
        }
        redirector.resetStdStreams();
        return result;
    }

    public Map<String, Object> run_keyword(String keyword, Object[] args) {
        return this.run_keyword(keyword, args, null);
    }

    public String[] get_keyword_arguments(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return new String[0];
        }
        try {
            String[] args = this.servlet.getLibrary().getKeywordArguments(keyword);
            return args == null ? new String[]{} : args;
        }
        catch (Throwable e) {
            this.log.warn("", e);
            throw new RuntimeException(e);
        }
    }

    public String get_keyword_documentation(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return "Stops the remote server.\n\nThe server may be configured so that users cannot stop it.";
        }
        try {
            String doc = this.servlet.getLibrary().getKeywordDocumentation(keyword);
            return doc == null ? "" : doc;
        }
        catch (Throwable e) {
            this.log.warn("", e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> stop_remote_server() {
        return this.run_keyword("stop_remote_server", null);
    }

    protected boolean stopRemoteServer() throws Exception {
        if (this.servlet.getAllowStop()) {
            System.out.print("Robot Framework remote server stopping");
            new Thread("remote-server-stopper"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }.start();
        } else {
            System.out.print("This Robot Framework remote server does not allow stopping");
        }
        return true;
    }

    private String getError(Throwable thrown) {
        String simpleName = thrown.getClass().getSimpleName();
        boolean suppressName = this.isFlagSet("ROBOT_SUPPRESS_NAME", thrown);
        if (genericExceptions.contains(simpleName) || suppressName) {
            return StringUtils.defaultIfEmpty(thrown.getMessage(), simpleName);
        }
        return String.format("%s: %s", thrown.getClass().getName(), thrown.getMessage());
    }

    private boolean isFlagSet(String name, Throwable thrown) {
        boolean flag = false;
        try {
            flag = thrown.getClass().getField(name).getBoolean(thrown);
        }
        catch (Exception e) {
            // empty catch block
        }
        return flag;
    }

    protected Object arraysToLists(Object arg) {
        if (arg instanceof Object[]) {
            Object[] array = (Object[])arg;
            List<Object> list = Arrays.asList(array);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.arraysToLists(list.get(i)));
            }
            return list;
        }
        if (arg instanceof Map) {
            Map oldMap = (Map)arg;
            HashMap newMap = new HashMap();
            for (Object key : oldMap.keySet()) {
                newMap.put(key, this.arraysToLists(oldMap.get(key)));
            }
            return newMap;
        }
        return arg;
    }

    private boolean illegalArgumentIn(Throwable t) {
        if (t.getClass().equals(IllegalArgumentException.class)) {
            return true;
        }
        Throwable inner = t;
        while (inner.getCause() != null) {
            if (!(inner = inner.getCause()).getClass().equals(IllegalArgumentException.class)) continue;
            return true;
        }
        return false;
    }
}

