/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.webserver.ServletOutputStreamImpl;

public class HttpServletResponseImpl
implements HttpServletResponse {
    static final int BUFFER_SIZE = 8192;
    private final Socket socket;
    private final OutputStream ostream;
    private final Map headers = new HashMap();
    private int status = 200;
    private String message = HttpServletResponseImpl.getStatusMessage(this.status);
    private Locale locale;
    private String charEncoding;
    private PrintWriter writer;
    private ServletOutputStreamImpl soStream;

    public HttpServletResponseImpl(Socket pSocket) throws IOException {
        this.socket = pSocket;
        this.ostream = this.socket.getOutputStream();
    }

    public void addCookie(Cookie pCookie) {
        throw new IllegalStateException("Not implemented");
    }

    public void addDateHeader(String pHeader, long pDate) {
        throw new IllegalStateException("Not implemented");
    }

    public void addHeader(String pHeader, String pValue) {
        String key = pHeader.toLowerCase();
        Object o = this.headers.get(key);
        if (o == null) {
            this.headers.put(key, pValue);
        } else {
            ArrayList<Object> list;
            if (o instanceof String) {
                list = new ArrayList<Object>();
                this.headers.put(key, list);
                list.add(o);
            } else {
                list = (ArrayList<Object>)o;
            }
            list.add(pValue);
        }
    }

    private String getHeader(String pHeader) {
        String key = pHeader.toLowerCase();
        Object o = this.headers.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        List list = (List)o;
        if (list.size() == 0) {
            return null;
        }
        return (String)list.get(0);
    }

    public void addIntHeader(String pHeader, int pValue) {
        this.addHeader(pHeader, Integer.toString(pValue));
    }

    public boolean containsHeader(String pHeader) {
        return this.headers.containsKey(pHeader.toLowerCase());
    }

    public String encodeRedirectURL(String pURL) {
        throw new IllegalStateException("Not implemented");
    }

    public String encodeRedirectUrl(String pURL) {
        return this.encodeRedirectURL(pURL);
    }

    public String encodeURL(String pURL) {
        throw new IllegalStateException("Not implemented");
    }

    public String encodeUrl(String pURL) {
        return this.encodeUrl(pURL);
    }

    public void sendError(int pStatusCode) throws IOException {
        this.sendError(pStatusCode, HttpServletResponseImpl.getStatusMessage(pStatusCode));
    }

    public void sendError(int pStatusCode, String pMessage) throws IOException {
        this.sendError(pStatusCode, pMessage, null);
    }

    protected void sendError(int pStatusCode, String pMessage, String pDescription) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Can't send an error message, if the response has already been committed.");
        }
        this.headers.clear();
        this.setContentType("text/html");
        this.setStatus(pStatusCode, pMessage);
        if (this.soStream == null) {
            this.soStream = new ServletOutputStreamImpl(this.ostream, this);
        } else {
            this.soStream.reset();
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.soStream, this.getCharacterEncoding());
        osw.write("<html><head><title>" + pStatusCode + " " + pMessage + "</title></head>\r\n");
        osw.write("<body><h1>" + pStatusCode + " " + pMessage + "</h1>\r\n");
        if (pDescription != null) {
            osw.write("<p>" + pDescription + "</p>\r\n");
        }
        osw.write("</body></html>\r\n");
        osw.close();
    }

    public void sendRedirect(String arg0) throws IOException {
        throw new IllegalStateException("Not implemented");
    }

    public void setDateHeader(String arg0, long arg1) {
        throw new IllegalStateException("Not implemented");
    }

    public void setHeader(String pHeader, String pValue) {
        this.headers.remove(pHeader.toLowerCase());
        this.addHeader(pHeader, pValue);
    }

    public void setIntHeader(String pHeader, int pValue) {
        this.setHeader(pHeader, Integer.toString(pValue));
    }

    public void setStatus(int pStatusCode) {
        this.setStatus(pStatusCode, HttpServletResponseImpl.getStatusMessage(pStatusCode));
    }

    public void setStatus(int pStatusCode, String pMessage) {
        this.status = pStatusCode;
        this.message = pMessage;
    }

    public void flushBuffer() throws IOException {
        this.ostream.flush();
    }

    public int getBufferSize() {
        return 8192;
    }

    public void setCharacterEncoding(String pCharset) {
        this.charEncoding = pCharset;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding == null) {
            return "ISO-8859-1";
        }
        return this.charEncoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("You may call either getWriter() or getOutputStream(), but not both.");
        }
        if (this.soStream == null) {
            this.soStream = new ServletOutputStreamImpl(this.ostream, this);
        }
        return this.soStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.soStream != null) {
            throw new IllegalStateException("You may call either getWriter() or getOutputStream(), but not both.");
        }
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
        return this.writer;
    }

    public boolean isCommitted() {
        return this.soStream != null && this.soStream.isCommitted();
    }

    public void reset() {
        this.resetBuffer();
        this.setStatus(200);
        this.headers.clear();
        this.charEncoding = null;
        this.locale = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("The ServletOutputStream is already committed. A reset is no longer possible.");
        }
        if (this.soStream != null) {
            this.soStream.reset();
        }
    }

    public void setBufferSize(int pBufferSize) {
        throw new IllegalStateException("Not implemented");
    }

    public void setContentLength(int pContentLength) {
        if (pContentLength == -1) {
            this.headers.remove("content-length");
        } else {
            this.setIntHeader("content-length", pContentLength);
        }
    }

    public String getContentType() {
        String enc;
        String s = this.getHeader("content-type");
        if (s != null && s.toLowerCase().startsWith("text/") && (enc = this.getCharacterEncoding()) != null) {
            s = s + "; charset=" + enc;
        }
        return s;
    }

    public void setContentType(String pType) {
        if (pType != null) {
            boolean charSetFound = false;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(pType, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.toLowerCase().startsWith("charset=")) {
                    charSetFound = true;
                    this.setCharacterEncoding(t.substring("charset=".length()).trim());
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(t);
            }
            if (charSetFound) {
                pType = sb.toString();
            }
        }
        this.setHeader("content-type", pType);
    }

    public void setLocale(Locale pLocale) {
        this.locale = pLocale;
    }

    public static String getStatusMessage(int pStatusCode) {
        switch (pStatusCode) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + pStatusCode;
    }

    String getHttpHeaders(Integer pContentLength) {
        StringBuffer sb = new StringBuffer();
        sb.append("HTTP/1.0 ");
        sb.append(this.status);
        sb.append(' ');
        sb.append(this.message);
        sb.append("\r\n");
        String contentType = this.getContentType();
        if (contentType != null) {
            sb.append("Content-Type: ");
            sb.append(contentType);
            sb.append("\r\n");
        }
        boolean contentLengthSeen = false;
        Iterator iter = this.headers.entrySet().iterator();
        while (iter.hasNext()) {
            Object o;
            Map.Entry entry = iter.next();
            String header = (String)entry.getKey();
            if ("content-type".equalsIgnoreCase(header) || (o = entry.getValue()) == null) continue;
            if ("content-length".equalsIgnoreCase(header)) {
                contentLengthSeen = true;
            }
            if (o instanceof String) {
                sb.append(header);
                sb.append(": ");
                sb.append(o);
                sb.append("\r\n");
                continue;
            }
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                sb.append(header);
                sb.append(": ");
                sb.append(list.get(i));
                sb.append("\r\n");
            }
        }
        if (pContentLength != null && !contentLengthSeen) {
            sb.append("Content-Length: ");
            sb.append(pContentLength);
            sb.append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

