/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.Framebuffer;
import edu.unh.iol.dlc.VNCClient;
import java.io.IOException;
import java.net.Socket;
import org.sikuli.basics.Debug;

public class VNCThread
extends Thread {
    private boolean listen = true;
    private int pollInterval = 50;
    private VNCClient client;
    private Framebuffer screen;
    private boolean pixel_flag = false;
    private boolean connected = false;

    public VNCThread(Socket s) {
        this.client = new VNCClient(s);
        this.screen = new Framebuffer();
    }

    public void terminate() {
        this.listen = false;
    }

    public VNCClient getClient() {
        return this.client;
    }

    public Framebuffer getScreen() {
        return this.screen;
    }

    public void changePollInterval(int milliseconds) {
        this.pollInterval = milliseconds;
    }

    public void openConnection(int connectOthers, int securityType) {
        try {
            this.client.protocolHandshake();
            this.client.securityMethod(this.client.securityInit(securityType));
            this.client.clientInit(connectOthers);
            int[] firstInput = this.client.listenServerInit();
            String secondInput = this.client.readDesktopName();
            this.pixel_flag = this.screen.setPF(firstInput, secondInput);
            this.connected = true;
        }
        catch (IOException e) {
            Debug.log(3, "" + e, new Object[0]);
        }
        catch (InterruptedException ie) {
            Debug.log(3, "" + ie, new Object[0]);
        }
    }

    public void setPixelFormat(String format, int bits, int bef) throws IOException {
        if (format.equals("Truecolor")) {
            Debug.log(3, "Format: " + format, new Object[0]);
            Debug.log(3, "Bits: " + bits, new Object[0]);
            switch (bits) {
                case 8: {
                    int[] a = new int[]{8, 8, bef, 1, 7, 7, 3, 5, 2, 0};
                    this.client.setPixelFormat(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]);
                    this.screen.resetPF(a);
                    this.pixel_flag = true;
                    break;
                }
                case 16: {
                    int[] b = new int[]{16, 15, bef, 1, 31, 31, 31, 10, 5, 0};
                    this.client.setPixelFormat(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7], b[8], b[9]);
                    this.screen.resetPF(b);
                    this.pixel_flag = true;
                    break;
                }
                case 32: {
                    int[] c = new int[]{32, 24, bef, 1, 255, 255, 255, 16, 8, 0};
                    this.client.setPixelFormat(c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9]);
                    this.screen.resetPF(c);
                    this.pixel_flag = false;
                    break;
                }
                default: {
                    Debug.log(3, "Error: Number of Bits unsupported", new Object[0]);
                    this.pixel_flag = true;
                    break;
                }
            }
        } else if (format.equals("Colormap")) {
            switch (bits) {
                case 8: {
                    int[] a = new int[]{8, 8, bef, 1, 7, 7, 3, 5, 2, 0};
                    this.client.setPixelFormat(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]);
                    this.screen.resetPF(a);
                    this.pixel_flag = true;
                    break;
                }
                case 16: {
                    int[] b = new int[]{8, 8, bef, 1, 7, 7, 3, 5, 2, 0};
                    this.client.setPixelFormat(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7], b[8], b[9]);
                    this.screen.resetPF(b);
                    this.pixel_flag = true;
                    break;
                }
                case 32: {
                    int[] c = new int[]{8, 8, bef, 1, 7, 7, 3, 5, 2, 0};
                    this.client.setPixelFormat(c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9]);
                    this.screen.resetPF(c);
                    this.pixel_flag = true;
                    break;
                }
                default: {
                    Debug.log(3, "Error: Number of Bits unsupported", new Object[0]);
                    this.pixel_flag = true;
                    break;
                }
            }
        } else {
            Debug.log(3, "Error: Format not supported.", new Object[0]);
            this.pixel_flag = true;
        }
    }

    @Override
    public void run() {
        while (!this.connected) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Debug.log(3, "Error: Thread Interrupted", new Object[0]);
            }
        }
        try {
            this.client.framebufferUpdateRequest(this.pixel_flag, 0, (short)0, (short)0, (short)this.screen.getWidth(), (short)this.screen.getHeight());
            while (this.listen) {
                if (this.client.available()) {
                    int message = this.client.readByte();
                    switch (message) {
                        case 0: {
                            this.client.readByte();
                            this.listenRemoteFramebufferUpdate();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            Debug.log(3, "Error: Unsupported Message Type: " + message, new Object[0]);
                        }
                    }
                }
                Thread.sleep(this.pollInterval);
                this.client.framebufferUpdateRequest(this.pixel_flag, 1, (short)0, (short)0, (short)this.screen.getWidth(), (short)this.screen.getHeight());
            }
            this.client.close();
        }
        catch (IOException io) {
            Debug.log(3, "Error: IO Exception" + io, new Object[0]);
        }
        catch (InterruptedException e) {
            Debug.log(3, "Error: Thread Interrupted", new Object[0]);
        }
    }

    private void listenRemoteFramebufferUpdate() throws IOException, InterruptedException {
        int numRect = this.client.readShort();
        block4: for (int i = 0; i < numRect; ++i) {
            int x = this.client.readShort();
            int y = this.client.readShort();
            int w = this.client.readShort();
            int h = this.client.readShort();
            int encType = this.client.readInt();
            switch (encType) {
                case 0: {
                    int[] pixels = this.client.readTC32Data(w * h * 3);
                    this.screen.raw(x, y, w, h, pixels);
                    continue block4;
                }
                case 1: {
                    int srcX = this.client.readShort();
                    int srcY = this.client.readShort();
                    this.screen.copyRect(x, y, w, h, srcX, srcY);
                    continue block4;
                }
                default: {
                    Debug.log(3, "Error: Encoding type not recognized or supported: " + Integer.toString(encType), new Object[0]);
                }
            }
        }
        this.screen.convertToBufferedImage();
    }
}

