/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.ConnectionController;
import edu.unh.iol.dlc.Framebuffer;
import edu.unh.iol.dlc.VNCRobot;
import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.script.Sikulix;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.util.ScreenHighlighter;

public class VNCScreen
extends Region
implements EventObserver,
IScreen {
    private static String me = "VNCScreen: ";
    private static int lvl = 3;
    protected static int _primaryScreen = -1;
    protected static Framebuffer[] _gdev;
    protected static Rectangle[] gdevsBounds;
    protected static ConnectionController _genv;
    protected static VNCScreen[] screens;
    private static VNCRobot[] mouseRobot;
    private static int waitForScreenshot;
    protected Framebuffer _curGD;
    protected int _curID = 0;
    protected int oldID = 0;
    protected IRobot robot = null;
    protected boolean waitPrompt;
    protected OverlayCapturePrompt prompt;
    private ScreenImage lastScreenImage = null;
    private String promptMsg = "Select a region on the screen";

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private static void initScreens(boolean reset) {
        int i;
        VNCScreen.log(lvl + 1, "initScreens: entry", new Object[0]);
        if (_genv != null && !reset) {
            return;
        }
        _genv = ConnectionController.getActiveController(0);
        if (_genv == null) {
            Debug.error("Did not find any active ConnectionControllers.  Cannot use VNCScreen without a ConnectionController instance.", new Object[0]);
            Sikulix.terminate(999);
        }
        _gdev = (Framebuffer[])_genv.getScreenDevices();
        gdevsBounds = new Rectangle[_gdev.length];
        screens = new VNCScreen[_gdev.length];
        if (_gdev.length == 0) {
            Debug.error("VNCScreen: initScreens: GraphicsEnvironment has no screens", new Object[0]);
            Sikulix.terminate(999);
        }
        _primaryScreen = -1;
        for (i = 0; i < VNCScreen.getNumberScreens(); ++i) {
            VNCScreen.gdevsBounds[i] = _gdev[i].getDefaultConfiguration().getBounds();
            if (!gdevsBounds[i].contains(new Point(0, 0))) continue;
            if (_primaryScreen < 0) {
                _primaryScreen = i;
                VNCScreen.log(lvl, "initScreens: ScreenDevice %d contains (0,0) --- will be used as primary", i);
                continue;
            }
            VNCScreen.log(lvl, "initScreens: ScreenDevice %d too contains (0,0)!", i);
        }
        if (_primaryScreen < 0) {
            Debug.log("Screen: initScreens: no ScreenDevice contains (0,0) --- using first ScreenDevice as primary", new Object[0]);
            _primaryScreen = 0;
        }
        VNCScreen.log(lvl + 1, "initScreens: after GD evaluation", new Object[0]);
        for (i = 0; i < screens.length; ++i) {
            VNCScreen.screens[i] = new VNCScreen(i, true);
            screens[i].initScreen();
        }
        try {
            VNCScreen.log(lvl + 1, "initScreens: getting mouseRobot", new Object[0]);
            mouseRobot = new VNCRobot[screens.length];
            for (i = 0; i < screens.length; ++i) {
                VNCScreen.mouseRobot[i] = new VNCRobot(_gdev[i]);
                mouseRobot[i].setAutoDelay(10);
            }
        }
        catch (AWTException e) {
            Debug.error("Can't initialize global Robot for Mouse: " + e.getMessage(), new Object[0]);
            Sikulix.terminate(999);
        }
        if (!reset) {
            VNCScreen.log(lvl - 1, "initScreens: basic initialization (%d VNCScreen(s) found)", _gdev.length);
            VNCScreen.log(lvl, "*** monitor configuration (primary: %d) ***", _primaryScreen);
            for (int i2 = 0; i2 < _gdev.length; ++i2) {
                VNCScreen.log(lvl, "%d: %s", i2, screens[i2].toStringShort());
            }
            VNCScreen.log(lvl, "*** end monitor configuration ***", new Object[0]);
        }
        if (VNCScreen.getNumberScreens() > 1) {
            VNCScreen.log(lvl, "initScreens: multi monitor mouse check", new Object[0]);
            Location lnow = Mouse.at();
            float mmd = Settings.MoveMouseDelay;
            Settings.MoveMouseDelay = 0.0f;
            Location lc = null;
            Location lcn = null;
            for (VNCScreen s : screens) {
                lc = s.getCenter();
                Mouse.move(lc);
                lcn = Mouse.at();
                if (!lc.equals(lcn)) {
                    VNCScreen.log(lvl, "*** multimonitor click check: %s center: (%d, %d) --- NOT OK:  (%d, %d)", s.toStringShort(), lc.x, lc.y, lcn.x, lcn.y);
                    continue;
                }
                VNCScreen.log(lvl, "*** checking: %s center: (%d, %d) --- OK", s.toStringShort(), lc.x, lc.y);
            }
            Mouse.move(lnow);
            Settings.MoveMouseDelay = mmd;
        }
    }

    protected static VNCRobot getMouseRobot() {
        return mouseRobot[0];
    }

    public static ScreenUnion all() {
        return new ScreenUnion();
    }

    public static int getNumberScreens() {
        return _gdev.length;
    }

    private static int getValidID(int id) {
        if (id < 0 || id >= _gdev.length) {
            Debug.error("VNCScreen: invalid screen id %d - using primary screen", id);
            return _primaryScreen;
        }
        return id;
    }

    public static int getPrimaryId() {
        return _primaryScreen;
    }

    public static VNCScreen getPrimaryScreen() {
        return screens[_primaryScreen];
    }

    public static VNCScreen getScreen(int id) {
        return screens[VNCScreen.getValidID(id)];
    }

    public static Rectangle getBounds(int id) {
        return gdevsBounds[VNCScreen.getValidID(id)];
    }

    public static IRobot getRobot(int id) {
        return VNCScreen.getScreen(id).getRobot();
    }

    public static void showMonitors() {
        Debug.info("*** monitor configuration [ %s VNCScreen(s)] ***", VNCScreen.getNumberScreens());
        Debug.info("*** Primary is VNCScreen %d", _primaryScreen);
        for (int i = 0; i < _gdev.length; ++i) {
            Debug.info("Screen %d: %s", i, VNCScreen.getScreen(i).toStringShort());
        }
        Debug.info("*** end monitor configuration ***", new Object[0]);
    }

    public static void resetMonitors() {
        Debug.error("*** BE AWARE: experimental - might not work ***", new Object[0]);
        Debug.error("Re-evaluation of the monitor setup has been requested", new Object[0]);
        Debug.error("... Current Region/Screen objects might not be valid any longer", new Object[0]);
        Debug.error("... Use existing Region/Screen objects only if you know what you are doing!", new Object[0]);
        VNCScreen.initScreens(true);
        Debug.info("*** new monitor configuration [ %s Screen(s)] ***", VNCScreen.getNumberScreens());
        Debug.info("*** Primary is VNCScreen %d", _primaryScreen);
        for (int i = 0; i < _gdev.length; ++i) {
            Debug.info("VNCScreen %d: %s", i, VNCScreen.getScreen(i).toStringShort());
        }
        Debug.error("*** end new monitor configuration ***", new Object[0]);
    }

    public VNCScreen() {
        this._curID = _primaryScreen;
        this.initScreen();
        super.initScreen(this);
    }

    public VNCScreen(int id) {
        VNCScreen.initScreens(true);
        if (id < 0 || id >= _gdev.length) {
            throw new IllegalArgumentException("VNCScreen ID " + id + " not in valid range " + "(between 0 and " + (_gdev.length - 1));
        }
        this._curID = id;
        this.initScreen();
        super.initScreen(this);
    }

    public VNCScreen(int id, boolean b) {
        this._curID = id;
        this.initScreen();
        super.initScreen(this);
    }

    public VNCScreen(boolean isScreenUnion) {
        this.initScreen();
        super.initScreen(this);
    }

    private void initScreen() {
        this.setOtherScreen();
        this._curGD = _gdev[this._curID];
        Rectangle bounds = this.getBounds();
        this.x = (int)bounds.getX();
        this.y = (int)bounds.getY();
        this.w = (int)bounds.getWidth();
        this.h = (int)bounds.getHeight();
        try {
            this.robot = new VNCRobot(this._curGD);
            this.robot.setAutoDelay(10);
        }
        catch (AWTException e) {
            Debug.error("Can't initialize Java Robot on VNCScreen " + this._curID + ": " + e.getMessage(), new Object[0]);
            this.robot = null;
        }
    }

    public void setAsScreenUnion() {
        this.oldID = this._curID;
        this._curID = -1;
    }

    public void setAsScreen() {
        this._curID = this.oldID;
    }

    @Override
    public void initScreen(IScreen scr) {
        this.updateSelf();
    }

    @Override
    public IScreen getScreen() {
        return this;
    }

    @Override
    protected Region setScreen(IScreen s) {
        throw new UnsupportedOperationException("The setScreen() method cannot be called from a VNCScreen object.");
    }

    protected boolean useFullscreen() {
        return false;
    }

    @Override
    public int getID() {
        return this._curID;
    }

    @Override
    public int getIdFromPoint(int x, int y) {
        return this._curID;
    }

    public GraphicsDevice getGraphicsDevice() {
        return this._curGD;
    }

    @Override
    public IRobot getRobot() {
        return this.robot;
    }

    @Override
    public Rectangle getBounds() {
        return gdevsBounds[this._curID];
    }

    public Region newRegion(Location loc, int width, int height) {
        return new Region(loc.x, loc.y, width, height, loc.getScreen());
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    public Location newLocation(Location loc) {
        return loc.setOtherScreen(this);
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getRect());
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        Rectangle rect = this.newRegion(new Location(x, y), w, h).getRect();
        return this.capture(rect);
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        ScreenImage simg;
        VNCScreen.log(lvl + 1, "VNCScreen.capture: (%d,%d) %dx%d", rect.x, rect.y, rect.width, rect.height);
        this.lastScreenImage = simg = this.robot.captureScreen(rect);
        return simg;
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.getRect());
    }

    public ScreenImage userCapture() {
        return this.userCapture(this.promptMsg);
    }

    @Override
    public ScreenImage userCapture(final String msg) {
        ScreenImage ret;
        this.waitPrompt = true;
        Thread th = new Thread(){

            @Override
            public void run() {
                if ("".equals(msg)) {
                    VNCScreen.this.prompt = new OverlayCapturePrompt(null, (EventObserver)VNCScreen.this);
                    VNCScreen.this.prompt.prompt(VNCScreen.this.promptMsg);
                } else {
                    VNCScreen.this.prompt = new OverlayCapturePrompt(VNCScreen.this, (EventObserver)VNCScreen.this);
                    VNCScreen.this.prompt.prompt(msg);
                }
            }
        };
        th.start();
        try {
            int count = 0;
            while (this.waitPrompt) {
                Thread.sleep(100L);
                if (count++ <= waitForScreenshot) continue;
                return null;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.lastScreenImage = ret = this.prompt.getSelection();
        this.prompt.close();
        return ret;
    }

    public Region selectRegion() {
        return this.selectRegion("Select a region on the screen");
    }

    public Region selectRegion(String msg) {
        ScreenImage sim = this.userCapture(msg);
        if (sim == null) {
            return null;
        }
        Rectangle r = sim.getROI();
        return Region.create((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public void update(EventSubject s) {
        this.waitPrompt = false;
    }

    @Override
    public void showTarget(Location loc) {
        this.showTarget(loc, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location loc, double secs) {
        if (Settings.isShowActions()) {
            ScreenHighlighter overlay = new ScreenHighlighter(this, null);
            overlay.showTarget(loc, (float)secs);
        }
    }

    @Override
    public boolean isOtherScreen() {
        return this.otherScreen;
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    @Override
    public int getX() {
        return (int)this.getBounds().getX();
    }

    @Override
    public int getY() {
        return (int)this.getBounds().getY();
    }

    @Override
    public int getW() {
        return (int)this.getBounds().getWidth();
    }

    @Override
    public int getH() {
        return (int)this.getBounds().getHeight();
    }

    @Override
    public String toString() {
        Rectangle r = this.getBounds();
        return String.format("S(%d)[%d,%d %dx%d] E:%s, T:%.1f", this._curID, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight(), this.getThrowException() ? "Y" : "N", this.getAutoWaitTimeout());
    }

    @Override
    public String toStringShort() {
        Rectangle r = this.getBounds();
        return String.format("S(%d)[%d,%d %dx%d]", this._curID, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    static {
        _genv = null;
        waitForScreenshot = 300;
        RunTime.loadLibrary("VisionProxy");
        VNCScreen.initScreens(false);
    }
}

