/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.VersionParser;

public enum ProtocolVersion {
    THREE_THREE(3, 3, "RFB 003.003"),
    THREE_FIVE(3, 5, "RFB 003.007"),
    THREE_SEVEN(3, 7, "RFB 003.007"),
    THREE_EIGHT(3, 8, "RFB 003.008"),
    FOUR_ONE(4, 1, "RFB 003.008");

    private final int majorVersion;
    private final int minorVersion;
    private final String replyCode;

    private ProtocolVersion(int majorVersion, int minorVersion, String replyCode) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.replyCode = replyCode;
    }

    public static ProtocolVersion fromString(String protocolString) {
        ProtocolVersion parsedVersion;
        VersionParser versionParser = new VersionParser(protocolString);
        try {
            parsedVersion = versionParser.parse();
        }
        catch (Exception e) {
            String error = "Error parsing protocol version: '%s'";
            String formattedError = String.format("Error parsing protocol version: '%s'", protocolString);
            throw new RuntimeException(formattedError, e);
        }
        return parsedVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getReplyCode() {
        return this.replyCode;
    }

    public String toString() {
        return "ProtocolVersion{majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", replyCode='" + this.replyCode + "}";
    }
}

