/* File: coremodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * See http://cens.ioc.ee/projects/f2py2e/
 * Generation date: Wed Apr 02 14:50:09 2014
 * $Revision:$
 * $Date:$
 * Do not edit this file directly unless you know what you are doing!!!
 */
#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *core_error;
static PyObject *core_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef struct {double r,i;} complex_double;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (((PyArrayObject *)(capi_ ## var ## _tmp))->nd)
#define old_shape(var,dim) (((PyArrayObject *)(capi_ ## var ## _tmp))->dimensions[dim])
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define pyobj_from_complex_double1(v) (PyComplex_FromDoubles(v.r,v.i))
#define CHECKSCALAR(check,tcheck,name,show,var)\
  if (!(check)) {\
    char errstring[256];\
    sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
    PyErr_SetString(core_error,errstring);\
    /*goto capi_fail;*/\
  } else 

/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyInt_Check(obj)) {
    *v = (int)PyInt_AS_LONG(obj);
    return 1;
  }
  tmp = PyNumber_Int(obj);
  if (tmp) {
    *v = PyInt_AS_LONG(tmp);
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = core_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int complex_double_from_pyobj(complex_double* v,PyObject *obj,const char *errmess) {
  Py_complex c;
  if (PyComplex_Check(obj)) {
    c=PyComplex_AsCComplex(obj);
    (*v).r=c.real, (*v).i=c.imag;
    return 1;
  }
  if (PyArray_IsScalar(obj, ComplexFloating)) {
    if (PyArray_IsScalar(obj, CFloat)) {
      npy_cfloat new;
      PyArray_ScalarAsCtype(obj, &new);
      (*v).r = (double)new.real;
      (*v).i = (double)new.imag;
    }
    else if (PyArray_IsScalar(obj, CLongDouble)) {
      npy_clongdouble new;
      PyArray_ScalarAsCtype(obj, &new);
      (*v).r = (double)new.real;
      (*v).i = (double)new.imag;
    }
    else { /* if (PyArray_IsScalar(obj, CDouble)) */
      PyArray_ScalarAsCtype(obj, v);
    }
    return 1;
  }
  if (PyArray_CheckScalar(obj)) { /* 0-dim array or still array scalar */
    PyObject *arr;
    if (PyArray_Check(obj)) {
      arr = PyArray_Cast((PyArrayObject *)obj, NPY_CDOUBLE);
    }
    else {
      arr = PyArray_FromScalar(obj, PyArray_DescrFromType(NPY_CDOUBLE));
    }
    if (arr==NULL) return 0;
    (*v).r = ((npy_cdouble *)PyArray_DATA(arr))->real;
    (*v).i = ((npy_cdouble *)PyArray_DATA(arr))->imag;
    return 1;
  }
  /* Python does not provide PyNumber_Complex function :-( */
  (*v).i=0.0;
  if (PyFloat_Check(obj)) {
#ifdef __sgi
    (*v).r = PyFloat_AsDouble(obj);
#else
    (*v).r = PyFloat_AS_DOUBLE(obj);
#endif
    return 1;
  }
  if (PyInt_Check(obj)) {
    (*v).r = (double)PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    (*v).r = PyLong_AsDouble(obj);
    return (!PyErr_Occurred());
  }
  if (PySequence_Check(obj) && !(PyString_Check(obj) || PyUnicode_Check(obj))) {
    PyObject *tmp = PySequence_GetItem(obj,0);
    if (tmp) {
      if (complex_double_from_pyobj(v,tmp,errmess)) {
        Py_DECREF(tmp);
        return 1;
      }
      Py_DECREF(tmp);
    }
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL)
      err = PyExc_TypeError;
    PyErr_SetString(err,errmess);
  }
  return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_WRAPPEDFUNC_US(scr_index,SCR_INDEX)(int*,int*,int*,int*,int*);
extern void F_FUNC_US(face_integrals_complex,FACE_INTEGRALS_COMPLEX)(int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR)(double*,double*,double*);
extern void F_FUNC_US(face_integrals_smooth_complex,FACE_INTEGRALS_SMOOTH_COMPLEX)(int*,int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF)(int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*);
extern void F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*);
extern void F_FUNC_US(voltage_plane_wave,VOLTAGE_PLANE_WAVE)(int*,int*,int*,int*,double*,int*,int*,int*,int*,int*,double*,double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(v_efie_faces_plane_wave,V_EFIE_FACES_PLANE_WAVE)(int*,int*,int*,double*,int*,double*,double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN)(double*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC_US(triangle_face_to_rwg,TRIANGLE_FACE_TO_RWG)(int*,int*,int*,int*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(set_threads,SET_THREADS)(int*);
extern void F_FUNC_US(get_threads,GET_THREADS)(int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************* scr_index *********************************/
static char doc_f2py_rout_core_scr_index[] = "\
Function signature:\n\
  scr_index = scr_index(row,col,indices,indptr)\n\
Required arguments:\n"
"  row : input int\n"
"  col : input int\n"
"  indices : input rank-1 array('i') with bounds (1)\n"
"  indptr : input rank-1 array('i') with bounds (1)\n"
"Return objects:\n"
"  scr_index : int";
/* extern void F_WRAPPEDFUNC_US(scr_index,SCR_INDEX)(int*,int*,int*,int*,int*); */
static PyObject *f2py_rout_core_scr_index(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int scr_index = 0;
  int row = 0;
  PyObject *row_capi = Py_None;
  int col = 0;
  PyObject *col_capi = Py_None;
  int *indices = NULL;
  npy_intp indices_Dims[1] = {-1};
  const int indices_Rank = 1;
  PyArrayObject *capi_indices_tmp = NULL;
  int capi_indices_intent = 0;
  PyObject *indices_capi = Py_None;
  int *indptr = NULL;
  npy_intp indptr_Dims[1] = {-1};
  const int indptr_Rank = 1;
  PyArrayObject *capi_indptr_tmp = NULL;
  int capi_indptr_intent = 0;
  PyObject *indptr_capi = Py_None;
  static char *capi_kwlist[] = {"row","col","indices","indptr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:core.scr_index",\
    capi_kwlist,&row_capi,&col_capi,&indices_capi,&indptr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable indices */
  indices_Dims[0]=1;
  capi_indices_intent |= F2PY_INTENT_IN;
  capi_indices_tmp = array_from_pyobj(NPY_INT,indices_Dims,indices_Rank,capi_indices_intent,indices_capi);
  if (capi_indices_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `indices' of core.scr_index to C/Fortran array" );
  } else {
    indices = (int *)(capi_indices_tmp->data);

  /* Processing variable indptr */
  indptr_Dims[0]=1;
  capi_indptr_intent |= F2PY_INTENT_IN;
  capi_indptr_tmp = array_from_pyobj(NPY_INT,indptr_Dims,indptr_Rank,capi_indptr_intent,indptr_capi);
  if (capi_indptr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `indptr' of core.scr_index to C/Fortran array" );
  } else {
    indptr = (int *)(capi_indptr_tmp->data);

  /* Processing variable scr_index */
  /* Processing variable col */
    f2py_success = int_from_pyobj(&col,col_capi,"core.scr_index() 2nd argument (col) can't be converted to int");
  if (f2py_success) {
  /* Processing variable row */
    f2py_success = int_from_pyobj(&row,row_capi,"core.scr_index() 1st argument (row) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&scr_index,&row,&col,indices,indptr);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",scr_index);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of row*/
  /* End of cleaning variable row */
  } /*if (f2py_success) of col*/
  /* End of cleaning variable col */
  /* End of cleaning variable scr_index */
  if((PyObject *)capi_indptr_tmp!=indptr_capi) {
    Py_XDECREF(capi_indptr_tmp); }
  }  /*if (capi_indptr_tmp == NULL) ... else of indptr*/
  /* End of cleaning variable indptr */
  if((PyObject *)capi_indices_tmp!=indices_capi) {
    Py_XDECREF(capi_indices_tmp); }
  }  /*if (capi_indices_tmp == NULL) ... else of indices*/
  /* End of cleaning variable indices */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of scr_index ******************************/

/*************************** face_integrals_complex ***************************/
static char doc_f2py_rout_core_face_integrals_complex[] = "\
Function signature:\n\
  i_a,i_phi = face_integrals_complex(xi_eta_s,weights_s,nodes_s_in,xi_eta_o,weights_o,nodes_o_in,jk_0,[n_s,n_o])\n\
Required arguments:\n"
"  xi_eta_s : input rank-2 array('d') with bounds (n_s,2)\n"
"  weights_s : input rank-1 array('d') with bounds (n_s)\n"
"  nodes_s_in : input rank-2 array('d') with bounds (3,3)\n"
"  xi_eta_o : input rank-2 array('d') with bounds (n_o,2)\n"
"  weights_o : input rank-1 array('d') with bounds (n_o)\n"
"  nodes_o_in : input rank-2 array('d') with bounds (3,3)\n"
"  jk_0 : input complex\n"
"Optional arguments:\n"
"  n_s := shape(xi_eta_s,0) input int\n"
"  n_o := shape(xi_eta_o,0) input int\n"
"Return objects:\n"
"  i_a : rank-2 array('D') with bounds (3,3)\n"
"  i_phi : complex";
/* extern void F_FUNC_US(face_integrals_complex,FACE_INTEGRALS_COMPLEX)(int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_face_integrals_complex(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n_s = 0;
  PyObject *n_s_capi = Py_None;
  double *xi_eta_s = NULL;
  npy_intp xi_eta_s_Dims[2] = {-1, -1};
  const int xi_eta_s_Rank = 2;
  PyArrayObject *capi_xi_eta_s_tmp = NULL;
  int capi_xi_eta_s_intent = 0;
  PyObject *xi_eta_s_capi = Py_None;
  double *weights_s = NULL;
  npy_intp weights_s_Dims[1] = {-1};
  const int weights_s_Rank = 1;
  PyArrayObject *capi_weights_s_tmp = NULL;
  int capi_weights_s_intent = 0;
  PyObject *weights_s_capi = Py_None;
  double *nodes_s_in = NULL;
  npy_intp nodes_s_in_Dims[2] = {-1, -1};
  const int nodes_s_in_Rank = 2;
  PyArrayObject *capi_nodes_s_in_tmp = NULL;
  int capi_nodes_s_in_intent = 0;
  PyObject *nodes_s_in_capi = Py_None;
  int n_o = 0;
  PyObject *n_o_capi = Py_None;
  double *xi_eta_o = NULL;
  npy_intp xi_eta_o_Dims[2] = {-1, -1};
  const int xi_eta_o_Rank = 2;
  PyArrayObject *capi_xi_eta_o_tmp = NULL;
  int capi_xi_eta_o_intent = 0;
  PyObject *xi_eta_o_capi = Py_None;
  double *weights_o = NULL;
  npy_intp weights_o_Dims[1] = {-1};
  const int weights_o_Rank = 1;
  PyArrayObject *capi_weights_o_tmp = NULL;
  int capi_weights_o_intent = 0;
  PyObject *weights_o_capi = Py_None;
  double *nodes_o_in = NULL;
  npy_intp nodes_o_in_Dims[2] = {-1, -1};
  const int nodes_o_in_Rank = 2;
  PyArrayObject *capi_nodes_o_in_tmp = NULL;
  int capi_nodes_o_in_intent = 0;
  PyObject *nodes_o_in_capi = Py_None;
  complex_double jk_0;
  PyObject *jk_0_capi = Py_None;
  complex_double *i_a = NULL;
  npy_intp i_a_Dims[2] = {-1, -1};
  const int i_a_Rank = 2;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  complex_double i_phi;
  PyObject *i_phi_capi = Py_None;
  static char *capi_kwlist[] = {"xi_eta_s","weights_s","nodes_s_in","xi_eta_o","weights_o","nodes_o_in","jk_0","n_s","n_o",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|OO:core.face_integrals_complex",\
    capi_kwlist,&xi_eta_s_capi,&weights_s_capi,&nodes_s_in_capi,&xi_eta_o_capi,&weights_o_capi,&nodes_o_in_capi,&jk_0_capi,&n_s_capi,&n_o_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nodes_o_in */
  nodes_o_in_Dims[0]=3,nodes_o_in_Dims[1]=3;
  capi_nodes_o_in_intent |= F2PY_INTENT_IN;
  capi_nodes_o_in_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_in_Dims,nodes_o_in_Rank,capi_nodes_o_in_intent,nodes_o_in_capi);
  if (capi_nodes_o_in_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `nodes_o_in' of core.face_integrals_complex to C/Fortran array" );
  } else {
    nodes_o_in = (double *)(capi_nodes_o_in_tmp->data);

  /* Processing variable xi_eta_o */
  xi_eta_o_Dims[1]=2;
  capi_xi_eta_o_intent |= F2PY_INTENT_IN;
  capi_xi_eta_o_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_o_Dims,xi_eta_o_Rank,capi_xi_eta_o_intent,xi_eta_o_capi);
  if (capi_xi_eta_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `xi_eta_o' of core.face_integrals_complex to C/Fortran array" );
  } else {
    xi_eta_o = (double *)(capi_xi_eta_o_tmp->data);

  /* Processing variable xi_eta_s */
  xi_eta_s_Dims[1]=2;
  capi_xi_eta_s_intent |= F2PY_INTENT_IN;
  capi_xi_eta_s_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_s_Dims,xi_eta_s_Rank,capi_xi_eta_s_intent,xi_eta_s_capi);
  if (capi_xi_eta_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `xi_eta_s' of core.face_integrals_complex to C/Fortran array" );
  } else {
    xi_eta_s = (double *)(capi_xi_eta_s_tmp->data);

  /* Processing variable i_a */
  i_a_Dims[0]=3,i_a_Dims[1]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_CDOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.face_integrals_complex to C/Fortran array" );
  } else {
    i_a = (complex_double *)(capi_i_a_tmp->data);

  /* Processing variable i_phi */
  /* Processing variable jk_0 */
    f2py_success = complex_double_from_pyobj(&jk_0,jk_0_capi,"core.face_integrals_complex() 7th argument (jk_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nodes_s_in */
  nodes_s_in_Dims[0]=3,nodes_s_in_Dims[1]=3;
  capi_nodes_s_in_intent |= F2PY_INTENT_IN;
  capi_nodes_s_in_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_in_Dims,nodes_s_in_Rank,capi_nodes_s_in_intent,nodes_s_in_capi);
  if (capi_nodes_s_in_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `nodes_s_in' of core.face_integrals_complex to C/Fortran array" );
  } else {
    nodes_s_in = (double *)(capi_nodes_s_in_tmp->data);

  /* Processing variable n_s */
  if (n_s_capi == Py_None) n_s = shape(xi_eta_s,0); else
    f2py_success = int_from_pyobj(&n_s,n_s_capi,"core.face_integrals_complex() 1st keyword (n_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_s,0)==n_s,"shape(xi_eta_s,0)==n_s","1st keyword n_s","face_integrals_complex:n_s=%d",n_s) {
  /* Processing variable n_o */
  if (n_o_capi == Py_None) n_o = shape(xi_eta_o,0); else
    f2py_success = int_from_pyobj(&n_o,n_o_capi,"core.face_integrals_complex() 2nd keyword (n_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_o,0)==n_o,"shape(xi_eta_o,0)==n_o","2nd keyword n_o","face_integrals_complex:n_o=%d",n_o) {
  /* Processing variable weights_o */
  weights_o_Dims[0]=n_o;
  capi_weights_o_intent |= F2PY_INTENT_IN;
  capi_weights_o_tmp = array_from_pyobj(NPY_DOUBLE,weights_o_Dims,weights_o_Rank,capi_weights_o_intent,weights_o_capi);
  if (capi_weights_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `weights_o' of core.face_integrals_complex to C/Fortran array" );
  } else {
    weights_o = (double *)(capi_weights_o_tmp->data);

  /* Processing variable weights_s */
  weights_s_Dims[0]=n_s;
  capi_weights_s_intent |= F2PY_INTENT_IN;
  capi_weights_s_tmp = array_from_pyobj(NPY_DOUBLE,weights_s_Dims,weights_s_Rank,capi_weights_s_intent,weights_s_capi);
  if (capi_weights_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `weights_s' of core.face_integrals_complex to C/Fortran array" );
  } else {
    weights_s = (double *)(capi_weights_s_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n_s,xi_eta_s,weights_s,nodes_s_in,&n_o,xi_eta_o,weights_o,nodes_o_in,&jk_0,i_a,&i_phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  i_phi_capi = pyobj_from_complex_double1(i_phi);
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_i_a_tmp,i_phi_capi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_s_tmp!=weights_s_capi) {
    Py_XDECREF(capi_weights_s_tmp); }
  }  /*if (capi_weights_s_tmp == NULL) ... else of weights_s*/
  /* End of cleaning variable weights_s */
  if((PyObject *)capi_weights_o_tmp!=weights_o_capi) {
    Py_XDECREF(capi_weights_o_tmp); }
  }  /*if (capi_weights_o_tmp == NULL) ... else of weights_o*/
  /* End of cleaning variable weights_o */
  } /*CHECKSCALAR(shape(xi_eta_o,0)==n_o)*/
  } /*if (f2py_success) of n_o*/
  /* End of cleaning variable n_o */
  } /*CHECKSCALAR(shape(xi_eta_s,0)==n_s)*/
  } /*if (f2py_success) of n_s*/
  /* End of cleaning variable n_s */
  if((PyObject *)capi_nodes_s_in_tmp!=nodes_s_in_capi) {
    Py_XDECREF(capi_nodes_s_in_tmp); }
  }  /*if (capi_nodes_s_in_tmp == NULL) ... else of nodes_s_in*/
  /* End of cleaning variable nodes_s_in */
  }  /*if (f2py_success) of jk_0 frompyobj*/
  /* End of cleaning variable jk_0 */
  /* End of cleaning variable i_phi */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  if((PyObject *)capi_xi_eta_s_tmp!=xi_eta_s_capi) {
    Py_XDECREF(capi_xi_eta_s_tmp); }
  }  /*if (capi_xi_eta_s_tmp == NULL) ... else of xi_eta_s*/
  /* End of cleaning variable xi_eta_s */
  if((PyObject *)capi_xi_eta_o_tmp!=xi_eta_o_capi) {
    Py_XDECREF(capi_xi_eta_o_tmp); }
  }  /*if (capi_xi_eta_o_tmp == NULL) ... else of xi_eta_o*/
  /* End of cleaning variable xi_eta_o */
  if((PyObject *)capi_nodes_o_in_tmp!=nodes_o_in_capi) {
    Py_XDECREF(capi_nodes_o_in_tmp); }
  }  /*if (capi_nodes_o_in_tmp == NULL) ... else of nodes_o_in*/
  /* End of cleaning variable nodes_o_in */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of face_integrals_complex ***********************/

/****************************** arcioni_singular ******************************/
static char doc_f2py_rout_core_arcioni_singular[] = "\
Function signature:\n\
  i_a,i_phi = arcioni_singular(nodes)\n\
Required arguments:\n"
"  nodes : input rank-2 array('d') with bounds (3,3)\n"
"Return objects:\n"
"  i_a : rank-2 array('d') with bounds (3,3)\n"
"  i_phi : float";
/* extern void F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR)(double*,double*,double*); */
static PyObject *f2py_rout_core_arcioni_singular(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  double *i_a = NULL;
  npy_intp i_a_Dims[2] = {-1, -1};
  const int i_a_Rank = 2;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  double i_phi = 0;
  static char *capi_kwlist[] = {"nodes",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:core.arcioni_singular",\
    capi_kwlist,&nodes_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i_phi */
  /* Processing variable nodes */
  nodes_Dims[0]=3,nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.arcioni_singular to C/Fortran array" );
  } else {
    nodes = (double *)(capi_nodes_tmp->data);

  /* Processing variable i_a */
  i_a_Dims[0]=3,i_a_Dims[1]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_DOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.arcioni_singular to C/Fortran array" );
  } else {
    i_a = (double *)(capi_i_a_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(nodes,i_a,&i_phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("Nd",capi_i_a_tmp,i_phi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  /* End of cleaning variable i_phi */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of arcioni_singular **************************/

/*********************** face_integrals_smooth_complex ***********************/
static char doc_f2py_rout_core_face_integrals_smooth_complex[] = "\
Function signature:\n\
  i_a,i_phi = face_integrals_smooth_complex(xi_eta_s,weights_s,nodes_s,xi_eta_o,weights_o,nodes_o,jk_0,[n_s,n_s2,n_o])\n\
Required arguments:\n"
"  xi_eta_s : input rank-3 array('d') with bounds (n_s2,n_s,2)\n"
"  weights_s : input rank-2 array('d') with bounds (n_s2,n_s)\n"
"  nodes_s : input rank-2 array('d') with bounds (3,3)\n"
"  xi_eta_o : input rank-2 array('d') with bounds (n_o,2)\n"
"  weights_o : input rank-1 array('d') with bounds (n_o)\n"
"  nodes_o : input rank-2 array('d') with bounds (3,3)\n"
"  jk_0 : input complex\n"
"Optional arguments:\n"
"  n_s := shape(xi_eta_s,1) input int\n"
"  n_s2 := shape(xi_eta_s,0) input int\n"
"  n_o := shape(xi_eta_o,0) input int\n"
"Return objects:\n"
"  i_a : rank-2 array('D') with bounds (3,3)\n"
"  i_phi : complex";
/* extern void F_FUNC_US(face_integrals_smooth_complex,FACE_INTEGRALS_SMOOTH_COMPLEX)(int*,int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_face_integrals_smooth_complex(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,double*,double*,double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n_s = 0;
  PyObject *n_s_capi = Py_None;
  int n_s2 = 0;
  PyObject *n_s2_capi = Py_None;
  double *xi_eta_s = NULL;
  npy_intp xi_eta_s_Dims[3] = {-1, -1, -1};
  const int xi_eta_s_Rank = 3;
  PyArrayObject *capi_xi_eta_s_tmp = NULL;
  int capi_xi_eta_s_intent = 0;
  PyObject *xi_eta_s_capi = Py_None;
  double *weights_s = NULL;
  npy_intp weights_s_Dims[2] = {-1, -1};
  const int weights_s_Rank = 2;
  PyArrayObject *capi_weights_s_tmp = NULL;
  int capi_weights_s_intent = 0;
  PyObject *weights_s_capi = Py_None;
  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int n_o = 0;
  PyObject *n_o_capi = Py_None;
  double *xi_eta_o = NULL;
  npy_intp xi_eta_o_Dims[2] = {-1, -1};
  const int xi_eta_o_Rank = 2;
  PyArrayObject *capi_xi_eta_o_tmp = NULL;
  int capi_xi_eta_o_intent = 0;
  PyObject *xi_eta_o_capi = Py_None;
  double *weights_o = NULL;
  npy_intp weights_o_Dims[1] = {-1};
  const int weights_o_Rank = 1;
  PyArrayObject *capi_weights_o_tmp = NULL;
  int capi_weights_o_intent = 0;
  PyObject *weights_o_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  complex_double jk_0;
  PyObject *jk_0_capi = Py_None;
  complex_double *i_a = NULL;
  npy_intp i_a_Dims[2] = {-1, -1};
  const int i_a_Rank = 2;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  complex_double i_phi;
  PyObject *i_phi_capi = Py_None;
  static char *capi_kwlist[] = {"xi_eta_s","weights_s","nodes_s","xi_eta_o","weights_o","nodes_o","jk_0","n_s","n_s2","n_o",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|OOO:core.face_integrals_smooth_complex",\
    capi_kwlist,&xi_eta_s_capi,&weights_s_capi,&nodes_s_capi,&xi_eta_o_capi,&weights_o_capi,&nodes_o_capi,&jk_0_capi,&n_s_capi,&n_s2_capi,&n_o_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xi_eta_o */
  xi_eta_o_Dims[1]=2;
  capi_xi_eta_o_intent |= F2PY_INTENT_IN;
  capi_xi_eta_o_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_o_Dims,xi_eta_o_Rank,capi_xi_eta_o_intent,xi_eta_o_capi);
  if (capi_xi_eta_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `xi_eta_o' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    xi_eta_o = (double *)(capi_xi_eta_o_tmp->data);

  /* Processing variable xi_eta_s */
  xi_eta_s_Dims[2]=2;
  capi_xi_eta_s_intent |= F2PY_INTENT_IN;
  capi_xi_eta_s_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_s_Dims,xi_eta_s_Rank,capi_xi_eta_s_intent,xi_eta_s_capi);
  if (capi_xi_eta_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `xi_eta_s' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    xi_eta_s = (double *)(capi_xi_eta_s_tmp->data);

  /* Processing variable nodes_o */
  nodes_o_Dims[0]=3,nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `nodes_o' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    nodes_o = (double *)(capi_nodes_o_tmp->data);

  /* Processing variable nodes_s */
  nodes_s_Dims[0]=3,nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `nodes_s' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    nodes_s = (double *)(capi_nodes_s_tmp->data);

  /* Processing variable i_phi */
  /* Processing variable jk_0 */
    f2py_success = complex_double_from_pyobj(&jk_0,jk_0_capi,"core.face_integrals_smooth_complex() 7th argument (jk_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable i_a */
  i_a_Dims[0]=3,i_a_Dims[1]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_CDOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    i_a = (complex_double *)(capi_i_a_tmp->data);

  /* Processing variable n_s2 */
  if (n_s2_capi == Py_None) n_s2 = shape(xi_eta_s,0); else
    f2py_success = int_from_pyobj(&n_s2,n_s2_capi,"core.face_integrals_smooth_complex() 2nd keyword (n_s2) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_s,0)==n_s2,"shape(xi_eta_s,0)==n_s2","2nd keyword n_s2","face_integrals_smooth_complex:n_s2=%d",n_s2) {
  /* Processing variable n_s */
  if (n_s_capi == Py_None) n_s = shape(xi_eta_s,1); else
    f2py_success = int_from_pyobj(&n_s,n_s_capi,"core.face_integrals_smooth_complex() 1st keyword (n_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_s,1)==n_s,"shape(xi_eta_s,1)==n_s","1st keyword n_s","face_integrals_smooth_complex:n_s=%d",n_s) {
  /* Processing variable n_o */
  if (n_o_capi == Py_None) n_o = shape(xi_eta_o,0); else
    f2py_success = int_from_pyobj(&n_o,n_o_capi,"core.face_integrals_smooth_complex() 3rd keyword (n_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_o,0)==n_o,"shape(xi_eta_o,0)==n_o","3rd keyword n_o","face_integrals_smooth_complex:n_o=%d",n_o) {
  /* Processing variable weights_o */
  weights_o_Dims[0]=n_o;
  capi_weights_o_intent |= F2PY_INTENT_IN;
  capi_weights_o_tmp = array_from_pyobj(NPY_DOUBLE,weights_o_Dims,weights_o_Rank,capi_weights_o_intent,weights_o_capi);
  if (capi_weights_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `weights_o' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    weights_o = (double *)(capi_weights_o_tmp->data);

  /* Processing variable weights_s */
  weights_s_Dims[0]=n_s2,weights_s_Dims[1]=n_s;
  capi_weights_s_intent |= F2PY_INTENT_IN;
  capi_weights_s_tmp = array_from_pyobj(NPY_DOUBLE,weights_s_Dims,weights_s_Rank,capi_weights_s_intent,weights_s_capi);
  if (capi_weights_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `weights_s' of core.face_integrals_smooth_complex to C/Fortran array" );
  } else {
    weights_s = (double *)(capi_weights_s_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n_s,&n_s2,xi_eta_s,weights_s,nodes_s,&n_o,xi_eta_o,weights_o,nodes_o,&jk_0,i_a,&i_phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  i_phi_capi = pyobj_from_complex_double1(i_phi);
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_i_a_tmp,i_phi_capi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_s_tmp!=weights_s_capi) {
    Py_XDECREF(capi_weights_s_tmp); }
  }  /*if (capi_weights_s_tmp == NULL) ... else of weights_s*/
  /* End of cleaning variable weights_s */
  if((PyObject *)capi_weights_o_tmp!=weights_o_capi) {
    Py_XDECREF(capi_weights_o_tmp); }
  }  /*if (capi_weights_o_tmp == NULL) ... else of weights_o*/
  /* End of cleaning variable weights_o */
  } /*CHECKSCALAR(shape(xi_eta_o,0)==n_o)*/
  } /*if (f2py_success) of n_o*/
  /* End of cleaning variable n_o */
  } /*CHECKSCALAR(shape(xi_eta_s,1)==n_s)*/
  } /*if (f2py_success) of n_s*/
  /* End of cleaning variable n_s */
  } /*CHECKSCALAR(shape(xi_eta_s,0)==n_s2)*/
  } /*if (f2py_success) of n_s2*/
  /* End of cleaning variable n_s2 */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  }  /*if (f2py_success) of jk_0 frompyobj*/
  /* End of cleaning variable jk_0 */
  /* End of cleaning variable i_phi */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  if((PyObject *)capi_xi_eta_s_tmp!=xi_eta_s_capi) {
    Py_XDECREF(capi_xi_eta_s_tmp); }
  }  /*if (capi_xi_eta_s_tmp == NULL) ... else of xi_eta_s*/
  /* End of cleaning variable xi_eta_s */
  if((PyObject *)capi_xi_eta_o_tmp!=xi_eta_o_capi) {
    Py_XDECREF(capi_xi_eta_o_tmp); }
  }  /*if (capi_xi_eta_o_tmp == NULL) ... else of xi_eta_o*/
  /* End of cleaning variable xi_eta_o */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************** end of face_integrals_smooth_complex ********************/

/***************************** z_efie_faces_self *****************************/
static char doc_f2py_rout_core_z_efie_faces_self[] = "\
Function signature:\n\
  a_face,phi_face = z_efie_faces_self(nodes,triangle_nodes,s,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,[num_nodes,num_triangles,num_integration,num_singular])\n\
Required arguments:\n"
"  nodes : input rank-2 array('d') with bounds (num_nodes,3)\n"
"  triangle_nodes : input rank-2 array('i') with bounds (num_triangles,3)\n"
"  s : input complex\n"
"  xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"  weights : input rank-1 array('d') with bounds (num_integration)\n"
"  phi_precalc : input rank-1 array('d') with bounds (num_singular)\n"
"  a_precalc : input rank-3 array('d') with bounds (num_singular,3,3)\n"
"  indices_precalc : input rank-1 array('i') with bounds (num_singular)\n"
"  indptr_precalc : input rank-1 array('i') with bounds (num_triangles + 1)\n"
"Optional arguments:\n"
"  num_nodes := shape(nodes,0) input int\n"
"  num_triangles := shape(triangle_nodes,0) input int\n"
"  num_integration := shape(xi_eta_eval,0) input int\n"
"  num_singular := len(phi_precalc) input int\n"
"Return objects:\n"
"  a_face : rank-4 array('D') with bounds (num_triangles,3,num_triangles,3)\n"
"  phi_face : rank-2 array('D') with bounds (num_triangles,num_triangles)";
/* extern void F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF)(int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_efie_faces_self(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes = 0;
  PyObject *num_nodes_capi = Py_None;
  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  int num_singular = 0;
  PyObject *num_singular_capi = Py_None;
  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  int *triangle_nodes = NULL;
  npy_intp triangle_nodes_Dims[2] = {-1, -1};
  const int triangle_nodes_Rank = 2;
  PyArrayObject *capi_triangle_nodes_tmp = NULL;
  int capi_triangle_nodes_intent = 0;
  PyObject *triangle_nodes_capi = Py_None;
  complex_double s;
  PyObject *s_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  double *phi_precalc = NULL;
  npy_intp phi_precalc_Dims[1] = {-1};
  const int phi_precalc_Rank = 1;
  PyArrayObject *capi_phi_precalc_tmp = NULL;
  int capi_phi_precalc_intent = 0;
  PyObject *phi_precalc_capi = Py_None;
  double *a_precalc = NULL;
  npy_intp a_precalc_Dims[3] = {-1, -1, -1};
  const int a_precalc_Rank = 3;
  PyArrayObject *capi_a_precalc_tmp = NULL;
  int capi_a_precalc_intent = 0;
  PyObject *a_precalc_capi = Py_None;
  int *indices_precalc = NULL;
  npy_intp indices_precalc_Dims[1] = {-1};
  const int indices_precalc_Rank = 1;
  PyArrayObject *capi_indices_precalc_tmp = NULL;
  int capi_indices_precalc_intent = 0;
  PyObject *indices_precalc_capi = Py_None;
  int *indptr_precalc = NULL;
  npy_intp indptr_precalc_Dims[1] = {-1};
  const int indptr_precalc_Rank = 1;
  PyArrayObject *capi_indptr_precalc_tmp = NULL;
  int capi_indptr_precalc_intent = 0;
  PyObject *indptr_precalc_capi = Py_None;
  complex_double *a_face = NULL;
  npy_intp a_face_Dims[4] = {-1, -1, -1, -1};
  const int a_face_Rank = 4;
  PyArrayObject *capi_a_face_tmp = NULL;
  int capi_a_face_intent = 0;
  complex_double *phi_face = NULL;
  npy_intp phi_face_Dims[2] = {-1, -1};
  const int phi_face_Rank = 2;
  PyArrayObject *capi_phi_face_tmp = NULL;
  int capi_phi_face_intent = 0;
  static char *capi_kwlist[] = {"nodes","triangle_nodes","s","xi_eta_eval","weights","phi_precalc","a_precalc","indices_precalc","indptr_precalc","num_nodes","num_triangles","num_integration","num_singular",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|OOOO:core.z_efie_faces_self",\
    capi_kwlist,&nodes_capi,&triangle_nodes_capi,&s_capi,&xi_eta_eval_capi,&weights_capi,&phi_precalc_capi,&a_precalc_capi,&indices_precalc_capi,&indptr_precalc_capi,&num_nodes_capi,&num_triangles_capi,&num_integration_capi,&num_singular_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `xi_eta_eval' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(capi_xi_eta_eval_tmp->data);

  /* Processing variable triangle_nodes */
  triangle_nodes_Dims[1]=3;
  capi_triangle_nodes_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_tmp = array_from_pyobj(NPY_INT,triangle_nodes_Dims,triangle_nodes_Rank,capi_triangle_nodes_intent,triangle_nodes_capi);
  if (capi_triangle_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    triangle_nodes = (int *)(capi_triangle_nodes_tmp->data);

  /* Processing variable s */
    f2py_success = complex_double_from_pyobj(&s,s_capi,"core.z_efie_faces_self() 3rd argument (s) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable nodes */
  nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    nodes = (double *)(capi_nodes_tmp->data);

  /* Processing variable phi_precalc */
  ;
  capi_phi_precalc_intent |= F2PY_INTENT_IN;
  capi_phi_precalc_tmp = array_from_pyobj(NPY_DOUBLE,phi_precalc_Dims,phi_precalc_Rank,capi_phi_precalc_intent,phi_precalc_capi);
  if (capi_phi_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `phi_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    phi_precalc = (double *)(capi_phi_precalc_tmp->data);

  /* Processing variable num_nodes */
  if (num_nodes_capi == Py_None) num_nodes = shape(nodes,0); else
    f2py_success = int_from_pyobj(&num_nodes,num_nodes_capi,"core.z_efie_faces_self() 1st keyword (num_nodes) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes,0)==num_nodes,"shape(nodes,0)==num_nodes","1st keyword num_nodes","z_efie_faces_self:num_nodes=%d",num_nodes) {
  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(triangle_nodes,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.z_efie_faces_self() 2nd keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes,0)==num_triangles,"shape(triangle_nodes,0)==num_triangles","2nd keyword num_triangles","z_efie_faces_self:num_triangles=%d",num_triangles) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_efie_faces_self() 3rd keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","3rd keyword num_integration","z_efie_faces_self:num_integration=%d",num_integration) {
  /* Processing variable num_singular */
  if (num_singular_capi == Py_None) num_singular = len(phi_precalc); else
    f2py_success = int_from_pyobj(&num_singular,num_singular_capi,"core.z_efie_faces_self() 4th keyword (num_singular) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(phi_precalc)>=num_singular,"len(phi_precalc)>=num_singular","4th keyword num_singular","z_efie_faces_self:num_singular=%d",num_singular) {
  /* Processing variable indptr_precalc */
  indptr_precalc_Dims[0]=num_triangles + 1;
  capi_indptr_precalc_intent |= F2PY_INTENT_IN;
  capi_indptr_precalc_tmp = array_from_pyobj(NPY_INT,indptr_precalc_Dims,indptr_precalc_Rank,capi_indptr_precalc_intent,indptr_precalc_capi);
  if (capi_indptr_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 9th argument `indptr_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    indptr_precalc = (int *)(capi_indptr_precalc_tmp->data);

  /* Processing variable a_precalc */
  a_precalc_Dims[0]=num_singular,a_precalc_Dims[1]=3,a_precalc_Dims[2]=3;
  capi_a_precalc_intent |= F2PY_INTENT_IN;
  capi_a_precalc_tmp = array_from_pyobj(NPY_DOUBLE,a_precalc_Dims,a_precalc_Rank,capi_a_precalc_intent,a_precalc_capi);
  if (capi_a_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `a_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    a_precalc = (double *)(capi_a_precalc_tmp->data);

  /* Processing variable phi_face */
  phi_face_Dims[0]=num_triangles,phi_face_Dims[1]=num_triangles;
  capi_phi_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_face_Dims,phi_face_Rank,capi_phi_face_intent,Py_None);
  if (capi_phi_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    phi_face = (complex_double *)(capi_phi_face_tmp->data);

  /* Processing variable a_face */
  a_face_Dims[0]=num_triangles,a_face_Dims[1]=3,a_face_Dims[2]=num_triangles,a_face_Dims[3]=3;
  capi_a_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_face_Dims,a_face_Rank,capi_a_face_intent,Py_None);
  if (capi_a_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    a_face = (complex_double *)(capi_a_face_tmp->data);

  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `weights' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    weights = (double *)(capi_weights_tmp->data);

  /* Processing variable indices_precalc */
  indices_precalc_Dims[0]=num_singular;
  capi_indices_precalc_intent |= F2PY_INTENT_IN;
  capi_indices_precalc_tmp = array_from_pyobj(NPY_INT,indices_precalc_Dims,indices_precalc_Rank,capi_indices_precalc_intent,indices_precalc_capi);
  if (capi_indices_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 8th argument `indices_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    indices_precalc = (int *)(capi_indices_precalc_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes,&num_triangles,&num_integration,&num_singular,nodes,triangle_nodes,&s,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,a_face,phi_face);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_a_face_tmp,capi_phi_face_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_indices_precalc_tmp!=indices_precalc_capi) {
    Py_XDECREF(capi_indices_precalc_tmp); }
  }  /*if (capi_indices_precalc_tmp == NULL) ... else of indices_precalc*/
  /* End of cleaning variable indices_precalc */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  }  /*if (capi_a_face_tmp == NULL) ... else of a_face*/
  /* End of cleaning variable a_face */
  }  /*if (capi_phi_face_tmp == NULL) ... else of phi_face*/
  /* End of cleaning variable phi_face */
  if((PyObject *)capi_a_precalc_tmp!=a_precalc_capi) {
    Py_XDECREF(capi_a_precalc_tmp); }
  }  /*if (capi_a_precalc_tmp == NULL) ... else of a_precalc*/
  /* End of cleaning variable a_precalc */
  if((PyObject *)capi_indptr_precalc_tmp!=indptr_precalc_capi) {
    Py_XDECREF(capi_indptr_precalc_tmp); }
  }  /*if (capi_indptr_precalc_tmp == NULL) ... else of indptr_precalc*/
  /* End of cleaning variable indptr_precalc */
  } /*CHECKSCALAR(len(phi_precalc)>=num_singular)*/
  } /*if (f2py_success) of num_singular*/
  /* End of cleaning variable num_singular */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  } /*CHECKSCALAR(shape(nodes,0)==num_nodes)*/
  } /*if (f2py_success) of num_nodes*/
  /* End of cleaning variable num_nodes */
  if((PyObject *)capi_phi_precalc_tmp!=phi_precalc_capi) {
    Py_XDECREF(capi_phi_precalc_tmp); }
  }  /*if (capi_phi_precalc_tmp == NULL) ... else of phi_precalc*/
  /* End of cleaning variable phi_precalc */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  }  /*if (f2py_success) of s frompyobj*/
  /* End of cleaning variable s */
  if((PyObject *)capi_triangle_nodes_tmp!=triangle_nodes_capi) {
    Py_XDECREF(capi_triangle_nodes_tmp); }
  }  /*if (capi_triangle_nodes_tmp == NULL) ... else of triangle_nodes*/
  /* End of cleaning variable triangle_nodes */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of z_efie_faces_self **************************/

/**************************** z_efie_faces_mutual ****************************/
static char doc_f2py_rout_core_z_efie_faces_mutual[] = "\
Function signature:\n\
  a_face,phi_face = z_efie_faces_mutual(nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,s,xi_eta_eval,weights,[num_nodes_o,num_triangles_o,num_nodes_s,num_triangles_s,num_integration])\n\
Required arguments:\n"
"  nodes_o : input rank-2 array('d') with bounds (num_nodes_o,3)\n"
"  triangle_nodes_o : input rank-2 array('i') with bounds (num_triangles_o,3)\n"
"  nodes_s : input rank-2 array('d') with bounds (num_nodes_s,3)\n"
"  triangle_nodes_s : input rank-2 array('i') with bounds (num_triangles_s,3)\n"
"  s : input complex\n"
"  xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"  weights : input rank-1 array('d') with bounds (num_integration)\n"
"Optional arguments:\n"
"  num_nodes_o := shape(nodes_o,0) input int\n"
"  num_triangles_o := shape(triangle_nodes_o,0) input int\n"
"  num_nodes_s := shape(nodes_s,0) input int\n"
"  num_triangles_s := shape(triangle_nodes_s,0) input int\n"
"  num_integration := shape(xi_eta_eval,0) input int\n"
"Return objects:\n"
"  a_face : rank-4 array('D') with bounds (num_triangles_o,3,num_triangles_s,3)\n"
"  phi_face : rank-2 array('D') with bounds (num_triangles_o,num_triangles_s)";
/* extern void F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_efie_faces_mutual(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes_o = 0;
  PyObject *num_nodes_o_capi = Py_None;
  int num_triangles_o = 0;
  PyObject *num_triangles_o_capi = Py_None;
  int num_nodes_s = 0;
  PyObject *num_nodes_s_capi = Py_None;
  int num_triangles_s = 0;
  PyObject *num_triangles_s_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  int *triangle_nodes_o = NULL;
  npy_intp triangle_nodes_o_Dims[2] = {-1, -1};
  const int triangle_nodes_o_Rank = 2;
  PyArrayObject *capi_triangle_nodes_o_tmp = NULL;
  int capi_triangle_nodes_o_intent = 0;
  PyObject *triangle_nodes_o_capi = Py_None;
  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int *triangle_nodes_s = NULL;
  npy_intp triangle_nodes_s_Dims[2] = {-1, -1};
  const int triangle_nodes_s_Rank = 2;
  PyArrayObject *capi_triangle_nodes_s_tmp = NULL;
  int capi_triangle_nodes_s_intent = 0;
  PyObject *triangle_nodes_s_capi = Py_None;
  complex_double s;
  PyObject *s_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  complex_double *a_face = NULL;
  npy_intp a_face_Dims[4] = {-1, -1, -1, -1};
  const int a_face_Rank = 4;
  PyArrayObject *capi_a_face_tmp = NULL;
  int capi_a_face_intent = 0;
  complex_double *phi_face = NULL;
  npy_intp phi_face_Dims[2] = {-1, -1};
  const int phi_face_Rank = 2;
  PyArrayObject *capi_phi_face_tmp = NULL;
  int capi_phi_face_intent = 0;
  static char *capi_kwlist[] = {"nodes_o","triangle_nodes_o","nodes_s","triangle_nodes_s","s","xi_eta_eval","weights","num_nodes_o","num_triangles_o","num_nodes_s","num_triangles_s","num_integration",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|OOOOO:core.z_efie_faces_mutual",\
    capi_kwlist,&nodes_o_capi,&triangle_nodes_o_capi,&nodes_s_capi,&triangle_nodes_s_capi,&s_capi,&xi_eta_eval_capi,&weights_capi,&num_nodes_o_capi,&num_triangles_o_capi,&num_nodes_s_capi,&num_triangles_s_capi,&num_integration_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable triangle_nodes_s */
  triangle_nodes_s_Dims[1]=3;
  capi_triangle_nodes_s_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_s_tmp = array_from_pyobj(NPY_INT,triangle_nodes_s_Dims,triangle_nodes_s_Rank,capi_triangle_nodes_s_intent,triangle_nodes_s_capi);
  if (capi_triangle_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `triangle_nodes_s' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    triangle_nodes_s = (int *)(capi_triangle_nodes_s_tmp->data);

  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `xi_eta_eval' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(capi_xi_eta_eval_tmp->data);

  /* Processing variable nodes_s */
  nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `nodes_s' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    nodes_s = (double *)(capi_nodes_s_tmp->data);

  /* Processing variable nodes_o */
  nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_o' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    nodes_o = (double *)(capi_nodes_o_tmp->data);

  /* Processing variable s */
    f2py_success = complex_double_from_pyobj(&s,s_capi,"core.z_efie_faces_mutual() 5th argument (s) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable triangle_nodes_o */
  triangle_nodes_o_Dims[1]=3;
  capi_triangle_nodes_o_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_o_tmp = array_from_pyobj(NPY_INT,triangle_nodes_o_Dims,triangle_nodes_o_Rank,capi_triangle_nodes_o_intent,triangle_nodes_o_capi);
  if (capi_triangle_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes_o' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    triangle_nodes_o = (int *)(capi_triangle_nodes_o_tmp->data);

  /* Processing variable num_nodes_o */
  if (num_nodes_o_capi == Py_None) num_nodes_o = shape(nodes_o,0); else
    f2py_success = int_from_pyobj(&num_nodes_o,num_nodes_o_capi,"core.z_efie_faces_mutual() 1st keyword (num_nodes_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_o,0)==num_nodes_o,"shape(nodes_o,0)==num_nodes_o","1st keyword num_nodes_o","z_efie_faces_mutual:num_nodes_o=%d",num_nodes_o) {
  /* Processing variable num_triangles_o */
  if (num_triangles_o_capi == Py_None) num_triangles_o = shape(triangle_nodes_o,0); else
    f2py_success = int_from_pyobj(&num_triangles_o,num_triangles_o_capi,"core.z_efie_faces_mutual() 2nd keyword (num_triangles_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes_o,0)==num_triangles_o,"shape(triangle_nodes_o,0)==num_triangles_o","2nd keyword num_triangles_o","z_efie_faces_mutual:num_triangles_o=%d",num_triangles_o) {
  /* Processing variable num_triangles_s */
  if (num_triangles_s_capi == Py_None) num_triangles_s = shape(triangle_nodes_s,0); else
    f2py_success = int_from_pyobj(&num_triangles_s,num_triangles_s_capi,"core.z_efie_faces_mutual() 4th keyword (num_triangles_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes_s,0)==num_triangles_s,"shape(triangle_nodes_s,0)==num_triangles_s","4th keyword num_triangles_s","z_efie_faces_mutual:num_triangles_s=%d",num_triangles_s) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_efie_faces_mutual() 5th keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","5th keyword num_integration","z_efie_faces_mutual:num_integration=%d",num_integration) {
  /* Processing variable num_nodes_s */
  if (num_nodes_s_capi == Py_None) num_nodes_s = shape(nodes_s,0); else
    f2py_success = int_from_pyobj(&num_nodes_s,num_nodes_s_capi,"core.z_efie_faces_mutual() 3rd keyword (num_nodes_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_s,0)==num_nodes_s,"shape(nodes_s,0)==num_nodes_s","3rd keyword num_nodes_s","z_efie_faces_mutual:num_nodes_s=%d",num_nodes_s) {
  /* Processing variable phi_face */
  phi_face_Dims[0]=num_triangles_o,phi_face_Dims[1]=num_triangles_s;
  capi_phi_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_face_Dims,phi_face_Rank,capi_phi_face_intent,Py_None);
  if (capi_phi_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    phi_face = (complex_double *)(capi_phi_face_tmp->data);

  /* Processing variable a_face */
  a_face_Dims[0]=num_triangles_o,a_face_Dims[1]=3,a_face_Dims[2]=num_triangles_s,a_face_Dims[3]=3;
  capi_a_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_face_Dims,a_face_Rank,capi_a_face_intent,Py_None);
  if (capi_a_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    a_face = (complex_double *)(capi_a_face_tmp->data);

  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `weights' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    weights = (double *)(capi_weights_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes_o,&num_triangles_o,&num_nodes_s,&num_triangles_s,&num_integration,nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,&s,xi_eta_eval,weights,a_face,phi_face);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_a_face_tmp,capi_phi_face_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  }  /*if (capi_a_face_tmp == NULL) ... else of a_face*/
  /* End of cleaning variable a_face */
  }  /*if (capi_phi_face_tmp == NULL) ... else of phi_face*/
  /* End of cleaning variable phi_face */
  } /*CHECKSCALAR(shape(nodes_s,0)==num_nodes_s)*/
  } /*if (f2py_success) of num_nodes_s*/
  /* End of cleaning variable num_nodes_s */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes_s,0)==num_triangles_s)*/
  } /*if (f2py_success) of num_triangles_s*/
  /* End of cleaning variable num_triangles_s */
  } /*CHECKSCALAR(shape(triangle_nodes_o,0)==num_triangles_o)*/
  } /*if (f2py_success) of num_triangles_o*/
  /* End of cleaning variable num_triangles_o */
  } /*CHECKSCALAR(shape(nodes_o,0)==num_nodes_o)*/
  } /*if (f2py_success) of num_nodes_o*/
  /* End of cleaning variable num_nodes_o */
  if((PyObject *)capi_triangle_nodes_o_tmp!=triangle_nodes_o_capi) {
    Py_XDECREF(capi_triangle_nodes_o_tmp); }
  }  /*if (capi_triangle_nodes_o_tmp == NULL) ... else of triangle_nodes_o*/
  /* End of cleaning variable triangle_nodes_o */
  }  /*if (f2py_success) of s frompyobj*/
  /* End of cleaning variable s */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
  if((PyObject *)capi_triangle_nodes_s_tmp!=triangle_nodes_s_capi) {
    Py_XDECREF(capi_triangle_nodes_s_tmp); }
  }  /*if (capi_triangle_nodes_s_tmp == NULL) ... else of triangle_nodes_s*/
  /* End of cleaning variable triangle_nodes_s */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of z_efie_faces_mutual *************************/

/***************************** voltage_plane_wave *****************************/
static char doc_f2py_rout_core_voltage_plane_wave[] = "\
Function signature:\n\
  v = voltage_plane_wave(nodes,triangle_nodes,basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,xi_eta_eval,weights,e_inc,jk_inc,[num_nodes,num_triangles,num_basis,num_integration])\n\
Required arguments:\n"
"  nodes : input rank-2 array('d') with bounds (num_nodes,3)\n"
"  triangle_nodes : input rank-2 array('i') with bounds (num_triangles,3)\n"
"  basis_tri_p : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_tri_m : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_node_p : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_node_m : input rank-1 array('i') with bounds (num_basis)\n"
"  xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"  weights : input rank-1 array('d') with bounds (num_integration)\n"
"  e_inc : input rank-1 array('D') with bounds (3)\n"
"  jk_inc : input rank-1 array('D') with bounds (3)\n"
"Optional arguments:\n"
"  num_nodes := shape(nodes,0) input int\n"
"  num_triangles := shape(triangle_nodes,0) input int\n"
"  num_basis := len(basis_tri_p) input int\n"
"  num_integration := shape(xi_eta_eval,0) input int\n"
"Return objects:\n"
"  v : rank-1 array('D') with bounds (num_basis)";
/* extern void F_FUNC_US(voltage_plane_wave,VOLTAGE_PLANE_WAVE)(int*,int*,int*,int*,double*,int*,int*,int*,int*,int*,double*,double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_voltage_plane_wave(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,double*,int*,int*,int*,int*,int*,double*,double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes = 0;
  PyObject *num_nodes_capi = Py_None;
  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_basis = 0;
  PyObject *num_basis_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  int *triangle_nodes = NULL;
  npy_intp triangle_nodes_Dims[2] = {-1, -1};
  const int triangle_nodes_Rank = 2;
  PyArrayObject *capi_triangle_nodes_tmp = NULL;
  int capi_triangle_nodes_intent = 0;
  PyObject *triangle_nodes_capi = Py_None;
  int *basis_tri_p = NULL;
  npy_intp basis_tri_p_Dims[1] = {-1};
  const int basis_tri_p_Rank = 1;
  PyArrayObject *capi_basis_tri_p_tmp = NULL;
  int capi_basis_tri_p_intent = 0;
  PyObject *basis_tri_p_capi = Py_None;
  int *basis_tri_m = NULL;
  npy_intp basis_tri_m_Dims[1] = {-1};
  const int basis_tri_m_Rank = 1;
  PyArrayObject *capi_basis_tri_m_tmp = NULL;
  int capi_basis_tri_m_intent = 0;
  PyObject *basis_tri_m_capi = Py_None;
  int *basis_node_p = NULL;
  npy_intp basis_node_p_Dims[1] = {-1};
  const int basis_node_p_Rank = 1;
  PyArrayObject *capi_basis_node_p_tmp = NULL;
  int capi_basis_node_p_intent = 0;
  PyObject *basis_node_p_capi = Py_None;
  int *basis_node_m = NULL;
  npy_intp basis_node_m_Dims[1] = {-1};
  const int basis_node_m_Rank = 1;
  PyArrayObject *capi_basis_node_m_tmp = NULL;
  int capi_basis_node_m_intent = 0;
  PyObject *basis_node_m_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  complex_double *e_inc = NULL;
  npy_intp e_inc_Dims[1] = {-1};
  const int e_inc_Rank = 1;
  PyArrayObject *capi_e_inc_tmp = NULL;
  int capi_e_inc_intent = 0;
  PyObject *e_inc_capi = Py_None;
  complex_double *jk_inc = NULL;
  npy_intp jk_inc_Dims[1] = {-1};
  const int jk_inc_Rank = 1;
  PyArrayObject *capi_jk_inc_tmp = NULL;
  int capi_jk_inc_intent = 0;
  PyObject *jk_inc_capi = Py_None;
  complex_double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  static char *capi_kwlist[] = {"nodes","triangle_nodes","basis_tri_p","basis_tri_m","basis_node_p","basis_node_m","xi_eta_eval","weights","e_inc","jk_inc","num_nodes","num_triangles","num_basis","num_integration",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|OOOO:core.voltage_plane_wave",\
    capi_kwlist,&nodes_capi,&triangle_nodes_capi,&basis_tri_p_capi,&basis_tri_m_capi,&basis_node_p_capi,&basis_node_m_capi,&xi_eta_eval_capi,&weights_capi,&e_inc_capi,&jk_inc_capi,&num_nodes_capi,&num_triangles_capi,&num_basis_capi,&num_integration_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable basis_tri_p */
  ;
  capi_basis_tri_p_intent |= F2PY_INTENT_IN;
  capi_basis_tri_p_tmp = array_from_pyobj(NPY_INT,basis_tri_p_Dims,basis_tri_p_Rank,capi_basis_tri_p_intent,basis_tri_p_capi);
  if (capi_basis_tri_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `basis_tri_p' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    basis_tri_p = (int *)(capi_basis_tri_p_tmp->data);

  /* Processing variable triangle_nodes */
  triangle_nodes_Dims[1]=3;
  capi_triangle_nodes_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_tmp = array_from_pyobj(NPY_INT,triangle_nodes_Dims,triangle_nodes_Rank,capi_triangle_nodes_intent,triangle_nodes_capi);
  if (capi_triangle_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    triangle_nodes = (int *)(capi_triangle_nodes_tmp->data);

  /* Processing variable e_inc */
  e_inc_Dims[0]=3;
  capi_e_inc_intent |= F2PY_INTENT_IN;
  capi_e_inc_tmp = array_from_pyobj(NPY_CDOUBLE,e_inc_Dims,e_inc_Rank,capi_e_inc_intent,e_inc_capi);
  if (capi_e_inc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 9th argument `e_inc' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    e_inc = (complex_double *)(capi_e_inc_tmp->data);

  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `xi_eta_eval' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(capi_xi_eta_eval_tmp->data);

  /* Processing variable nodes */
  nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    nodes = (double *)(capi_nodes_tmp->data);

  /* Processing variable jk_inc */
  jk_inc_Dims[0]=3;
  capi_jk_inc_intent |= F2PY_INTENT_IN;
  capi_jk_inc_tmp = array_from_pyobj(NPY_CDOUBLE,jk_inc_Dims,jk_inc_Rank,capi_jk_inc_intent,jk_inc_capi);
  if (capi_jk_inc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 10th argument `jk_inc' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    jk_inc = (complex_double *)(capi_jk_inc_tmp->data);

  /* Processing variable num_nodes */
  if (num_nodes_capi == Py_None) num_nodes = shape(nodes,0); else
    f2py_success = int_from_pyobj(&num_nodes,num_nodes_capi,"core.voltage_plane_wave() 1st keyword (num_nodes) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes,0)==num_nodes,"shape(nodes,0)==num_nodes","1st keyword num_nodes","voltage_plane_wave:num_nodes=%d",num_nodes) {
  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(triangle_nodes,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.voltage_plane_wave() 2nd keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes,0)==num_triangles,"shape(triangle_nodes,0)==num_triangles","2nd keyword num_triangles","voltage_plane_wave:num_triangles=%d",num_triangles) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.voltage_plane_wave() 4th keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","4th keyword num_integration","voltage_plane_wave:num_integration=%d",num_integration) {
  /* Processing variable num_basis */
  if (num_basis_capi == Py_None) num_basis = len(basis_tri_p); else
    f2py_success = int_from_pyobj(&num_basis,num_basis_capi,"core.voltage_plane_wave() 3rd keyword (num_basis) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(basis_tri_p)>=num_basis,"len(basis_tri_p)>=num_basis","3rd keyword num_basis","voltage_plane_wave:num_basis=%d",num_basis) {
  /* Processing variable basis_tri_m */
  basis_tri_m_Dims[0]=num_basis;
  capi_basis_tri_m_intent |= F2PY_INTENT_IN;
  capi_basis_tri_m_tmp = array_from_pyobj(NPY_INT,basis_tri_m_Dims,basis_tri_m_Rank,capi_basis_tri_m_intent,basis_tri_m_capi);
  if (capi_basis_tri_m_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `basis_tri_m' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    basis_tri_m = (int *)(capi_basis_tri_m_tmp->data);

  /* Processing variable basis_node_m */
  basis_node_m_Dims[0]=num_basis;
  capi_basis_node_m_intent |= F2PY_INTENT_IN;
  capi_basis_node_m_tmp = array_from_pyobj(NPY_INT,basis_node_m_Dims,basis_node_m_Rank,capi_basis_node_m_intent,basis_node_m_capi);
  if (capi_basis_node_m_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `basis_node_m' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    basis_node_m = (int *)(capi_basis_node_m_tmp->data);

  /* Processing variable basis_node_p */
  basis_node_p_Dims[0]=num_basis;
  capi_basis_node_p_intent |= F2PY_INTENT_IN;
  capi_basis_node_p_tmp = array_from_pyobj(NPY_INT,basis_node_p_Dims,basis_node_p_Rank,capi_basis_node_p_intent,basis_node_p_capi);
  if (capi_basis_node_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `basis_node_p' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    basis_node_p = (int *)(capi_basis_node_p_tmp->data);

  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 8th argument `weights' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    weights = (double *)(capi_weights_tmp->data);

  /* Processing variable v */
  v_Dims[0]=num_basis;
  capi_v_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_v_tmp = array_from_pyobj(NPY_CDOUBLE,v_Dims,v_Rank,capi_v_intent,Py_None);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `v' of core.voltage_plane_wave to C/Fortran array" );
  } else {
    v = (complex_double *)(capi_v_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes,&num_triangles,&num_basis,&num_integration,nodes,triangle_nodes,basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,xi_eta_eval,weights,e_inc,jk_inc,v);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_v_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  if((PyObject *)capi_basis_node_p_tmp!=basis_node_p_capi) {
    Py_XDECREF(capi_basis_node_p_tmp); }
  }  /*if (capi_basis_node_p_tmp == NULL) ... else of basis_node_p*/
  /* End of cleaning variable basis_node_p */
  if((PyObject *)capi_basis_node_m_tmp!=basis_node_m_capi) {
    Py_XDECREF(capi_basis_node_m_tmp); }
  }  /*if (capi_basis_node_m_tmp == NULL) ... else of basis_node_m*/
  /* End of cleaning variable basis_node_m */
  if((PyObject *)capi_basis_tri_m_tmp!=basis_tri_m_capi) {
    Py_XDECREF(capi_basis_tri_m_tmp); }
  }  /*if (capi_basis_tri_m_tmp == NULL) ... else of basis_tri_m*/
  /* End of cleaning variable basis_tri_m */
  } /*CHECKSCALAR(len(basis_tri_p)>=num_basis)*/
  } /*if (f2py_success) of num_basis*/
  /* End of cleaning variable num_basis */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  } /*CHECKSCALAR(shape(nodes,0)==num_nodes)*/
  } /*if (f2py_success) of num_nodes*/
  /* End of cleaning variable num_nodes */
  if((PyObject *)capi_jk_inc_tmp!=jk_inc_capi) {
    Py_XDECREF(capi_jk_inc_tmp); }
  }  /*if (capi_jk_inc_tmp == NULL) ... else of jk_inc*/
  /* End of cleaning variable jk_inc */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
  if((PyObject *)capi_e_inc_tmp!=e_inc_capi) {
    Py_XDECREF(capi_e_inc_tmp); }
  }  /*if (capi_e_inc_tmp == NULL) ... else of e_inc*/
  /* End of cleaning variable e_inc */
  if((PyObject *)capi_triangle_nodes_tmp!=triangle_nodes_capi) {
    Py_XDECREF(capi_triangle_nodes_tmp); }
  }  /*if (capi_triangle_nodes_tmp == NULL) ... else of triangle_nodes*/
  /* End of cleaning variable triangle_nodes */
  if((PyObject *)capi_basis_tri_p_tmp!=basis_tri_p_capi) {
    Py_XDECREF(capi_basis_tri_p_tmp); }
  }  /*if (capi_basis_tri_p_tmp == NULL) ... else of basis_tri_p*/
  /* End of cleaning variable basis_tri_p */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of voltage_plane_wave *************************/

/************************** v_efie_faces_plane_wave **************************/
static char doc_f2py_rout_core_v_efie_faces_plane_wave[] = "\
Function signature:\n\
  v_faces = v_efie_faces_plane_wave(nodes,triangle_nodes,xi_eta_eval,weights,e_inc,jk_inc,[num_nodes,num_triangles,num_integration])\n\
Required arguments:\n"
"  nodes : input rank-2 array('d') with bounds (num_nodes,3)\n"
"  triangle_nodes : input rank-2 array('i') with bounds (num_triangles,3)\n"
"  xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"  weights : input rank-1 array('d') with bounds (num_integration)\n"
"  e_inc : input rank-1 array('D') with bounds (3)\n"
"  jk_inc : input rank-1 array('D') with bounds (3)\n"
"Optional arguments:\n"
"  num_nodes := shape(nodes,0) input int\n"
"  num_triangles := shape(triangle_nodes,0) input int\n"
"  num_integration := shape(xi_eta_eval,0) input int\n"
"Return objects:\n"
"  v_faces : rank-2 array('D') with bounds (num_triangles,3)";
/* extern void F_FUNC_US(v_efie_faces_plane_wave,V_EFIE_FACES_PLANE_WAVE)(int*,int*,int*,double*,int*,double*,double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_v_efie_faces_plane_wave(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,double*,int*,double*,double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes = 0;
  PyObject *num_nodes_capi = Py_None;
  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  int *triangle_nodes = NULL;
  npy_intp triangle_nodes_Dims[2] = {-1, -1};
  const int triangle_nodes_Rank = 2;
  PyArrayObject *capi_triangle_nodes_tmp = NULL;
  int capi_triangle_nodes_intent = 0;
  PyObject *triangle_nodes_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  complex_double *e_inc = NULL;
  npy_intp e_inc_Dims[1] = {-1};
  const int e_inc_Rank = 1;
  PyArrayObject *capi_e_inc_tmp = NULL;
  int capi_e_inc_intent = 0;
  PyObject *e_inc_capi = Py_None;
  complex_double *jk_inc = NULL;
  npy_intp jk_inc_Dims[1] = {-1};
  const int jk_inc_Rank = 1;
  PyArrayObject *capi_jk_inc_tmp = NULL;
  int capi_jk_inc_intent = 0;
  PyObject *jk_inc_capi = Py_None;
  complex_double *v_faces = NULL;
  npy_intp v_faces_Dims[2] = {-1, -1};
  const int v_faces_Rank = 2;
  PyArrayObject *capi_v_faces_tmp = NULL;
  int capi_v_faces_intent = 0;
  static char *capi_kwlist[] = {"nodes","triangle_nodes","xi_eta_eval","weights","e_inc","jk_inc","num_nodes","num_triangles","num_integration",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OOO:core.v_efie_faces_plane_wave",\
    capi_kwlist,&nodes_capi,&triangle_nodes_capi,&xi_eta_eval_capi,&weights_capi,&e_inc_capi,&jk_inc_capi,&num_nodes_capi,&num_triangles_capi,&num_integration_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `xi_eta_eval' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(capi_xi_eta_eval_tmp->data);

  /* Processing variable triangle_nodes */
  triangle_nodes_Dims[1]=3;
  capi_triangle_nodes_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_tmp = array_from_pyobj(NPY_INT,triangle_nodes_Dims,triangle_nodes_Rank,capi_triangle_nodes_intent,triangle_nodes_capi);
  if (capi_triangle_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    triangle_nodes = (int *)(capi_triangle_nodes_tmp->data);

  /* Processing variable e_inc */
  e_inc_Dims[0]=3;
  capi_e_inc_intent |= F2PY_INTENT_IN;
  capi_e_inc_tmp = array_from_pyobj(NPY_CDOUBLE,e_inc_Dims,e_inc_Rank,capi_e_inc_intent,e_inc_capi);
  if (capi_e_inc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `e_inc' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    e_inc = (complex_double *)(capi_e_inc_tmp->data);

  /* Processing variable jk_inc */
  jk_inc_Dims[0]=3;
  capi_jk_inc_intent |= F2PY_INTENT_IN;
  capi_jk_inc_tmp = array_from_pyobj(NPY_CDOUBLE,jk_inc_Dims,jk_inc_Rank,capi_jk_inc_intent,jk_inc_capi);
  if (capi_jk_inc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `jk_inc' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    jk_inc = (complex_double *)(capi_jk_inc_tmp->data);

  /* Processing variable nodes */
  nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    nodes = (double *)(capi_nodes_tmp->data);

  /* Processing variable num_nodes */
  if (num_nodes_capi == Py_None) num_nodes = shape(nodes,0); else
    f2py_success = int_from_pyobj(&num_nodes,num_nodes_capi,"core.v_efie_faces_plane_wave() 1st keyword (num_nodes) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes,0)==num_nodes,"shape(nodes,0)==num_nodes","1st keyword num_nodes","v_efie_faces_plane_wave:num_nodes=%d",num_nodes) {
  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(triangle_nodes,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.v_efie_faces_plane_wave() 2nd keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes,0)==num_triangles,"shape(triangle_nodes,0)==num_triangles","2nd keyword num_triangles","v_efie_faces_plane_wave:num_triangles=%d",num_triangles) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.v_efie_faces_plane_wave() 3rd keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","3rd keyword num_integration","v_efie_faces_plane_wave:num_integration=%d",num_integration) {
  /* Processing variable v_faces */
  v_faces_Dims[0]=num_triangles,v_faces_Dims[1]=3;
  capi_v_faces_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_v_faces_tmp = array_from_pyobj(NPY_CDOUBLE,v_faces_Dims,v_faces_Rank,capi_v_faces_intent,Py_None);
  if (capi_v_faces_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `v_faces' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    v_faces = (complex_double *)(capi_v_faces_tmp->data);

  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `weights' of core.v_efie_faces_plane_wave to C/Fortran array" );
  } else {
    weights = (double *)(capi_weights_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes,&num_triangles,&num_integration,nodes,triangle_nodes,xi_eta_eval,weights,e_inc,jk_inc,v_faces);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_v_faces_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  }  /*if (capi_v_faces_tmp == NULL) ... else of v_faces*/
  /* End of cleaning variable v_faces */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  } /*CHECKSCALAR(shape(nodes,0)==num_nodes)*/
  } /*if (f2py_success) of num_nodes*/
  /* End of cleaning variable num_nodes */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  if((PyObject *)capi_jk_inc_tmp!=jk_inc_capi) {
    Py_XDECREF(capi_jk_inc_tmp); }
  }  /*if (capi_jk_inc_tmp == NULL) ... else of jk_inc*/
  /* End of cleaning variable jk_inc */
  if((PyObject *)capi_e_inc_tmp!=e_inc_capi) {
    Py_XDECREF(capi_e_inc_tmp); }
  }  /*if (capi_e_inc_tmp == NULL) ... else of e_inc*/
  /* End of cleaning variable e_inc */
  if((PyObject *)capi_triangle_nodes_tmp!=triangle_nodes_capi) {
    Py_XDECREF(capi_triangle_nodes_tmp); }
  }  /*if (capi_triangle_nodes_tmp == NULL) ... else of triangle_nodes*/
  /* End of cleaning variable triangle_nodes */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of v_efie_faces_plane_wave ***********************/

/************************** face_integrals_hanninen **************************/
static char doc_f2py_rout_core_face_integrals_hanninen[] = "\
Function signature:\n\
  i_a,i_phi = face_integrals_hanninen(nodes_s,xi_eta_o,weights_o,nodes_o,[n_o])\n\
Required arguments:\n"
"  nodes_s : input rank-2 array('d') with bounds (3,3)\n"
"  xi_eta_o : input rank-2 array('d') with bounds (n_o,2)\n"
"  weights_o : input rank-1 array('d') with bounds (n_o)\n"
"  nodes_o : input rank-2 array('d') with bounds (3,3)\n"
"Optional arguments:\n"
"  n_o := shape(xi_eta_o,0) input int\n"
"Return objects:\n"
"  i_a : rank-2 array('d') with bounds (3,3)\n"
"  i_phi : float";
/* extern void F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN)(double*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_core_face_integrals_hanninen(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int n_o = 0;
  PyObject *n_o_capi = Py_None;
  double *xi_eta_o = NULL;
  npy_intp xi_eta_o_Dims[2] = {-1, -1};
  const int xi_eta_o_Rank = 2;
  PyArrayObject *capi_xi_eta_o_tmp = NULL;
  int capi_xi_eta_o_intent = 0;
  PyObject *xi_eta_o_capi = Py_None;
  double *weights_o = NULL;
  npy_intp weights_o_Dims[1] = {-1};
  const int weights_o_Rank = 1;
  PyArrayObject *capi_weights_o_tmp = NULL;
  int capi_weights_o_intent = 0;
  PyObject *weights_o_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  double *i_a = NULL;
  npy_intp i_a_Dims[2] = {-1, -1};
  const int i_a_Rank = 2;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  double i_phi = 0;
  static char *capi_kwlist[] = {"nodes_s","xi_eta_o","weights_o","nodes_o","n_o",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:core.face_integrals_hanninen",\
    capi_kwlist,&nodes_s_capi,&xi_eta_o_capi,&weights_o_capi,&nodes_o_capi,&n_o_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nodes_s */
  nodes_s_Dims[0]=3,nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_s' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    nodes_s = (double *)(capi_nodes_s_tmp->data);

  /* Processing variable xi_eta_o */
  xi_eta_o_Dims[1]=2;
  capi_xi_eta_o_intent |= F2PY_INTENT_IN;
  capi_xi_eta_o_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_o_Dims,xi_eta_o_Rank,capi_xi_eta_o_intent,xi_eta_o_capi);
  if (capi_xi_eta_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `xi_eta_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    xi_eta_o = (double *)(capi_xi_eta_o_tmp->data);

  /* Processing variable i_a */
  i_a_Dims[0]=3,i_a_Dims[1]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_DOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    i_a = (double *)(capi_i_a_tmp->data);

  /* Processing variable i_phi */
  /* Processing variable nodes_o */
  nodes_o_Dims[0]=3,nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `nodes_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    nodes_o = (double *)(capi_nodes_o_tmp->data);

  /* Processing variable n_o */
  if (n_o_capi == Py_None) n_o = shape(xi_eta_o,0); else
    f2py_success = int_from_pyobj(&n_o,n_o_capi,"core.face_integrals_hanninen() 1st keyword (n_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_o,0)==n_o,"shape(xi_eta_o,0)==n_o","1st keyword n_o","face_integrals_hanninen:n_o=%d",n_o) {
  /* Processing variable weights_o */
  weights_o_Dims[0]=n_o;
  capi_weights_o_intent |= F2PY_INTENT_IN;
  capi_weights_o_tmp = array_from_pyobj(NPY_DOUBLE,weights_o_Dims,weights_o_Rank,capi_weights_o_intent,weights_o_capi);
  if (capi_weights_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `weights_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    weights_o = (double *)(capi_weights_o_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(nodes_s,&n_o,xi_eta_o,weights_o,nodes_o,i_a,&i_phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("Nd",capi_i_a_tmp,i_phi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_o_tmp!=weights_o_capi) {
    Py_XDECREF(capi_weights_o_tmp); }
  }  /*if (capi_weights_o_tmp == NULL) ... else of weights_o*/
  /* End of cleaning variable weights_o */
  } /*CHECKSCALAR(shape(xi_eta_o,0)==n_o)*/
  } /*if (f2py_success) of n_o*/
  /* End of cleaning variable n_o */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  /* End of cleaning variable i_phi */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  if((PyObject *)capi_xi_eta_o_tmp!=xi_eta_o_capi) {
    Py_XDECREF(capi_xi_eta_o_tmp); }
  }  /*if (capi_xi_eta_o_tmp == NULL) ... else of xi_eta_o*/
  /* End of cleaning variable xi_eta_o */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of face_integrals_hanninen ***********************/

/**************************** triangle_face_to_rwg ****************************/
static char doc_f2py_rout_core_triangle_face_to_rwg[] = "\
Function signature:\n\
  vector_rwg,scalar_rwg = triangle_face_to_rwg(basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,vector_face,scalar_face,[num_triangles,num_basis])\n\
Required arguments:\n"
"  basis_tri_p : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_tri_m : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_node_p : input rank-1 array('i') with bounds (num_basis)\n"
"  basis_node_m : input rank-1 array('i') with bounds (num_basis)\n"
"  vector_face : input rank-4 array('D') with bounds (num_triangles,num_triangles,3,3)\n"
"  scalar_face : input rank-2 array('D') with bounds (num_triangles,num_triangles)\n"
"Optional arguments:\n"
"  num_triangles := shape(vector_face,0) input int\n"
"  num_basis := len(basis_tri_p) input int\n"
"Return objects:\n"
"  vector_rwg : rank-2 array('D') with bounds (num_basis,num_basis)\n"
"  scalar_rwg : rank-2 array('D') with bounds (num_basis,num_basis)";
/* extern void F_FUNC_US(triangle_face_to_rwg,TRIANGLE_FACE_TO_RWG)(int*,int*,int*,int*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_triangle_face_to_rwg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_basis = 0;
  PyObject *num_basis_capi = Py_None;
  int *basis_tri_p = NULL;
  npy_intp basis_tri_p_Dims[1] = {-1};
  const int basis_tri_p_Rank = 1;
  PyArrayObject *capi_basis_tri_p_tmp = NULL;
  int capi_basis_tri_p_intent = 0;
  PyObject *basis_tri_p_capi = Py_None;
  int *basis_tri_m = NULL;
  npy_intp basis_tri_m_Dims[1] = {-1};
  const int basis_tri_m_Rank = 1;
  PyArrayObject *capi_basis_tri_m_tmp = NULL;
  int capi_basis_tri_m_intent = 0;
  PyObject *basis_tri_m_capi = Py_None;
  int *basis_node_p = NULL;
  npy_intp basis_node_p_Dims[1] = {-1};
  const int basis_node_p_Rank = 1;
  PyArrayObject *capi_basis_node_p_tmp = NULL;
  int capi_basis_node_p_intent = 0;
  PyObject *basis_node_p_capi = Py_None;
  int *basis_node_m = NULL;
  npy_intp basis_node_m_Dims[1] = {-1};
  const int basis_node_m_Rank = 1;
  PyArrayObject *capi_basis_node_m_tmp = NULL;
  int capi_basis_node_m_intent = 0;
  PyObject *basis_node_m_capi = Py_None;
  complex_double *vector_face = NULL;
  npy_intp vector_face_Dims[4] = {-1, -1, -1, -1};
  const int vector_face_Rank = 4;
  PyArrayObject *capi_vector_face_tmp = NULL;
  int capi_vector_face_intent = 0;
  PyObject *vector_face_capi = Py_None;
  complex_double *scalar_face = NULL;
  npy_intp scalar_face_Dims[2] = {-1, -1};
  const int scalar_face_Rank = 2;
  PyArrayObject *capi_scalar_face_tmp = NULL;
  int capi_scalar_face_intent = 0;
  PyObject *scalar_face_capi = Py_None;
  complex_double *vector_rwg = NULL;
  npy_intp vector_rwg_Dims[2] = {-1, -1};
  const int vector_rwg_Rank = 2;
  PyArrayObject *capi_vector_rwg_tmp = NULL;
  int capi_vector_rwg_intent = 0;
  complex_double *scalar_rwg = NULL;
  npy_intp scalar_rwg_Dims[2] = {-1, -1};
  const int scalar_rwg_Rank = 2;
  PyArrayObject *capi_scalar_rwg_tmp = NULL;
  int capi_scalar_rwg_intent = 0;
  static char *capi_kwlist[] = {"basis_tri_p","basis_tri_m","basis_node_p","basis_node_m","vector_face","scalar_face","num_triangles","num_basis",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OO:core.triangle_face_to_rwg",\
    capi_kwlist,&basis_tri_p_capi,&basis_tri_m_capi,&basis_node_p_capi,&basis_node_m_capi,&vector_face_capi,&scalar_face_capi,&num_triangles_capi,&num_basis_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vector_face */
  vector_face_Dims[2]=3,vector_face_Dims[3]=3;
  capi_vector_face_intent |= F2PY_INTENT_IN;
  capi_vector_face_tmp = array_from_pyobj(NPY_CDOUBLE,vector_face_Dims,vector_face_Rank,capi_vector_face_intent,vector_face_capi);
  if (capi_vector_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `vector_face' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    vector_face = (complex_double *)(capi_vector_face_tmp->data);

  /* Processing variable basis_tri_p */
  ;
  capi_basis_tri_p_intent |= F2PY_INTENT_IN;
  capi_basis_tri_p_tmp = array_from_pyobj(NPY_INT,basis_tri_p_Dims,basis_tri_p_Rank,capi_basis_tri_p_intent,basis_tri_p_capi);
  if (capi_basis_tri_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `basis_tri_p' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    basis_tri_p = (int *)(capi_basis_tri_p_tmp->data);

  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(vector_face,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.triangle_face_to_rwg() 1st keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(vector_face,0)==num_triangles,"shape(vector_face,0)==num_triangles","1st keyword num_triangles","triangle_face_to_rwg:num_triangles=%d",num_triangles) {
  /* Processing variable scalar_face */
  scalar_face_Dims[0]=num_triangles,scalar_face_Dims[1]=num_triangles;
  capi_scalar_face_intent |= F2PY_INTENT_IN;
  capi_scalar_face_tmp = array_from_pyobj(NPY_CDOUBLE,scalar_face_Dims,scalar_face_Rank,capi_scalar_face_intent,scalar_face_capi);
  if (capi_scalar_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `scalar_face' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    scalar_face = (complex_double *)(capi_scalar_face_tmp->data);

  /* Processing variable num_basis */
  if (num_basis_capi == Py_None) num_basis = len(basis_tri_p); else
    f2py_success = int_from_pyobj(&num_basis,num_basis_capi,"core.triangle_face_to_rwg() 2nd keyword (num_basis) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(basis_tri_p)>=num_basis,"len(basis_tri_p)>=num_basis","2nd keyword num_basis","triangle_face_to_rwg:num_basis=%d",num_basis) {
  /* Processing variable scalar_rwg */
  scalar_rwg_Dims[0]=num_basis,scalar_rwg_Dims[1]=num_basis;
  capi_scalar_rwg_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_scalar_rwg_tmp = array_from_pyobj(NPY_CDOUBLE,scalar_rwg_Dims,scalar_rwg_Rank,capi_scalar_rwg_intent,Py_None);
  if (capi_scalar_rwg_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `scalar_rwg' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    scalar_rwg = (complex_double *)(capi_scalar_rwg_tmp->data);

  /* Processing variable basis_node_m */
  basis_node_m_Dims[0]=num_basis;
  capi_basis_node_m_intent |= F2PY_INTENT_IN;
  capi_basis_node_m_tmp = array_from_pyobj(NPY_INT,basis_node_m_Dims,basis_node_m_Rank,capi_basis_node_m_intent,basis_node_m_capi);
  if (capi_basis_node_m_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `basis_node_m' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    basis_node_m = (int *)(capi_basis_node_m_tmp->data);

  /* Processing variable vector_rwg */
  vector_rwg_Dims[0]=num_basis,vector_rwg_Dims[1]=num_basis;
  capi_vector_rwg_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_vector_rwg_tmp = array_from_pyobj(NPY_CDOUBLE,vector_rwg_Dims,vector_rwg_Rank,capi_vector_rwg_intent,Py_None);
  if (capi_vector_rwg_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `vector_rwg' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    vector_rwg = (complex_double *)(capi_vector_rwg_tmp->data);

  /* Processing variable basis_node_p */
  basis_node_p_Dims[0]=num_basis;
  capi_basis_node_p_intent |= F2PY_INTENT_IN;
  capi_basis_node_p_tmp = array_from_pyobj(NPY_INT,basis_node_p_Dims,basis_node_p_Rank,capi_basis_node_p_intent,basis_node_p_capi);
  if (capi_basis_node_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `basis_node_p' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    basis_node_p = (int *)(capi_basis_node_p_tmp->data);

  /* Processing variable basis_tri_m */
  basis_tri_m_Dims[0]=num_basis;
  capi_basis_tri_m_intent |= F2PY_INTENT_IN;
  capi_basis_tri_m_tmp = array_from_pyobj(NPY_INT,basis_tri_m_Dims,basis_tri_m_Rank,capi_basis_tri_m_intent,basis_tri_m_capi);
  if (capi_basis_tri_m_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `basis_tri_m' of core.triangle_face_to_rwg to C/Fortran array" );
  } else {
    basis_tri_m = (int *)(capi_basis_tri_m_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_triangles,&num_basis,basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,vector_face,scalar_face,vector_rwg,scalar_rwg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_vector_rwg_tmp,capi_scalar_rwg_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_basis_tri_m_tmp!=basis_tri_m_capi) {
    Py_XDECREF(capi_basis_tri_m_tmp); }
  }  /*if (capi_basis_tri_m_tmp == NULL) ... else of basis_tri_m*/
  /* End of cleaning variable basis_tri_m */
  if((PyObject *)capi_basis_node_p_tmp!=basis_node_p_capi) {
    Py_XDECREF(capi_basis_node_p_tmp); }
  }  /*if (capi_basis_node_p_tmp == NULL) ... else of basis_node_p*/
  /* End of cleaning variable basis_node_p */
  }  /*if (capi_vector_rwg_tmp == NULL) ... else of vector_rwg*/
  /* End of cleaning variable vector_rwg */
  if((PyObject *)capi_basis_node_m_tmp!=basis_node_m_capi) {
    Py_XDECREF(capi_basis_node_m_tmp); }
  }  /*if (capi_basis_node_m_tmp == NULL) ... else of basis_node_m*/
  /* End of cleaning variable basis_node_m */
  }  /*if (capi_scalar_rwg_tmp == NULL) ... else of scalar_rwg*/
  /* End of cleaning variable scalar_rwg */
  } /*CHECKSCALAR(len(basis_tri_p)>=num_basis)*/
  } /*if (f2py_success) of num_basis*/
  /* End of cleaning variable num_basis */
  if((PyObject *)capi_scalar_face_tmp!=scalar_face_capi) {
    Py_XDECREF(capi_scalar_face_tmp); }
  }  /*if (capi_scalar_face_tmp == NULL) ... else of scalar_face*/
  /* End of cleaning variable scalar_face */
  } /*CHECKSCALAR(shape(vector_face,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  if((PyObject *)capi_basis_tri_p_tmp!=basis_tri_p_capi) {
    Py_XDECREF(capi_basis_tri_p_tmp); }
  }  /*if (capi_basis_tri_p_tmp == NULL) ... else of basis_tri_p*/
  /* End of cleaning variable basis_tri_p */
  if((PyObject *)capi_vector_face_tmp!=vector_face_capi) {
    Py_XDECREF(capi_vector_face_tmp); }
  }  /*if (capi_vector_face_tmp == NULL) ... else of vector_face*/
  /* End of cleaning variable vector_face */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************ end of triangle_face_to_rwg ************************/

/******************************** set_threads ********************************/
static char doc_f2py_rout_core_set_threads[] = "\
Function signature:\n\
  set_threads(n)\n\
Required arguments:\n"
"  n : input int";
/* extern void F_FUNC_US(set_threads,SET_THREADS)(int*); */
static PyObject *f2py_rout_core_set_threads(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  static char *capi_kwlist[] = {"n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:core.set_threads",\
    capi_kwlist,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"core.set_threads() 1st argument (n) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of set_threads *****************************/

/******************************** get_threads ********************************/
static char doc_f2py_rout_core_get_threads[] = "\
Function signature:\n\
  n = get_threads()\n\
Return objects:\n"
"  n : int";
/* extern void F_FUNC_US(get_threads,GET_THREADS)(int*); */
static PyObject *f2py_rout_core_get_threads(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":core.get_threads",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",n);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of get_threads *****************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_constants_def[] = {
  {"sp",0,{{-1}},NPY_INT},
  {"dp",0,{{-1}},NPY_INT},
  {"wp",0,{{-1}},NPY_INT},
  {NULL}
};

static void f2py_setup_constants(char *sp,char *dp,char *wp) {
  int i_f2py=0;
  f2py_constants_def[i_f2py++].data = sp;
  f2py_constants_def[i_f2py++].data = dp;
  f2py_constants_def[i_f2py++].data = wp;
}
extern void F_FUNC(f2pyinitconstants,F2PYINITCONSTANTS)(void (*)(char*,char*,char*));
static void f2py_init_constants(void) {
  F_FUNC(f2pyinitconstants,F2PYINITCONSTANTS)(f2py_setup_constants);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"scr_index",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(scr_index,SCR_INDEX),(f2py_init_func)f2py_rout_core_scr_index,doc_f2py_rout_core_scr_index},
  {"face_integrals_complex",-1,{{-1}},0,(char *)F_FUNC_US(face_integrals_complex,FACE_INTEGRALS_COMPLEX),(f2py_init_func)f2py_rout_core_face_integrals_complex,doc_f2py_rout_core_face_integrals_complex},
  {"arcioni_singular",-1,{{-1}},0,(char *)F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR),(f2py_init_func)f2py_rout_core_arcioni_singular,doc_f2py_rout_core_arcioni_singular},
  {"face_integrals_smooth_complex",-1,{{-1}},0,(char *)F_FUNC_US(face_integrals_smooth_complex,FACE_INTEGRALS_SMOOTH_COMPLEX),(f2py_init_func)f2py_rout_core_face_integrals_smooth_complex,doc_f2py_rout_core_face_integrals_smooth_complex},
  {"z_efie_faces_self",-1,{{-1}},0,(char *)F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF),(f2py_init_func)f2py_rout_core_z_efie_faces_self,doc_f2py_rout_core_z_efie_faces_self},
  {"z_efie_faces_mutual",-1,{{-1}},0,(char *)F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL),(f2py_init_func)f2py_rout_core_z_efie_faces_mutual,doc_f2py_rout_core_z_efie_faces_mutual},
  {"voltage_plane_wave",-1,{{-1}},0,(char *)F_FUNC_US(voltage_plane_wave,VOLTAGE_PLANE_WAVE),(f2py_init_func)f2py_rout_core_voltage_plane_wave,doc_f2py_rout_core_voltage_plane_wave},
  {"v_efie_faces_plane_wave",-1,{{-1}},0,(char *)F_FUNC_US(v_efie_faces_plane_wave,V_EFIE_FACES_PLANE_WAVE),(f2py_init_func)f2py_rout_core_v_efie_faces_plane_wave,doc_f2py_rout_core_v_efie_faces_plane_wave},
  {"face_integrals_hanninen",-1,{{-1}},0,(char *)F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN),(f2py_init_func)f2py_rout_core_face_integrals_hanninen,doc_f2py_rout_core_face_integrals_hanninen},
  {"triangle_face_to_rwg",-1,{{-1}},0,(char *)F_FUNC_US(triangle_face_to_rwg,TRIANGLE_FACE_TO_RWG),(f2py_init_func)f2py_rout_core_triangle_face_to_rwg,doc_f2py_rout_core_triangle_face_to_rwg},
  {"set_threads",-1,{{-1}},0,(char *)F_FUNC_US(set_threads,SET_THREADS),(f2py_init_func)f2py_rout_core_set_threads,doc_f2py_rout_core_set_threads},
  {"get_threads",-1,{{-1}},0,(char *)F_FUNC_US(get_threads,GET_THREADS),(f2py_init_func)f2py_rout_core_get_threads,doc_f2py_rout_core_get_threads},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "core",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyObject *PyInit_core(void) {
#else
#define RETVAL
PyMODINIT_FUNC initcore(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = core_module = PyModule_Create(&moduledef);
#else
  m = core_module = Py_InitModule("core", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module core (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'core' is auto-generated with f2py (version:2).\nFunctions:\n"
"  scr_index = scr_index(row,col,indices,indptr)\n"
"  i_a,i_phi = face_integrals_complex(xi_eta_s,weights_s,nodes_s_in,xi_eta_o,weights_o,nodes_o_in,jk_0,n_s=shape(xi_eta_s,0),n_o=shape(xi_eta_o,0))\n"
"  i_a,i_phi = arcioni_singular(nodes)\n"
"  i_a,i_phi = face_integrals_smooth_complex(xi_eta_s,weights_s,nodes_s,xi_eta_o,weights_o,nodes_o,jk_0,n_s=shape(xi_eta_s,1),n_s2=shape(xi_eta_s,0),n_o=shape(xi_eta_o,0))\n"
"  a_face,phi_face = z_efie_faces_self(nodes,triangle_nodes,s,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,num_nodes=shape(nodes,0),num_triangles=shape(triangle_nodes,0),num_integration=shape(xi_eta_eval,0),num_singular=len(phi_precalc))\n"
"  a_face,phi_face = z_efie_faces_mutual(nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,s,xi_eta_eval,weights,num_nodes_o=shape(nodes_o,0),num_triangles_o=shape(triangle_nodes_o,0),num_nodes_s=shape(nodes_s,0),num_triangles_s=shape(triangle_nodes_s,0),num_integration=shape(xi_eta_eval,0))\n"
"  v = voltage_plane_wave(nodes,triangle_nodes,basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,xi_eta_eval,weights,e_inc,jk_inc,num_nodes=shape(nodes,0),num_triangles=shape(triangle_nodes,0),num_basis=len(basis_tri_p),num_integration=shape(xi_eta_eval,0))\n"
"  v_faces = v_efie_faces_plane_wave(nodes,triangle_nodes,xi_eta_eval,weights,e_inc,jk_inc,num_nodes=shape(nodes,0),num_triangles=shape(triangle_nodes,0),num_integration=shape(xi_eta_eval,0))\n"
"  i_a,i_phi = face_integrals_hanninen(nodes_s,xi_eta_o,weights_o,nodes_o,n_o=shape(xi_eta_o,0))\n"
"  vector_rwg,scalar_rwg = triangle_face_to_rwg(basis_tri_p,basis_tri_m,basis_node_p,basis_node_m,vector_face,scalar_face,num_triangles=shape(vector_face,0),num_basis=len(basis_tri_p))\n"
"  set_threads(n)\n"
"  n = get_threads()\n"
"Fortran 90/95 modules:\n""  constants --- sp,dp,wp"".");
  PyDict_SetItemString(d, "__doc__", s);
  core_error = PyErr_NewException ("core.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));

    {
      extern int F_FUNC_US(scr_index,SCR_INDEX)(void);
      PyObject* o = PyDict_GetItemString(d,"scr_index");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(scr_index,SCR_INDEX),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("scr_index"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("scr_index"));
#endif
    }
    











/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "constants", PyFortranObject_New(f2py_constants_def,f2py_init_constants));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"core");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
