# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JsonFieldWithDefault(Model):
    """This is used to express the source of an input schema mapping for a single
    target field
    in the Event Grid Event schema. This is currently used in the mappings for
    the 'subject',
    'eventtype' and 'dataversion' properties. This represents a field in the
    input event schema
    along with a default value to be used, and at least one of these two
    properties should be provided.

    :param source_field: Name of a field in the input event schema that's to
     be used as the source of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a
     SourceField is not provided or if there's no property with the specified
     name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = kwargs.get('source_field', None)
        self.default_value = kwargs.get('default_value', None)
