# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HandlerMapping(Model):
    """
    The IIS handler mappings used to define which handler processes HTTP
    requests with certain extension.
    For example it is used to configure php-cgi.exe process to
    handle all HTTP requests with *.php extension.

    :param str extension: Requests with this extension will be handled using
     the specified FastCGI application.
    :param str script_processor: The absolute path to the FastCGI application.
    :param str arguments: Command-line arguments to be passed to the script
     processor.
    """ 

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(self, extension=None, script_processor=None, arguments=None, **kwargs):
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments
