# -*- coding: utf-8 -*-
"""rackio/status_code.py

This module holds all status codes taken from falcon
"""

"""HTTP status line constants."""

import falcon

HTTP_100 = falcon.HTTP_100
HTTP_CONTINUE = HTTP_100
HTTP_101 = falcon.HTTP_101
HTTP_SWITCHING_PROTOCOLS = HTTP_101
HTTP_102 = falcon.HTTP_102
HTTP_PROCESSING = HTTP_102

HTTP_200 = falcon.HTTP_200
HTTP_OK = HTTP_200
HTTP_201 = falcon.HTTP_201
HTTP_CREATED = HTTP_201
HTTP_202 = falcon.HTTP_202
HTTP_ACCEPTED = HTTP_202
HTTP_203 = falcon.HTTP_203
HTTP_NON_AUTHORITATIVE_INFORMATION = HTTP_203
HTTP_204 = falcon.HTTP_204
HTTP_NO_CONTENT = HTTP_204
HTTP_205 = falcon.HTTP_205
HTTP_RESET_CONTENT = HTTP_205
HTTP_206 = falcon.HTTP_206
HTTP_PARTIAL_CONTENT = HTTP_206
HTTP_207 = falcon.HTTP_207
HTTP_MULTI_STATUS = HTTP_207
HTTP_208 = falcon.HTTP_208
HTTP_ALREADY_REPORTED = HTTP_208
HTTP_226 = falcon.HTTP_226
HTTP_IM_USED = HTTP_226

HTTP_300 = falcon.HTTP_300
HTTP_MULTIPLE_CHOICES = HTTP_300
HTTP_301 = falcon.HTTP_301
HTTP_MOVED_PERMANENTLY = HTTP_301
HTTP_302 = falcon.HTTP_302
HTTP_FOUND = HTTP_302
HTTP_303 = falcon.HTTP_303
HTTP_SEE_OTHER = HTTP_303
HTTP_304 = falcon.HTTP_304
HTTP_NOT_MODIFIED = HTTP_304
HTTP_305 = falcon.HTTP_305
HTTP_USE_PROXY = HTTP_305
HTTP_307 = falcon.HTTP_307
HTTP_TEMPORARY_REDIRECT = HTTP_307
HTTP_308 = falcon.HTTP_308
HTTP_PERMANENT_REDIRECT = HTTP_308

HTTP_400 = falcon.HTTP_400
HTTP_BAD_REQUEST = HTTP_400
HTTP_401 = falcon.HTTP_401  # <-- Really means "unauthenticated"
HTTP_UNAUTHORIZED = HTTP_401
HTTP_402 = falcon.HTTP_402
HTTP_PAYMENT_REQUIRED = HTTP_402
HTTP_403 = falcon.HTTP_403 # <-- Really means "unauthorized"
HTTP_FORBIDDEN = HTTP_403
HTTP_404 = falcon.HTTP_404
HTTP_NOT_FOUND = HTTP_404
HTTP_405 = falcon.HTTP_405
HTTP_METHOD_NOT_ALLOWED = HTTP_405
HTTP_406 = falcon.HTTP_406
HTTP_NOT_ACCEPTABLE = HTTP_406
HTTP_407 = falcon.HTTP_407
HTTP_PROXY_AUTHENTICATION_REQUIRED = HTTP_407
HTTP_408 = falcon.HTTP_408
HTTP_REQUEST_TIMEOUT = HTTP_408
HTTP_409 = falcon.HTTP_409
HTTP_CONFLICT = HTTP_409
HTTP_410 = falcon.HTTP_410
HTTP_GONE = HTTP_410
HTTP_411 = falcon.HTTP_411
HTTP_LENGTH_REQUIRED = HTTP_411
HTTP_412 = falcon.HTTP_412
HTTP_PRECONDITION_FAILED = HTTP_412
HTTP_413 = falcon.HTTP_413
HTTP_REQUEST_ENTITY_TOO_LARGE = HTTP_413
HTTP_414 = falcon.HTTP_414
HTTP_REQUEST_URI_TOO_LONG = HTTP_414
HTTP_415 = falcon.HTTP_415
HTTP_UNSUPPORTED_MEDIA_TYPE = HTTP_415
HTTP_416 = falcon.HTTP_416
HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = HTTP_416
HTTP_417 = falcon.HTTP_417
HTTP_EXPECTATION_FAILED = HTTP_417
HTTP_418 = falcon.HTTP_418
HTTP_IM_A_TEAPOT = HTTP_418
HTTP_422 = falcon.HTTP_422
HTTP_UNPROCESSABLE_ENTITY = HTTP_422
HTTP_423 = falcon.HTTP_423
HTTP_LOCKED = HTTP_423
HTTP_424 = falcon.HTTP_424
HTTP_FAILED_DEPENDENCY = HTTP_424
HTTP_426 = falcon.HTTP_426
HTTP_UPGRADE_REQUIRED = HTTP_426
HTTP_428 = falcon.HTTP_428
HTTP_PRECONDITION_REQUIRED = HTTP_428
HTTP_429 = falcon.HTTP_429
HTTP_TOO_MANY_REQUESTS = HTTP_429
HTTP_431 = falcon.HTTP_431
HTTP_REQUEST_HEADER_FIELDS_TOO_LARGE = HTTP_431
HTTP_451 = falcon.HTTP_451
HTTP_UNAVAILABLE_FOR_LEGAL_REASONS = HTTP_451

HTTP_500 = falcon.HTTP_500
HTTP_INTERNAL_SERVER_ERROR = HTTP_500
HTTP_501 = falcon.HTTP_501
HTTP_NOT_IMPLEMENTED = HTTP_501
HTTP_502 = falcon.HTTP_502
HTTP_BAD_GATEWAY = HTTP_502
HTTP_503 = falcon.HTTP_503
HTTP_SERVICE_UNAVAILABLE = HTTP_503
HTTP_504 = falcon.HTTP_504
HTTP_GATEWAY_TIMEOUT = HTTP_504
HTTP_505 = falcon.HTTP_505
HTTP_HTTP_VERSION_NOT_SUPPORTED = HTTP_505
HTTP_507 = falcon.HTTP_507
HTTP_INSUFFICIENT_STORAGE = HTTP_507
HTTP_508 = falcon.HTTP_508
HTTP_LOOP_DETECTED = HTTP_508
HTTP_511 = falcon.HTTP_511
HTTP_NETWORK_AUTHENTICATION_REQUIRED = HTTP_511

# 70X - Inexcusable
HTTP_701 = falcon.HTTP_701
HTTP_702 = falcon.HTTP_702
HTTP_703 = falcon.HTTP_703

# 71X - Novelty Implementations
HTTP_710 = falcon.HTTP_710
HTTP_711 = falcon.HTTP_711
HTTP_712 = falcon.HTTP_712
HTTP_719 = falcon.HTTP_719

# 72X - Edge Cases
HTTP_720 = falcon.HTTP_720
HTTP_721 = falcon.HTTP_721
HTTP_722 = falcon.HTTP_722
HTTP_723 = falcon.HTTP_723
HTTP_724 = falcon.HTTP_724
HTTP_725 = falcon.HTTP_725
HTTP_726 = falcon.HTTP_726
HTTP_727 = falcon.HTTP_727

# 74X - Meme Driven
HTTP_740 = falcon.HTTP_740
HTTP_741 = falcon.HTTP_741
HTTP_742 = falcon.HTTP_742
HTTP_743 = falcon.HTTP_743
HTTP_744 = falcon.HTTP_744
HTTP_745 = falcon.HTTP_745
HTTP_748 = falcon.HTTP_748
HTTP_749 = falcon.HTTP_749

# 75X - Syntax Errors
HTTP_750 = falcon.HTTP_750
HTTP_753 = falcon.HTTP_753
HTTP_754 = falcon.HTTP_754
HTTP_755 = falcon.HTTP_755
HTTP_759 = falcon.HTTP_759

# 77X - Predictable Problems
HTTP_771 = falcon.HTTP_771
HTTP_772 = falcon.HTTP_772
HTTP_773 = falcon.HTTP_773
HTTP_774 = falcon.HTTP_774
HTTP_776 = falcon.HTTP_776
HTTP_777 = falcon.HTTP_777
HTTP_778 = falcon.HTTP_778
HTTP_779 = falcon.HTTP_779

# 78X - Somebody Else's Problem
HTTP_780 = falcon.HTTP_780
HTTP_781 = falcon.HTTP_781
HTTP_782 = falcon.HTTP_782
HTTP_783 = falcon.HTTP_783
HTTP_784 = falcon.HTTP_784
HTTP_785 = falcon.HTTP_785
HTTP_786 = falcon.HTTP_786

# 79X - Internet crashed
HTTP_791 = falcon.HTTP_791
HTTP_792 = falcon.HTTP_792
HTTP_797 = falcon.HTTP_797
HTTP_799 = falcon.HTTP_799