# Creating a development environment

It's best to set up a new virtual environment for nexxT builds and development:

    python3 -m venv venv

It is assumed that this environment is activated for the following commands.
    
## Build dependencies
The build expects the following dependencies to be available on the system:
- QT5: set QTDIR for identifying the QT version. Note that the QT installer
  has a known bug of wrong paths in the lib/pkgconfig/*.pc files. These have
  to be fixed before building.
- shiboken2_generator: this is referenced in requirements.txt. A binary wheel
  can be found here:
  https://download.qt.io/official_releases/QtForPython/shiboken2-generator/
  This is working for windows and debian builds and probably also for more,
  even though the PySide2 project doesn't recommend to use the binary 
  distribution
- On linux, the binding generator also needs llvm installed and the path can
  be set in the LLVM_INSTALL_DIR variable, e.g. /usr/lib/llvm-7
- On linux it is recommended to have xvfb installed for a headless test environment

You can use pip to install the required dependencies like that

    python -m pip install pip -U
    pip install -r requirements.txt -f https://download.qt.io/official_releases/QtForPython/shiboken2-generator/ --trusted-host download.qt.io

Be sure to have the environment variables QTDIR and LLVM_INSTALL_DIR set correctly.
Afterwards you should be able to use 

    scons -j 8 ..

to build and install nexxT binaries and c extensions. Note that the file 
nexxT/core/qrc_resources.py is regenerated by executing scons and it's likely to be 
changed. It's best not to check it in all the time. However, it is kept there for 
being able to use the project in pure python mode (i.e., with NEXXT_DISABLE_CIMPL=1) 
without the necessity for rebuilding the project.

Note that the project uses pylint for coding style checks. Use 
    
    pylint_nexxT[.bat|.sh] 
    
for generating a report.

For running tests, use

    pytest_nexxT[.bat|.sh]
    
scripts. The coverage of the tests is reported in ./htmlcov/index.html.
