/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.xom;

import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.xom.Mode;
import nu.validator.htmlparser.xom.SimpleNodeFactory;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.XMLException;
import org.xml.sax.SAXException;

class XOMTreeBuilder
extends CoalescingTreeBuilder<Element> {
    private final SimpleNodeFactory nodeFactory;
    private Document document;
    private int cachedTableIndex = -1;
    private Element cachedTable = null;

    protected XOMTreeBuilder(SimpleNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String uri;
                String localName = attributes.getLocalNameNoBoundsCheck(i);
                if (element.getAttribute(localName, uri = attributes.getURINoBoundsCheck(i)) != null) continue;
                element.addAttribute(this.nodeFactory.makeAttribute(localName, uri, attributes.getValueNoBoundsCheck(i), attributes.getTypeNoBoundsCheck(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendCharacters(Element parent, String text) throws SAXException {
        try {
            Node lastChild;
            int childCount = parent.getChildCount();
            if (childCount != 0 && (lastChild = parent.getChild(childCount - 1)) instanceof Text) {
                Text lastAsText = (Text)lastChild;
                lastAsText.setValue(lastAsText.getValue() + text);
                return;
            }
            parent.appendChild((Node)this.nodeFactory.makeText(text));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            Nodes children = oldParent.removeChildren();
            for (int i = 0; i < children.size(); ++i) {
                newParent.appendChild(children.get(i));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendComment(Element parent, String comment) throws SAXException {
        try {
            parent.appendChild((Node)this.nodeFactory.makeComment(comment));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendCommentToDocument(String comment) throws SAXException {
        try {
            Element root = this.document.getRootElement();
            if ("http://www.xom.nu/fakeRoot".equals(root.getNamespaceURI())) {
                this.document.insertChild((Node)this.nodeFactory.makeComment(comment), this.document.indexOf((Node)root));
            } else {
                this.document.appendChild((Node)this.nodeFactory.makeComment(comment));
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element intendedParent) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement(name, ns);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalNameNoBoundsCheck(i), attributes.getURINoBoundsCheck(i), attributes.getValueNoBoundsCheck(i), attributes.getTypeNoBoundsCheck(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement("html", "http://www.w3.org/1999/xhtml");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalNameNoBoundsCheck(i), attributes.getURINoBoundsCheck(i), attributes.getValueNoBoundsCheck(i), attributes.getTypeNoBoundsCheck(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            this.document.setRootElement(rv);
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            element.detach();
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void appendElement(Element child, Element newParent) throws SAXException {
        try {
            child.detach();
            newParent.appendChild((Node)child);
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.getChildCount() != 0;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    Nodes getDocumentFragment() {
        Element rootElt = this.document.getRootElement();
        Nodes rv = rootElt.removeChildren();
        this.document = null;
        return rv;
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element form, Element intendedParent) throws SAXException {
        try {
            Element rv = this.nodeFactory.makeElement(name, ns, form);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.addAttribute(this.nodeFactory.makeAttribute(attributes.getLocalName(i), attributes.getURINoBoundsCheck(i), attributes.getValueNoBoundsCheck(i), attributes.getTypeNoBoundsCheck(i) == "ID" ? Attribute.Type.ID : Attribute.Type.CDATA));
            }
            return rv;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.nodeFactory.makeDocument();
        this.cachedTableIndex = -1;
        this.cachedTable = null;
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.document instanceof Mode) {
            Mode modal = (Mode)this.document;
            modal.setMode(mode);
        }
    }

    @Override
    protected Element createAndInsertFosterParentedElement(String ns, String name, HtmlAttributes attributes, Element table, Element stackParent) throws SAXException {
        try {
            ParentNode parent = table.getParent();
            Element child = this.createElement(ns, name, attributes, parent != null ? (Element)parent : stackParent);
            if (parent != null) {
                parent.insertChild((Node)child, this.indexOfTable(table, stackParent));
                ++this.cachedTableIndex;
            } else {
                stackParent.appendChild((Node)child);
            }
            return child;
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void insertFosterParentedCharacters(String text, Element table, Element stackParent) throws SAXException {
        try {
            Node lastChild;
            ParentNode parent = table.getParent();
            if (parent != null) {
                Node prevSibling;
                Element parentAsElt = (Element)parent;
                int tableIndex = this.indexOfTable(table, parentAsElt);
                if (tableIndex != 0 && (prevSibling = parentAsElt.getChild(tableIndex - 1)) instanceof Text) {
                    Text prevAsText = (Text)prevSibling;
                    prevAsText.setValue(prevAsText.getValue() + text);
                    return;
                }
                parentAsElt.insertChild((Node)this.nodeFactory.makeText(text), tableIndex);
                ++this.cachedTableIndex;
                return;
            }
            int childCount = stackParent.getChildCount();
            if (childCount != 0 && (lastChild = stackParent.getChild(childCount - 1)) instanceof Text) {
                Text lastAsText = (Text)lastChild;
                lastAsText.setValue(lastAsText.getValue() + text);
                return;
            }
            stackParent.appendChild((Node)this.nodeFactory.makeText(text));
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    @Override
    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        try {
            ParentNode parent = table.getParent();
            if (parent != null) {
                parent.insertChild((Node)child, this.indexOfTable(table, stackParent));
                ++this.cachedTableIndex;
            } else {
                stackParent.appendChild((Node)child);
            }
        }
        catch (XMLException e) {
            this.fatal((Exception)((Object)e));
        }
    }

    private int indexOfTable(Element table, Element stackParent) {
        if (table == this.cachedTable) {
            return this.cachedTableIndex;
        }
        this.cachedTable = table;
        this.cachedTableIndex = stackParent.indexOf((Node)table);
        return this.cachedTableIndex;
    }

    @Override
    protected void end() throws SAXException {
        this.cachedTableIndex = -1;
        this.cachedTable = null;
    }
}

