/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.io.IOException;
import java.io.StringReader;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class SvgPathData
extends AbstractDatatype {
    private StringReader reader;
    private StringBuilder context;
    private static final int MAX_CONTEXT_LENGTH = 20;
    private int current;

    protected SvgPathData() {
    }

    private void appendToContext(int i) {
        if (i != -1) {
            if (this.context.length() == 20) {
                this.context.deleteCharAt(0);
            }
            this.context.append((char)i);
        }
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        block33: {
            this.reader = new StringReader(literal.toString());
            this.context = new StringBuilder(20);
            try {
                this.current = this.reader.read();
                this.appendToContext(this.current);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                while (true) {
                    switch (this.current) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            this.current = this.reader.read();
                            this.appendToContext(this.current);
                            break;
                        }
                        case 90: 
                        case 122: {
                            this.current = this.reader.read();
                            this.appendToContext(this.current);
                            break;
                        }
                        case 109: {
                            this.checkm();
                            break;
                        }
                        case 77: {
                            this.checkM();
                            break;
                        }
                        case 108: {
                            this.checkl();
                            break;
                        }
                        case 76: {
                            this.checkL();
                            break;
                        }
                        case 104: {
                            this.checkh();
                            break;
                        }
                        case 72: {
                            this.checkH();
                            break;
                        }
                        case 118: {
                            this.checkv();
                            break;
                        }
                        case 86: {
                            this.checkV();
                            break;
                        }
                        case 99: {
                            this.checkc();
                            break;
                        }
                        case 67: {
                            this.checkC();
                            break;
                        }
                        case 113: {
                            this.checkq();
                            break;
                        }
                        case 81: {
                            this.checkQ();
                            break;
                        }
                        case 115: {
                            this.checks();
                            break;
                        }
                        case 83: {
                            this.checkS();
                            break;
                        }
                        case 116: {
                            this.checkt();
                            break;
                        }
                        case 84: {
                            this.checkT();
                            break;
                        }
                        case 97: {
                            this.checka();
                            break;
                        }
                        case 65: {
                            this.checkA();
                            break;
                        }
                        case -1: {
                            break block33;
                        }
                        default: {
                            throw this.newDatatypeException("Expected command but found \u201c" + (char)this.current + "\u201d (context: \u201c" + this.context.toString() + "\u201d).");
                        }
                    }
                }
            }
            catch (IOException e) {
                try {
                    this.skipSubPath();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                throw new RuntimeException(e);
            }
        }
        try {
            this.skipSpaces();
            if (this.current != -1) {
                throw this.newDatatypeException("Found unexpected character \u201c" + (char)this.current + "\u201d.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkm() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        this.checkArg('m', "x coordinate");
        this.skipCommaSpaces();
        this.checkArg('m', "y coordinate");
        boolean expectNumber = this.skipCommaSpaces2();
        this._checkl('m', expectNumber);
    }

    private void checkM() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        this.checkArg('M', "x coordinate");
        this.skipCommaSpaces();
        this.checkArg('M', "y coordinate");
        boolean expectNumber = this.skipCommaSpaces2();
        this._checkL('M', expectNumber);
    }

    private void checkl() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        this._checkl('l', true);
    }

    private void _checkl(char command, boolean expectNumber) throws IOException, DatatypeException {
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportUnexpected("coordinate pair for \u201c" + command + "\u201d command", this.current);
                        this.skipSubPath();
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg(command, "x coordinate");
            this.skipCommaSpaces();
            this.checkArg(command, "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkL() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        this._checkL('L', true);
    }

    private void _checkL(char command, boolean expectNumber) throws IOException, DatatypeException {
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportUnexpected("coordinate pair for \u201c" + command + "\u201d command", this.current);
                        this.skipSubPath();
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg(command, "x coordinate");
            this.skipCommaSpaces();
            this.checkArg(command, "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkh() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('h', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('h', "x coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkH() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('H', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('H', "x coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkv() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('v', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('v', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkV() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('V', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('V', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkc() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('c', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('c', "x1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('c', "y1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('c', "x2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('c', "y2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('c', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('c', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkC() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('C', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('C', "x1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('C', "y1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('C', "x2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('C', "y2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('C', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('C', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkq() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('q', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('q', "x1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('q', "y1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('q', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('q', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkQ() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('Q', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('Q', "x1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('Q', "y1 coordinate");
            this.skipCommaSpaces();
            this.checkArg('Q', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('Q', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checks() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('s', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('s', "x2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('s', "y2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('s', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('s', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkS() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('S', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('S', "x2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('S', "y2 coordinate");
            this.skipCommaSpaces();
            this.checkArg('S', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('S', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkt() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('t', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('t', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('t', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkT() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('T', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('T', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('T', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checka() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('a', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('a', "rx radius");
            this.skipCommaSpaces();
            this.checkArg('a', "ry radius");
            this.skipCommaSpaces();
            this.checkArg('a', "x-axis-rotation");
            this.skipCommaSpaces();
            switch (this.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for large-arc-flag for \u201ca\u201d command", this.current);
                    this.skipSubPath();
                    return;
                }
                case 48: 
                case 49: 
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
            this.skipCommaSpaces();
            switch (this.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for sweep-flag for \u201ca\u201d command", this.current);
                    this.skipSubPath();
                    return;
                }
                case 48: 
                case 49: 
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
            this.skipCommaSpaces();
            this.checkArg('a', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('a', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkA() throws DatatypeException, IOException {
        if (this.context.length() == 0) {
            this.appendToContext(this.current);
        }
        this.current = this.reader.read();
        this.appendToContext(this.current);
        this.skipSpaces();
        boolean expectNumber = true;
        while (true) {
            switch (this.current) {
                default: {
                    if (expectNumber) {
                        this.reportNonNumber('A', this.current);
                    }
                    return;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            this.checkArg('A', "rx radius");
            this.skipCommaSpaces();
            this.checkArg('A', "ry radius");
            this.skipCommaSpaces();
            this.checkArg('A', "x-axis-rotation");
            this.skipCommaSpaces();
            switch (this.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for large-arc-flag for \u201cA\u201d command", this.current);
                    this.skipSubPath();
                    return;
                }
                case 48: 
                case 49: 
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
            this.skipCommaSpaces();
            switch (this.current) {
                default: {
                    this.reportUnexpected("\u201c0\u201d or \u201c1\u201d for sweep-flag for \u201cA\u201d command", this.current);
                    this.skipSubPath();
                    return;
                }
                case 48: 
                case 49: 
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
            this.skipCommaSpaces();
            this.checkArg('A', "x coordinate");
            this.skipCommaSpaces();
            this.checkArg('A', "y coordinate");
            expectNumber = this.skipCommaSpaces2();
        }
    }

    private void checkArg(char command, String arg) throws DatatypeException, IOException {
        int mant = 0;
        int mantDig = 0;
        boolean mantPos = true;
        boolean mantRead = false;
        int exp = 0;
        int expDig = 0;
        int expAdj = 0;
        boolean expPos = true;
        switch (this.current) {
            case 45: {
                mantPos = false;
            }
            case 43: {
                this.current = this.reader.read();
                this.appendToContext(this.current);
            }
        }
        block4 : switch (this.current) {
            default: {
                this.reportUnexpected(arg + " for \u201c" + command + "\u201d command", this.current);
                this.skipSubPath();
                return;
            }
            case 46: {
                break;
            }
            case 48: {
                mantRead = true;
                block50: while (true) {
                    this.current = this.reader.read();
                    this.appendToContext(this.current);
                    switch (this.current) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break block50;
                        }
                        case 46: 
                        case 69: 
                        case 101: {
                            break block4;
                        }
                        default: {
                            return;
                        }
                        case 48: {
                            continue block50;
                        }
                    }
                    break;
                }
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                mantRead = true;
                while (true) {
                    if (mantDig < 9) {
                        ++mantDig;
                        mant = mant * 10 + (this.current - 48);
                    } else {
                        ++expAdj;
                    }
                    this.current = this.reader.read();
                    this.appendToContext(this.current);
                    switch (this.current) {
                        default: {
                            break block4;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                    }
                }
            }
        }
        if (this.current == 46) {
            this.current = this.reader.read();
            this.appendToContext(this.current);
            block17 : switch (this.current) {
                default: {
                    if (mantRead) break;
                    this.reportNonNumber(command, this.current);
                    return;
                }
                case 48: {
                    if (mantDig == 0) {
                        block52: while (true) {
                            this.current = this.reader.read();
                            this.appendToContext(this.current);
                            --expAdj;
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block52;
                                }
                                default: {
                                    if (mantRead) break block17;
                                    return;
                                }
                                case 48: {
                                    continue block52;
                                }
                            }
                            break;
                        }
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (true) {
                        if (mantDig < 9) {
                            ++mantDig;
                            mant = mant * 10 + (this.current - 48);
                            --expAdj;
                        }
                        this.current = this.reader.read();
                        this.appendToContext(this.current);
                        switch (this.current) {
                            default: {
                                break block17;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                }
            }
        }
        block28 : switch (this.current) {
            case 69: 
            case 101: {
                this.current = this.reader.read();
                this.appendToContext(this.current);
                switch (this.current) {
                    default: {
                        this.reportNonNumber(command, this.current);
                        return;
                    }
                    case 45: {
                        expPos = false;
                    }
                    case 43: {
                        this.current = this.reader.read();
                        this.appendToContext(this.current);
                        switch (this.current) {
                            default: {
                                this.reportNonNumber(command, this.current);
                                return;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                }
                switch (this.current) {
                    case 48: {
                        block54: while (true) {
                            this.current = this.reader.read();
                            this.appendToContext(this.current);
                            switch (this.current) {
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    break block54;
                                }
                                default: {
                                    break block28;
                                }
                                case 48: {
                                    continue block54;
                                }
                            }
                            break;
                        }
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        while (true) {
                            if (expDig < 3) {
                                ++expDig;
                                exp = exp * 10 + (this.current - 48);
                            }
                            this.current = this.reader.read();
                            this.appendToContext(this.current);
                            switch (this.current) {
                                default: {
                                    break block28;
                                }
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                            }
                        }
                    }
                }
            }
        }
        if (!expPos) {
            exp = -exp;
        }
        exp += expAdj;
        if (!mantPos) {
            mant = -mant;
        }
    }

    private void skipSubPath() throws IOException {
        while (true) {
            switch (this.current) {
                case -1: 
                case 77: 
                case 109: {
                    return;
                }
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
        }
    }

    private void skipSpaces() throws IOException {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.current = this.reader.read();
            this.appendToContext(this.current);
        }
    }

    private void skipCommaSpaces() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    this.appendToContext(this.current);
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        this.appendToContext(this.current);
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.appendToContext(this.current);
                        continue block7;
                    }
                }
                break;
            }
        }
    }

    private boolean skipCommaSpaces2() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    this.appendToContext(this.current);
                    continue block6;
                }
            }
            break;
        }
        if (this.current != 44) {
            return false;
        }
        block7: while (true) {
            this.current = this.reader.read();
            switch (this.current) {
                default: {
                    this.appendToContext(this.current);
                    break block7;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.appendToContext(this.current);
                    continue block7;
                }
            }
            break;
        }
        return true;
    }

    private void reportUnexpected(String expected, int ch) throws DatatypeException {
        if (ch != -1) {
            throw this.newDatatypeException("Expected " + expected + " but found \u201c" + (char)ch + "\u201d instead " + "(context: \u201c" + this.context.toString() + "\u201d).");
        }
        throw this.newDatatypeException("Expected " + expected + " but value ended " + "(context: \u201c" + this.context.toString() + "\u201d).");
    }

    private void reportNonNumber(char command, int ch) throws DatatypeException {
        if (ch != -1) {
            throw this.newDatatypeException("Expected number for \u201c" + command + "\u201d command but found " + "\u201c" + (char)ch + "\u201d instead " + "(context: \u201c" + this.context.toString() + "\u201d).");
        }
        throw this.newDatatypeException("Expected number for \u201c" + command + "\u201d command but value ended " + "(context: \u201c" + this.context.toString() + "\u201d).");
    }

    @Override
    public String getName() {
        return "SVG path data";
    }
}

