/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import com.shapesecurity.salvation.Parser;
import com.shapesecurity.salvation.data.Notice;
import java.util.ArrayList;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class ContentSecurityPolicy
extends AbstractDatatype {
    public static final ContentSecurityPolicy THE_INSTANCE = new ContentSecurityPolicy();
    private static final String DIRECTIVE_NAME = " (child-src|connect-src|default-src|font-src|img-src|manifest-src|media-src|object-src|script-src|style-src|worker-src|frame-src|allow|options|referrer|upgrade-insecure-requests|block-all-mixed-content|report-to|report-uri) ";
    private static final String SANDBOX_KEYWORDS = "(allow-forms|allow-modals|allow-pointer-lock|allow-popups-to-escape-sandbox|allow-popups|allow-same-origin|allow-scripts|allow-top-navigation)";
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    protected ContentSecurityPolicy() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        ArrayList<Notice> notices = new ArrayList<Notice>();
        StringBuilder errors = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        StringBuilder others = new StringBuilder();
        Parser.parse(literal.toString(), "http://example.org", notices);
        if (!notices.isEmpty()) {
            for (Notice notice : notices) {
                if (notice.show().contains("experimental directive")) continue;
                String message = notice.show().replaceAll(DIRECTIVE_NAME, " \u201c$1\u201d ").replaceAll(SANDBOX_KEYWORDS, "\u201c$1\u201d") + " ";
                if (notice.isError()) {
                    errors.append(message);
                    continue;
                }
                if (notice.isWarning()) {
                    warnings.append(message);
                    continue;
                }
                if (!notice.isInfo()) continue;
                others.append(message);
            }
            if (errors.length() > 0) {
                throw this.newDatatypeException(errors.toString());
            }
            if (warnings.length() > 0) {
                throw this.newDatatypeException(warnings.toString(), WARN);
            }
            if (others.length() > 0) {
                throw this.newDatatypeException(others.toString(), WARN);
            }
        }
    }

    @Override
    public String getName() {
        return "content security policy";
    }
}

