/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import net.arnx.jsonic.io.InputSource;

public class ReaderInputSource
implements InputSource {
    private static int BACK = 20;
    private long lines = 1L;
    private long columns = 0L;
    private long offset = 0L;
    private InputStream in;
    private Reader reader;
    private final char[] buf = new char[1024];
    private int back = BACK;
    private int start = BACK;
    private int end = BACK - 1;
    private int mark = -1;

    public ReaderInputSource(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
    }

    public ReaderInputSource(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    @Override
    public int next() throws IOException {
        int n = -1;
        n = this.get();
        if (n != -1) {
            ++this.offset;
            if (n == 13) {
                ++this.lines;
                this.columns = 0L;
            } else if (n == 10) {
                if (this.start < 2 || this.buf[this.start - 2] != '\r') {
                    ++this.lines;
                    this.columns = 0L;
                }
            } else {
                ++this.columns;
            }
        }
        return n;
    }

    private int get() throws IOException {
        if (this.start > this.end) {
            int size;
            if (this.end > BACK) {
                int len = Math.min(BACK, this.end - BACK + 1);
                System.arraycopy(this.buf, this.end + 1 - len, this.buf, BACK - len, len);
                this.back = BACK - len;
            }
            if (this.in != null) {
                if (!this.in.markSupported()) {
                    this.in = new PushbackInputStream(this.in, 4);
                }
                this.reader = new InputStreamReader(this.in, ReaderInputSource.determineEncoding(this.in));
                this.in = null;
            }
            if ((size = this.reader.read(this.buf, BACK, this.buf.length - BACK)) != -1) {
                this.mark = this.mark > this.end - BACK ? BACK - (this.end - this.mark + 1) : -1;
                this.start = BACK;
                this.end = BACK + size - 1;
            } else {
                ++this.start;
                return -1;
            }
        }
        return this.buf[this.start++];
    }

    @Override
    public void back() {
        if (this.start <= this.back) {
            throw new IllegalStateException("no backup charcter");
        }
        --this.start;
        if (this.start <= this.end) {
            --this.offset;
            --this.columns;
        }
    }

    @Override
    public int mark() throws IOException {
        if (this.start > this.end) {
            int c = this.get();
            this.back();
            if (c == -1) {
                this.mark = -1;
                return 0;
            }
        }
        this.mark = this.start;
        return this.end - this.mark + 1;
    }

    @Override
    public void copy(StringBuilder sb, int len) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + len > this.end + 1) {
            throw new IndexOutOfBoundsException();
        }
        sb.append(this.buf, this.mark, len);
    }

    @Override
    public String copy(int len) {
        if (this.mark == -1) {
            throw new IllegalStateException("no mark");
        }
        if (this.mark + len > this.end + 1) {
            throw new IndexOutOfBoundsException();
        }
        return String.valueOf(this.buf, this.mark, len);
    }

    @Override
    public long getLineNumber() {
        return this.lines;
    }

    @Override
    public long getColumnNumber() {
        return this.columns;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    private static String determineEncoding(InputStream in) throws IOException {
        byte[] check;
        int size;
        String encoding = "UTF-8";
        if (in.markSupported()) {
            in.mark(4);
        }
        if ((size = in.read(check = new byte[4])) == 2) {
            if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) != 0 || (check[0] & 0xFF) == 254 && (check[1] & 0xFF) == 255) {
                encoding = "UTF-16BE";
            } else if ((check[0] & 0xFF) != 0 && (check[1] & 0xFF) == 0 || (check[0] & 0xFF) == 255 && (check[1] & 0xFF) == 254) {
                encoding = "UTF-16LE";
            }
        } else if (size == 4) {
            if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) == 0) {
                encoding = "UTF-32BE";
            } else if ((check[2] & 0xFF) == 0 && (check[3] & 0xFF) == 0) {
                encoding = "UTF-32LE";
            } else if ((check[0] & 0xFF) == 0 && (check[1] & 0xFF) != 0 || (check[0] & 0xFF) == 254 && (check[1] & 0xFF) == 255) {
                encoding = "UTF-16BE";
            } else if ((check[0] & 0xFF) != 0 && (check[1] & 0xFF) == 0 || (check[0] & 0xFF) == 255 && (check[1] & 0xFF) == 254) {
                encoding = "UTF-16LE";
            }
        }
        if (in.markSupported()) {
            in.reset();
        } else {
            ((PushbackInputStream)in).unread(check, 0, size);
        }
        return encoding;
    }

    public String toString() {
        int spos = this.back;
        int max = Math.min(this.start - 1, this.end);
        int charCount = 0;
        for (int i = 0; i < max + 1 - this.back && i < BACK; ++i) {
            char c = this.buf[max - i];
            if (c == '\r' || c == '\n' && (max - i - 1 < 0 || this.buf[max - i - 1] != '\r')) {
                if (charCount <= 0) continue;
                break;
            }
            if (c == '\n') continue;
            spos = max - i;
            ++charCount;
        }
        return spos <= max ? String.valueOf(this.buf, spos, max - spos + 1) : "";
    }
}

