/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.tokens;

import com.shapesecurity.salvation.tokens.Token;
import javax.annotation.Nonnull;

public class DirectiveNameToken
extends Token {
    @Nonnull
    public final DirectiveNameSubtype subtype;

    public DirectiveNameToken(@Nonnull String value) {
        super(value);
        DirectiveNameSubtype subtype;
        this.subtype = subtype = DirectiveNameSubtype.fromString(value);
    }

    @Override
    @Nonnull
    public String toJSON() {
        return super.toJSON("DirectiveName");
    }

    public static enum DirectiveNameSubtype {
        BaseUri,
        BlockAllMixedContent,
        ChildSrc,
        ConnectSrc,
        DefaultSrc,
        FontSrc,
        FormAction,
        FrameAncestors,
        FrameSrc,
        ImgSrc,
        ManifestSrc,
        MediaSrc,
        ObjectSrc,
        PluginTypes,
        Referrer,
        ReportTo,
        ReportUri,
        RequireSriFor,
        Sandbox,
        ScriptSrc,
        StyleSrc,
        WorkerSrc,
        UpgradeInsecureRequests,
        Allow,
        Options,
        Unrecognised;


        @Nonnull
        static DirectiveNameSubtype fromString(@Nonnull String directiveName) {
            switch (directiveName.toLowerCase()) {
                case "base-uri": {
                    return BaseUri;
                }
                case "block-all-mixed-content": {
                    return BlockAllMixedContent;
                }
                case "child-src": {
                    return ChildSrc;
                }
                case "connect-src": {
                    return ConnectSrc;
                }
                case "default-src": {
                    return DefaultSrc;
                }
                case "font-src": {
                    return FontSrc;
                }
                case "form-action": {
                    return FormAction;
                }
                case "frame-ancestors": {
                    return FrameAncestors;
                }
                case "img-src": {
                    return ImgSrc;
                }
                case "manifest-src": {
                    return ManifestSrc;
                }
                case "media-src": {
                    return MediaSrc;
                }
                case "object-src": {
                    return ObjectSrc;
                }
                case "plugin-types": {
                    return PluginTypes;
                }
                case "referrer": {
                    return Referrer;
                }
                case "report-to": {
                    return ReportTo;
                }
                case "require-sri-for": {
                    return RequireSriFor;
                }
                case "sandbox": {
                    return Sandbox;
                }
                case "script-src": {
                    return ScriptSrc;
                }
                case "style-src": {
                    return StyleSrc;
                }
                case "upgrade-insecure-requests": {
                    return UpgradeInsecureRequests;
                }
                case "worker-src": {
                    return WorkerSrc;
                }
                case "allow": {
                    return Allow;
                }
                case "frame-src": {
                    return FrameSrc;
                }
                case "options": {
                    return Options;
                }
                case "report-uri": {
                    return ReportUri;
                }
            }
            return Unrecognised;
        }
    }
}

