/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.directives;

import com.shapesecurity.salvation.directiveValues.HostSource;
import com.shapesecurity.salvation.directiveValues.None;
import com.shapesecurity.salvation.directives.BaseUriDirective;
import com.shapesecurity.salvation.directives.BlockAllMixedContentDirective;
import com.shapesecurity.salvation.directives.ChildSrcDirective;
import com.shapesecurity.salvation.directives.ConnectSrcDirective;
import com.shapesecurity.salvation.directives.DefaultSrcDirective;
import com.shapesecurity.salvation.directives.DirectiveValue;
import com.shapesecurity.salvation.directives.FetchDirective;
import com.shapesecurity.salvation.directives.FontSrcDirective;
import com.shapesecurity.salvation.directives.FormActionDirective;
import com.shapesecurity.salvation.directives.FrameAncestorsDirective;
import com.shapesecurity.salvation.directives.FrameSrcDirective;
import com.shapesecurity.salvation.directives.ImgSrcDirective;
import com.shapesecurity.salvation.directives.ManifestSrcDirective;
import com.shapesecurity.salvation.directives.MediaSrcDirective;
import com.shapesecurity.salvation.directives.NestedContextDirective;
import com.shapesecurity.salvation.directives.ObjectSrcDirective;
import com.shapesecurity.salvation.directives.PluginTypesDirective;
import com.shapesecurity.salvation.directives.ReferrerDirective;
import com.shapesecurity.salvation.directives.ReportToDirective;
import com.shapesecurity.salvation.directives.ReportUriDirective;
import com.shapesecurity.salvation.directives.RequireSriForDirective;
import com.shapesecurity.salvation.directives.SandboxDirective;
import com.shapesecurity.salvation.directives.ScriptSrcDirective;
import com.shapesecurity.salvation.directives.StyleSrcDirective;
import com.shapesecurity.salvation.directives.UpgradeInsecureRequestsDirective;
import com.shapesecurity.salvation.directives.WorkerSrcDirective;
import com.shapesecurity.salvation.interfaces.Show;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Directive<Value extends DirectiveValue>
implements Show {
    @Nonnull
    public final String name;
    @Nonnull
    private Set<Value> values;
    static List<Class<? extends Directive>> fetchDirectives = new ArrayList<Class<? extends Directive>>();
    static List<Class<? extends Directive>> nestedContextDirectives = new ArrayList<Class<? extends Directive>>();
    public static final int FETCH_DIRECIVE_COUNT;
    public static final int NESTED_CONTEXT_DIRECTIVE_COUNT;

    public static List<Class<? extends Directive>> getFetchDirectives() {
        return fetchDirectives;
    }

    public static List<Class<? extends Directive>> getNestedContextDirectives() {
        return nestedContextDirectives;
    }

    static void register(Class<? extends Directive> directiveClass) {
        if (NestedContextDirective.class.isAssignableFrom(directiveClass)) {
            nestedContextDirectives.add(directiveClass);
        } else if (FetchDirective.class.isAssignableFrom(directiveClass) && directiveClass != DefaultSrcDirective.class && directiveClass != FrameSrcDirective.class && directiveClass != WorkerSrcDirective.class) {
            fetchDirectives.add(directiveClass);
        }
    }

    Directive(@Nonnull String name, @Nonnull Set<Value> values) {
        this.name = name;
        this.values = values;
    }

    @Nonnull
    private static <T> Set<T> union(@Nonnull Set<T> a, @Nonnull Set<T> b) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        set.addAll(a);
        set.addAll(b);
        Optional<Object> star = set.stream().filter(x -> x instanceof HostSource && ((HostSource)x).isWildcard()).findAny();
        if (star.isPresent()) {
            set.removeIf(y -> y instanceof HostSource);
            set.add(star.get());
        }
        return set;
    }

    @Nonnull
    private static <T> Set<T> intersect(@Nonnull Set<T> a, @Nonnull Set<T> b) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        Iterator<T> aIterator = a.iterator();
        Iterator<T> bIterator = b.iterator();
        if (!aIterator.hasNext() || aIterator.next() == None.INSTANCE || !bIterator.hasNext() || bIterator.next() == None.INSTANCE) {
            return set;
        }
        Optional<Object> star = b.stream().filter(x -> x instanceof HostSource && ((HostSource)x).isWildcard()).findAny();
        if (star.isPresent()) {
            set.addAll(a);
            return set;
        }
        for (T x2 : a) {
            if (x2 instanceof HostSource && ((HostSource)x2).isWildcard()) {
                set.clear();
                set.addAll(b);
                return set;
            }
            if (!b.contains(x2)) continue;
            set.add(x2);
        }
        return set;
    }

    @Nonnull
    public final Stream<Value> values() {
        return this.values.stream();
    }

    @Nonnull
    public abstract Directive<Value> construct(Set<Value> var1);

    @Nonnull
    public final Directive<Value> clone() {
        LinkedHashSet<Value> s = new LinkedHashSet<Value>();
        s.addAll(this.values);
        return this.construct(s);
    }

    @Nonnull
    public final Directive<Value> bind(@Nonnull Function<Value, Set<? extends Value>> f) {
        LinkedHashSet<DirectiveValue> newValues = new LinkedHashSet<DirectiveValue>();
        for (DirectiveValue v : this.values) {
            Set<? extends Value> result = f.apply(v);
            if (result == null) {
                newValues.add(v);
                continue;
            }
            newValues.addAll(result);
        }
        return this.construct(newValues);
    }

    public final void union(@Nonnull Directive<Value> other) {
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException(this.getClass() + " can be unioned with " + this.getClass() + ", but found " + other.getClass());
        }
        this.values = Directive.union(this.values, other.values);
    }

    public final void intersect(@Nonnull Directive<Value> other) {
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException(this.getClass() + " can be intersected with " + this.getClass() + ", but found " + other.getClass());
        }
        this.values = Directive.intersect(this.values, other.values);
    }

    boolean equalsHelper(@Nonnull Directive<Value> other) {
        return this.values().count() == other.values().count() && this.values().allMatch(m -> other.values().anyMatch(n -> n.equals(m)));
    }

    int hashCodeHelper(int seed) {
        return this.values().map(Object::hashCode).reduce(seed, (a, b) -> a ^ b);
    }

    @Override
    @Nonnull
    public String show() {
        return Stream.concat(Stream.of(this.name), this.values().map(Show::show)).collect(Collectors.joining(" "));
    }

    public final boolean contains(@Nonnull DirectiveValue value) {
        return this.values().anyMatch(value::equals);
    }

    public final boolean sourceListEquals(@Nullable Object other) {
        return other != null && this.equalsHelper((Directive)other);
    }

    public final boolean equals(@Nullable Object other) {
        return other != null && other.getClass() == this.getClass() && this.equalsHelper((Directive)other);
    }

    public final int hashCode() {
        return this.hashCodeHelper(this.getClass().getCanonicalName().hashCode());
    }

    static {
        Directive.register(ScriptSrcDirective.class);
        Directive.register(StyleSrcDirective.class);
        Directive.register(ImgSrcDirective.class);
        Directive.register(ChildSrcDirective.class);
        Directive.register(ConnectSrcDirective.class);
        Directive.register(FontSrcDirective.class);
        Directive.register(MediaSrcDirective.class);
        Directive.register(ObjectSrcDirective.class);
        Directive.register(ManifestSrcDirective.class);
        Directive.register(DefaultSrcDirective.class);
        Directive.register(ReferrerDirective.class);
        Directive.register(FrameSrcDirective.class);
        Directive.register(ReportUriDirective.class);
        Directive.register(ReportToDirective.class);
        Directive.register(RequireSriForDirective.class);
        Directive.register(FrameAncestorsDirective.class);
        Directive.register(SandboxDirective.class);
        Directive.register(PluginTypesDirective.class);
        Directive.register(FormActionDirective.class);
        Directive.register(UpgradeInsecureRequestsDirective.class);
        Directive.register(WorkerSrcDirective.class);
        Directive.register(BlockAllMixedContentDirective.class);
        Directive.register(BaseUriDirective.class);
        FETCH_DIRECIVE_COUNT = fetchDirectives.size();
        NESTED_CONTEXT_DIRECTIVE_COUNT = nestedContextDirectives.size();
    }
}

