# Copyright (c) 2015, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

import stix.bindings.ttp as ttp_binding
from stix.common.related import GenericRelationshipList, RelatedExploitTarget


class ExploitTargets(GenericRelationshipList):
    _namespace = "http://stix.mitre.org/TTP-1"
    _binding = ttp_binding
    _binding_class = _binding.ExploitTargetsType
    _binding_var = "Exploit_Target"
    _contained_type = RelatedExploitTarget
    _inner_name = "exploit_targets"
