/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public enum TaskStatus implements Serializable
{
    SUBMITTED("Submitted", true),
    PENDING("Pending", true),
    PAUSED("Paused", true),
    RUNNING("Running", true),
    WAITING_ON_ERROR("Faulty...", true),
    WAITING_ON_FAILURE("Failed...", true),
    FAILED("Resource down", false),
    NOT_STARTED("Could not start", false),
    NOT_RESTARTED("Could not restart", false),
    ABORTED("Aborted", false),
    FAULTY("Faulty", false),
    FINISHED("Finished", false),
    SKIPPED("Skipped", false),
    IN_ERROR("In-Error", true);

    public static final Set<TaskStatus> ERROR_TASKS;
    public static final Set<TaskStatus> FINISHED_TASKS;
    public static final Set<TaskStatus> RUNNING_TASKS;
    public static final Set<TaskStatus> PENDING_TASKS;
    private String name;
    private final boolean taskAlive;

    private TaskStatus(String name, boolean taskAlive) {
        this.name = name;
        this.taskAlive = taskAlive;
    }

    public boolean isTaskAlive() {
        return this.taskAlive;
    }

    public String toString() {
        return this.name;
    }

    public static List<TaskStatus> allExceptThese(TaskStatus ... taskStatuses) {
        HashSet<TaskStatus> statusesToAvoid = new HashSet<TaskStatus>(Arrays.asList(taskStatuses));
        return Arrays.stream(TaskStatus.values()).filter(taskStatus -> !statusesToAvoid.contains(taskStatus)).collect(Collectors.toList());
    }

    public static Set<TaskStatus> expandAggregatedStatusesToRealStatuses(List<String> aggregatedStatuses) {
        return aggregatedStatuses.stream().flatMap(aggregatedStatus -> {
            switch (aggregatedStatus.toLowerCase()) {
                case "submitted": {
                    return Stream.of(SUBMITTED);
                }
                case "pending": {
                    return Stream.of(PENDING);
                }
                case "running": 
                case "active": 
                case "current": {
                    return RUNNING_TASKS.stream();
                }
                case "finished": 
                case "terminated": 
                case "past": {
                    return FINISHED_TASKS.stream();
                }
                case "error": {
                    return ERROR_TASKS.stream();
                }
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
    }

    static {
        ERROR_TASKS = ImmutableSet.of((Object)IN_ERROR, (Object)WAITING_ON_ERROR, (Object)WAITING_ON_FAILURE, (Object)FAILED, (Object)FAULTY);
        FINISHED_TASKS = ImmutableSet.of((Object)FAILED, (Object)NOT_RESTARTED, (Object)ABORTED, (Object)FAULTY, (Object)FINISHED, (Object)SKIPPED, (Object[])new TaskStatus[]{NOT_STARTED});
        RUNNING_TASKS = ImmutableSet.of((Object)PAUSED, (Object)IN_ERROR, (Object)RUNNING, (Object)WAITING_ON_ERROR, (Object)WAITING_ON_FAILURE);
        PENDING_TASKS = ImmutableSet.of((Object)SUBMITTED, (Object)PENDING);
    }
}

