/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelValidator
implements Validator<String> {
    ExpressionParser parser = new SpelExpressionParser();
    Expression spelExpression;

    public SpelValidator(String spelExpression) {
        this.spelExpression = this.parser.parseExpression(spelExpression);
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        try {
            context.getSpELContext().setVariable("value", (Object)parameterValue);
            Object untypedResult = this.spelExpression.getValue((EvaluationContext)context.getSpELContext());
            if (!(untypedResult instanceof Boolean)) {
                throw new ValidationException("SPEL expression did not return a boolean value.");
            }
            boolean evaluationResult = (Boolean)untypedResult;
            if (!evaluationResult) {
                throw new ValidationException("SPEL expression returned false, received " + parameterValue);
            }
        }
        catch (EvaluationException e) {
            throw new ValidationException("SPEL expression raised an error: " + e.getMessage(), e);
        }
        return parameterValue;
    }
}

