# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BatchAccountCreateParameters(Model):
    """
    Parameters supplied to the Create operation.

    :param location: The region in which the account is created.
    :type location: str
    :param tags: The user specified tags associated with the account.
    :type tags: dict
    :param auto_storage: The properties related to auto storage.
    :type auto_storage: :class:`AutoStorageBaseProperties
     <azure.mgmt.batch.models.AutoStorageBaseProperties>`
    """ 

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
    }

    def __init__(self, location=None, tags=None, auto_storage=None, **kwargs):
        self.location = location
        self.tags = tags
        self.auto_storage = auto_storage
