"""
The MIT License (MIT)

Copyright (c) 2016 Gehad Shaat

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""


def add_attributes_to_findings(findingArns=None, attributes=None):
    """
    :param findingArns: [REQUIRED]
            The ARNs that specify the findings that you want to assign attributes to.
            (string) --
            
    :type findingArns: list
    :param attributes: [REQUIRED]
            The array of attributes that you want to assign to specified findings.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            
    :type attributes: list
    """
    pass


def can_paginate(operation_name=None):
    """
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').
            ReturnsTrue if the operation can be paginated,
            False otherwise.
            
    :type operation_name: string
    """
    pass


def create_assessment_target(assessmentTargetName=None, resourceGroupArn=None):
    """
    :param assessmentTargetName: [REQUIRED]
            The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.
            
    :type assessmentTargetName: string
    :param resourceGroupArn: [REQUIRED]
            The ARN that specifies the resource group that is used to create the assessment target.
            
    :type resourceGroupArn: string
    """
    pass


def create_assessment_template(assessmentTargetArn=None, assessmentTemplateName=None, durationInSeconds=None,
                               rulesPackageArns=None, userAttributesForFindings=None):
    """
    :param assessmentTargetArn: [REQUIRED]
            The ARN that specifies the assessment target for which you want to create the assessment template.
            
    :type assessmentTargetArn: string
    :param assessmentTemplateName: [REQUIRED]
            The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
            
    :type assessmentTemplateName: string
    :param durationInSeconds: [REQUIRED]
            The duration of the assessment run in seconds. The default value is 3600 seconds (one hour).
            
    :type durationInSeconds: integer
    :param rulesPackageArns: [REQUIRED]
            The ARNs that specify the rules packages that you want to attach to the assessment template.
            (string) --
            
    :type rulesPackageArns: list
    :param userAttributesForFindings: The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            
    :type userAttributesForFindings: list
    """
    pass


def create_resource_group(resourceGroupTags=None):
    """
    :param resourceGroupTags: [REQUIRED]
            A collection of keys and an array of possible values, '[{'key':'key1','values':['Value1','Value2']},{'key':'Key2','values':['Value3']}]'.
            For example,'[{'key':'Name','values':['TestEC2Instance']}]'.
            (dict) --This data type is used as one of the elements of the ResourceGroup data type.
            key (string) -- [REQUIRED]A tag key.
            value (string) --The value assigned to a tag key.
            
            Return typedict
            ReturnsResponse Syntax{
              'resourceGroupArn': 'string'
            }
            Response Structure
            (dict) --
            resourceGroupArn (string) --The ARN that specifies the resource group that is created.
            
            
    :type resourceGroupTags: list
    """
    pass


def delete_assessment_run(assessmentRunArn=None):
    """
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run that you want to delete.
            ReturnsNone
            
    :type assessmentRunArn: string
    """
    pass


def delete_assessment_target(assessmentTargetArn=None):
    """
    :param assessmentTargetArn: [REQUIRED]
            The ARN that specifies the assessment target that you want to delete.
            ReturnsNone
            
    :type assessmentTargetArn: string
    """
    pass


def delete_assessment_template(assessmentTemplateArn=None):
    """
    :param assessmentTemplateArn: [REQUIRED]
            The ARN that specifies the assessment template that you want to delete.
            ReturnsNone
            
    :type assessmentTemplateArn: string
    """
    pass


def describe_assessment_runs(assessmentRunArns=None):
    """
    :param assessmentRunArns: [REQUIRED]
            The ARN that specifies the assessment run that you want to describe.
            (string) --
            Return typedict
            ReturnsResponse Syntax{
              'assessmentRuns': [
                {
                  'arn': 'string',
                  'name': 'string',
                  'assessmentTemplateArn': 'string',
                  'state': 'CREATED'|'START_DATA_COLLECTION_PENDING'|'START_DATA_COLLECTION_IN_PROGRESS'|'COLLECTING_DATA'|'STOP_DATA_COLLECTION_PENDING'|'DATA_COLLECTED'|'EVALUATING_RULES'|'FAILED'|'COMPLETED'|'COMPLETED_WITH_ERRORS',
                  'durationInSeconds': 123,
                  'rulesPackageArns': [
                    'string',
                  ],
                  'userAttributesForFindings': [
                    {
                      'key': 'string',
                      'value': 'string'
                    },
                  ],
                  'createdAt': datetime(2015, 1, 1),
                  'startedAt': datetime(2015, 1, 1),
                  'completedAt': datetime(2015, 1, 1),
                  'stateChangedAt': datetime(2015, 1, 1),
                  'dataCollected': True|False,
                  'stateChanges': [
                    {
                      'stateChangedAt': datetime(2015, 1, 1),
                      'state': 'CREATED'|'START_DATA_COLLECTION_PENDING'|'START_DATA_COLLECTION_IN_PROGRESS'|'COLLECTING_DATA'|'STOP_DATA_COLLECTION_PENDING'|'DATA_COLLECTED'|'EVALUATING_RULES'|'FAILED'|'COMPLETED'|'COMPLETED_WITH_ERRORS'
                    },
                  ],
                  'notifications': [
                    {
                      'date': datetime(2015, 1, 1),
                      'event': 'ASSESSMENT_RUN_STARTED'|'ASSESSMENT_RUN_COMPLETED'|'ASSESSMENT_RUN_STATE_CHANGED'|'FINDING_REPORTED'|'OTHER',
                      'message': 'string',
                      'error': True|False,
                      'snsTopicArn': 'string',
                      'snsPublishStatusCode': 'SUCCESS'|'TOPIC_DOES_NOT_EXIST'|'ACCESS_DENIED'|'INTERNAL_ERROR'
                    },
                  ]
                },
              ],
              'failedItems': {
                'string': {
                  'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                  'retryable': True|False
                }
              }
            }
            Response Structure
            (dict) --
            assessmentRuns (list) --Information about the assessment run.
            (dict) --A snapshot of an Amazon Inspector assessment run that contains the findings of the assessment run .
            Used as the response element in the DescribeAssessmentRuns action.
            arn (string) --The ARN of the assessment run.
            name (string) --The auto-generated name for the assessment run.
            assessmentTemplateArn (string) --The ARN of the assessment template that is associated with the assessment run.
            state (string) --The state of the assessment run.
            durationInSeconds (integer) --The duration of the assessment run.
            rulesPackageArns (list) --The rules packages selected for the assessment run.
            (string) --
            userAttributesForFindings (list) --The user-defined attributes that are assigned to every generated finding.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) --The attribute key.
            value (string) --The value assigned to the attribute key.
            
            createdAt (datetime) --The time when StartAssessmentRun was called.
            startedAt (datetime) --The time when StartAssessmentRun was called.
            completedAt (datetime) --The assessment run completion time that corresponds to the rules packages evaluation completion time or failure.
            stateChangedAt (datetime) --The last time when the assessment run's state changed.
            dataCollected (boolean) --A Boolean value (true or false) that specifies whether the process of collecting data from the agents is completed.
            stateChanges (list) --A list of the assessment run state changes.
            (dict) --Used as one of the elements of the AssessmentRun data type.
            stateChangedAt (datetime) --The last time the assessment run state changed.
            state (string) --The assessment run state.
            
            notifications (list) --A list of notifications for the event subscriptions. A notification about a particular generated finding is added to this list only once.
            (dict) --Used as one of the elements of the AssessmentRun data type.
            date (datetime) --The date of the notification.
            event (string) --The event for which a notification is sent.
            message (string) --
            error (boolean) --The Boolean value that specifies whether the notification represents an error.
            snsTopicArn (string) --The SNS topic to which the SNS notification is sent.
            snsPublishStatusCode (string) --The status code of the SNS notification.
            
            
            failedItems (dict) --Assessment run details that cannot be described. An error code is provided for each failed item.
            (string) --
            (dict) --Includes details about the failed items.
            failureCode (string) --The status code of a failed item.
            retryable (boolean) --Indicates whether you can immediately retry a request for this item for a specified resource.
            
            
            
            
    :type assessmentRunArns: list
    """
    pass


def describe_assessment_targets(assessmentTargetArns=None):
    """
    :param assessmentTargetArns: [REQUIRED]
            The ARNs that specifies the assessment targets that you want to describe.
            (string) --
            Return typedict
            ReturnsResponse Syntax{
              'assessmentTargets': [
                {
                  'arn': 'string',
                  'name': 'string',
                  'resourceGroupArn': 'string',
                  'createdAt': datetime(2015, 1, 1),
                  'updatedAt': datetime(2015, 1, 1)
                },
              ],
              'failedItems': {
                'string': {
                  'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                  'retryable': True|False
                }
              }
            }
            Response Structure
            (dict) --
            assessmentTargets (list) --Information about the assessment targets.
            (dict) --Contains information about an Amazon Inspector application. This data type is used as the response element in the DescribeAssessmentTargets action.
            arn (string) --The ARN that specifies the Amazon Inspector assessment target.
            name (string) --The name of the Amazon Inspector assessment target.
            resourceGroupArn (string) --The ARN that specifies the resource group that is associated with the assessment target.
            createdAt (datetime) --The time at which the assessment target is created.
            updatedAt (datetime) --The time at which UpdateAssessmentTarget is called.
            
            failedItems (dict) --Assessment target details that cannot be described. An error code is provided for each failed item.
            (string) --
            (dict) --Includes details about the failed items.
            failureCode (string) --The status code of a failed item.
            retryable (boolean) --Indicates whether you can immediately retry a request for this item for a specified resource.
            
            
            
            
    :type assessmentTargetArns: list
    """
    pass


def describe_assessment_templates(assessmentTemplateArns=None):
    """
    :param assessmentTemplateArns: [REQUIRED]
            The ARN that specifiesthe assessment templates that you want to describe.
            (string) --
            Return typedict
            ReturnsResponse Syntax{
              'assessmentTemplates': [
                {
                  'arn': 'string',
                  'name': 'string',
                  'assessmentTargetArn': 'string',
                  'durationInSeconds': 123,
                  'rulesPackageArns': [
                    'string',
                  ],
                  'userAttributesForFindings': [
                    {
                      'key': 'string',
                      'value': 'string'
                    },
                  ],
                  'createdAt': datetime(2015, 1, 1)
                },
              ],
              'failedItems': {
                'string': {
                  'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                  'retryable': True|False
                }
              }
            }
            Response Structure
            (dict) --
            assessmentTemplates (list) --Information about the assessment templates.
            (dict) --Contains information about an Amazon Inspector assessment template. This data type is used as the response element in the DescribeAssessmentTemplates action.
            arn (string) --The ARN of the assessment template.
            name (string) --The name of the assessment template.
            assessmentTargetArn (string) --The ARN of the assessment target that corresponds to this assessment template.
            durationInSeconds (integer) --The duration in seconds specified for this assessment tempate. The default value is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).
            rulesPackageArns (list) --The rules packages that are specified for this assessment template.
            (string) --
            userAttributesForFindings (list) --The user-defined attributes that are assigned to every generated finding from the assessment run that uses this assessment template.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) --The attribute key.
            value (string) --The value assigned to the attribute key.
            
            createdAt (datetime) --The time at which the assessment template is created.
            
            failedItems (dict) --Assessment template details that cannot be described. An error code is provided for each failed item.
            (string) --
            (dict) --Includes details about the failed items.
            failureCode (string) --The status code of a failed item.
            retryable (boolean) --Indicates whether you can immediately retry a request for this item for a specified resource.
            
            
            
            
    :type assessmentTemplateArns: list
    """
    pass


def describe_cross_account_access_role():
    """
    """
    pass


def describe_findings(findingArns=None, locale=None):
    """
    :param findingArns: [REQUIRED]
            The ARN that specifies the finding that you want to describe.
            (string) --
            
    :type findingArns: list
    :param locale: The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.
    :type locale: string
    """
    pass


def describe_resource_groups(resourceGroupArns=None):
    """
    :param resourceGroupArns: [REQUIRED]
            The ARN that specifies the resource group that you want to describe.
            (string) --
            Return typedict
            ReturnsResponse Syntax{
              'resourceGroups': [
                {
                  'arn': 'string',
                  'tags': [
                    {
                      'key': 'string',
                      'value': 'string'
                    },
                  ],
                  'createdAt': datetime(2015, 1, 1)
                },
              ],
              'failedItems': {
                'string': {
                  'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                  'retryable': True|False
                }
              }
            }
            Response Structure
            (dict) --
            resourceGroups (list) --Information about a resource group.
            (dict) --Contains information about a resource group. The resource group defines a set of tags that, when queried, identify the AWS resources that make up the assessment target. This data type is used as the response element in the DescribeResourceGroups action.
            arn (string) --The ARN of the resource group.
            tags (list) --The tags (key and value pairs) of the resource group. This data type property is used in the CreateResourceGroup action.
            (dict) --This data type is used as one of the elements of the ResourceGroup data type.
            key (string) --A tag key.
            value (string) --The value assigned to a tag key.
            
            createdAt (datetime) --The time at which resource group is created.
            
            failedItems (dict) --Resource group details that cannot be described. An error code is provided for each failed item.
            (string) --
            (dict) --Includes details about the failed items.
            failureCode (string) --The status code of a failed item.
            retryable (boolean) --Indicates whether you can immediately retry a request for this item for a specified resource.
            
            
            
            
    :type resourceGroupArns: list
    """
    pass


def describe_rules_packages(rulesPackageArns=None, locale=None):
    """
    :param rulesPackageArns: [REQUIRED]
            The ARN that specifies the rules package that you want to describe.
            (string) --
            
    :type rulesPackageArns: list
    :param locale: The locale that you want to translate a rules package description into.
    :type locale: string
    """
    pass


def generate_presigned_url(ClientMethod=None, Params=None, ExpiresIn=None, HttpMethod=None):
    """
    :param ClientMethod: The client method to presign for
    :type ClientMethod: string
    :param Params: The parameters normally passed to
            ClientMethod.
    :type Params: dict
    :param ExpiresIn: The number of seconds the presigned url is valid
            for. By default it expires in an hour (3600 seconds)
    :type ExpiresIn: int
    :param HttpMethod: The http method to use on the generated url. By
            default, the http method is whatever is used in the method's model.
    :type HttpMethod: string
    """
    pass


def get_paginator(operation_name=None):
    """
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').
            Raises OperationNotPageableErrorRaised if the operation is not
            pageable. You can use the client.can_paginate method to
            check if an operation is pageable.
            Return typeL{botocore.paginate.Paginator}
            ReturnsA paginator object.
            
    :type operation_name: string
    """
    pass


def get_telemetry_metadata(assessmentRunArn=None):
    """
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run that has the telemetry data that you want to obtain.
            Return typedict
            ReturnsResponse Syntax{
              'telemetryMetadata': [
                {
                  'messageType': 'string',
                  'count': 123,
                  'dataSize': 123
                },
              ]
            }
            Response Structure
            (dict) --
            telemetryMetadata (list) --Telemetry details.
            (dict) --The metadata about the Amazon Inspector application data metrics collected by the agent. This data type is used as the response element in the GetTelemetryMetadata action.
            messageType (string) --A specific type of behavioral data that is collected by the agent.
            count (integer) --The count of messages that the agent sends to the Amazon Inspector service.
            dataSize (integer) --The data size of messages that the agent sends to the Amazon Inspector service.
            
            
            
    :type assessmentRunArn: string
    """
    pass


def get_waiter():
    """
    """
    pass


def list_assessment_run_agents(assessmentRunArn=None, filter=None, nextToken=None, maxResults=None):
    """
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run whose agents you want to list.
            
    :type assessmentRunArn: string
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            agentHealths (list) -- [REQUIRED]The current health state of the agent. Values can be set to HEALTHY or UNHEALTHY .
            (string) --
            agentHealthCodes (list) -- [REQUIRED]The detailed health state of the agent. Values can be set to IDLE , RUNNING , SHUTDOWN , UNHEALTHY , THROTTLED , and UNKNOWN .
            (string) --
            
    :type filter: dict
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentRunAgents action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_assessment_runs(assessmentTemplateArns=None, filter=None, nextToken=None, maxResults=None):
    """
    :param assessmentTemplateArns: The ARNs that specify the assessment templates whose assessment runs you want to list.
            (string) --
            
    :type assessmentTemplateArns: list
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            namePattern (string) --For a record to match a filter, an explicit value or a string containing a wildcard that is specified for this data type property must match the value of the assessmentRunName property of the AssessmentRun data type.
            states (list) --For a record to match a filter, one of the values specified for this data type property must be the exact match of the value of the assessmentRunState property of the AssessmentRun data type.
            (string) --
            durationRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the durationInSeconds property of the AssessmentRun data type.
            minSeconds (integer) --The minimum value of the duration range. Must be greater than zero.
            maxSeconds (integer) --The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
            rulesPackageArns (list) --For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the rulesPackages property of the AssessmentRun data type.
            (string) --
            startTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the startTime property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            completionTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the completedAt property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            stateChangeTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must match the stateChangedAt property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            
            
    :type filter: dict
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentRuns action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_assessment_targets(filter=None, nextToken=None, maxResults=None):
    """
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            assessmentTargetNamePattern (string) --For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the assessmentTargetName property of the AssessmentTarget data type.
            
    :type filter: dict
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTargets action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_assessment_templates(assessmentTargetArns=None, filter=None, nextToken=None, maxResults=None):
    """
    :param assessmentTargetArns: A list of ARNs that specifies the assessment targets whose assessment templates you want to list.
            (string) --
            
    :type assessmentTargetArns: list
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            namePattern (string) --For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the assessmentTemplateName property of the AssessmentTemplate data type.
            durationRange (dict) --For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the durationInSeconds property of the AssessmentTemplate data type.
            minSeconds (integer) --The minimum value of the duration range. Must be greater than zero.
            maxSeconds (integer) --The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
            rulesPackageArns (list) --For a record to match a filter, the values that are specified for this data type property must be contained in the list of values of the rulesPackageArns property of the AssessmentTemplate data type.
            (string) --
            
    :type filter: dict
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTemplates action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_event_subscriptions(resourceArn=None, nextToken=None, maxResults=None):
    """
    :param resourceArn: The ARN of the assessment template for which you want to list the existing event subscriptions.
    :type resourceArn: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListEventSubscriptions action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_findings(assessmentRunArns=None, filter=None, nextToken=None, maxResults=None):
    """
    :param assessmentRunArns: The ARNs of the assessment runs that generate the findings that you want to list.
            (string) --
            
    :type assessmentRunArns: list
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            agentIds (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the agentId property of the Finding data type.
            (string) --
            autoScalingGroups (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the autoScalingGroup property of the Finding data type.
            (string) --
            ruleNames (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the ruleName property of the Finding data type.
            (string) --
            severities (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the severity property of the Finding data type.
            (string) --
            rulesPackageArns (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the rulesPackageArn property of the Finding data type.
            (string) --
            attributes (list) --For a record to match a filter, the list of values that are specified for this data type property must be contained in the list of values of the attributes property of the Finding data type.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            userAttributes (list) --For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the userAttributes property of the Finding data type.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            creationTimeRange (dict) --The time range during which the finding is generated.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            
            
    :type filter: dict
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListFindings action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_rules_packages(nextToken=None, maxResults=None):
    """
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListRulesPackages action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def list_tags_for_resource(resourceArn=None):
    """
    :param resourceArn: [REQUIRED]
            The ARN that specifies the assessment template whose tags you want to list.
            Return typedict
            ReturnsResponse Syntax{
              'tags': [
                {
                  'key': 'string',
                  'value': 'string'
                },
              ]
            }
            Response Structure
            (dict) --
            tags (list) --A collection of key and value pairs.
            (dict) --A key and value pair. This data type is used as a request parameter in the SetTagsForResource action and a response element in the ListTagsForResource action.
            key (string) --A tag key.
            value (string) --A value assigned to a tag key.
            
            
            
    :type resourceArn: string
    """
    pass


def preview_agents(previewAgentsArn=None, nextToken=None, maxResults=None):
    """
    :param previewAgentsArn: [REQUIRED]
            The ARN of the assessment target whose agents you want to preview.
            
    :type previewAgentsArn: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the PreviewAgents action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.
    :type nextToken: string
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.
    :type maxResults: integer
    """
    pass


def register_cross_account_access_role(roleArn=None):
    """
    :param roleArn: [REQUIRED]
            The ARN of the IAM role that Amazon Inspector uses to list your EC2 instances during the assessment run or when you call the PreviewAgents action.
            ReturnsNone
            
    :type roleArn: string
    """
    pass


def remove_attributes_from_findings(findingArns=None, attributeKeys=None):
    """
    :param findingArns: [REQUIRED]
            The ARNs that specify the findings that you want to remove attributes from.
            (string) --
            
    :type findingArns: list
    :param attributeKeys: [REQUIRED]
            The array of attribute keys that you want to remove from specified findings.
            (string) --
            
    :type attributeKeys: list
    """
    pass


def set_tags_for_resource(resourceArn=None, tags=None):
    """
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that you want to set tags to.
            
    :type resourceArn: string
    :param tags: A collection of key and value pairs that you want to set to the assessment template.
            (dict) --A key and value pair. This data type is used as a request parameter in the SetTagsForResource action and a response element in the ListTagsForResource action.
            key (string) -- [REQUIRED]A tag key.
            value (string) --A value assigned to a tag key.
            
            
    :type tags: list
    """
    pass


def start_assessment_run(assessmentTemplateArn=None, assessmentRunName=None):
    """
    :param assessmentTemplateArn: [REQUIRED]
            The ARN of the assessment template of the assessment run that you want to start.
            
    :type assessmentTemplateArn: string
    :param assessmentRunName: You can specify the name for the assessment run, or you can use the auto-generated name that is based on the assessment template name. The name must be unique for the assessment template.
    :type assessmentRunName: string
    """
    pass


def stop_assessment_run(assessmentRunArn=None):
    """
    :param assessmentRunArn: [REQUIRED]
            The ARN of the assessment run that you want to stop.
            ReturnsNone
            
    :type assessmentRunArn: string
    """
    pass


def subscribe_to_event(resourceArn=None, event=None, topicArn=None):
    """
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.
            
    :type resourceArn: string
    :param event: [REQUIRED]
            The event for which you want to receive SNS notifications.
            
    :type event: string
    :param topicArn: [REQUIRED]
            The ARN of the SNS topic to which the SNS notifications are sent.
            
    :type topicArn: string
    """
    pass


def unsubscribe_from_event(resourceArn=None, event=None, topicArn=None):
    """
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.
            
    :type resourceArn: string
    :param event: [REQUIRED]
            The event for which you want to stop receiving SNS notifications.
            
    :type event: string
    :param topicArn: [REQUIRED]
            The ARN of the SNS topic to which SNS notifications are sent.
            
    :type topicArn: string
    """
    pass


def update_assessment_target(assessmentTargetArn=None, assessmentTargetName=None, resourceGroupArn=None):
    """
    :param assessmentTargetArn: [REQUIRED]
            The ARN of the assessment target that you want to update.
            
    :type assessmentTargetArn: string
    :param assessmentTargetName: [REQUIRED]
            The name of the assessment target that you want to update.
            
    :type assessmentTargetName: string
    :param resourceGroupArn: [REQUIRED]
            The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.
            
    :type resourceGroupArn: string
    """
    pass
