# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RedisRegenerateKeyParameters(Model):
    """Specifies which Redis access keys to reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Redis access key to regenerate. Possible
     values include: 'Primary', 'Secondary'
    :type key_type: str or ~azure.mgmt.redis.models.RedisKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'RedisKeyType'},
    }

    def __init__(self, **kwargs):
        super(RedisRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', None)
