# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6369, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: skip-file

from typing import Optional, Union

import msrest.serialization

from ._communication_enums import *


class CommunicationError(msrest.serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code.
    :type code: str
    :param message: Required. The error message.
    :type message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~communication.models.CommunicationError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~communication.models.CommunicationError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CommunicationError]'},
        'inner_error': {'key': 'innererror', 'type': 'CommunicationError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        super(CommunicationError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class CommunicationErrorResponse(msrest.serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The Communication Services error.
    :type error: ~communication.models.CommunicationError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CommunicationError'},
    }

    def __init__(
        self,
        *,
        error: "CommunicationError",
        **kwargs
    ):
        super(CommunicationErrorResponse, self).__init__(**kwargs)
        self.error = error


class CommunicationIdentifierModel(msrest.serialization.Model):
    """Identifies a participant in Azure Communication services. A participant is, for example, a phone number or an Azure communication user. This model must be interpreted as a union: Apart from rawId, at most one further property may be set.

    :param raw_id: Raw Id of the identifier. Optional in requests, required in responses.
    :type raw_id: str
    :param communication_user: The communication user.
    :type communication_user: ~communication.models.CommunicationUserIdentifierModel
    :param phone_number: The phone number.
    :type phone_number: ~communication.models.PhoneNumberIdentifierModel
    :param microsoft_teams_user: The Microsoft Teams user.
    :type microsoft_teams_user: ~communication.models.MicrosoftTeamsUserIdentifierModel
    """

    _attribute_map = {
        'raw_id': {'key': 'rawId', 'type': 'str'},
        'communication_user': {'key': 'communicationUser', 'type': 'CommunicationUserIdentifierModel'},
        'phone_number': {'key': 'phoneNumber', 'type': 'PhoneNumberIdentifierModel'},
        'microsoft_teams_user': {'key': 'microsoftTeamsUser', 'type': 'MicrosoftTeamsUserIdentifierModel'},
    }

    def __init__(
        self,
        *,
        raw_id: Optional[str] = None,
        communication_user: Optional["CommunicationUserIdentifierModel"] = None,
        phone_number: Optional["PhoneNumberIdentifierModel"] = None,
        microsoft_teams_user: Optional["MicrosoftTeamsUserIdentifierModel"] = None,
        **kwargs
    ):
        super(CommunicationIdentifierModel, self).__init__(**kwargs)
        self.raw_id = raw_id
        self.communication_user = communication_user
        self.phone_number = phone_number
        self.microsoft_teams_user = microsoft_teams_user


class CommunicationUserIdentifierModel(msrest.serialization.Model):
    """A user that got created with an Azure Communication Services resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Id of the communication user.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(CommunicationUserIdentifierModel, self).__init__(**kwargs)
        self.id = id


class MicrosoftTeamsUserIdentifierModel(msrest.serialization.Model):
    """A Microsoft Teams user.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. The Id of the Microsoft Teams user. If not anonymous, this is the AAD
     object Id of the user.
    :type user_id: str
    :param is_anonymous: True if the Microsoft Teams user is anonymous. By default false if
     missing.
    :type is_anonymous: bool
    :param cloud: The cloud that the Microsoft Teams user belongs to. By default 'public' if
     missing. Possible values include: "public", "dod", "gcch".
    :type cloud: str or ~communication.models.CommunicationCloudEnvironmentModel
    """

    _validation = {
        'user_id': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'cloud': {'key': 'cloud', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_id: str,
        is_anonymous: Optional[bool] = None,
        cloud: Optional[Union[str, "CommunicationCloudEnvironmentModel"]] = None,
        **kwargs
    ):
        super(MicrosoftTeamsUserIdentifierModel, self).__init__(**kwargs)
        self.user_id = user_id
        self.is_anonymous = is_anonymous
        self.cloud = cloud


class PhoneNumberIdentifierModel(msrest.serialization.Model):
    """A phone number.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The phone number in E.164 format.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(PhoneNumberIdentifierModel, self).__init__(**kwargs)
        self.value = value
