# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class NetworkSecurityGroup(Resource):
    """
    NetworkSecurityGroup resource

    :param id: Resource Id
    :type id: str
    :param name: Resource name
    :type name: str
    :param type: Resource type
    :type type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param security_rules: Gets or sets Security rules of network security
     group
    :type security_rules: list of :class:`SecurityRule
     <azure.mgmt.network.models.SecurityRule>`
    :param default_security_rules: Gets or sets Default security rules of
     network security group
    :type default_security_rules: list of :class:`SecurityRule
     <azure.mgmt.network.models.SecurityRule>`
    :param network_interfaces: Gets collection of references to Network
     Interfaces
    :type network_interfaces: list of :class:`NetworkInterface
     <azure.mgmt.network.models.NetworkInterface>`
    :param subnets: Gets collection of references to subnets
    :type subnets: list of :class:`Subnet <azure.mgmt.network.models.Subnet>`
    :param resource_guid: Gets or sets resource guid property of the network
     security group resource
    :type resource_guid: str
    :param provisioning_state: Gets or sets Provisioning state of the
     PublicIP resource Updating/Deleting/Failed
    :type provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated
    :type etag: str
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, security_rules=None, default_security_rules=None, network_interfaces=None, subnets=None, resource_guid=None, provisioning_state=None, etag=None, **kwargs):
        super(NetworkSecurityGroup, self).__init__(id=id, name=name, type=type, location=location, tags=tags, **kwargs)
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = network_interfaces
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
        self.etag = etag
