# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class ApplicationGatewayBackendAddressPool(SubResource):
    """
    Backend Address Pool of application gateway

    :param id: Resource Id
    :type id: str
    :param backend_ip_configurations: Gets or sets backendIPConfiguration of
     application gateway
    :type backend_ip_configurations: list of :class:`SubResource
     <azure.mgmt.network.models.SubResource>`
    :param backend_addresses: Gets or sets the backend addresses
    :type backend_addresses: list of :class:`ApplicationGatewayBackendAddress
     <azure.mgmt.network.models.ApplicationGatewayBackendAddress>`
    :param provisioning_state: Gets or sets Provisioning state of the backend
     address pool resource Updating/Deleting/Failed
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated
    :type etag: str
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[SubResource]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, backend_ip_configurations=None, backend_addresses=None, provisioning_state=None, name=None, etag=None, **kwargs):
        super(ApplicationGatewayBackendAddressPool, self).__init__(id=id, **kwargs)
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
