/*!
 * MediaElementPlayer
 * http://mediaelementjs.com/
 *
 * Creates a controller bar for HTML5 <video> add <audio> tags
 * using jQuery and MediaElement.js (HTML5 Flash/Silverlight wrapper)
 *
 * Copyright 2010-2011, John Dyer (http://j.hn/)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 */if(typeof jQuery!="undefined")mejs.$=jQuery;else if(typeof ender!="undefined")mejs.$=ender;
(function(f){mejs.MepDefaults={poster:"",defaultVideoWidth:480,defaultVideoHeight:270,videoWidth:-1,videoHeight:-1,audioWidth:400,audioHeight:30,startVolume:0.8,loop:false,enableAutosize:true,alwaysShowHours:false,alwaysShowControls:false,iPadUseNativeControls:true,features:["playpause","current","progress","duration","tracks","volume","fullscreen"]};mejs.mepIndex=0;mejs.MediaElementPlayer=function(a,c){if(!(this instanceof mejs.MediaElementPlayer))return new mejs.MediaElementPlayer(a,c);this.options=
f.extend({},mejs.MepDefaults,c);this.$media=this.$node=f(a);this.node=this.media=this.$media[0];if(typeof this.node.player!="undefined")return this.node.player;else this.node.player=this;this.isVideo=this.media.tagName.toLowerCase()==="video";this.init();return this};mejs.MediaElementPlayer.prototype={init:function(){var a=this,c=mejs.MediaFeatures,b=f.extend(true,{},a.options,{success:function(d,e){a.meReady(d,e)},error:function(d){a.handleError(d)}});if(c.isiPad&&a.options.iPadUseNativeControls||
c.isiPhone){a.$media.attr("controls","controls");a.$media.removeAttr("poster");if(c.isiPad&&a.media.getAttribute("autoplay")!==null){a.media.load();a.media.play()}}else if(!(c.isAndroid&&a.isVideo)){a.$media.removeAttr("controls");a.id="mep_"+mejs.mepIndex++;a.container=f('<div id="'+a.id+'" class="mejs-container"><div class="mejs-inner"><div class="mejs-mediaelement"></div><div class="mejs-layers"></div><div class="mejs-controls"></div><div class="mejs-clear"></div></div></div>').addClass(a.$media[0].className).insertBefore(a.$media);
a.container.find(".mejs-mediaelement").append(a.$media);a.controls=a.container.find(".mejs-controls");a.layers=a.container.find(".mejs-layers");if(a.isVideo){a.width=a.options.videoWidth>0?a.options.videoWidth:a.$media[0].getAttribute("width")!==null?a.$media.attr("width"):a.options.defaultVideoWidth;a.height=a.options.videoHeight>0?a.options.videoHeight:a.$media[0].getAttribute("height")!==null?a.$media.attr("height"):a.options.defaultVideoHeight}else{a.width=a.options.audioWidth;a.height=a.options.audioHeight}a.setPlayerSize(a.width,
a.height);b.pluginWidth=a.height;b.pluginHeight=a.width}mejs.MediaElement(a.$media[0],b)},meReady:function(a,c){var b=this,d=mejs.MediaFeatures,e;if(!b.created){b.created=true;b.media=a;b.domNode=c;if(!d.isiPhone&&!d.isAndroid&&!(d.isiPad&&b.options.iPadUseNativeControls)){b.buildposter(b,b.controls,b.layers,b.media);b.buildoverlays(b,b.controls,b.layers,b.media);b.findTracks();for(e in b.options.features){d=b.options.features[e];if(b["build"+d])try{b["build"+d](b,b.controls,b.layers,b.media)}catch(g){}}b.container.trigger("controlsready");
b.setPlayerSize(b.width,b.height);b.setControlsSize();if(b.isVideo){b.container.bind("mouseenter",function(){if(!b.options.alwaysShowControls){b.controls.css("visibility","visible");b.controls.stop(true,true).fadeIn(200)}}).bind("mouseleave",function(){!b.media.paused&&!b.options.alwaysShowControls&&b.controls.stop(true,true).fadeOut(200,function(){f(this).css("visibility","hidden");f(this).css("display","block")})});b.domNode.getAttribute("autoplay")!==null&&!b.options.alwaysShowControls&&b.controls.css("visibility",
"hidden");b.options.enableAutosize&&b.media.addEventListener("loadedmetadata",function(h){if(b.options.videoHeight<=0&&b.domNode.getAttribute("height")===null&&!isNaN(h.target.videoHeight)){b.setPlayerSize(h.target.videoWidth,h.target.videoHeight);b.setControlsSize();b.media.setVideoSize(h.target.videoWidth,h.target.videoHeight)}},false)}b.media.addEventListener("ended",function(){b.media.setCurrentTime(0);b.media.pause();b.setProgressRail&&b.setProgressRail();b.setCurrentRail&&b.setCurrentRail();
if(b.options.loop)b.media.play();else b.options.alwaysShowControls||b.controls.css("visibility","visible")},true);b.media.addEventListener("loadedmetadata",function(){b.updateDuration&&b.updateDuration();b.updateCurrent&&b.updateCurrent();b.setControlsSize()},true);setTimeout(function(){b.setControlsSize();b.setPlayerSize(b.width,b.height)},50)}b.options.success&&b.options.success(b.media,b.domNode)}},handleError:function(a){this.options.error&&this.options.error(a)},setPlayerSize:function(a,c){this.width=
parseInt(a,10);this.height=parseInt(c,10);this.container.width(this.width).height(this.height);this.layers.children(".mejs-layer").width(this.width).height(this.height)},setControlsSize:function(){var a=0,c=0,b=this.controls.find(".mejs-time-rail"),d=this.controls.find(".mejs-time-total");this.controls.find(".mejs-time-current");this.controls.find(".mejs-time-loaded");others=b.siblings();others.each(function(){if(f(this).css("position")!="absolute")a+=f(this).outerWidth(true)});c=this.controls.width()-
a-(b.outerWidth(true)-b.outerWidth(false));b.width(c);d.width(c-(d.outerWidth(true)-d.width()));this.setProgressRail&&this.setProgressRail();this.setCurrentRail&&this.setCurrentRail()},buildposter:function(a,c,b,d){var e=f('<div class="mejs-poster mejs-layer"><img /></div>').appendTo(b);c=a.$media.attr("poster");b=e.find("img").width(a.width).height(a.height);if(a.options.poster!="")b.attr("src",a.options.poster);else c!==""&&c!=null?b.attr("src",c):e.remove();d.addEventListener("play",function(){e.hide()},
false)},buildoverlays:function(a,c,b,d){if(a.isVideo){var e=f('<div class="mejs-overlay mejs-layer"><div class="mejs-overlay-loading"><span></span></div></div>').hide().appendTo(b),g=f('<div class="mejs-overlay mejs-layer"><div class="mejs-overlay-error"></div></div>').hide().appendTo(b),h=f('<div class="mejs-overlay mejs-layer mejs-overlay-play"><div class="mejs-overlay-button"></div></div>').appendTo(b).click(function(){d.paused?d.play():d.pause()});d.addEventListener("play",function(){h.hide();
g.hide()},false);d.addEventListener("pause",function(){h.show()},false);d.addEventListener("loadstart",function(){mejs.MediaFeatures.isChrome&&d.getAttribute&&d.getAttribute("preload")==="none"||e.show()},false);d.addEventListener("canplay",function(){e.hide()},false);d.addEventListener("error",function(){e.hide();g.show();g.find("mejs-overlay-error").html("Error loading this resource")},false)}},findTracks:function(){var a=this,c=a.$media.find("track");a.tracks=[];c.each(function(){a.tracks.push({srclang:f(this).attr("srclang").toLowerCase(),
src:f(this).attr("src"),kind:f(this).attr("kind"),entries:[],isLoaded:false})})},changeSkin:function(a){this.container[0].className="mejs-container "+a;this.setPlayerSize();this.setControlsSize()},play:function(){this.media.play()},pause:function(){this.media.pause()},load:function(){this.media.load()},setMuted:function(a){this.media.setMuted(a)},setCurrentTime:function(a){this.media.setCurrentTime(a)},getCurrentTime:function(){return this.media.currentTime},setVolume:function(a){this.media.setVolume(a)},
getVolume:function(){return this.media.volume},setSrc:function(a){this.media.setSrc(a)}};if(typeof jQuery!="undefined")jQuery.fn.mediaelementplayer=function(a){return this.each(function(){new mejs.MediaElementPlayer(this,a)})};window.MediaElementPlayer=mejs.MediaElementPlayer})(mejs.$);
(function(f){MediaElementPlayer.prototype.buildplaypause=function(a,c,b,d){var e=f('<div class="mejs-button mejs-playpause-button mejs-play" type="button"><button type="button"></button></div>').appendTo(c).click(function(g){g.preventDefault();d.paused?d.play():d.pause();return false});d.addEventListener("play",function(){e.removeClass("mejs-play").addClass("mejs-pause")},false);d.addEventListener("playing",function(){e.removeClass("mejs-play").addClass("mejs-pause")},false);d.addEventListener("pause",
function(){e.removeClass("mejs-pause").addClass("mejs-play")},false);d.addEventListener("paused",function(){e.removeClass("mejs-pause").addClass("mejs-play")},false)}})(mejs.$);
(function(f){MediaElementPlayer.prototype.buildstop=function(a,c,b,d){f('<div class="mejs-button mejs-stop-button mejs-stop"><button type="button"></button></div>').appendTo(c).click(function(){d.paused||d.pause();if(d.currentTime>0){d.setCurrentTime(0);c.find(".mejs-time-current").width("0px");c.find(".mejs-time-handle").css("left","0px");c.find(".mejs-time-float-current").html(mejs.Utility.secondsToTimeCode(0));c.find(".mejs-currenttime").html(mejs.Utility.secondsToTimeCode(0));b.find(".mejs-poster").show()}})}})(mejs.$);
(function(f){MediaElementPlayer.prototype.buildprogress=function(a,c,b,d){f('<div class="mejs-time-rail"><span class="mejs-time-total"><span class="mejs-time-loaded"></span><span class="mejs-time-current"></span><span class="mejs-time-handle"></span><span class="mejs-time-float"><span class="mejs-time-float-current">00:00</span><span class="mejs-time-float-corner"></span></span></span></div>').appendTo(c);var e=c.find(".mejs-time-total");b=c.find(".mejs-time-loaded");var g=c.find(".mejs-time-current"),
h=c.find(".mejs-time-handle"),j=c.find(".mejs-time-float"),l=c.find(".mejs-time-float-current"),o=function(k){k=k.pageX;var n=e.offset(),q=e.outerWidth(),p=0;p=0;if(k>n.left&&k<=q+n.left&&d.duration){p=(k-n.left)/q;p=p<=0.02?0:p*d.duration;m&&d.setCurrentTime(p);j.css("left",k-n.left);l.html(mejs.Utility.secondsToTimeCode(p))}},m=false,i=false;e.bind("mousedown",function(k){m=true;o(k);return false});c.find(".mejs-time-rail").bind("mouseenter",function(){i=true}).bind("mouseleave",function(){i=false});
f(document).bind("mouseup",function(){m=false}).bind("mousemove",function(k){if(m||i)o(k)});d.addEventListener("progress",function(k){a.setProgressRail(k);a.setCurrentRail(k)},false);d.addEventListener("timeupdate",function(k){a.setProgressRail(k);a.setCurrentRail(k)},false);this.loaded=b;this.total=e;this.current=g;this.handle=h};MediaElementPlayer.prototype.setProgressRail=function(a){var c=a!=undefined?a.target:this.media,b=null;if(c&&c.buffered&&c.buffered.length>0&&c.buffered.end&&c.duration)b=
c.buffered.end(0)/c.duration;else if(c&&c.bytesTotal!=undefined&&c.bytesTotal>0&&c.bufferedBytes!=undefined)b=c.bufferedBytes/c.bytesTotal;else if(a&&a.lengthComputable&&a.total!=0)b=a.loaded/a.total;if(b!==null){b=Math.min(1,Math.max(0,b));this.loaded&&this.total&&this.loaded.width(this.total.width()*b)}};MediaElementPlayer.prototype.setCurrentRail=function(){if(this.media.currentTime!=undefined&&this.media.duration)if(this.total&&this.handle){var a=this.total.width()*this.media.currentTime/this.media.duration,
c=a-this.handle.outerWidth(true)/2;this.current.width(a);this.handle.css("left",c)}}})(mejs.$);
(function(f){MediaElementPlayer.prototype.buildcurrent=function(a,c,b,d){f('<div class="mejs-time"><span class="mejs-currenttime">'+(a.options.alwaysShowHours?"00:":"")+"00:00</span></div>").appendTo(c);this.currenttime=this.controls.find(".mejs-currenttime");d.addEventListener("timeupdate",function(){a.updateCurrent()},false)};MediaElementPlayer.prototype.buildduration=function(a,c,b,d){if(c.children().last().find(".mejs-currenttime").length>0)f(' <span> | </span> <span class="mejs-duration">'+(a.options.alwaysShowHours?
"00:":"")+"00:00</span>").appendTo(c.find(".mejs-time"));else{c.find(".mejs-currenttime").parent().addClass("mejs-currenttime-container");f('<div class="mejs-time mejs-duration-container"><span class="mejs-duration">'+(a.options.alwaysShowHours?"00:":"")+"00:00</span></div>").appendTo(c)}this.durationD=this.controls.find(".mejs-duration");d.addEventListener("timeupdate",function(){a.updateDuration()},false)};MediaElementPlayer.prototype.updateCurrent=function(){if(this.currenttime)this.currenttime.html(mejs.Utility.secondsToTimeCode(this.media.currentTime|
0,this.options.alwaysShowHours||this.media.duration>3600))};MediaElementPlayer.prototype.updateDuration=function(){this.media.duration&&this.durationD&&this.durationD.html(mejs.Utility.secondsToTimeCode(this.media.duration,this.options.alwaysShowHours))}})(mejs.$);
(function(f){MediaElementPlayer.prototype.buildvolume=function(a,c,b,d){var e=f('<div class="mejs-button mejs-volume-button mejs-mute"><button type="button"></button><div class="mejs-volume-slider"><div class="mejs-volume-total"></div><div class="mejs-volume-current"></div><div class="mejs-volume-handle"></div></div></div>').appendTo(c);c=e.find(".mejs-volume-slider");var g=e.find(".mejs-volume-total"),h=e.find(".mejs-volume-current"),j=e.find(".mejs-volume-handle"),l=function(i){i=g.height()-g.height()*
i;j.css("top",i-j.height()/2);h.height(g.height()-i+parseInt(g.css("top").replace(/px/,""),10));h.css("top",i)},o=function(i){var k=g.height(),n=g.offset(),q=parseInt(g.css("top").replace(/px/,""),10);i=i.pageY-n.top;n=(k-i)/k;if(i<0)i=0;else if(i>k)i=k;j.css("top",i-j.height()/2+q);h.height(k-i);h.css("top",i+q);if(n==0){d.setMuted(true);e.removeClass("mejs-mute").addClass("mejs-unmute")}else{d.setMuted(false);e.removeClass("mejs-unmute").addClass("mejs-mute")}n=Math.max(0,n);n=Math.min(n,1);d.setVolume(n)},
m=false;c.bind("mousedown",function(i){o(i);m=true;return false});f(document).bind("mouseup",function(){m=false}).bind("mousemove",function(i){m&&o(i)});e.find("button").click(function(){if(d.muted){d.setMuted(false);e.removeClass("mejs-unmute").addClass("mejs-mute");l(1)}else{d.setMuted(true);e.removeClass("mejs-mute").addClass("mejs-unmute");l(0)}});d.addEventListener("volumechange",function(i){m||l(i.target.volume)},true);l(a.options.startVolume);d.pluginType==="native"&&d.setVolume(a.options.startVolume)}})(mejs.$);
(function(f){mejs.MediaElementDefaults.forcePluginFullScreen=false;MediaElementPlayer.prototype.isFullScreen=false;MediaElementPlayer.prototype.buildfullscreen=function(a,c,b,d){if(a.isVideo){mejs.MediaFeatures.hasNativeFullScreen&&a.container.bind("webkitfullscreenchange",function(){document.webkitIsFullScreen?a.setControlsSize():a.exitFullScreen()});var e=0,g=0,h=a.container,j=document.documentElement,l,o=f('<div class="mejs-button mejs-fullscreen-button"><button type="button"></button></div>').appendTo(c).click(function(){(mejs.MediaFeatures.hasNativeFullScreen?
document.webkitIsFullScreen:a.isFullScreen)?a.exitFullScreen():a.enterFullScreen()});a.enterFullScreen=function(){if(a.pluginType!=="native"&&(mejs.MediaFeatures.isFirefox||a.options.forcePluginFullScreen))d.setFullscreen(true);else{mejs.MediaFeatures.hasNativeFullScreen&&a.container[0].webkitRequestFullScreen();l=j.style.overflow;j.style.overflow="hidden";e=a.container.height();g=a.container.width();h.addClass("mejs-container-fullscreen").width("100%").height("100%").css("z-index",1E3);if(a.pluginType===
"native")a.$media.width("100%").height("100%");else{h.find("object embed").width("100%").height("100%");a.media.setVideoSize(f(window).width(),f(window).height())}b.children("div").width("100%").height("100%");o.removeClass("mejs-fullscreen").addClass("mejs-unfullscreen");a.setControlsSize();a.isFullScreen=true}};a.exitFullScreen=function(){if(a.pluginType!=="native"&&mejs.MediaFeatures.isFirefox)d.setFullscreen(false);else{mejs.MediaFeatures.hasNativeFullScreen&&document.webkitIsFullScreen&&document.webkitCancelFullScreen();
j.style.overflow=l;h.removeClass("mejs-container-fullscreen").width(g).height(e).css("z-index",1);if(a.pluginType==="native")a.$media.width(g).height(e);else{h.find("object embed").width(g).height(e);a.media.setVideoSize(g,e)}b.children("div").width(g).height(e);o.removeClass("mejs-unfullscreen").addClass("mejs-fullscreen");a.setControlsSize();a.isFullScreen=false}};f(window).bind("resize",function(){a.setControlsSize()});f(document).bind("keydown",function(m){a.isFullScreen&&m.keyCode==27&&a.exitFullScreen()})}}})(mejs.$);
(function(f){f.extend(mejs.MepDefaults,{startLanguage:"",translations:[],translationSelector:false,googleApiKey:""});f.extend(MediaElementPlayer.prototype,{buildtracks:function(a,c,b,d){if(a.isVideo)if(a.tracks.length!=0){var e,g="";a.chapters=f('<div class="mejs-chapters mejs-layer"></div>').prependTo(b).hide();a.captions=f('<div class="mejs-captions-layer mejs-layer"><div class="mejs-captions-position"><span class="mejs-captions-text"></span></div></div>').prependTo(b).hide();a.captionsText=a.captions.find(".mejs-captions-text");
a.captionsButton=f('<div class="mejs-button mejs-captions-button"><button type="button" ></button><div class="mejs-captions-selector"><ul><li><input type="radio" name="'+a.id+'_captions" id="'+a.id+'_captions_none" value="none" checked="checked" /><label for="'+a.id+'_captions_none">None</label></li></ul></div></button>').appendTo(c).delegate("input[type=radio]","click",function(){lang=this.value;if(lang=="none")a.selectedTrack=null;else for(e=0;e<a.tracks.length;e++)if(a.tracks[e].srclang==lang){a.selectedTrack=
a.tracks[e];a.captions.attr("lang",a.selectedTrack.srclang);a.displayCaptions();break}});a.options.alwaysShowControls?a.container.find(".mejs-captions-position").addClass("mejs-captions-position-hover"):a.container.bind("mouseenter",function(){a.container.find(".mejs-captions-position").addClass("mejs-captions-position-hover")}).bind("mouseleave",function(){d.paused||a.container.find(".mejs-captions-position").removeClass("mejs-captions-position-hover")});a.trackToLoad=-1;a.selectedTrack=null;a.isLoadingTrack=
false;if(a.tracks.length>0&&a.options.translations.length>0)for(e=0;e<a.options.translations.length;e++)a.tracks.push({srclang:a.options.translations[e].toLowerCase(),src:null,kind:"subtitles",entries:[],isLoaded:false,isTranslation:true});for(e=0;e<a.tracks.length;e++)a.tracks[e].kind=="subtitles"&&a.addTrackButton(a.tracks[e].srclang,a.tracks[e].isTranslation);a.loadNextTrack();d.addEventListener("timeupdate",function(){a.displayCaptions()},false);d.addEventListener("loadedmetadata",function(){a.displayChapters()},
false);a.container.hover(function(){a.chapters.css("visibility","visible");a.chapters.fadeIn(200)},function(){d.paused||a.chapters.fadeOut(200,function(){f(this).css("visibility","hidden");f(this).css("display","block")})});a.node.getAttribute("autoplay")!==null&&a.chapters.css("visibility","hidden");if(a.options.translationSelector){for(e in mejs.language.codes)g+='<option value="'+e+'">'+mejs.language.codes[e]+"</option>";a.container.find(".mejs-captions-selector ul").before(f('<select class="mejs-captions-translations"><option value="">--Add Translation--</option>'+
g+"</select>"));a.container.find(".mejs-captions-translations").change(function(){lang=f(this).val();if(lang!=""){a.tracks.push({srclang:lang,src:null,entries:[],isLoaded:false,isTranslation:true});if(!a.isLoadingTrack){a.trackToLoad--;a.addTrackButton(lang,true);a.options.startLanguage=lang;a.loadNextTrack()}}})}}},loadNextTrack:function(){this.trackToLoad++;if(this.trackToLoad<this.tracks.length){this.isLoadingTrack=true;this.loadTrack(this.trackToLoad)}else this.isLoadingTrack=false},loadTrack:function(a){var c=
this,b=c.tracks[a],d=function(){b.isLoaded=true;c.enableTrackButton(b.srclang);c.loadNextTrack()};b.isTranslation?mejs.TrackFormatParser.translateTrackText(c.tracks[0].entries,c.tracks[0].srclang,b.srclang,c.options.googleApiKey,function(e){b.entries=e;d()}):f.ajax({url:b.src,success:function(e){b.entries=mejs.TrackFormatParser.parse(e);d();b.kind=="chapters"&&c.media.duration>0&&c.drawChapters(b)},error:function(){c.loadNextTrack()}})},enableTrackButton:function(a){this.captionsButton.find("input[value="+
a+"]").prop("disabled",false).siblings("label").html(mejs.language.codes[a]||a);this.options.startLanguage==a&&f("#"+this.id+"_captions_"+a).click();this.adjustLanguageBox()},addTrackButton:function(a,c){var b=mejs.language.codes[a]||a;this.captionsButton.find("ul").append(f('<li><input type="radio" name="'+this.id+'_captions" id="'+this.id+"_captions_"+a+'" value="'+a+'" disabled="disabled" /><label for="'+this.id+"_captions_"+a+'">'+b+(c?" (translating)":" (loading)")+"</label></li>"));this.adjustLanguageBox();
this.container.find(".mejs-captions-translations option[value="+a+"]").remove()},adjustLanguageBox:function(){this.captionsButton.find(".mejs-captions-selector").height(this.captionsButton.find(".mejs-captions-selector ul").outerHeight(true)+this.captionsButton.find(".mejs-captions-translations").outerHeight(true))},displayCaptions:function(){if(typeof this.tracks!="undefined"){var a,c=this.selectedTrack;if(c!=null&&c.isLoaded)for(a=0;a<c.entries.times.length;a++)if(this.media.currentTime>=c.entries.times[a].start&&
this.media.currentTime<=c.entries.times[a].stop){this.captionsText.html(c.entries.text[a]);this.captions.show();return}this.captions.hide()}},displayChapters:function(){var a;for(a=0;a<this.tracks.length;a++)if(this.tracks[a].kind=="chapters"&&this.tracks[a].isLoaded){this.drawChapters(this.tracks[a]);break}},drawChapters:function(a){var c=this,b,d,e=d=0;c.chapters.empty();for(b=0;b<a.entries.times.length;b++){d=a.entries.times[b].stop-a.entries.times[b].start;d=Math.floor(d/c.media.duration*100);
if(d+e>100||b==a.entries.times.length-1&&d+e<100)d=100-e;c.chapters.append(f('<div class="mejs-chapter" rel="'+a.entries.times[b].start+'" style="left: '+e.toString()+"%;width: "+d.toString()+'%;"><div class="mejs-chapter-block'+(b==a.entries.times.length-1?" mejs-chapter-block-last":"")+'"><span class="ch-title">'+a.entries.text[b]+'</span><span class="ch-time">'+mejs.Utility.secondsToTimeCode(a.entries.times[b].start)+"&ndash;"+mejs.Utility.secondsToTimeCode(a.entries.times[b].stop)+"</span></div></div>"));
e+=d}c.chapters.find("div.mejs-chapter").click(function(){c.media.setCurrentTime(parseFloat(f(this).attr("rel")));c.media.paused&&c.media.play()});c.chapters.show()}});mejs.language={codes:{af:"Afrikaans",sq:"Albanian",ar:"Arabic",be:"Belarusian",bg:"Bulgarian",ca:"Catalan",zh:"Chinese","zh-cn":"Chinese Simplified","zh-tw":"Chinese Traditional",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch",en:"English",et:"Estonian",tl:"Filipino",fi:"Finnish",fr:"French",gl:"Galician",de:"German",el:"Greek",ht:"Haitian Creole",
iw:"Hebrew",hi:"Hindi",hu:"Hungarian",is:"Icelandic",id:"Indonesian",ga:"Irish",it:"Italian",ja:"Japanese",ko:"Korean",lv:"Latvian",lt:"Lithuanian",mk:"Macedonian",ms:"Malay",mt:"Maltese",no:"Norwegian",fa:"Persian",pl:"Polish",pt:"Portuguese",ro:"Romanian",ru:"Russian",sr:"Serbian",sk:"Slovak",sl:"Slovenian",es:"Spanish",sw:"Swahili",sv:"Swedish",tl:"Tagalog",th:"Thai",tr:"Turkish",uk:"Ukrainian",vi:"Vietnamese",cy:"Welsh",yi:"Yiddish"}};mejs.TrackFormatParser={pattern_identifier:/^[0-9]+$/,pattern_timecode:/^([0-9]{2}:[0-9]{2}:[0-9]{2}(,[0-9]{1,3})?) --\> ([0-9]{2}:[0-9]{2}:[0-9]{2}(,[0-9]{3})?)(.*)$/,
split2:function(a,c){return a.split(c)},parse:function(a){var c=0;a=this.split2(a,/\r?\n/);for(var b={text:[],times:[]},d,e;c<a.length;c++)if(this.pattern_identifier.exec(a[c])){c++;if((d=this.pattern_timecode.exec(a[c]))&&c<a.length){c++;e=a[c];for(c++;a[c]!==""&&c<a.length;){e=e+"\n"+a[c];c++}b.text.push(e);b.times.push({start:mejs.Utility.timeCodeToSeconds(d[1]),stop:mejs.Utility.timeCodeToSeconds(d[3]),settings:d[5]})}}return b},translateTrackText:function(a,c,b,d,e){var g={text:[],times:[]},
h,j;this.translateText(a.text.join(" <a></a>"),c,b,d,function(l){h=l.split("<a></a>");for(j=0;j<a.text.length;j++){g.text[j]=h[j];g.times[j]={start:a.times[j].start,stop:a.times[j].stop,settings:a.times[j].settings}}e(g)})},translateText:function(a,c,b,d,e){for(var g,h=[],j,l="",o=function(){if(h.length>0){j=h.shift();mejs.TrackFormatParser.translateChunk(j,c,b,d,function(m){if(m!="undefined")l+=m;o()})}else e(l)};a.length>0;)if(a.length>1E3){g=a.lastIndexOf(".",1E3);h.push(a.substring(0,g));a=a.substring(g+
1)}else{h.push(a);a=""}o()},translateChunk:function(a,c,b,d,e){a={q:a,langpair:c+"|"+b,v:"1.0"};if(d!==""&&d!==null)a.key=d;f.ajax({url:"https://ajax.googleapis.com/ajax/services/language/translate",data:a,type:"GET",dataType:"jsonp",success:function(g){e(g.responseData.translatedText)},error:function(){e(null)}})}};if("x\n\ny".split(/\n/gi).length!=3)mejs.TrackFormatParser.split2=function(a,c){var b=[],d="",e;for(e=0;e<a.length;e++){d+=a.substring(e,e+1);if(c.test(d)){b.push(d.replace(c,""));d=""}}b.push(d);
return b}})(mejs.$);
