# created on 160323:1647

miriamids =\
{'2D-PAGE protein': {'data_entry': 'http://2dbase.techfak.uni-bielefeld.de/cgi-bin/2d/2d.cgi?ac=$id',
                     'example': 'P39172',
                     'name': '2D-PAGE protein',
                     'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$" restricted="true" obsolete="true" replacement="MIR:00000005',
                     'url': 'http://identifiers.org/2d-page.protein/'},
 '3DMET': {'data_entry': 'http://www.3dmet.dna.affrc.go.jp/cgi/show_data.php?acc=$id',
           'example': 'B00162',
           'name': '3DMET',
           'pattern': '^B\\d{5}$',
           'url': 'http://identifiers.org/3dmet/'},
 'ABS': {'data_entry': 'http://genome.crg.es/datasets/abs2005/entries/$id.html',
         'example': 'A0014',
         'name': 'ABS',
         'pattern': '^A\\d+$',
         'url': 'http://identifiers.org/abs/'},
 'AFTOL': {'data_entry': 'http://wasabi.lutzonilab.net/pub/displayTaxonInfo?aftol_id=$id',
           'example': '959',
           'name': 'AFTOL',
           'pattern': '^\\d+$" restricted="true',
           'url': 'http://identifiers.org/aftol.taxonomy/'},
 'AGD': {'data_entry': 'http://agd.vital-it.ch/Ashbya_gossypii/geneview?gene=$id',
         'example': 'AGR144C',
         'name': 'AGD',
         'pattern': '^AGR\\w+$" obsolete="true" replacement="',
         'url': 'http://identifiers.org/agd/'},
 'APD': {'data_entry': 'http://aps.unmc.edu/AP/database/query_output.php?ID=$id',
         'example': '01001',
         'name': 'APD',
         'pattern': '^\\d{5}$',
         'url': 'http://identifiers.org/apd/'},
 'ASAP': {'data_entry': 'http://asap.ahabs.wisc.edu/asap/feature_info.php?LocationID=WIS&amp;FeatureID=$id',
          'example': 'ABE-0009634',
          'name': 'ASAP',
          'pattern': '^[A-Za-z0-9-]+$" restricted="true',
          'url': 'http://identifiers.org/asap/'},
 'ATCC': {'data_entry': 'http://www.lgcstandards-atcc.org/Products/All/$id.aspx',
          'example': '11303',
          'name': 'ATCC',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/atcc/'},
 'Aceview Worm': {'data_entry': 'http://www.ncbi.nlm.nih.gov/IEB/Research/Acembly/av.cgi?db=worm&amp;c=Gene&amp;l=$id',
                  'example': 'aap-1',
                  'name': 'Aceview Worm',
                  'pattern': '^[a-z0-9-]+$',
                  'url': 'http://identifiers.org/aceview.worm/'},
 'Aclame': {'data_entry': 'http://aclame.ulb.ac.be/perl/Aclame/Genomes/mge_view.cgi?view=info&amp;id=$id',
            'example': 'mge:2',
            'name': 'Aclame',
            'pattern': '^mge:\\d+$',
            'url': 'http://identifiers.org/aclame/'},
 'Affymetrix Probeset': {'data_entry': 'https://www.affymetrix.com/LinkServlet?probeset=$id',
                         'example': '243002_at',
                         'name': 'Affymetrix Probeset',
                         'pattern': '\\d{4,}((_[asx])?_at)?" restricted="true',
                         'url': 'http://identifiers.org/affy.probeset/'},
 'Allergome': {'data_entry': 'http://www.allergome.org/script/dettaglio.php?id_molecule=$id',
               'example': '1948',
               'name': 'Allergome',
               'pattern': '^\\d+$" restricted="true',
               'url': 'http://identifiers.org/allergome/'},
 'AmoebaDB': {'data_entry': 'http://amoebadb.org/amoeba/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'EDI_244000',
              'name': 'AmoebaDB',
              'pattern': '^EDI_\\d+$',
              'url': 'http://identifiers.org/amoebadb/'},
 'Anatomical Therapeutic Chemical': {'data_entry': 'http://www.whocc.no/atc_ddd_index/?code=$id',
                                     'example': 'A10BA02',
                                     'name': 'Anatomical Therapeutic Chemical',
                                     'pattern': '^[A-Z](\\d+([A-Z]{1,2}(\\d+)?)?)?$',
                                     'url': 'http://identifiers.org/atc/'},
 'Anatomical Therapeutic Chemical Vetinary': {'data_entry': 'http://www.whocc.no/atcvet/atcvet_index/?code=$id',
                                              'example': 'QJ51RV02',
                                              'name': 'Anatomical Therapeutic Chemical Vetinary',
                                              'pattern': '^Q[A-Z0-9]+$',
                                              'url': 'http://identifiers.org/atcvet/'},
 'Animal Diversity Web': {'data_entry': 'http://animaldiversity.ummz.umich.edu/accounts/$id/',
                          'example': 'Lycalopex_vetulus',
                          'name': 'Animal Diversity Web',
                          'pattern': '^[A-Z_a-z]+$',
                          'url': 'http://identifiers.org/adw/'},
 'Animal Genome Cattle QTL': {'data_entry': 'http://www.animalgenome.org/cgi-bin/QTLdb/BT/qdetails?QTL_ID=$id',
                              'example': '4685',
                              'name': 'Animal Genome Cattle QTL',
                              'pattern': '^\\d+$',
                              'url': 'http://identifiers.org/cattleqtldb/'},
 'Animal Genome Chicken QTL': {'data_entry': 'http://www.animalgenome.org/cgi-bin/QTLdb/GG/qdetails?QTL_ID=$id',
                               'example': '14362',
                               'name': 'Animal Genome Chicken QTL',
                               'pattern': '^\\d+$',
                               'url': 'http://identifiers.org/chickenqtldb/'},
 'Animal Genome Pig QTL': {'data_entry': 'http://www.animalgenome.org/cgi-bin/QTLdb/SS/qdetails?QTL_ID=$id',
                           'example': '14',
                           'name': 'Animal Genome Pig QTL',
                           'pattern': '^\\d+$',
                           'url': 'http://identifiers.org/pigqtldb/'},
 'Animal Genome Sheep QTL': {'data_entry': 'http://www.animalgenome.org/cgi-bin/QTLdb/OA/qdetails?QTL_ID=$id',
                             'example': '19803',
                             'name': 'Animal Genome Sheep QTL',
                             'pattern': '^\\d+$',
                             'url': 'http://identifiers.org/sheepqtldb/'},
 'Animal TFDB Family': {'data_entry': 'http://www.bioguo.org/AnimalTFDB/family.php?fam=$id',
                        'example': 'CUT',
                        'name': 'Animal TFDB Family',
                        'pattern': '^\\w+$',
                        'url': 'http://identifiers.org/atfdb.family/'},
 'AntWeb': {'data_entry': 'http://www.antweb.org/specimen.do?name=$id',
            'example': 'casent0106247',
            'name': 'AntWeb',
            'pattern': '^casent\\d+(\\-D\\d+)?$',
            'url': 'http://identifiers.org/antweb/'},
 'Antibiotic Resistance Genes Database': {'data_entry': 'http://ardb.cbcb.umd.edu/cgi/search.cgi?db=L&amp;amp;field=ni&amp;amp;term=$id',
                                          'example': 'CAE46076',
                                          'name': 'Antibiotic Resistance Genes Database',
                                          'pattern': '^[A-Z_]{3}[0-9]{4,}$',
                                          'url': 'http://identifiers.org/ardb/'},
 'Antibody Registry': {'data_entry': 'http://antibodyregistry.org/AB_$id',
                       'example': '493771',
                       'name': 'Antibody Registry',
                       'pattern': '^\\d+{6}$',
                       'url': 'http://identifiers.org/antibodyregistry/'},
 'AphidBase Transcript': {'data_entry': 'http://bipaa.genouest.org/apps/grs-2.3/grs?reportID=aphidbase_transcript_report&amp;objectID=$id',
                          'example': 'ACYPI000159',
                          'name': 'AphidBase Transcript',
                          'pattern': '^ACYPI\\d{6}(-RA)?$" restricted="true',
                          'url': 'http://identifiers.org/aphidbase.transcript/'},
 'ArachnoServer': {'data_entry': 'http://www.arachnoserver.org/toxincard.html?id=$id',
                   'example': 'AS000060',
                   'name': 'ArachnoServer',
                   'pattern': '^AS\\d{6}$',
                   'url': 'http://identifiers.org/arachnoserver/'},
 'ArrayExpress': {'data_entry': 'http://www.ebi.ac.uk/arrayexpress/experiments/$id',
                  'example': 'E-MEXP-1712',
                  'name': 'ArrayExpress',
                  'pattern': '^[AEP]-\\w{4}-\\d+$',
                  'url': 'http://identifiers.org/arrayexpress/'},
 'ArrayExpress Platform': {'data_entry': 'http://www.ebi.ac.uk/arrayexpress/arrays/$id',
                           'example': 'A-GEOD-50',
                           'name': 'ArrayExpress Platform',
                           'pattern': '^[AEP]-\\w{4}-\\d+$',
                           'url': 'http://identifiers.org/arrayexpress.platform/'},
 'AspGD Locus': {'data_entry': 'http://www.aspergillusgenome.org/cgi-bin/locus.pl?dbid=$id',
                 'example': 'ASPL0000349247',
                 'name': 'AspGD Locus',
                 'pattern': '^[A-Za-z_0-9]+$',
                 'url': 'http://identifiers.org/aspgd.locus/'},
 'AspGD Protein': {'data_entry': 'http://www.aspergillusgenome.org/cgi-bin/protein/proteinPage.pl?dbid=$id',
                   'example': 'ASPL0000349247',
                   'name': 'AspGD Protein',
                   'pattern': '^[A-Za-z_0-9]+$',
                   'url': 'http://identifiers.org/aspgd.protein/'},
 'AutDB': {'data_entry': 'http://autism.mindspec.org/GeneDetail/$id',
           'example': 'ADA',
           'name': 'AutDB',
           'pattern': '^[A-Z]+[A-Z-0-9]{2,}$',
           'url': 'http://identifiers.org/autdb/'},
 'BDGP EST': {'data_entry': 'http://www.ncbi.nlm.nih.gov/nucest/$id',
              'example': 'EY223054.1',
              'name': 'BDGP EST',
              'pattern': '^\\w+(\\.)?(\\d+)?$" restricted="true',
              'url': 'http://identifiers.org/bdgp.est/'},
 'BDGP insertion DB': {'data_entry': 'http://flypush.imgen.bcm.tmc.edu/pscreen/details.php?line=$id',
                       'example': 'KG09531',
                       'name': 'BDGP insertion DB',
                       'pattern': '^\\w+$',
                       'url': 'http://identifiers.org/bdgp.insertion/'},
 'BIND': {'data_entry': 'http://www.bind.ca/Action?identifier=bindid&amp;idsearch=$id',
          'example': None,
          'name': 'BIND',
          'pattern': '^\\d+$" restricted="true" obsolete="true" replacement="MIR:00000010',
          'url': 'http://identifiers.org/bind/'},
 'BOLD Taxonomy': {'data_entry': 'http://www.boldsystems.org/index.php/Taxbrowser_Taxonpage?taxid=$id',
                   'example': '27267',
                   'name': 'BOLD Taxonomy',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/bold.taxonomy/'},
 'BRENDA': {'data_entry': 'http://www.brenda-enzymes.org/php/result_flat.php4?ecno=$id',
            'example': '1.1.1.1',
            'name': 'BRENDA',
            'pattern': '^((\\d+\\.-\\.-\\.-)|(\\d+\\.\\d+\\.-\\.-)|(\\d+\\.\\d+\\.\\d+\\.-)|(\\d+\\.\\d+\\.\\d+\\.\\d+))$',
            'url': 'http://identifiers.org/brenda/'},
 'BYKdb': {'data_entry': 'https://bykdb.ibcp.fr/data/html/annotated/$id.html',
           'example': 'A0A010GJI9',
           'name': 'BYKdb',
           'pattern': '^[A-Z0-9]+$',
           'url': 'http://identifiers.org/bykdb/'},
 'BacMap Biography': {'data_entry': 'http://bacmap.wishartlab.com/organisms/$id',
                      'example': '1050',
                      'name': 'BacMap Biography',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/bacmap.biog/'},
 'BacMap Map': {'data_entry': 'http://bacmap.wishartlab.com/maps/$id/index.html',
                'example': 'AP011135',
                'name': 'BacMap Map',
                'pattern': '^\\w+(\\_)?\\d+(\\.\\d+)?$',
                'url': 'http://identifiers.org/bacmap.map/'},
 'BeetleBase': {'data_entry': 'http://beetlebase.org/cgi-bin/gbrowse/BeetleBase3.gff3/?name=$id',
                'example': 'TC010103',
                'name': 'BeetleBase',
                'pattern': '^TC\\d+$',
                'url': 'http://identifiers.org/beetlebase/'},
 'Bgee family': {'data_entry': 'http://bgee.unil.ch/bgee/bgee?page=gene_family&amp;action=family_details&amp;gene_family_id=$id',
                 'example': 'ENSFM00500000270089',
                 'name': 'Bgee family',
                 'pattern': '^(ENSFM|ENSGTV:)\\d+$',
                 'url': 'http://identifiers.org/bgee.family/'},
 'Bgee gene': {'data_entry': 'http://bgee.unil.ch/bgee/bgee?page=gene&amp;action=summary&amp;gene_id=$id',
               'example': 'ENSDARG00000013057',
               'name': 'Bgee gene',
               'pattern': '^(ENS|FBgn)\\w+$',
               'url': 'http://identifiers.org/bgee.gene/'},
 'Bgee organ': {'data_entry': 'http://bgee.unil.ch/bgee/bgee?page=anatomy&amp;action=organ_details&amp;organ_id=$id&amp;organ_children=on',
                'example': 'EHDAA:2185',
                'name': 'Bgee organ',
                'pattern': '^(XAO|ZFA|EHDAA|EMAPA|EV|MA)\\:\\d+$',
                'url': 'http://identifiers.org/bgee.organ/'},
 'Bgee stage': {'data_entry': 'http://bgee.unil.ch/bgee/bgee?page=anatomy&amp;action=organs&amp;stage_id=$id&amp;stage_children=on',
                'example': 'HsapDO:0000004',
                'name': 'Bgee stage',
                'pattern': '^(FBvd|XtroDO|HsapDO|MmusDO)\\:\\d+$',
                'url': 'http://identifiers.org/bgee.stage/'},
 'BiGG Compartment': {'data_entry': 'http://bigg.ucsd.edu/compartments/$id',
                      'example': 'c',
                      'name': 'BiGG Compartment',
                      'pattern': '^[a-z_A-Z]+$" restricted="true',
                      'url': 'http://identifiers.org/bigg.compartment/'},
 'BiGG Metabolite': {'data_entry': 'http://bigg.ucsd.edu/models/universal/metabolites/$id',
                     'example': '12dgr161',
                     'name': 'BiGG Metabolite',
                     'pattern': '^[a-z_A-Z0-9]+$" restricted="true',
                     'url': 'http://identifiers.org/bigg.metabolite/'},
 'BiGG Model': {'data_entry': 'http://bigg.ucsd.edu/models/$id',
                'example': 'iECABU_c1320',
                'name': 'BiGG Model',
                'pattern': '^[a-z_A-Z0-9]+$" restricted="true',
                'url': 'http://identifiers.org/bigg.model/'},
 'BiGG Reaction': {'data_entry': 'http://bigg.ucsd.edu/models/universal/reactions/$id',
                   'example': '13GS',
                   'name': 'BiGG Reaction',
                   'pattern': '^[a-z_A-Z]+$" restricted="true',
                   'url': 'http://identifiers.org/bigg.reaction/'},
 'BindingDB': {'data_entry': 'http://www.bindingdb.org/bind/chemsearch/marvin/MolStructure.jsp?monomerid=$id',
               'example': '22360',
               'name': 'BindingDB',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/bindingDB/'},
 'BioCarta Pathway': {'data_entry': 'http://cgap.nci.nih.gov/Pathways/BioCarta/$id',
                      'example': 'h_aktPathway',
                      'name': 'BioCarta Pathway',
                      'pattern': '^([hm]\\_)?\\w+Pathway$" restricted="true',
                      'url': 'http://identifiers.org/biocarta.pathway/'},
 'BioCatalogue': {'data_entry': 'https://www.biocatalogue.org/services/$id',
                  'example': '614',
                  'name': 'BioCatalogue',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/biocatalogue.service/'},
 'BioCyc': {'data_entry': 'http://biocyc.org/getid?id=$id',
            'example': 'ECOLI:CYT-D-UBIOX-CPLX',
            'name': 'BioCyc',
            'pattern': '^[A-Z-0-9]+(?&lt;!CHEBI)(\\:)?[A-Za-z0-9+_.%-]+$" restricted="true',
            'url': 'http://identifiers.org/biocyc/'},
 'BioGRID': {'data_entry': 'http://thebiogrid.org/$id',
             'example': '31623',
             'name': 'BioGRID',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/biogrid/'},
 'BioModels Database': {'data_entry': 'http://www.ebi.ac.uk/biomodels-main/$id',
                        'example': 'BIOMD0000000048',
                        'name': 'BioModels Database',
                        'pattern': '^((BIOMD|MODEL)\\d{10})|(BMID\\d{12})$',
                        'url': 'http://identifiers.org/biomodels.db/'},
 'BioNumbers': {'data_entry': 'http://www.bionumbers.hms.harvard.edu/bionumber.aspx?s=y&amp;id=$id&amp;ver=1',
                'example': '104674',
                'name': 'BioNumbers',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/bionumbers/'},
 'BioPortal': {'data_entry': 'http://bioportal.bioontology.org/ontologies/$id',
               'example': '1046',
               'name': 'BioPortal',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/bioportal/'},
 'BioProject': {'data_entry': 'http://trace.ddbj.nig.ac.jp/BPSearch/bioproject?acc=$id',
                'example': 'PRJDB3',
                'name': 'BioProject',
                'pattern': '^PRJ[DEN][A-Z]\\d+$',
                'url': 'http://identifiers.org/bioproject/'},
 'BioSample': {'data_entry': 'http://www.ebi.ac.uk/biosamples/browse.html?keywords=$id',
               'example': 'SAMEG70402',
               'name': 'BioSample',
               'pattern': '^SAM[NED](\\w)?\\d+$',
               'url': 'http://identifiers.org/biosample/'},
 'BioSharing': {'data_entry': 'https://www.biosharing.org/$id',
                'example': 'bsg-000052',
                'name': 'BioSharing',
                'pattern': '^bsg-\\d{6}$',
                'url': 'http://identifiers.org/biosharing/'},
 'BioSystems': {'data_entry': 'http://www.ncbi.nlm.nih.gov/biosystems/$id',
                'example': '001',
                'name': 'BioSystems',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/biosystems/'},
 'BitterDB Compound': {'data_entry': 'http://bitterdb.agri.huji.ac.il/bitterdb/compound.php?id=$id',
                       'example': '46',
                       'name': 'BitterDB Compound',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/bitterdb.cpd/'},
 'BitterDB Receptor': {'data_entry': 'http://bitterdb.agri.huji.ac.il/Receptor.php?id=$id',
                       'example': '1',
                       'name': 'BitterDB Receptor',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/bitterdb.rec/'},
 'Brenda Tissue Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                            'example': 'BTO:0000146',
                            'name': 'Brenda Tissue Ontology',
                            'pattern': '^BTO:\\d{7}$',
                            'url': 'http://identifiers.org/bto/'},
 'Broad Fungal Genome Initiative': {'data_entry': 'http://www.broadinstitute.org/annotation/genome/magnaporthe_grisea/GeneDetails.html?sp=$id',
                                    'example': 'S7000002168151102',
                                    'name': 'Broad Fungal Genome Initiative',
                                    'pattern': '^S\\d+$',
                                    'url': 'http://identifiers.org/broad/'},
 'BugBase Expt': {'data_entry': 'http://bugs.sgul.ac.uk/bugsbase/tabs/experiment.php?expt_id=$id&amp;action=view',
                  'example': '288',
                  'name': 'BugBase Expt',
                  'pattern': '^\\d+$" restricted="true',
                  'url': 'http://identifiers.org/bugbase.expt/'},
 'BugBase Protocol': {'data_entry': 'http://bugs.sgul.ac.uk/bugsbase/tabs/protocol.php?protocol_id=$id&amp;amp;action=view',
                      'example': '67',
                      'name': 'BugBase Protocol',
                      'pattern': '^\\d+$" restricted="true',
                      'url': 'http://identifiers.org/bugbase.protocol/'},
 'CABRI': {'data_entry': 'http://www.cabri.org/CABRI/srs-bin/wgetz?-e+-page+EntryPage+[$id]',
           'example': 'dsmz_mutz-id:ACC 291',
           'name': 'CABRI',
           'pattern': '^([A-Za-z]+)?(\\_)?([A-Za-z-]+)\\:([A-Za-z0-9 ]+)$',
           'url': 'http://identifiers.org/cabri/'},
 'CAPS-DB': {'data_entry': 'http://www.bioinsilico.org/cgi-bin/CAPSDB/getCAPScluster?nidcl=$id',
             'example': '434',
             'name': 'CAPS-DB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/caps/'},
 'CAS': {'data_entry': 'http://commonchemistry.org/ChemicalDetail.aspx?ref=$id',
         'example': '50-00-0',
         'name': 'CAS',
         'pattern': '^\\d{1,7}\\-\\d{2}\\-\\d$" restricted="true',
         'url': 'http://identifiers.org/cas/'},
 'CATH domain': {'data_entry': 'http://www.cathdb.info/domain/$id',
                 'example': '1cukA01',
                 'name': 'CATH domain',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/cath.domain/'},
 'CATH superfamily': {'data_entry': 'http://www.cathdb.info/cathnode/$id',
                      'example': '1.10.10.200',
                      'name': 'CATH superfamily',
                      'pattern': '^\\d+(\\.\\d+(\\.\\d+(\\.\\d+)?)?)?$',
                      'url': 'http://identifiers.org/cath.superfamily/'},
 'CAZy': {'data_entry': 'http://www.cazy.org/$id.html',
          'example': 'GT10',
          'name': 'CAZy',
          'pattern': '^(GT|GH|PL|CE|CBM)\\d+(\\_\\d+)?$',
          'url': 'http://identifiers.org/cazy/'},
 'CGSC Strain': {'data_entry': 'http://cgsc.biology.yale.edu/Strain.php?ID=$id',
                 'example': '11042',
                 'name': 'CGSC Strain',
                 'pattern': '^\\d+$',
                 'url': 'http://identifiers.org/cgsc/'},
 'CLDB': {'data_entry': 'http://bioinformatics.hsanmartino.it/hypercldb/$id.html',
          'example': 'cl3603',
          'name': 'CLDB',
          'pattern': '^(cl|tum)\\d+$',
          'url': 'http://identifiers.org/cldb/'},
 'CMR Gene': {'data_entry': 'http://cmr.jcvi.org/cgi-bin/CMR/shared/GenePage.cgi?locus=$id',
              'example': 'NTL15EF2281',
              'name': 'CMR Gene',
              'pattern': '^\\w+(\\_)?\\w+$" obsolete="true" replacement="MIR:00000202',
              'url': 'http://identifiers.org/cmr.gene/'},
 'COGs': {'data_entry': 'http://www.ncbi.nlm.nih.gov/COG/grace/wiew.cgi?$id',
          'example': 'COG0001',
          'name': 'COGs',
          'pattern': '^COG\\d+$" obsolete="true" replacement="MIR:00000119',
          'url': 'http://identifiers.org/cogs/'},
 'COGs Function': {'data_entry': 'http://www.ncbi.nlm.nih.gov/COG/grace/wiew.cgi?fun=$id',
                   'example': 'A',
                   'name': 'COGs Function',
                   'pattern': '^[A-Z]$" obsolete="true" replacement="MIR:00000119',
                   'url': 'http://identifiers.org/cogs.function/'},
 'COMBINE specifications': {'data_entry': 'http://co.mbine.org/specifications/$id',
                            'example': 'sbgn.er.level-1.version-1.2',
                            'name': 'COMBINE specifications',
                            'pattern': '^\\w+(\\-|\\.|\\w)*$',
                            'url': 'http://identifiers.org/combine.specifications/'},
 'CORUM': {'data_entry': 'http://mips.helmholtz-muenchen.de/genre/proj/corum/complexdetails.html?id=$id',
           'example': '100',
           'name': 'CORUM',
           'pattern': '^\\d+$" restricted="true',
           'url': 'http://identifiers.org/corum/'},
 'CSA': {'data_entry': 'http://www.ebi.ac.uk/thornton-srv/databases/CSA/SearchResults.php?PDBID=$id',
         'example': '1a05',
         'name': 'CSA',
         'pattern': '^[0-9][A-Za-z0-9]{3}$',
         'url': 'http://identifiers.org/csa/'},
 'CTD Chemical': {'data_entry': 'http://ctdbase.org/detail.go?type=chem&amp;acc=$id',
                  'example': 'D001151',
                  'name': 'CTD Chemical',
                  'pattern': '^D\\d+$',
                  'url': 'http://identifiers.org/ctd.chemical/'},
 'CTD Disease': {'data_entry': 'http://ctdbase.org/detail.go?type=disease&amp;db=MESH&amp;acc=$id',
                 'example': 'D053716',
                 'name': 'CTD Disease',
                 'pattern': '^D\\d+$',
                 'url': 'http://identifiers.org/ctd.disease/'},
 'CTD Gene': {'data_entry': 'http://ctdbase.org/detail.go?type=gene&amp;acc=$id',
              'example': '101',
              'name': 'CTD Gene',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/ctd.gene/'},
 'CYGD': {'data_entry': 'http://pedant.helmholtz-muenchen.de/pedant3htmlview/pedant3view?Db=p3_p13838_Sac_cerev&amp;Method=ReportGene&amp;GeneticelemCode=$id',
          'example': 'YFL039c',
          'name': 'CYGD',
          'pattern': '^\\w{2,3}\\d{2,4}(\\w)?$" restricted="true',
          'url': 'http://identifiers.org/cygd/'},
 'Canadian Drug Product Database': {'data_entry': 'http://webprod3.hc-sc.gc.ca/dpd-bdpp/info.do?lang=eng&amp;code=$id',
                                    'example': '63250',
                                    'name': 'Canadian Drug Product Database',
                                    'pattern': '^\\d+$" restricted="true',
                                    'url': 'http://identifiers.org/cdpd/'},
 'Candida Genome Database': {'data_entry': 'http://www.candidagenome.org/cgi-bin/locus.pl?dbid=$id',
                             'example': 'CAL0003079',
                             'name': 'Candida Genome Database',
                             'pattern': '^CAL\\d{7}$',
                             'url': 'http://identifiers.org/cgd/'},
 'Cell Cycle Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                         'example': 'CCO:P0000023',
                         'name': 'Cell Cycle Ontology',
                         'pattern': '^CCO\\:\\w+$',
                         'url': 'http://identifiers.org/cco/'},
 'Cell Image Library': {'data_entry': 'http://cellimagelibrary.org/images/$id',
                        'example': '24801',
                        'name': 'Cell Image Library',
                        'pattern': '^\\d+$" restricted="true',
                        'url': 'http://identifiers.org/cellimage/'},
 'Cell Signaling Technology Antibody': {'data_entry': 'http://www.cellsignal.com/products/$id.html',
                                        'example': '3305',
                                        'name': 'Cell Signaling Technology Antibody',
                                        'pattern': '^\\d+$',
                                        'url': 'http://identifiers.org/cst.ab/'},
 'Cell Signaling Technology Pathways': {'data_entry': 'http://www.cellsignal.com/reference/pathway/$id.html',
                                        'example': 'Akt_PKB',
                                        'name': 'Cell Signaling Technology Pathways',
                                        'pattern': '^[A-Za-z0-9_-]+$',
                                        'url': 'http://identifiers.org/cst/'},
 'Cell Type Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                        'example': 'CL:0000232',
                        'name': 'Cell Type Ontology',
                        'pattern': '^CL:\\d{7}$',
                        'url': 'http://identifiers.org/cl/'},
 'ChEBI': {'data_entry': 'http://www.ebi.ac.uk/chebi/searchId.do?chebiId=$id',
           'example': 'CHEBI:36927',
           'name': 'ChEBI',
           'pattern': '^CHEBI:\\d+$',
           'url': 'http://identifiers.org/chebi/'},
 'ChEMBL compound': {'data_entry': 'https://www.ebi.ac.uk/chembl/compound/inspect/$id',
                     'example': 'CHEMBL308052',
                     'name': 'ChEMBL compound',
                     'pattern': '^CHEMBL\\d+$',
                     'url': 'http://identifiers.org/chembl.compound/'},
 'ChEMBL target': {'data_entry': 'https://www.ebi.ac.uk/chembl/target/inspect/$id',
                   'example': 'CHEMBL3467',
                   'name': 'ChEMBL target',
                   'pattern': '^CHEMBL\\d+$',
                   'url': 'http://identifiers.org/chembl.target/'},
 'CharProt': {'data_entry': 'http://www.jcvi.org/charprotdb/index.cgi/view/$id',
              'example': 'CH_001923',
              'name': 'CharProt',
              'pattern': '^CH_\\d+$',
              'url': 'http://identifiers.org/charprot/'},
 'ChemBank': {'data_entry': 'http://chembank.broadinstitute.org/chemistry/viewMolecule.htm?cbid=$id',
              'example': '1000000',
              'name': 'ChemBank',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/chembank/'},
 'ChemDB': {'data_entry': 'http://cdb.ics.uci.edu/cgibin/ChemicalDetailWeb.py?chemical_id=$id',
            'example': '3966782',
            'name': 'ChemDB',
            'pattern': '^\\d+$" restricted="true',
            'url': 'http://identifiers.org/chemdb/'},
 'ChemIDplus': {'data_entry': 'http://chem.sis.nlm.nih.gov/chemidplus/direct.jsp?regno=$id',
                'example': '000057272',
                'name': 'ChemIDplus',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/chemidplus/'},
 'ChemSpider': {'data_entry': 'http://www.chemspider.com/Chemical-Structure.$id.html',
                'example': '56586',
                'name': 'ChemSpider',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/chemspider/'},
 'Chemical Component Dictionary': {'data_entry': 'http://www.ebi.ac.uk/pdbe-srv/pdbechem/chemicalCompound/show/$id',
                                   'example': 'AB0',
                                   'name': 'Chemical Component Dictionary',
                                   'pattern': '^\\w{3}$',
                                   'url': 'http://identifiers.org/pdb-ccd/'},
 'ClinVar Record': {'data_entry': 'http://www.ncbi.nlm.nih.gov/clinvar/$id/',
                    'example': 'RCV000033555.3',
                    'name': 'ClinVar Record',
                    'pattern': '^RCV\\d+(\\.\\d+)?$',
                    'url': 'http://identifiers.org/clinvar.record/'},
 'ClinicalTrials.gov': {'data_entry': 'http://clinicaltrials.gov/ct2/show/$id',
                        'example': 'NCT00222573',
                        'name': 'ClinicalTrials.gov',
                        'pattern': '^NCT\\d{8}$',
                        'url': 'http://identifiers.org/clinicaltrials/'},
 'CluSTr': {'data_entry': 'http://www.ebi.ac.uk/clustr-srv/CCluster?interpro=yes&amp;cluster_varid=$id',
            'example': 'HUMAN:55140:308.6',
            'name': 'CluSTr',
            'pattern': '^[0-9A-Za-z]+:\\d+:\\d{1,5}(\\.\\d)?$" obsolete="true" replacement="',
            'url': 'http://identifiers.org/clustr/'},
 'Compulyeast': {'data_entry': 'http://compluyeast2dpage.dacya.ucm.es/cgi-bin/2d/2d.cgi?ac=$id',
                 'example': 'O08709',
                 'name': 'Compulyeast',
                 'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
                 'url': 'http://identifiers.org/compulyeast/'},
 'Conoserver': {'data_entry': 'http://www.conoserver.org/?page=card&amp;table=protein&amp;id=$id',
                'example': '2639',
                'name': 'Conoserver',
                'pattern': '^\\d+$" restricted="true',
                'url': 'http://identifiers.org/conoserver/'},
 'Consensus CDS': {'data_entry': 'http://www.ncbi.nlm.nih.gov/CCDS/CcdsBrowse.cgi?REQUEST=CCDS&amp;DATA=$id',
                   'example': 'CCDS13573.1',
                   'name': 'Consensus CDS',
                   'pattern': '^CCDS\\d+\\.\\d+$',
                   'url': 'http://identifiers.org/ccds/'},
 'Conserved Domain Database': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Structure/cdd/cddsrv.cgi?uid=$id',
                               'example': 'cd00400',
                               'name': 'Conserved Domain Database',
                               'pattern': '^(cd)?\\d{5}$',
                               'url': 'http://identifiers.org/cdd/'},
 'Cooperative Patent Classification': {'data_entry': 'http://worldwide.espacenet.com/classification?locale=en_EP#!/CPC=$id',
                                       'example': 'A01M1/026',
                                       'name': 'Cooperative Patent Classification',
                                       'pattern': '^([A-H,Y]|[A-H, Y]\\d+{2}|[A-H, Y]\\d+{2}[A-Z]|[A-H, Y]\\d+{2}[A-Z]\\d+{1,3}|[A-H, Y]\\d+{2}[A-Z]\\d+{1,3}(\\/)?\\d+{2,})$',
                                       'url': 'http://identifiers.org/cpc/'},
 'Coriell Cell Repositories': {'data_entry': 'http://ccr.coriell.org/Sections/Search/Sample_Detail.aspx?Ref=$id',
                               'example': 'GM17027',
                               'name': 'Coriell Cell Repositories',
                               'pattern': '^[A-Z]{2}\\d+$',
                               'url': 'http://identifiers.org/coriell/'},
 'CryptoDB': {'data_entry': 'http://cryptodb.org/cryptodb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'cgd7_230',
              'name': 'CryptoDB',
              'pattern': '^\\w+',
              'url': 'http://identifiers.org/cryptodb/'},
 'Cube db': {'data_entry': 'http://epsf.bmad.bii.a-star.edu.sg/cube/db/data/$id/',
             'example': 'AKR',
             'name': 'Cube db',
             'pattern': '^[A-Za-z_0-9]+$" restricted="true',
             'url': 'http://identifiers.org/cubedb/'},
 'CutDB': {'data_entry': 'http://cutdb.burnham.org/relation/show/$id',
           'example': '25782',
           'name': 'CutDB',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pmap.cutdb/'},
 'DARC': {'data_entry': 'http://darcsite.genzentrum.lmu.de/darc/view.php?id=$id',
          'example': '1250',
          'name': 'DARC',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/darc/'},
 'DASHR': {'data_entry': 'http://lisanwanglab.org/DASHR/entry/$id',
           'example': 'hsa-mir-200a',
           'name': 'DASHR',
           'pattern': '^(hsa-(let|mir)-\\w+(-\\w+)?)|(piR-\\d+)|(chr\\w+.tRNA\\d+-\\w+)|(chr\\w+.tRNA\\d+-\\w+-tRF\\d)|((SNORD|SNORA|ACA|HBII|HBI|U)(-)?\\w+)|(HY\\d\\+(-L\\d+)?)|((LSU|SSU|5S)(-rRNA_Hsa)?(-L\\d+)?)$',
           'url': 'http://identifiers.org/dashr/'},
 'DASHR expression': {'data_entry': 'http://lisanwanglab.org/DASHR/entry/$id#exprPerTissueTable',
                      'example': 'hsa-mir-200a',
                      'name': 'DASHR expression',
                      'pattern': '^(hsa-(let|mir)-\\w+(-\\w+)?)|(piR-\\d+)|(chr\\w+.tRNA\\d+-\\w+)|(chr\\w+.tRNA\\d+-\\w+-tRF\\d)|((SNORD|SNORA|ACA|HBII|HBI|U)(-)?\\w+)|(HY\\d\\+(-L\\d+)?)|((LSU|SSU|5S)(-rRNA_Hsa)?(-L\\d+)?)$',
                      'url': 'http://identifiers.org/dashr.expression/'},
 'DATF': {'data_entry': 'http://datf.cbi.pku.edu.cn/entry-display.php?id=$id',
          'example': 'AT1G01030.1',
          'name': 'DATF',
          'pattern': '^AT[1-5]G\\d{5}(\\.\\d+)?$',
          'url': 'http://identifiers.org/datf/'},
 'DBD': {'data_entry': 'http://www.transcriptionfactor.org/index.cgi?Search/Domain+domain:$id+cat:DBD',
         'example': '0045310',
         'name': 'DBD',
         'pattern': '^\\d+$',
         'url': 'http://identifiers.org/dbd/'},
 'DBG2 Introns': {'data_entry': 'http://webapps2.ucalgary.ca/~groupii/cgi-bin/intron.cgi?name=$id',
                  'example': 'Cu.me.I1',
                  'name': 'DBG2 Introns',
                  'pattern': '^\\w{1,2}\\.(\\w{1,2}\\.)?[A-Za-z0-9]+$" restricted="true',
                  'url': 'http://identifiers.org/dbg2introns/'},
 'DEPOD': {'data_entry': 'http://www.koehnlab.de/depod/showp.php?gene=$id',
           'example': 'PTPN1',
           'name': 'DEPOD',
           'pattern': '^[A-Z0-9]+$',
           'url': 'http://identifiers.org/depod/'},
 'DOI': {'data_entry': 'http://dx.doi.org/$id',
         'example': '10.1038/nbt1156',
         'name': 'DOI',
         'pattern': '^(doi\\:)?\\d{2}\\.\\d{4}.*$',
         'url': 'http://identifiers.org/doi/'},
 'DOMMINO': {'data_entry': 'http://orion.rnet.missouri.edu/~nz953/DOMMINO/index.php/result/show_network/$id',
             'example': '2GC4',
             'name': 'DOMMINO',
             'pattern': '^[0-9][A-Za-z0-9]{3}$',
             'url': 'http://identifiers.org/dommino/'},
 'DOOR': {'data_entry': 'http://csbl1.bmb.uga.edu/OperonDB/genedetail.php?id=$id',
          'example': '60101',
          'name': 'DOOR',
          'pattern': '^\\d+$" restricted="true',
          'url': 'http://identifiers.org/door/'},
 'DPV': {'data_entry': 'http://www.dpvweb.net/dpv/showdpv.php?dpvno=$id',
         'example': '100',
         'name': 'DPV',
         'pattern': '^\\d+$" restricted="true',
         'url': 'http://identifiers.org/dpv/'},
 'DRSC': {'data_entry': 'http://www.flyrnai.org/cgi-bin/RNAi_gene_lookup_public.pl?gname=$id',
          'example': 'DRSC05221',
          'name': 'DRSC',
          'pattern': '^DRSC\\d+$',
          'url': 'http://identifiers.org/drsc/'},
 'DailyMed': {'data_entry': 'http://dailymed.nlm.nih.gov/dailymed/lookup.cfm?setid=$id',
              'example': '8889bcd7-d0e9-434b-b09d-30132bd033b0',
              'name': 'DailyMed',
              'pattern': '^[A-Za-z0-9-]+',
              'url': 'http://identifiers.org/dailymed/'},
 'Database of Interacting Proteins': {'data_entry': 'http://dip.doe-mbi.ucla.edu/dip/DIPview.cgi?ID=$id',
                                      'example': 'DIP-743N',
                                      'name': 'Database of Interacting Proteins',
                                      'pattern': '^DIP(\\:)?\\-\\d{1,}[ENXS]$',
                                      'url': 'http://identifiers.org/dip/'},
 'Database of Quantitative Cellular Signaling: Model': {'data_entry': 'http://doqcs.ncbs.res.in/template.php?&amp;y=accessiondetails&amp;an=$id',
                                                        'example': '57',
                                                        'name': 'Database of Quantitative Cellular Signaling: Model',
                                                        'pattern': '^\\d+$',
                                                        'url': 'http://identifiers.org/doqcs.model/'},
 'Database of Quantitative Cellular Signaling: Pathway': {'data_entry': 'http://doqcs.ncbs.res.in/template.php?&amp;y=pathwaydetails&amp;pn=$id',
                                                          'example': '131',
                                                          'name': 'Database of Quantitative Cellular Signaling: Pathway',
                                                          'pattern': '^\\d+$',
                                                          'url': 'http://identifiers.org/doqcs.pathway/'},
 'Degradome Database': {'data_entry': 'http://degradome.uniovi.es/cgi-bin/protease/$id',
                        'example': 'Ax1',
                        'name': 'Degradome Database',
                        'pattern': '^[AMCST][0-9x][0-9]$',
                        'url': 'http://identifiers.org/degradome/'},
 'Dictybase EST': {'data_entry': 'http://dictybase.org/db/cgi-bin/feature_page.pl?primary_id=$id',
                   'example': 'DDB0016567',
                   'name': 'Dictybase EST',
                   'pattern': '^DDB\\d+$',
                   'url': 'http://identifiers.org/dictybase.est/'},
 'Dictybase Gene': {'data_entry': 'http://dictybase.org/gene/$id',
                    'example': 'DDB_G0267522',
                    'name': 'Dictybase Gene',
                    'pattern': '^DDB_G\\d+$',
                    'url': 'http://identifiers.org/dictybase.gene/'},
 'DisProt': {'data_entry': 'http://www.disprot.org/protein.php?id=$id',
             'example': 'DP00001',
             'name': 'DisProt',
             'pattern': '^DP\\d{5}$',
             'url': 'http://identifiers.org/disprot/'},
 'DragonDB Allele': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id&amp;amp;class=Allele',
                     'example': 'cho',
                     'name': 'DragonDB Allele',
                     'pattern': '^\\w+$" restricted="true',
                     'url': 'http://identifiers.org/dragondb.allele/'},
 'DragonDB DNA': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id;class=DNA',
                  'example': '3hB06',
                  'name': 'DragonDB DNA',
                  'pattern': '^\\d\\w+$',
                  'url': 'http://identifiers.org/dragondb.dna/'},
 'DragonDB Locus': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id&amp;amp;class=Locus',
                    'example': 'DEF',
                    'name': 'DragonDB Locus',
                    'pattern': '^\\w+$',
                    'url': 'http://identifiers.org/dragondb.locus/'},
 'DragonDB Protein': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id;class=Peptide',
                      'example': 'AMDEFA',
                      'name': 'DragonDB Protein',
                      'pattern': '^\\w+$',
                      'url': 'http://identifiers.org/dragondb.protein/'},
 'DrugBank': {'data_entry': 'http://www.drugbank.ca/drugs/$id',
              'example': 'DB00001',
              'name': 'DrugBank',
              'pattern': '^DB\\d{5}$',
              'url': 'http://identifiers.org/drugbank/'},
 'DrugBank Target v3': {'data_entry': 'http://v3.drugbank.ca/molecules/$id?as=target',
                        'example': '54',
                        'name': 'DrugBank Target v3',
                        'pattern': '^\\d+$" obsolete="true" replacement="MIR:00000528',
                        'url': 'http://identifiers.org/drugbank.target/'},
 'DrugBank Target v4': {'data_entry': 'http://www.drugbank.ca/biodb/bio_entities/$id',
                        'example': 'BE0000048',
                        'name': 'DrugBank Target v4',
                        'pattern': '^BE\\d{7}$',
                        'url': 'http://identifiers.org/drugbankv4.target/'},
 'EBI Metagenomics Project': {'data_entry': 'https://www.ebi.ac.uk/metagenomics/projects/$id',
                              'example': 'ERP004492',
                              'name': 'EBI Metagenomics Project',
                              'pattern': '^[A-Z]+[0-9]+$',
                              'url': 'http://identifiers.org/ebimetagenomics.proj/'},
 'EBI Metagenomics Sample': {'data_entry': 'http://www.ebi.ac.uk/metagenomics/samples/$id',
                             'example': 'SRS086444',
                             'name': 'EBI Metagenomics Sample',
                             'pattern': '^[A-Z]+[0-9]+$',
                             'url': 'http://identifiers.org/ebimetagenomics.samp/'},
 'EDAM Ontology': {'data_entry': 'http://purl.bioontology.org/ontology/EDAM/$id',
                   'example': 'data_1664',
                   'name': 'EDAM Ontology',
                   'pattern': '^(data|topic|operation|format)\\_\\d{4}$',
                   'url': 'http://identifiers.org/edam/'},
 'ELM': {'data_entry': 'http://elm.eu.org/elms/elmPages/$id.html',
         'example': 'CLV_MEL_PAP_1',
         'name': 'ELM',
         'pattern': '^[A-Za-z_0-9]+$',
         'url': 'http://identifiers.org/elm/'},
 'ENA': {'data_entry': 'http://www.ebi.ac.uk/ena/data/view/$id',
         'example': 'BN000065',
         'name': 'ENA',
         'pattern': '^[A-Z]+[0-9]+\\.\\d+$',
         'url': 'http://identifiers.org/ena.embl/'},
 'EPD': {'data_entry': 'http://epd.vital-it.ch/cgi-bin/query_result.pl?out_format=NICE&amp;Entry_0=$id',
         'example': 'TA_H3',
         'name': 'EPD',
         'pattern': '^[A-Z-_0-9]+$',
         'url': 'http://identifiers.org/epd/'},
 'EU Clinical Trials': {'data_entry': 'https://www.clinicaltrialsregister.eu/ctr-search/search?query=$id',
                        'example': '2008-005144-16',
                        'name': 'EU Clinical Trials',
                        'pattern': '^\\d{4}\\-\\d{6}\\-\\d{2}$',
                        'url': 'http://identifiers.org/euclinicaltrials/'},
 'EchoBASE': {'data_entry': 'http://www.york.ac.uk/res/thomas/Gene.cfm?recordID=$id',
              'example': 'EB0170',
              'name': 'EchoBASE',
              'pattern': '^EB\\d+$',
              'url': 'http://identifiers.org/echobase/'},
 'EcoGene': {'data_entry': 'http://www.ecogene.org/gene/$id',
             'example': 'EG10173',
             'name': 'EcoGene',
             'pattern': '^EG\\d+$',
             'url': 'http://identifiers.org/ecogene/'},
 'EcoliWiki': {'data_entry': 'http://ecoliwiki.net/colipedia/index.php/$id:Gene',
               'example': 'aaeA',
               'name': 'EcoliWiki',
               'pattern': '^[A-Za-z0-9-]+$',
               'url': 'http://identifiers.org/ecoliwiki/'},
 'Electron Microscopy Data Bank': {'data_entry': 'http://www.ebi.ac.uk/pdbe/entry/emdb/$id',
                                   'example': 'EMD-1001',
                                   'name': 'Electron Microscopy Data Bank',
                                   'pattern': '^EMD-\\d{4}$',
                                   'url': 'http://identifiers.org/emdb/'},
 'Ensembl': {'data_entry': 'http://www.ensembl.org/id/$id',
             'example': 'ENSG00000139618',
             'name': 'Ensembl',
             'pattern': '^((ENS[A-Z]*[FPTG]\\d{11}(\\.\\d+)?)|(FB\\w{2}\\d{7})|(Y[A-Z]{2}\\d{3}[a-zA-Z](\\-[A-Z])?)|([A-Z_a-z0-9]+(\\.)?(t)?(\\d+)?([a-z])?))$" restricted="true',
             'url': 'http://identifiers.org/ensembl/'},
 'Ensembl Bacteria': {'data_entry': 'http://bacteria.ensembl.org/id/$id',
                      'example': 'MU9_3181',
                      'name': 'Ensembl Bacteria',
                      'pattern': '^((EB\\w+)|([A-Z0-9]+\\_[A-Z0-9]+))$',
                      'url': 'http://identifiers.org/ensembl.bacteria/'},
 'Ensembl Fungi': {'data_entry': 'http://fungi.ensembl.org/id/$id',
                   'example': 'CADAFLAT00006211',
                   'name': 'Ensembl Fungi',
                   'pattern': '^[A-Z-a-z0-9]+$',
                   'url': 'http://identifiers.org/ensembl.fungi/'},
 'Ensembl Metazoa': {'data_entry': 'http://metazoa.ensembl.org/id/$id',
                     'example': 'FBtr0084214',
                     'name': 'Ensembl Metazoa',
                     'pattern': '^\\w+(\\.)?\\d+$',
                     'url': 'http://identifiers.org/ensembl.metazoa/'},
 'Ensembl Plants': {'data_entry': 'http://plants.ensembl.org/id/$id',
                    'example': 'AT1G73965',
                    'name': 'Ensembl Plants',
                    'pattern': '^\\w+(\\.\\d+)?(\\.\\d+)?$',
                    'url': 'http://identifiers.org/ensembl.plant/'},
 'Ensembl Protists': {'data_entry': 'http://protists.ensembl.org/id/$id',
                      'example': 'PFC0120w',
                      'name': 'Ensembl Protists',
                      'pattern': '^\\w+$',
                      'url': 'http://identifiers.org/ensembl.protist/'},
 'Enzyme Nomenclature': {'data_entry': 'http://www.ebi.ac.uk/intenz/query?cmd=SearchEC&amp;ec=$id',
                         'example': '1.1.1.1',
                         'name': 'Enzyme Nomenclature',
                         'pattern': '^\\d+\\.-\\.-\\.-|\\d+\\.\\d+\\.-\\.-|\\d+\\.\\d+\\.\\d+\\.-|\\d+\\.\\d+\\.\\d+\\.(n)?\\d+$',
                         'url': 'http://identifiers.org/ec-code/'},
 'European Genome-phenome Archive Dataset': {'data_entry': 'https://www.ebi.ac.uk/ega/datasets/$id',
                                             'example': 'EGAD00000000001',
                                             'name': 'European Genome-phenome Archive Dataset',
                                             'pattern': '^EGAD\\d{11}$',
                                             'url': 'http://identifiers.org/ega.dataset/'},
 'European Genome-phenome Archive Study': {'data_entry': 'https://www.ebi.ac.uk/ega/studies/$id',
                                           'example': 'EGAS00000000001',
                                           'name': 'European Genome-phenome Archive Study',
                                           'pattern': '^EGAS\\d{11}$',
                                           'url': 'http://identifiers.org/ega.study/'},
 'Evidence Code Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                            'example': 'ECO:0000006',
                            'name': 'Evidence Code Ontology',
                            'pattern': 'ECO:\\d{7}$',
                            'url': 'http://identifiers.org/eco/'},
 'ExAC Gene': {'data_entry': 'http://exac.broadinstitute.org/gene/$id',
               'example': 'ENSG00000169174',
               'name': 'ExAC Gene',
               'pattern': '^ENSG\\d{11}$',
               'url': 'http://identifiers.org/exac.gene/'},
 'ExAC Transcript': {'data_entry': 'http://exac.broadinstitute.org/transcript/$id',
                     'example': 'ENST00000407236',
                     'name': 'ExAC Transcript',
                     'pattern': '^ENST\\d{11}$',
                     'url': 'http://identifiers.org/exac.transcript/'},
 'ExAC Variant': {'data_entry': 'http://exac.broadinstitute.org/variant/$id',
                  'example': '22-46615880-T-C',
                  'name': 'ExAC Variant',
                  'pattern': '^\\d{1,2}\\-\\d+\\-[GATC]\\-[GATC]$',
                  'url': 'http://identifiers.org/exac.variant/'},
 'Experimental Factor Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=EFO:$id',
                                  'example': '0004859',
                                  'name': 'Experimental Factor Ontology',
                                  'pattern': '^\\d{7}$',
                                  'url': 'http://identifiers.org/efo/'},
 'F-SNP': {'data_entry': 'http://compbio.cs.queensu.ca/cgi-bin/compbio/search/main.cgi?search_mode=id&amp;amp;id_type=snp_id&amp;amp;id_val=$id',
           'example': 'rs17852708',
           'name': 'F-SNP',
           'pattern': '^rs\\d+$',
           'url': 'http://identifiers.org/fsnp/'},
 'FMA': {'data_entry': 'http://www.ebi.ac.uk/ols/beta/ontologies/fma/terms?obo_id=$id',
         'example': 'FMA:67112',
         'name': 'FMA',
         'pattern': '^FMA:\\d+$',
         'url': 'http://identifiers.org/fma/'},
 'FlyBase': {'data_entry': 'http://flybase.org/reports/$id.html',
             'example': 'FBgn0011293',
             'name': 'FlyBase',
             'pattern': '^FB\\w{2}\\d{7}$',
             'url': 'http://identifiers.org/flybase/'},
 'Flystock': {'data_entry': 'http://flystocks.bio.indiana.edu/Reports/$id.html',
              'example': '33159',
              'name': 'Flystock',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/flystock/'},
 'FooDB Compound': {'data_entry': 'http://foodb.ca/compounds/$id',
                    'example': 'FDB002100',
                    'name': 'FooDB Compound',
                    'pattern': '^FDB\\d+$',
                    'url': 'http://identifiers.org/foodb.compound/'},
 'FunCat': {'data_entry': 'http://mips.helmholtz-muenchen.de/funcatDB/cgi-bin/search_advanced.pl?action=2&amp;wert=$id',
            'example': '32.01.01',
            'name': 'FunCat',
            'pattern': '^\\d{2}|\\d{2}\\.\\d{2}|\\d{2}\\.\\d{2}\\.\\d{2}|\\d{2}\\.\\d{2}\\.\\d{2}\\d{2}$',
            'url': 'http://identifiers.org/funcat/'},
 'FuncBase Fly': {'data_entry': 'http://func.mshri.on.ca/fly/genes/list_functional_scores/$id',
                  'example': '10194',
                  'name': 'FuncBase Fly',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/funcbase.fly/'},
 'FuncBase Human': {'data_entry': 'http://func.mshri.on.ca/human/genes/list_functional_scores/$id',
                    'example': '119514',
                    'name': 'FuncBase Human',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/funcbase.human/'},
 'FuncBase Mouse': {'data_entry': 'http://func.mshri.on.ca/mouse/genes/list_functional_scores/$id',
                    'example': '1351341',
                    'name': 'FuncBase Mouse',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/funcbase.mouse/'},
 'FuncBase Yeast': {'data_entry': 'http://func.mshri.on.ca/yeast/genes/list_functional_scores/$id',
                    'example': '2701',
                    'name': 'FuncBase Yeast',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/funcbase.yeast/'},
 'Fungal Barcode': {'data_entry': 'http://www.fungalbarcoding.org/BioloMICS.aspx?Table=Fungal barcodes&amp;Rec=$id&amp;Fields=All&amp;ExactMatch=T',
                    'example': '2224',
                    'name': 'Fungal Barcode',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/fbol/'},
 'FungiDB': {'data_entry': 'http://fungidb.org/gene/$id',
             'example': 'CNBG_0001',
             'name': 'FungiDB',
             'pattern': '^[A-Za-z_0-9]+$" restricted="true',
             'url': 'http://identifiers.org/fungidb/'},
 'GABI': {'data_entry': 'http://www.gabipd.org/database/cgi-bin/GreenCards.pl.cgi?BioObjectId=$id&amp;Mode=ShowBioObject',
          'example': '2679240',
          'name': 'GABI',
          'pattern': '^\\w+$',
          'url': 'http://identifiers.org/gabi/'},
 'GEO': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sites/GDSbrowser?acc=$id',
         'example': 'GDS1234',
         'name': 'GEO',
         'pattern': '^GDS\\d+$',
         'url': 'http://identifiers.org/geo/'},
 'GLIDA GPCR': {'data_entry': 'http://pharminfo.pharm.kyoto-u.ac.jp/services/glida/gpcr_information.php?id=$id',
                'example': 'ACM1_HUMAN',
                'name': 'GLIDA GPCR',
                'pattern': '^[A-Z-_0-9]+$',
                'url': 'http://identifiers.org/glida.gpcr/'},
 'GLIDA Ligand': {'data_entry': 'http://pharminfo.pharm.kyoto-u.ac.jp/services/glida/ligand_information.php?id=$id',
                  'example': 'L000001',
                  'name': 'GLIDA Ligand',
                  'pattern': '^L\\d+$',
                  'url': 'http://identifiers.org/glida.ligand/'},
 'GOA': {'data_entry': 'http://www.ebi.ac.uk/QuickGO/GProtein?ac=$id',
         'example': 'P12345',
         'name': 'GOA',
         'pattern': '^(([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9]))|(URS[0-9A-F]{10}(_[0-9]+){0,1})|(EBI-[0-9]+)$',
         'url': 'http://identifiers.org/goa/'},
 'GOLD genome': {'data_entry': 'http://www.genomesonline.org/cgi-bin/GOLD/GOLDCards.cgi?goldstamp=$id',
                 'example': 'Gi07796',
                 'name': 'GOLD genome',
                 'pattern': '^[Gi|Gc]\\d+$',
                 'url': 'http://identifiers.org/gold.genome/'},
 'GOLD metadata': {'data_entry': 'http://genomesonline.org/cgi-bin/GOLD/bin/GOLDCards.cgi?goldstamp=$id',
                   'example': 'Gm00047',
                   'name': 'GOLD metadata',
                   'pattern': '^Gm\\d+$',
                   'url': 'http://identifiers.org/gold.meta/'},
 'GPCRDB': {'data_entry': 'http://www.gpcr.org/7tm/proteins/$id',
            'example': 'RL3R1_HUMAN',
            'name': 'GPCRDB',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/gpcrdb/'},
 'GRIN Plant Taxonomy': {'data_entry': 'http://www.ars-grin.gov/cgi-bin/npgs/html/taxon.pl?$id',
                         'example': '19333',
                         'name': 'GRIN Plant Taxonomy',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/grin.taxonomy/'},
 'GRSDB': {'data_entry': 'http://bioinformatics.ramapo.edu/GRSDB2/geneview.php?geneID=$id',
           'example': '10142',
           'name': 'GRSDB',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/grsdb/'},
 'GWAS Central Marker': {'data_entry': 'http://www.gwascentral.org/marker/$id',
                         'example': 'HGVM15354',
                         'name': 'GWAS Central Marker',
                         'pattern': '^HGVM\\d+$',
                         'url': 'http://identifiers.org/gwascentral.marker/'},
 'GWAS Central Phenotype': {'data_entry': 'http://www.gwascentral.org/phenotype/$id',
                            'example': 'HGVPM623',
                            'name': 'GWAS Central Phenotype',
                            'pattern': '^HGVP\\d+$',
                            'url': 'http://identifiers.org/gwascentral.phenotype/'},
 'GWAS Central Study': {'data_entry': 'http://www.gwascentral.org/study/$id',
                        'example': 'HGVST1828',
                        'name': 'GWAS Central Study',
                        'pattern': '^HGVST\\d+$',
                        'url': 'http://identifiers.org/gwascentral.study/'},
 'GXA Expt': {'data_entry': 'http://www.ebi.ac.uk/gxa/experiments/$id',
              'example': 'E-MTAB-2037',
              'name': 'GXA Expt',
              'pattern': '^[AEP]-\\w{4}-\\d+$" restricted="true',
              'url': 'http://identifiers.org/gxa.expt/'},
 'GXA Gene': {'data_entry': 'http://www.ebi.ac.uk/gxa/genes/$id',
              'example': 'AT4G01080',
              'name': 'GXA Gene',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/gxa.gene/'},
 'GenPept': {'data_entry': 'http://www.ncbi.nlm.nih.gov/protein/$id?report=genpept',
             'example': 'CAA71118.1',
             'name': 'GenPept',
             'pattern': '^\\w{3}\\d{5}(\\.\\d+)?$" restricted="true',
             'url': 'http://identifiers.org/genpept/'},
 'Genatlas': {'data_entry': 'http://genatlas.medecine.univ-paris5.fr/fiche.php?symbol=$id',
              'example': 'HBB',
              'name': 'Genatlas',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/genatlas/'},
 'Gene Ontology': {'data_entry': 'http://www.ebi.ac.uk/QuickGO/GTerm?id=$id',
                   'example': 'GO:0006915',
                   'name': 'Gene Ontology',
                   'pattern': '^GO:\\d{7}$',
                   'url': 'http://identifiers.org/go/'},
 'Gene Ontology Reference': {'data_entry': 'http://www.geneontology.org/cgi-bin/references.cgi#$id',
                             'example': 'GO_REF:0000041',
                             'name': 'Gene Ontology Reference',
                             'pattern': '^GO_REF:\\d{7}$',
                             'url': 'http://identifiers.org/go.ref/'},
 'Gene Wiki': {'data_entry': 'http://plugins.biogps.org/cgi-bin/wp.cgi?id=$id',
               'example': '1017',
               'name': 'Gene Wiki',
               'pattern': '^\\d+$" restricted="true',
               'url': 'http://identifiers.org/genewiki/'},
 'GeneCards': {'data_entry': 'http://www.genecards.org/cgi-bin/carddisp.pl?gene=$id',
               'example': 'ABL1',
               'name': 'GeneCards',
               'pattern': '^\\w+$" restricted="true',
               'url': 'http://identifiers.org/genecards/'},
 'GeneDB': {'data_entry': 'http://www.genedb.org/gene/$id',
            'example': 'Cj1536c',
            'name': 'GeneDB',
            'pattern': '^[\\w\\d\\.-]*$',
            'url': 'http://identifiers.org/genedb/'},
 'GeneFarm': {'data_entry': 'https://urgi.versailles.inra.fr/Genefarm/Gene/display_gene.htpl?GENE_ID=$id',
              'example': '4892',
              'name': 'GeneFarm',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/genefarm/'},
 'GeneTree': {'data_entry': 'http://www.ensembl.org/Multi/GeneTree/Image?db=core;gt=$id',
              'example': 'ENSGT00550000074763',
              'name': 'GeneTree',
              'pattern': '^ENSGT\\d+$',
              'url': 'http://identifiers.org/genetree/'},
 'Genome Properties': {'data_entry': 'http://cmr.jcvi.org/tigr-scripts/CMR/shared/GenomePropDefinition.cgi?prop_acc=$id',
                       'example': 'GenProp0151',
                       'name': 'Genome Properties',
                       'pattern': '^GenProp\\d+$" obsolete="true" replacement="MIR:00000202',
                       'url': 'http://identifiers.org/genprop/'},
 'GiardiaDB': {'data_entry': 'http://giardiadb.org/giardiadb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
               'example': 'GL50803_102438',
               'name': 'GiardiaDB',
               'pattern': '^\\w+$',
               'url': 'http://identifiers.org/giardiadb/'},
 'GlycoEpitope': {'data_entry': 'http://www.glycoepitope.jp/epitopes/$id',
                  'example': 'EP0311',
                  'name': 'GlycoEpitope',
                  'pattern': '^EP\\d{4}$',
                  'url': 'http://identifiers.org/glycoepitope/'},
 'GlycomeDB': {'data_entry': 'http://www.glycome-db.org/database/showStructure.action?glycomeId=$id',
               'example': '1',
               'name': 'GlycomeDB',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/glycomedb/'},
 'Golm Metabolome Database': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/Metabolites/$id.aspx',
                              'example': '68513255-fc44-4041-bc4b-4fd2fae7541d',
                              'name': 'Golm Metabolome Database',
                              'pattern': '^([0-9a-fA-F]){8}(-([0-9a-fA-F]){4}){3}-([0-9a-fA-F]){12}$" restricted="true',
                              'url': 'http://identifiers.org/gmd/'},
 'Golm Metabolome Database Analyte': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/Analytes/$id',
                                      'example': '4f0fa9b6-514f-4ff4-98cc-0009bc08eb80',
                                      'name': 'Golm Metabolome Database Analyte',
                                      'pattern': '^([0-9a-fA-F]){8}(-([0-9a-fA-F]){4}){3}-([0-9a-fA-F]){12}$" restricted="true',
                                      'url': 'http://identifiers.org/gmd.analyte/'},
 'Golm Metabolome Database GC-MS spectra': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/Spectrums/$id',
                                            'example': '53d583d8-40c6-40e1-9296-23f821cd77a5',
                                            'name': 'Golm Metabolome Database GC-MS spectra',
                                            'pattern': '^([0-9a-fA-F]){8}(-([0-9a-fA-F]){4}){3}-([0-9a-fA-F]){12}$" restricted="true',
                                            'url': 'http://identifiers.org/gmd.gcms/'},
 'Golm Metabolome Database Profile': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/profile/default.aspx?XemlId=$id',
                                      'example': '10b38aaf-b977-4950-85b8-f4775f66658d',
                                      'name': 'Golm Metabolome Database Profile',
                                      'pattern': '^([0-9a-fA-F]){8}(-([0-9a-fA-F]){4}){3}-([0-9a-fA-F]){12}$" restricted="true',
                                      'url': 'http://identifiers.org/gmd.profile/'},
 'Golm Metabolome Database Reference Substance': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/ReferenceSubstances/$id',
                                                  'example': '8cf84adb-b4db-4807-ac98-0004247c35df',
                                                  'name': 'Golm Metabolome Database Reference Substance',
                                                  'pattern': '^([0-9a-fA-F]){8}(-([0-9a-fA-F]){4}){3}-([0-9a-fA-F]){12}$" restricted="true',
                                                  'url': 'http://identifiers.org/gmd.ref/'},
 'Google Patents': {'data_entry': 'https://www.google.com/patents/$id',
                    'example': 'US4145692',
                    'name': 'Google Patents',
                    'pattern': '^[A-Z]{2}\\d+([A-Z])?$',
                    'url': 'http://identifiers.org/google.patent/'},
 'Gramene Growth Stage Ontology': {'data_entry': 'http://www.gramene.org/db/ontology/search?id=$id',
                                   'example': 'GRO:0007133',
                                   'name': 'Gramene Growth Stage Ontology',
                                   'pattern': '^GRO\\:\\d+$',
                                   'url': 'http://identifiers.org/gramene.growthstage/'},
 'Gramene QTL': {'data_entry': 'http://www.gramene.org/db/qtl/qtl_display?qtl_accession_id=$id',
                 'example': 'CQG5',
                 'name': 'Gramene QTL',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/gramene.qtl/'},
 'Gramene Taxonomy': {'data_entry': 'http://www.gramene.org/db/ontology/search?id=$id',
                      'example': 'GR_tax:013681',
                      'name': 'Gramene Taxonomy',
                      'pattern': '^GR\\_tax\\:\\d+$',
                      'url': 'http://identifiers.org/gramene.taxonomy/'},
 'Gramene genes': {'data_entry': 'http://www.gramene.org/db/genes/search_gene?acc=$id',
                   'example': 'GR:0080039',
                   'name': 'Gramene genes',
                   'pattern': '^GR\\:\\d+$',
                   'url': 'http://identifiers.org/gramene.gene/'},
 'Gramene protein': {'data_entry': 'http://www.gramene.org/db/protein/protein_search?protein_id=$id',
                     'example': '78073',
                     'name': 'Gramene protein',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/gramene.protein/'},
 'GreenGenes': {'data_entry': 'http://greengenes.lbl.gov/cgi-bin/show_one_record_v2.pl?prokMSA_id=$id',
                'example': '100000',
                'name': 'GreenGenes',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/greengenes/'},
 'H-InvDb Locus': {'data_entry': 'http://h-invitational.jp/hinv/spsoup/locus_view?hix_id=$id',
                   'example': 'HIX0004394',
                   'name': 'H-InvDb Locus',
                   'pattern': '^HIX\\d{7}(\\.\\d+)?$',
                   'url': 'http://identifiers.org/hinv.locus/'},
 'H-InvDb Protein': {'data_entry': 'http://h-invitational.jp/hinv/protein/protein_view.cgi?hip_id=$id',
                     'example': 'HIP000030660',
                     'name': 'H-InvDb Protein',
                     'pattern': '^HIP\\d{9}(\\.\\d+)?$',
                     'url': 'http://identifiers.org/hinv.protein/'},
 'H-InvDb Transcript': {'data_entry': 'http://h-invitational.jp/hinv/spsoup/transcript_view?hit_id=$id',
                        'example': 'HIT000195363',
                        'name': 'H-InvDb Transcript',
                        'pattern': '^HIT\\d{9}(\\.\\d+)?$',
                        'url': 'http://identifiers.org/hinv.transcript/'},
 'HAMAP': {'data_entry': 'http://hamap.expasy.org/unirule/$id',
           'example': 'MF_01400',
           'name': 'HAMAP',
           'pattern': '^MF_\\d+$',
           'url': 'http://identifiers.org/hamap/'},
 'HCVDB': {'data_entry': 'https://euhcvdb.ibcp.fr/euHCVdb/do/displayHCVEntry?primaryAC=$id',
           'example': 'M58335',
           'name': 'HCVDB',
           'pattern': '^M\\d{5}$',
           'url': 'http://identifiers.org/hcvdb/'},
 'HGMD': {'data_entry': 'http://www.hgmd.cf.ac.uk/ac/gene.php?gene=$id',
          'example': 'CALM1',
          'name': 'HGMD',
          'pattern': '^[A-Z_0-9]+$" restricted="true',
          'url': 'http://identifiers.org/hgmd/'},
 'HGNC': {'data_entry': 'http://www.genenames.org/cgi-bin/gene_symbol_report?hgnc_id=$id',
          'example': '2674',
          'name': 'HGNC',
          'pattern': '^((HGNC|hgnc):)?\\d{1,5}$',
          'url': 'http://identifiers.org/hgnc/'},
 'HGNC Family': {'data_entry': 'http://www.genenames.org/genefamilies/$id',
                 'example': 'PADI',
                 'name': 'HGNC Family',
                 'pattern': '^[A-Z0-9-]+(#[A-Z0-9-]+)?$',
                 'url': 'http://identifiers.org/hgnc.family/'},
 'HGNC Symbol': {'data_entry': 'http://www.genenames.org/cgi-bin/gene_symbol_report?match=$id',
                 'example': 'DAPK1',
                 'name': 'HGNC Symbol',
                 'pattern': '^[A-Za-z-0-9_]+(\\@)?$" restricted="true',
                 'url': 'http://identifiers.org/hgnc.symbol/'},
 'HMDB': {'data_entry': 'http://www.hmdb.ca/metabolites/$id',
          'example': 'HMDB00001',
          'name': 'HMDB',
          'pattern': '^HMDB\\d{5}$',
          'url': 'http://identifiers.org/hmdb/'},
 'HOGENOM': {'data_entry': 'http://pbil.univ-lyon1.fr/cgi-bin/view-tree.pl?db=HOGENOM5&amp;query=$id',
             'example': 'HBG284870',
             'name': 'HOGENOM',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/hogenom/'},
 'HOMD Sequence Metainformation': {'data_entry': 'http://www.homd.org/modules.php?op=modload&amp;name=GenomeList&amp;file=index&amp;link=detailinfo&amp;seqid=$id',
                                   'example': 'SEQF1003',
                                   'name': 'HOMD Sequence Metainformation',
                                   'pattern': '^SEQF\\d+$',
                                   'url': 'http://identifiers.org/homd.seq/'},
 'HOMD Taxonomy': {'data_entry': 'http://www.homd.org/modules.php?op=modload&amp;name=HOMD&amp;file=index&amp;oraltaxonid=$id&amp;view=dynamic',
                   'example': '811',
                   'name': 'HOMD Taxonomy',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/homd.taxon/'},
 'HOVERGEN': {'data_entry': 'http://pbil.univ-lyon1.fr/cgi-bin/view-tree.pl?query=$id&amp;db=HOVERGEN',
              'example': 'HBG004341',
              'name': 'HOVERGEN',
              'pattern': '^HBG\\d+$',
              'url': 'http://identifiers.org/hovergen/'},
 'HPA': {'data_entry': 'http://www.proteinatlas.org/$id',
         'example': 'ENSG00000026508',
         'name': 'HPA',
         'pattern': '^ENSG\\d{11}$" restricted="true',
         'url': 'http://identifiers.org/hpa/'},
 'HPRD': {'data_entry': 'http://www.hprd.org/protein/$id',
          'example': '00001',
          'name': 'HPRD',
          'pattern': '^\\d+$" restricted="true',
          'url': 'http://identifiers.org/hprd/'},
 'HSSP': {'data_entry': 'ftp://ftp.embl-heidelberg.de/pub/databases/protein_extras/hssp/$id.hssp.bz2',
          'example': '102l',
          'name': 'HSSP',
          'pattern': '^\\w{4}$',
          'url': 'http://identifiers.org/hssp/'},
 'HUGE': {'data_entry': 'http://www.kazusa.or.jp/huge/gfpage/$id/',
          'example': 'KIAA0001',
          'name': 'HUGE',
          'pattern': '^KIAA\\d{4}$" restricted="true',
          'url': 'http://identifiers.org/huge/'},
 'Homeodomain Research': {'data_entry': 'http://research.nhgri.nih.gov/apps/homeodomain/web/index.cgi?mode=view&amp;amp;view=proteins&amp;amp;id=$id',
                          'example': '63',
                          'name': 'Homeodomain Research',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/hdr/'},
 'HomoloGene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/homologene/$id',
                'example': '1000',
                'name': 'HomoloGene',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/homologene/'},
 'Human Disease Ontology': {'data_entry': 'http://purl.bioontology.org/ontology/DOID/$id',
                            'example': 'DOID:11337',
                            'name': 'Human Disease Ontology',
                            'pattern': '^DOID\\:\\d+$',
                            'url': 'http://identifiers.org/doid/'},
 'Human Phenotype Ontology': {'data_entry': 'http://compbio.charite.de/hpoweb/showterm?id=$id',
                              'example': 'HP:0000118',
                              'name': 'Human Phenotype Ontology',
                              'pattern': '^HP:\\d{7}$',
                              'url': 'http://identifiers.org/hpo/'},
 'Human Proteome Map Peptide': {'data_entry': 'http://www.humanproteomemap.org/spectrum.php?pep_id=$id',
                                'example': '9606117',
                                'name': 'Human Proteome Map Peptide',
                                'pattern': '^\\d+$',
                                'url': 'http://identifiers.org/hpm.peptide/'},
 'Human Proteome Map Protein': {'data_entry': 'http://www.humanproteomemap.org/protein.php?hpm_id=$id',
                                'example': '1968',
                                'name': 'Human Proteome Map Protein',
                                'pattern': '^\\d+$',
                                'url': 'http://identifiers.org/hpm.protein/'},
 'ICD': {'data_entry': 'http://apps.who.int/classifications/icd10/browse/2010/en#/$id',
         'example': 'C34',
         'name': 'ICD',
         'pattern': '^[A-Z]\\d+(\\.[-\\d+])?$',
         'url': 'http://identifiers.org/icd/'},
 'ICEberg element': {'data_entry': 'http://db-mml.sjtu.edu.cn/ICEberg/feature_page.php?ice_id=$id',
                     'example': '100',
                     'name': 'ICEberg element',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/iceberg.element/'},
 'ICEberg family': {'data_entry': 'http://db-mml.sjtu.edu.cn/ICEberg/browse_result.php?type=fam&amp;fam_id=$id',
                    'example': '1',
                    'name': 'ICEberg family',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/iceberg.family/'},
 'IDEAL': {'data_entry': 'http://idp1.force.cs.is.nagoya-u.ac.jp/IDEAL/idealItem.php?id=$id',
           'example': 'IID00001',
           'name': 'IDEAL',
           'pattern': '^IID\\d+$',
           'url': 'http://identifiers.org/ideal/'},
 'IMEx': {'data_entry': 'http://www.ebi.ac.uk/intact/imex/main.xhtml?query=$id',
          'example': 'IM-19210-3',
          'name': 'IMEx',
          'pattern': '^IM-\\d+(-?)(\\d+?)$',
          'url': 'http://identifiers.org/imex/'},
 'IMGT HLA': {'data_entry': 'http://www.ebi.ac.uk/cgi-bin/imgt/hla/get_allele.cgi?$id',
              'example': 'A*01:01:01:01',
              'name': 'IMGT HLA',
              'pattern': '^[A-Z0-9*:]+$',
              'url': 'http://identifiers.org/imgt.hla/'},
 'IMGT LIGM': {'data_entry': 'http://genius.embnet.dkfz-heidelberg.de/menu/cgi-bin/srs7.1.3.1/wgetz?-id+4ktAl1fNMTA+-e+[IMGT:&apos;$id&apos;]',
               'example': 'M94112',
               'name': 'IMGT LIGM',
               'pattern': '^M\\d+$" restricted="true',
               'url': 'http://identifiers.org/imgt.ligm/'},
 'IPI': {'data_entry': 'http://www.ebi.ac.uk/Tools/dbfetch/dbfetch?db=ipi&amp;id=$id&amp;format=default&amp;style=html',
         'example': 'IPI00000001',
         'name': 'IPI',
         'pattern': '^IPI\\d{8}$" obsolete="true" replacement="MIR:00000005',
         'url': 'http://identifiers.org/ipi/'},
 'IRD Segment Sequence': {'data_entry': 'http://www.fludb.org/brc/fluSegmentDetails.do?ncbiGenomicAccession=$id',
                          'example': 'CY077097',
                          'name': 'IRD Segment Sequence',
                          'pattern': '^\\w+(\\_)?\\d+(\\.\\d+)?$',
                          'url': 'http://identifiers.org/ird.segment/'},
 'ISBN': {'data_entry': 'http://isbndb.com/search-all.html?kw=$id',
          'example': '9781584885658',
          'name': 'ISBN',
          'pattern': '^(ISBN)?(-13|-10)?[:]?[ ]?(\\d{2,3}[ -]?)?\\d{1,5}[ -]?\\d{1,7}[ -]?\\d{1,6}[ -]?(\\d|X)$',
          'url': 'http://identifiers.org/isbn/'},
 'ISFinder': {'data_entry': 'http://www-is.biotoul.fr/index.html?is_special_name=$id',
              'example': 'ISA1083-2',
              'name': 'ISFinder',
              'pattern': '^IS\\w+(\\-\\d)?$',
              'url': 'http://identifiers.org/isfinder/'},
 'ISSN': {'data_entry': 'http://catalog.loc.gov/cgi-bin/Pwebrecon.cgi?Search_Arg=0745-4570$id&amp;PID=le0kCQllk84KcxI3gMhUTowLMnn9H',
          'example': '0745-4570',
          'name': 'ISSN',
          'pattern': '^\\d{4}\\-\\d{4}$" restricted="true',
          'url': 'http://identifiers.org/issn/'},
 'IUPHAR family': {'data_entry': 'http://www.guidetopharmacology.org/GRAC/FamilyDisplayForward?familyId=$id',
                   'example': '78',
                   'name': 'IUPHAR family',
                   'pattern': '^\\d+$" restricted="true',
                   'url': 'http://identifiers.org/iuphar.family/'},
 'IUPHAR ligand': {'data_entry': 'http://www.guidetopharmacology.org/GRAC/LigandDisplayForward?ligandId=$id',
                   'example': '1755',
                   'name': 'IUPHAR ligand',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/iuphar.ligand/'},
 'IUPHAR receptor': {'data_entry': 'http://www.guidetopharmacology.org/GRAC/ObjectDisplayForward?objectId=$id',
                     'example': '101',
                     'name': 'IUPHAR receptor',
                     'pattern': '^\\d+$" restricted="true',
                     'url': 'http://identifiers.org/iuphar.receptor/'},
 'Identifiers.org Terms': {'data_entry': 'http://biomodels.net/vocab/idot.rdf#$id',
                           'example': 'identifierPattern',
                           'name': 'Identifiers.org Terms',
                           'pattern': '^[A-Za-z]+$',
                           'url': 'http://identifiers.org/idot/'},
 'InChI': {'data_entry': 'http://rdf.openmolecules.net/?$id',
           'example': 'InChI=1S/C2H6O/c1-2-3/h3H,2H2,1H3',
           'name': 'InChI',
           'pattern': '^InChI\\=1S\\/[A-Za-z0-9]+(\\/[cnpqbtmsih][A-Za-z0-9\\-\\+\\(\\)\\,]+)+$" restricted="true',
           'url': 'http://identifiers.org/inchi/'},
 'InChIKey': {'data_entry': 'http://www.chemspider.com/inchikey=$id',
              'example': 'RYYVLZVUVIJVGH-UHFFFAOYSA-N',
              'name': 'InChIKey',
              'pattern': '^[A-Z]{14}\\-[A-Z]{10}(\\-[A-N])?" restricted="true',
              'url': 'http://identifiers.org/inchikey/'},
 'IntAct': {'data_entry': 'http://www.ebi.ac.uk/intact/interaction/$id',
            'example': 'EBI-2307691',
            'name': 'IntAct',
            'pattern': '^EBI\\-[0-9]+$',
            'url': 'http://identifiers.org/intact/'},
 'IntAct Molecule': {'data_entry': 'http://www.ebi.ac.uk/intact/molecule/$id',
                     'example': 'EBI-366083',
                     'name': 'IntAct Molecule',
                     'pattern': '^EBI\\-[0-9]+$',
                     'url': 'http://identifiers.org/intact.molecule/'},
 'Integrated Microbial Genomes Gene': {'data_entry': 'http://img.jgi.doe.gov/cgi-bin/w/main.cgi?section=GeneDetail&amp;gene_oid=$id',
                                       'example': '638309541',
                                       'name': 'Integrated Microbial Genomes Gene',
                                       'pattern': '^\\d+$" restricted="true',
                                       'url': 'http://identifiers.org/img.gene/'},
 'Integrated Microbial Genomes Taxon': {'data_entry': 'http://img.jgi.doe.gov/cgi-bin/w/main.cgi?section=TaxonDetail&amp;taxon_oid=$id',
                                        'example': '648028003',
                                        'name': 'Integrated Microbial Genomes Taxon',
                                        'pattern': '^\\d+$" restricted="true',
                                        'url': 'http://identifiers.org/img.taxon/'},
 'InterPro': {'data_entry': 'http://www.ebi.ac.uk/interpro/entry/$id',
              'example': 'IPR000100',
              'name': 'InterPro',
              'pattern': '^IPR\\d{6}$',
              'url': 'http://identifiers.org/interpro/'},
 'JAX Mice': {'data_entry': 'http://jaxmice.jax.org/strain/$id.html',
              'example': '005012',
              'name': 'JAX Mice',
              'pattern': '^\\d+$" restricted="true',
              'url': 'http://identifiers.org/jaxmice/'},
 'JCGGDB': {'data_entry': 'http://jcggdb.jp/idb/jcggdb/$id',
            'example': 'JCGG-STR008690',
            'name': 'JCGGDB',
            'pattern': '^JCGG-STR\\d{6}$',
            'url': 'http://identifiers.org/jcggdb/'},
 'JSTOR': {'data_entry': 'http://www.jstor.org/stable/$id',
           'example': '3075966',
           'name': 'JSTOR',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/jstor/'},
 'JWS Online': {'data_entry': 'http://jjj.biochem.sun.ac.za/models/$id/',
                'example': 'curien',
                'name': 'JWS Online',
                'pattern': '^\\w+$',
                'url': 'http://identifiers.org/jws/'},
 'Japan Chemical Substance Dictionary': {'data_entry': 'http://nikkajiweb.jst.go.jp/nikkaji_web/pages/top_e.jsp?CONTENT=syosai&amp;SN=$id',
                                         'example': 'J55.713G',
                                         'name': 'Japan Chemical Substance Dictionary',
                                         'pattern': '^J\\d{1,3}(\\.\\d{3})?(\\.\\d{1,3})?[A-Za-z]$',
                                         'url': 'http://identifiers.org/jcsd/'},
 'Japan Collection of Microorganisms': {'data_entry': 'http://www.jcm.riken.go.jp/cgi-bin/jcm/jcm_number?JCM=$id',
                                        'example': '17254',
                                        'name': 'Japan Collection of Microorganisms',
                                        'pattern': '^\\d+$',
                                        'url': 'http://identifiers.org/jcm/'},
 'KEGG Compound': {'data_entry': 'http://www.kegg.jp/entry/$id',
                   'example': 'C12345',
                   'name': 'KEGG Compound',
                   'pattern': '^C\\d+$',
                   'url': 'http://identifiers.org/kegg.compound/'},
 'KEGG Disease': {'data_entry': 'http://www.kegg.jp/entry/$id',
                  'example': 'H00076',
                  'name': 'KEGG Disease',
                  'pattern': '^H\\d+$',
                  'url': 'http://identifiers.org/kegg.disease/'},
 'KEGG Drug': {'data_entry': 'http://www.kegg.jp/entry/$id',
               'example': 'D00123',
               'name': 'KEGG Drug',
               'pattern': '^D\\d+$',
               'url': 'http://identifiers.org/kegg.drug/'},
 'KEGG Environ': {'data_entry': 'http://www.kegg.jp/entry/$id',
                  'example': 'ev:E00032',
                  'name': 'KEGG Environ',
                  'pattern': '^ev\\:E\\d+$',
                  'url': 'http://identifiers.org/kegg.environ/'},
 'KEGG Genes': {'data_entry': 'http://www.kegg.jp/entry/$id',
                'example': 'syn:ssr3451',
                'name': 'KEGG Genes',
                'pattern': '^\\w+:[\\w\\d\\.-]*$',
                'url': 'http://identifiers.org/kegg.genes/'},
 'KEGG Genome': {'data_entry': 'http://www.kegg.jp/entry/$id',
                 'example': 'eco',
                 'name': 'KEGG Genome',
                 'pattern': '^(T0\\d+|\\w{3,5})$',
                 'url': 'http://identifiers.org/kegg.genome/'},
 'KEGG Glycan': {'data_entry': 'http://www.kegg.jp/entry/$id',
                 'example': 'G00123',
                 'name': 'KEGG Glycan',
                 'pattern': '^G\\d+$',
                 'url': 'http://identifiers.org/kegg.glycan/'},
 'KEGG Metagenome': {'data_entry': 'http://www.kegg.jp/entry/$id',
                     'example': 'T30002',
                     'name': 'KEGG Metagenome',
                     'pattern': '^T3\\d+$',
                     'url': 'http://identifiers.org/kegg.metagenome/'},
 'KEGG Module': {'data_entry': 'http://www.kegg.jp/entry/$id',
                 'example': 'M00002',
                 'name': 'KEGG Module',
                 'pattern': '^([a-z]{3,5}_)?M\\d{5}$',
                 'url': 'http://identifiers.org/kegg.module/'},
 'KEGG Orthology': {'data_entry': 'http://www.kegg.jp/entry/$id',
                    'example': 'K00001',
                    'name': 'KEGG Orthology',
                    'pattern': '^K\\d+$',
                    'url': 'http://identifiers.org/kegg.orthology/'},
 'KEGG Pathway': {'data_entry': 'http://www.kegg.jp/entry/$id',
                  'example': 'hsa00620',
                  'name': 'KEGG Pathway',
                  'pattern': '^\\w{2,4}\\d{5}$',
                  'url': 'http://identifiers.org/kegg.pathway/'},
 'KEGG Reaction': {'data_entry': 'http://www.kegg.jp/entry/$id',
                   'example': 'R00100',
                   'name': 'KEGG Reaction',
                   'pattern': '^R\\d+$',
                   'url': 'http://identifiers.org/kegg.reaction/'},
 'KiSAO': {'data_entry': 'http://purl.bioontology.org/ontology/KISAO/kisao:$id',
           'example': 'KISAO_0000057',
           'name': 'KiSAO',
           'pattern': '^KISAO_\\d+$',
           'url': 'http://identifiers.org/biomodels.kisao/'},
 'KnapSack': {'data_entry': 'http://kanaya.naist.jp/knapsack_jsp/information.jsp?word=$id',
              'example': 'C00000001',
              'name': 'KnapSack',
              'pattern': '^C\\d{8}',
              'url': 'http://identifiers.org/knapsack/'},
 'LINCS Cell': {'data_entry': 'http://lincs.hms.harvard.edu/db/cells/$id/',
                'example': '50002',
                'name': 'LINCS Cell',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/lincs.cell/'},
 'LINCS Molecule': {'data_entry': 'http://lincs.hms.harvard.edu/db/sm/$id/',
                    'example': '10001-101',
                    'name': 'LINCS Molecule',
                    'pattern': '^\\d+\\-\\d+$',
                    'url': 'http://identifiers.org/lincs.molecule/'},
 'LINCS Protein': {'data_entry': 'http://lincs.hms.harvard.edu/db/proteins/$id/',
                   'example': '200282',
                   'name': 'LINCS Protein',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/lincs.protein/'},
 'LIPID MAPS': {'data_entry': 'http://www.lipidmaps.org/data/LMSDRecord.php?LMID=$id',
                'example': 'LMPR0102010012',
                'name': 'LIPID MAPS',
                'pattern': '^LM(FA|GL|GP|SP|ST|PR|SL|PK)[0-9]{4}([0-9a-zA-Z]{4,6})?$',
                'url': 'http://identifiers.org/lipidmaps/'},
 'Ligand Expo': {'data_entry': 'http://ligand-depot.rutgers.edu/pyapps/ldHandler.py?formid=cc-index-search&amp;target=$id&amp;operation=ccid',
                 'example': 'ABC',
                 'name': 'Ligand Expo',
                 'pattern': '^(\\w){3}$',
                 'url': 'http://identifiers.org/ligandexpo/'},
 'Ligand-Gated Ion Channel database': {'data_entry': 'http://www.ebi.ac.uk/compneur-srv/LGICdb/HTML/$id.php',
                                       'example': '5HT3Arano',
                                       'name': 'Ligand-Gated Ion Channel database',
                                       'pattern': '^\\w+$',
                                       'url': 'http://identifiers.org/lgic/'},
 'LigandBox': {'data_entry': 'http://ligandbox.protein.osaka-u.ac.jp/ligandbox/cgi-bin/liginf.cgi?id=$id',
               'example': 'D00001',
               'name': 'LigandBox',
               'pattern': '^D\\d{5}',
               'url': 'http://identifiers.org/ligandbox/'},
 'LipidBank': {'data_entry': 'http://lipidbank.jp/cgi-bin/detail.cgi?id=$id',
               'example': 'BBA0001',
               'name': 'LipidBank',
               'pattern': '^\\w+\\d+$',
               'url': 'http://identifiers.org/lipidbank/'},
 'Locus Reference Genomic': {'data_entry': 'ftp://ftp.ebi.ac.uk/pub/databases/lrgex/$id.xml',
                             'example': 'LRG_1',
                             'name': 'Locus Reference Genomic',
                             'pattern': '^LRG_\\d+$',
                             'url': 'http://identifiers.org/lrg/'},
 'MACiE': {'data_entry': 'http://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/MACiE/entry/getPage.pl?id=$id',
           'example': 'M0001',
           'name': 'MACiE',
           'pattern': '^M\\d{4}$',
           'url': 'http://identifiers.org/macie/'},
 'MEROPS': {'data_entry': 'http://merops.sanger.ac.uk/cgi-bin/pepsum?mid=$id',
            'example': 'S01.001',
            'name': 'MEROPS',
            'pattern': '^[SCTAGMNU]\\d{2}\\.([AB]\\d{2}|\\d{3})$',
            'url': 'http://identifiers.org/merops/'},
 'MEROPS Family': {'data_entry': 'http://merops.sanger.ac.uk/cgi-bin/famsum?family=$id',
                   'example': 'S1',
                   'name': 'MEROPS Family',
                   'pattern': '^[SCTAGMNU]\\d+$',
                   'url': 'http://identifiers.org/merops.family/'},
 'MEROPS Inhibitor': {'data_entry': 'http://merops.sanger.ac.uk/cgi-bin/pepsum?id=$id',
                      'example': 'I31.952',
                      'name': 'MEROPS Inhibitor',
                      'pattern': '^I\\d{2}\\.\\d{3}$',
                      'url': 'http://identifiers.org/merops.inhibitor/'},
 'METLIN': {'data_entry': 'http://metlin.scripps.edu/metabo_info.php?molid=$id',
            'example': '1455',
            'name': 'METLIN',
            'pattern': '^\\d{4}$" restricted="true',
            'url': 'http://identifiers.org/metlin/'},
 'MGED Ontology': {'data_entry': 'http://purl.bioontology.org/ontology/MO/$id',
                   'example': 'ArrayGroup',
                   'name': 'MGED Ontology',
                   'pattern': '^\\w+$',
                   'url': 'http://identifiers.org/mo/'},
 'MINT': {'data_entry': 'http://mint.bio.uniroma2.it/mint/search/inFrameInteraction.do?interactionAc=$id',
          'example': 'MINT-10000',
          'name': 'MINT',
          'pattern': '^MINT\\-\\d{1,7}$',
          'url': 'http://identifiers.org/mint/'},
 'MIPModDB': {'data_entry': 'http://bioinfo.iitk.ac.in/MIPModDB/result.php?code=$id',
              'example': 'HOSAPI0399',
              'name': 'MIPModDB',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/mipmod/'},
 'MIRIAM Registry collection': {'data_entry': 'http://www.ebi.ac.uk/miriam/main/$id',
                                'example': 'MIR:00000008',
                                'name': 'MIRIAM Registry collection',
                                'pattern': '^MIR:000\\d{5}$',
                                'url': 'http://identifiers.org/miriam.collection/'},
 'MIRIAM Registry resource': {'data_entry': 'http://www.ebi.ac.uk/miriam/main/resources/$id',
                              'example': 'MIR:00100005',
                              'name': 'MIRIAM Registry resource',
                              'pattern': '^MIR:001\\d{5}$',
                              'url': 'http://identifiers.org/miriam.resource/'},
 'MMRRC': {'data_entry': 'http://www.mmrrc.org/catalog/getSDS.php?mmrrc_id=$id',
           'example': '70',
           'name': 'MMRRC',
           'pattern': '^\\d+$" restricted="true',
           'url': 'http://identifiers.org/mmrrc/'},
 'MaizeGDB Locus': {'data_entry': 'http://www.maizegdb.org/cgi-bin/displaylocusrecord.cgi?id=$id',
                    'example': '25011',
                    'name': 'MaizeGDB Locus',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/maizegdb.locus/'},
 'MassBank': {'data_entry': 'http://www.massbank.jp/jsp/FwdRecord.jsp?id=$id',
              'example': 'PB000166',
              'name': 'MassBank',
              'pattern': '^[A-Z]{2}[A-Z0-9][0-9]{5}$" restricted="true',
              'url': 'http://identifiers.org/massbank/'},
 'Mathematical Modelling Ontology': {'data_entry': 'http://bioportal.bioontology.org/ontologies/MAMO/?p=classes&amp;conceptid=http://identifiers.org/mamo/$id',
                                     'example': 'MAMO_0000026',
                                     'name': 'Mathematical Modelling Ontology',
                                     'pattern': '^MAMO_\\d{7}$',
                                     'url': 'http://identifiers.org/mamo/'},
 'MatrixDB': {'data_entry': 'http://matrixdb.ibcp.fr/cgi-bin/current/newPort?type=association&amp;value=$id&amp;class=Association',
              'example': 'P00747__P07355',
              'name': 'MatrixDB',
              'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])_.*|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9]_.*)|(GAG_.*)|(MULT_.*)|(PFRAG_.*)|(LIP_.*)|(CAT_.*)$',
              'url': 'http://identifiers.org/matrixdb.association/'},
 'MeSH': {'data_entry': 'http://id.nlm.nih.gov/mesh/$id',
          'example': 'C000100',
          'name': 'MeSH',
          'pattern': '^(C|D)0\\d{5}$',
          'url': 'http://identifiers.org/mesh/'},
 'MeSH 2012': {'data_entry': 'http://www.nlm.nih.gov/cgi/mesh/2012/MB_cgi?mode=&amp;index=$id&amp;view=expanded',
               'example': '17186',
               'name': 'MeSH 2012',
               'pattern': '^[A-Za-z0-9]+$" restricted="true',
               'url': 'http://identifiers.org/mesh.2012/'},
 'MeSH 2013': {'data_entry': 'http://www.nlm.nih.gov/cgi/mesh/2013/MB_cgi?mode=&amp;index=$id&amp;view=expanded',
               'example': '17165',
               'name': 'MeSH 2013',
               'pattern': '^[A-Za-z0-9]+$" restricted="true',
               'url': 'http://identifiers.org/mesh.2013/'},
 'MedDRA': {'data_entry': 'http://purl.bioontology.org/ontology/MEDDRA/$id',
            'example': '10015919',
            'name': 'MedDRA',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/meddra/'},
 'MedlinePlus': {'data_entry': 'http://www.nlm.nih.gov/medlineplus/ency/article/$id.htm',
                 'example': '002804',
                 'name': 'MedlinePlus',
                 'pattern': '^\\d+$',
                 'url': 'http://identifiers.org/medlineplus/'},
 'Melanoma Molecular Map Project Biomaps': {'data_entry': 'http://www.mmmp.org/MMMP/public/biomap/viewBiomap.mmmp?id=$id',
                                            'example': '37',
                                            'name': 'Melanoma Molecular Map Project Biomaps',
                                            'pattern': '^\\d+$',
                                            'url': 'http://identifiers.org/biomaps/'},
 'MetaNetX chemical': {'data_entry': 'http://metanetx.org/cgi-bin/mnxweb/chem_info?chem=$id',
                       'example': 'MNXM55180',
                       'name': 'MetaNetX chemical',
                       'pattern': '^MNXM\\d+$',
                       'url': 'http://identifiers.org/metanetx.chemical/'},
 'MetaNetX compartment': {'data_entry': 'http://metanetx.org/cgi-bin/mnxweb/comp_info?comp=$id',
                          'example': 'MNXC15',
                          'name': 'MetaNetX compartment',
                          'pattern': '^MNXC\\d+$',
                          'url': 'http://identifiers.org/metanetx.compartment/'},
 'MetaNetX reaction': {'data_entry': 'http://metanetx.org/cgi-bin/mnxweb/equa_info?equa=$id',
                       'example': 'MNXR3546',
                       'name': 'MetaNetX reaction',
                       'pattern': '^MNXR\\d+$',
                       'url': 'http://identifiers.org/metanetx.reaction/'},
 'MetaboLights': {'data_entry': 'http://www.ebi.ac.uk/metabolights/$id',
                  'example': 'MTBLS1',
                  'name': 'MetaboLights',
                  'pattern': '^MTBLS\\d+$',
                  'url': 'http://identifiers.org/metabolights/'},
 'Microbial Protein Interaction Database': {'data_entry': 'http://www.jcvi.org/mpidb/experiment.php?interaction_id=$id',
                                            'example': '172',
                                            'name': 'Microbial Protein Interaction Database',
                                            'pattern': '^\\d+$',
                                            'url': 'http://identifiers.org/mpid/'},
 'MicrosporidiaDB': {'data_entry': 'http://microsporidiadb.org/micro/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
                     'example': 'ECU03_0820i',
                     'name': 'MicrosporidiaDB',
                     'pattern': '^\\w+$',
                     'url': 'http://identifiers.org/microsporidia/'},
 'MimoDB': {'data_entry': 'http://immunet.cn/mimodb/browse.php?table=mimoset&amp;ID=$id',
            'example': '1',
            'name': 'MimoDB',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/mimodb/'},
 'ModelDB': {'data_entry': 'http://senselab.med.yale.edu/ModelDB/ShowModel.asp?model=$id',
             'example': '45539',
             'name': 'ModelDB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/modeldb/'},
 'Molbase': {'data_entry': 'http://www.molbase.com/en/index.php?app=search&amp;search_keyword=$id',
             'example': '128796-39-4',
             'name': 'Molbase',
             'pattern': '^(\\d{1,7}\\-\\d{2}\\-\\d)|([A-Za-z0-9\\+\\-\\_]+)$',
             'url': 'http://identifiers.org/molbase/'},
 'Molecular Interactions Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                                     'example': 'MI:0308',
                                     'name': 'Molecular Interactions Ontology',
                                     'pattern': '^MI:\\d{4}$" restricted="true',
                                     'url': 'http://identifiers.org/psimi/'},
 'Molecular Modeling Database': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Structure/mmdb/mmdbsrv.cgi?uid=$id',
                                 'example': '50885',
                                 'name': 'Molecular Modeling Database',
                                 'pattern': '^\\d{1,5}$',
                                 'url': 'http://identifiers.org/mmdb/'},
 'Mouse Adult Gross Anatomy': {'data_entry': 'http://purl.bioontology.org/ontology/MA/$id',
                               'example': 'MA:0002502',
                               'name': 'Mouse Adult Gross Anatomy',
                               'pattern': '^MA:\\d+$',
                               'url': 'http://identifiers.org/ma/'},
 'Mouse Genome Database': {'data_entry': 'http://www.informatics.jax.org/accession/$id',
                           'example': 'MGI:2442292',
                           'name': 'Mouse Genome Database',
                           'pattern': '^MGI:\\d+$',
                           'url': 'http://identifiers.org/mgd/'},
 'MycoBank': {'data_entry': 'http://www.mycobank.org/Biolomics.aspx?Table=Mycobank&amp;MycoBankNr_=$id',
              'example': '349124',
              'name': 'MycoBank',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/mycobank/'},
 'MycoBrowser leprae': {'data_entry': 'http://mycobrowser.epfl.ch/leprosysearch.php?gene+name=$id',
                        'example': 'ML0224',
                        'name': 'MycoBrowser leprae',
                        'pattern': '^ML\\w+$',
                        'url': 'http://identifiers.org/myco.lepra/'},
 'MycoBrowser marinum': {'data_entry': 'http://mycobrowser.epfl.ch/marinosearch.php?gene+name=$id',
                         'example': 'MMAR_2462',
                         'name': 'MycoBrowser marinum',
                         'pattern': '^MMAR\\_\\d+$',
                         'url': 'http://identifiers.org/myco.marinum/'},
 'MycoBrowser smegmatis': {'data_entry': 'http://mycobrowser.epfl.ch/smegmasearch.php?gene+name=$id',
                           'example': 'MSMEG_3769',
                           'name': 'MycoBrowser smegmatis',
                           'pattern': '^MSMEG\\w+$',
                           'url': 'http://identifiers.org/myco.smeg/'},
 'MycoBrowser tuberculosis': {'data_entry': 'http://tuberculist.epfl.ch/quicksearch.php?gene+name=$id',
                              'example': 'Rv1908c',
                              'name': 'MycoBrowser tuberculosis',
                              'pattern': '^Rv\\d{4}(A|B|c)?$',
                              'url': 'http://identifiers.org/myco.tuber/'},
 'NAPP': {'data_entry': 'http://rna.igmors.u-psud.fr/NAPP/Niveau2.php?specie=$id',
          'example': '351',
          'name': 'NAPP',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/napp/'},
 'NARCIS': {'data_entry': 'http://www.narcis.nl/publication/RecordID/$id',
            'example': 'oai:cwi.nl:4725',
            'name': 'NARCIS',
            'pattern': '^oai\\:cwi\\.nl\\:\\d+$',
            'url': 'http://identifiers.org/narcis/'},
 'NASC code': {'data_entry': 'http://arabidopsis.info/StockInfo?NASC_id=$id',
               'example': 'N1899',
               'name': 'NASC code',
               'pattern': '^(\\w+)?\\d+$',
               'url': 'http://identifiers.org/nasc/'},
 'NCBI GI': {'data_entry': 'http://www.ncbi.nlm.nih.gov/protein/$id',
             'example': 'GI:9082283',
             'name': 'NCBI GI',
             'pattern': '^(GI|gi)\\:\\d+$" restricted="true',
             'url': 'http://identifiers.org/ncbigi/'},
 'NCBI Gene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/gene/$id',
               'example': '100010',
               'name': 'NCBI Gene',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/ncbigene/'},
 'NCBI Protein': {'data_entry': 'http://www.ncbi.nlm.nih.gov/protein/$id',
                  'example': 'CAA71118.1',
                  'name': 'NCBI Protein',
                  'pattern': '^(\\w+\\d+(\\.\\d+)?)|(NP_\\d+)$" restricted="true',
                  'url': 'http://identifiers.org/ncbiprotein/'},
 'NCI Pathway Interaction Database: Pathway': {'data_entry': 'http://pid.nci.nih.gov/search/pathway_landing.shtml?what=graphic&amp;jpg=on&amp;pathway_id=$id',
                                               'example': 'pi3kcipathway',
                                               'name': 'NCI Pathway Interaction Database: Pathway',
                                               'pattern': '^\\w+$',
                                               'url': 'http://identifiers.org/pid.pathway/'},
 'NCIm': {'data_entry': 'http://ncim.nci.nih.gov/ncimbrowser/ConceptReport.jsp?dictionary=NCI%20MetaThesaurus&amp;code=$id',
          'example': 'C0026339',
          'name': 'NCIm',
          'pattern': '^C\\d+$" restricted="true',
          'url': 'http://identifiers.org/ncim/'},
 'NCIt': {'data_entry': 'http://ncit.nci.nih.gov/ncitbrowser/ConceptReport.jsp?dictionary=NCI%20Thesaurus&amp;code=$id',
          'example': 'C80519',
          'name': 'NCIt',
          'pattern': '^C\\d+$',
          'url': 'http://identifiers.org/ncit/'},
 'NEXTDB': {'data_entry': 'http://nematode.lab.nig.ac.jp/db2/ShowCloneInfo.php?clone=$id',
            'example': '6b1',
            'name': 'NEXTDB',
            'pattern': '^[A-Za-z0-9]+$" restricted="true',
            'url': 'http://identifiers.org/nextdb/'},
 'NIAEST': {'data_entry': 'http://lgsun.grc.nia.nih.gov/cgi-bin/pro3?sname1=$id',
            'example': 'J0705A10',
            'name': 'NIAEST',
            'pattern': '^\\w\\d{4}\\w\\d{2}(\\-[35])?$',
            'url': 'http://identifiers.org/niaest/'},
 'NITE Biological Research Center Catalogue': {'data_entry': 'http://www.nbrc.nite.go.jp/NBRC2/NBRCCatalogueDetailServlet?ID=NBRC&amp;CAT=$id',
                                               'example': '00001234',
                                               'name': 'NITE Biological Research Center Catalogue',
                                               'pattern': '^\\d+$',
                                               'url': 'http://identifiers.org/nbrc/'},
 'NONCODE v3': {'data_entry': 'http://www.noncode.org/NONCODERv3/ncrna.php?ncid=$id',
                'example': '377550',
                'name': 'NONCODE v3',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/noncodev3/'},
 'NONCODE v4 Gene': {'data_entry': 'http://www.bioinfo.org/NONCODEv4/show_gene.php?id=$id',
                     'example': 'NONHSAG00001',
                     'name': 'NONCODE v4 Gene',
                     'pattern': '^NONHSAG\\d{5}$',
                     'url': 'http://identifiers.org/noncodev4.gene/'},
 'NONCODE v4 Transcript': {'data_entry': 'http://www.bioinfo.org/NONCODEv4/show_rna.php?id=$id',
                           'example': 'NONHSAT000001',
                           'name': 'NONCODE v4 Transcript',
                           'pattern': '^NONHSAT\\d{6}$',
                           'url': 'http://identifiers.org/noncodev4.rna/'},
 'NORINE': {'data_entry': 'http://bioinfo.lifl.fr/norine/result.jsp?ID=$id',
            'example': 'NOR00681',
            'name': 'NORINE',
            'pattern': '^NOR\\d+$',
            'url': 'http://identifiers.org/norine/'},
 'National Bibliography Number': {'data_entry': 'http://nbn-resolving.org/resolver?identifier=$id&amp;verb=full',
                                  'example': 'urn:nbn:fi:tkk-004781',
                                  'name': 'National Bibliography Number',
                                  'pattern': '^urn\\:nbn\\:[A-Za-z_0-9]+\\:([A-Za-z_0-9]+\\:)?[A-Za-z_0-9]+$',
                                  'url': 'http://identifiers.org/nbn/'},
 'National Drug Code': {'data_entry': 'http://www.hipaaspace.com/Medical_Billing/Coding/National.Drug.Codes/$id',
                        'example': '0002-1975-61',
                        'name': 'National Drug Code',
                        'pattern': '^\\d+\\-\\d+\\-\\d+',
                        'url': 'http://identifiers.org/ndc/'},
 'NeuroLex': {'data_entry': 'http://www.neurolex.org/wiki/$id',
              'example': 'Birnlex_721',
              'name': 'NeuroLex',
              'pattern': '^([Bb]irnlex_|Sao|nlx_|GO_|CogPO|HDO|nifext_)\\d+$',
              'url': 'http://identifiers.org/neurolex/'},
 'NeuroMorpho': {'data_entry': 'http://neuromorpho.org/neuron_info.jsp?neuron_name=$id',
                 'example': 'Rosa2',
                 'name': 'NeuroMorpho',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/neuromorpho/'},
 'NeuronDB': {'data_entry': 'http://senselab.med.yale.edu/NeuronDB/NeuronProp.aspx?id=$id',
              'example': '265',
              'name': 'NeuronDB',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/neurondb/'},
 'NucleaRDB': {'data_entry': 'http://www.receptors.org/nucleardb/proteins/$id',
               'example': 'prgr_human',
               'name': 'NucleaRDB',
               'pattern': '^\\w+\\_\\w+$',
               'url': 'http://identifiers.org/nuclearbd/'},
 'Nucleotide Sequence Database': {'data_entry': 'http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=$id',
                                  'example': 'X58356',
                                  'name': 'Nucleotide Sequence Database',
                                  'pattern': '^([A-Z]\\d{5}|[A-Z]{2}\\d{6}|[A-Z]{4}\\d{8}|[A-J][A-Z]{2}\\d{5})(\\.\\d+)?$',
                                  'url': 'http://identifiers.org/insdc/'},
 'OMA Group': {'data_entry': 'http://omabrowser.org/cgi-bin/gateway.pl?f=DisplayGroup&amp;p1=$id',
               'example': 'LCSCCPN',
               'name': 'OMA Group',
               'pattern': '^[A-Z]+$" restricted="true',
               'url': 'http://identifiers.org/oma.grp/'},
 'OMA Protein': {'data_entry': 'http://omabrowser.org/cgi-bin/gateway.pl?f=DisplayEntry&amp;p1=$id',
                 'example': 'HUMAN16963',
                 'name': 'OMA Protein',
                 'pattern': '^[A-Z0-9]{5}\\d+$" restricted="true',
                 'url': 'http://identifiers.org/oma.protein/'},
 'OMIA': {'data_entry': 'http://omia.angis.org.au/$id/',
          'example': '1000',
          'name': 'OMIA',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/omia/'},
 'OMIM': {'data_entry': 'http://omim.org/entry/$id',
          'example': '603903',
          'name': 'OMIM',
          'pattern': '^[*#+%^]?\\d{6}$',
          'url': 'http://identifiers.org/omim/'},
 'OPM': {'data_entry': 'http://opm.phar.umich.edu/protein.php?pdbid=$id',
         'example': '1h68',
         'name': 'OPM',
         'pattern': '^[0-9][A-Za-z0-9]{3}$" restricted="true',
         'url': 'http://identifiers.org/opm/'},
 'ORCID': {'data_entry': 'https://orcid.org/$id',
           'example': '0000-0002-6309-7327',
           'name': 'ORCID',
           'pattern': '^\\d{4}-\\d{4}-\\d{4}-\\d{3}(\\d|X)$',
           'url': 'http://identifiers.org/orcid/'},
 'Odor Molecules DataBase': {'data_entry': 'http://senselab.med.yale.edu/OdorDB/Data/$id/?db=5',
                             'example': '74',
                             'name': 'Odor Molecules DataBase',
                             'pattern': '^\\d+$',
                             'url': 'http://identifiers.org/odor/'},
 'Olfactory Receptor Database': {'data_entry': 'http://senselab.med.yale.edu/ORDB/Data/$id',
                                 'example': '8497',
                                 'name': 'Olfactory Receptor Database',
                                 'pattern': '^\\d+$',
                                 'url': 'http://identifiers.org/ordb/'},
 'Ontology for Biomedical Investigations': {'data_entry': 'http://purl.obolibrary.org/obo/$id',
                                            'example': 'OBI_0000070',
                                            'name': 'Ontology for Biomedical Investigations',
                                            'pattern': '^OBI_\\d{7}$',
                                            'url': 'http://identifiers.org/obi/'},
 'Ontology of Physics for Biology': {'data_entry': 'http://purl.bioontology.org/ontology/OPB?conceptid=http%3A%2F%2Fbhi.washington.edu%2FOPB%23$id',
                                     'example': 'OPB_00573',
                                     'name': 'Ontology of Physics for Biology',
                                     'pattern': '^OPB_\\d+$',
                                     'url': 'http://identifiers.org/opb/'},
 'OriDB Saccharomyces': {'data_entry': 'http://cerevisiae.oridb.org/details.php?id=$id',
                         'example': '1',
                         'name': 'OriDB Saccharomyces',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/oridb.sacch/'},
 'OriDB Schizosaccharomyces': {'data_entry': 'http://pombe.oridb.org/details.php?id=$id',
                               'example': '1',
                               'name': 'OriDB Schizosaccharomyces',
                               'pattern': '^\\d+$',
                               'url': 'http://identifiers.org/oridb.schizo/'},
 'Orphanet': {'data_entry': 'http://www.orpha.net/consor/cgi-bin/OC_Exp.php?Lng=EN&amp;Expert=$id',
              'example': '85163',
              'name': 'Orphanet',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/orphanet/'},
 'Orphanet Rare Disease Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                                    'example': 'Orphanet:C023',
                                    'name': 'Orphanet Rare Disease Ontology',
                                    'pattern': '^Orphanet(_|:)C?\\d+$',
                                    'url': 'http://identifiers.org/orphanet.ordo/'},
 'OrthoDB': {'data_entry': 'http://cegg.unige.ch/orthodb/results?searchtext=$id',
             'example': 'Q9P0K8',
             'name': 'OrthoDB',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/orthodb/'},
 'Oryza Tag Line': {'data_entry': 'http://oryzatagline.cirad.fr/cgi-bin/general_mutant.pl?line=$id',
                    'example': 'AADB12',
                    'name': 'Oryza Tag Line',
                    'pattern': '^A[A-Z]+\\d+$',
                    'url': 'http://identifiers.org/otl/'},
 'Oryzabase Gene': {'data_entry': 'http://www.shigen.nig.ac.jp/rice/oryzabaseV4/gene/detail/$id',
                    'example': '117',
                    'name': 'Oryzabase Gene',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/oryzabase.gene/'},
 'Oryzabase Mutant': {'data_entry': 'http://www.shigen.nig.ac.jp/rice/oryzabaseV4/strain/inducedMutationLine/detail/$id',
                      'example': '21393',
                      'name': 'Oryzabase Mutant',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/oryzabase.mutant/'},
 'Oryzabase Stage': {'data_entry': 'http://www.shigen.nig.ac.jp/rice/oryzabaseV4/devstageineachorgan/detail/$id',
                     'example': '34',
                     'name': 'Oryzabase Stage',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/oryzabase.stage/'},
 'Oryzabase Strain': {'data_entry': 'http://www.shigen.nig.ac.jp/rice/oryzabaseV4/strain/wildCore/detail/$id',
                      'example': '1',
                      'name': 'Oryzabase Strain',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/oryzabase.strain/'},
 'P3DB Protein': {'data_entry': 'http://www.p3db.org/protein.php?id=$id&amp;amp;ref=0',
                  'example': '70',
                  'name': 'P3DB Protein',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/p3db.protein/'},
 'P3DB Site': {'data_entry': 'http://www.p3db.org/phosphosite.php?id=$id&amp;ref=0',
               'example': '65',
               'name': 'P3DB Site',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/p3db.site/'},
 'PANTHER Family': {'data_entry': 'http://www.pantherdb.org/panther/family.do?clsAccession=$id',
                    'example': 'PTHR12345',
                    'name': 'PANTHER Family',
                    'pattern': '^PTHR\\d{5}(\\:SF\\d{1,3})?$',
                    'url': 'http://identifiers.org/panther.family/'},
 'PANTHER Node': {'data_entry': 'http://www.pantree.org/node/annotationNode.jsp?id=$id',
                  'example': 'PTN000000026',
                  'name': 'PANTHER Node',
                  'pattern': '^PTN\\d{9}$',
                  'url': 'http://identifiers.org/panther.node/'},
 'PANTHER Pathway': {'data_entry': 'http://www.pantherdb.org/pathway/pathwayDiagram.jsp?catAccession=$id',
                     'example': 'P00024',
                     'name': 'PANTHER Pathway',
                     'pattern': '^P\\d{5}$',
                     'url': 'http://identifiers.org/panther.pathway/'},
 'PANTHER Pathway Component': {'data_entry': 'http://www.pantherdb.org/pathway/pathCatDetail.do?clsAccession=$id',
                               'example': 'P00266',
                               'name': 'PANTHER Pathway Component',
                               'pattern': '^G|P|U|C|S\\d{5}$',
                               'url': 'http://identifiers.org/panther.pthcmp/'},
 'PASS2': {'data_entry': 'http://caps.ncbs.res.in/cgi-bin/pass2//show_sf.py?sf_id=$id',
           'example': '46977',
           'name': 'PASS2',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pass2/'},
 'PATO': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
          'example': 'PATO:0001998',
          'name': 'PATO',
          'pattern': '^PATO:\\d{7}$',
          'url': 'http://identifiers.org/pato/'},
 'PINA': {'data_entry': 'http://cbg.garvan.unsw.edu.au/pina/interactome.oneP.do?ac=$id&amp;showExtend=null',
          'example': 'Q13485',
          'name': 'PINA',
          'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$" restricted="true',
          'url': 'http://identifiers.org/pina/'},
 'PIRSF': {'data_entry': 'http://pir.georgetown.edu/cgi-bin/ipcSF?id=$id',
           'example': 'PIRSF000100',
           'name': 'PIRSF',
           'pattern': '^PIRSF\\d{6}$',
           'url': 'http://identifiers.org/pirsf/'},
 'PMC International': {'data_entry': 'http://www.ncbi.nlm.nih.gov/pmc/articles/$id/?tool=pubmed',
                       'example': 'PMC3084216',
                       'name': 'PMC International',
                       'pattern': 'PMC\\d+',
                       'url': 'http://identifiers.org/pmc/'},
 'PMP': {'data_entry': 'http://www.proteinmodelportal.org/query/uniprot/$id',
         'example': 'Q0VCA6',
         'name': 'PMP',
         'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
         'url': 'http://identifiers.org/pmp/'},
 'PRIDE': {'data_entry': 'http://www.ebi.ac.uk/pride/archive/assays/$id',
           'example': '1',
           'name': 'PRIDE',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pride/'},
 'PRIDE Project': {'data_entry': 'http://www.ebi.ac.uk/pride/archive/projects/$id',
                   'example': 'PXD000440',
                   'name': 'PRIDE Project',
                   'pattern': '^P(X|R)D\\d+{6}$',
                   'url': 'http://identifiers.org/pride.project/'},
 'PRINTS': {'data_entry': 'http://www.bioinf.manchester.ac.uk/cgi-bin/dbbrowser/sprint/searchprintss.cgi?prints_accn=$id&amp;display_opts=Prints&amp;category=None&amp;queryform=false&amp;regexpr=off',
            'example': 'PR00001',
            'name': 'PRINTS',
            'pattern': '^PR\\d{5}$',
            'url': 'http://identifiers.org/sprint/'},
 'PROSITE': {'data_entry': 'http://prosite.expasy.org/$id',
             'example': 'PS00001',
             'name': 'PROSITE',
             'pattern': '^PS\\d{5}$',
             'url': 'http://identifiers.org/prosite/'},
 'PSCDB': {'data_entry': 'http://idp1.force.cs.is.nagoya-u.ac.jp/pscdb/$id.html',
           'example': '051',
           'name': 'PSCDB',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pscdb/'},
 'PaleoDB': {'data_entry': 'http://fossilworks.org/?a=taxonInfo&amp;taxon_no=$id',
             'example': '83088',
             'name': 'PaleoDB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/paleodb/'},
 'Pathema': {'data_entry': 'http://pathema.jcvi.org/$id',
             'example': None,
             'name': 'Pathema',
             'pattern': '^.+$" obsolete="true" replacement="',
             'url': 'http://identifiers.org/pathema/'},
 'Pathway Commons': {'data_entry': 'http://www.pathwaycommons.org/pc/record2.do?id=$id',
                     'example': '485991',
                     'name': 'Pathway Commons',
                     'pattern': '^\\d+$" restricted="true',
                     'url': 'http://identifiers.org/pathwaycommons/'},
 'Pathway Ontology': {'data_entry': 'http://rgd.mcw.edu/rgdweb/ontology/annot.html?acc_id=$id',
                      'example': 'PW:0000208',
                      'name': 'Pathway Ontology',
                      'pattern': '^PW:\\d{7}$',
                      'url': 'http://identifiers.org/pw/'},
 'PaxDb Organism': {'data_entry': 'http://pax-db.org/#!species/$id',
                    'example': '9606',
                    'name': 'PaxDb Organism',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/paxdb.organism/'},
 'PaxDb Protein': {'data_entry': 'http://pax-db.org/#!protein/$id',
                   'example': '977869',
                   'name': 'PaxDb Protein',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/paxdb.protein/'},
 'Pazar Transcription Factor': {'data_entry': 'http://www.pazar.info/cgi-bin/tf_search.cgi?geneID=$id',
                                'example': 'TF0001053',
                                'name': 'Pazar Transcription Factor',
                                'pattern': '^TF\\w+$',
                                'url': 'http://identifiers.org/pazar/'},
 'PeptideAtlas': {'data_entry': 'https://db.systemsbiology.net/sbeams/cgi/PeptideAtlas/Summarize_Peptide?query=QUERY&amp;searchForThis=$id',
                  'example': 'PAp00000009',
                  'name': 'PeptideAtlas',
                  'pattern': '^PAp[0-9]{8}$',
                  'url': 'http://identifiers.org/peptideatlas/'},
 'Peroxibase': {'data_entry': 'http://peroxibase.toulouse.inra.fr/browse/process/view_perox.php?id=$id',
                'example': '5282',
                'name': 'Peroxibase',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/peroxibase/'},
 'Pfam': {'data_entry': 'http://pfam.xfam.org/family/$id',
          'example': 'PF01234',
          'name': 'Pfam',
          'pattern': '^PF\\d{5}$',
          'url': 'http://identifiers.org/pfam/'},
 'PharmGKB Disease': {'data_entry': 'http://www.pharmgkb.org/disease/$id',
                      'example': 'PA447218',
                      'name': 'PharmGKB Disease',
                      'pattern': '^PA\\d+$" restricted="true',
                      'url': 'http://identifiers.org/pharmgkb.disease/'},
 'PharmGKB Drug': {'data_entry': 'http://www.pharmgkb.org/drug/$id',
                   'example': 'PA448710',
                   'name': 'PharmGKB Drug',
                   'pattern': '^PA\\d+$" restricted="true',
                   'url': 'http://identifiers.org/pharmgkb.drug/'},
 'PharmGKB Gene': {'data_entry': 'http://www.pharmgkb.org/gene/$id',
                   'example': 'PA131',
                   'name': 'PharmGKB Gene',
                   'pattern': '^PA\\w+$" restricted="true',
                   'url': 'http://identifiers.org/pharmgkb.gene/'},
 'PharmGKB Pathways': {'data_entry': 'http://www.pharmgkb.org/pathway/$id',
                       'example': 'PA146123006',
                       'name': 'PharmGKB Pathways',
                       'pattern': '^PA\\d+$" restricted="true',
                       'url': 'http://identifiers.org/pharmgkb.pathways/'},
 'Phenol-Explorer': {'data_entry': 'http://phenol-explorer.eu/foods/$id',
                     'example': '75',
                     'name': 'Phenol-Explorer',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/phenolexplorer/'},
 'PhosphoPoint Kinase': {'data_entry': 'http://kinase.bioinformatics.tw/showall.jsp?type=Kinase&amp;info=Gene&amp;name=$id&amp;drawing=0&amp;sorting=0&amp;kinome=1',
                         'example': 'AURKA',
                         'name': 'PhosphoPoint Kinase',
                         'pattern': '^\\w+$',
                         'url': 'http://identifiers.org/phosphopoint.kinase/'},
 'PhosphoPoint Phosphoprotein': {'data_entry': 'http://kinase.bioinformatics.tw/showall.jsp?type=PhosphoProtein&amp;info=Gene&amp;name=$id&amp;drawing=0&amp;sorting=0&amp;kinome=0',
                                 'example': 'AURKA',
                                 'name': 'PhosphoPoint Phosphoprotein',
                                 'pattern': '^\\w+$',
                                 'url': 'http://identifiers.org/phosphopoint.protein/'},
 'PhosphoSite Protein': {'data_entry': 'http://www.phosphosite.org/proteinAction.do?id=$id',
                         'example': '12300',
                         'name': 'PhosphoSite Protein',
                         'pattern': '^\\d{5}$',
                         'url': 'http://identifiers.org/phosphosite.protein/'},
 'PhosphoSite Residue': {'data_entry': 'http://www.phosphosite.org/siteAction.do?id=$id',
                         'example': '2842',
                         'name': 'PhosphoSite Residue',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/phosphosite.residue/'},
 'PhylomeDB': {'data_entry': 'http://phylomedb.org/?seqid=$id',
               'example': 'Phy000CLXM_RAT',
               'name': 'PhylomeDB',
               'pattern': '^\\w+$',
               'url': 'http://identifiers.org/phylomedb/'},
 'Phytozome Locus': {'data_entry': 'http://www.phytozome.net/genePage.php?crown&amp;method=0&amp;search=1&amp;detail=1&amp;searchText=locusname:$id',
                     'example': 'Glyma0021s00410',
                     'name': 'Phytozome Locus',
                     'pattern': '^[A-Za-z0-9]+$',
                     'url': 'http://identifiers.org/phytozome.locus/'},
 'PiroplasmaDB': {'data_entry': 'http://piroplasmadb.org/piro/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
                  'example': 'TA14985',
                  'name': 'PiroplasmaDB',
                  'pattern': '^TA\\d+$',
                  'url': 'http://identifiers.org/piroplasma/'},
 'Plant Environment Ontology': {'data_entry': 'http://archive.gramene.org/db/ontology/search?query=$id',
                                'example': 'EO:0007404',
                                'name': 'Plant Environment Ontology',
                                'pattern': '^[EP]O\\:\\d{7}$',
                                'url': 'http://identifiers.org/peo/'},
 'Plant Genome Network': {'data_entry': 'http://pgn.cornell.edu/unigene/unigene_assembly_contigs.pl?unigene_id=$id',
                          'example': '196828',
                          'name': 'Plant Genome Network',
                          'pattern': '^\\d+$" obsolete="true" replacement="MIR:00000185',
                          'url': 'http://identifiers.org/pgn/'},
 'Plant Ontology': {'data_entry': 'http://www.plantontology.org/amigo/go.cgi?view=details&amp;query=$id',
                    'example': 'PO:0009089',
                    'name': 'Plant Ontology',
                    'pattern': '^PO:\\d+$',
                    'url': 'http://identifiers.org/po/'},
 'PlasmoDB': {'data_entry': 'http://plasmodb.org/plasmo/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'PF11_0344',
              'name': 'PlasmoDB',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/plasmodb/'},
 'Pocketome': {'data_entry': 'http://www.pocketome.org/files/$id.html',
               'example': '1433C_TOBAC_1_252',
               'name': 'Pocketome',
               'pattern': '^[A-Za-z_0-9]+',
               'url': 'http://identifiers.org/pocketome/'},
 'PolBase': {'data_entry': 'https://polbase.neb.com/polymerases/$id#sequences',
             'example': '19-T4',
             'name': 'PolBase',
             'pattern': '^[A-Za-z-0-9]+$',
             'url': 'http://identifiers.org/polbase/'},
 'PomBase': {'data_entry': 'http://www.pombase.org/spombe/result/$id',
             'example': 'SPCC13B11.01',
             'name': 'PomBase',
             'pattern': '^S\\w+(\\.)?\\w+(\\.)?$',
             'url': 'http://identifiers.org/pombase/'},
 'ProDom': {'data_entry': 'http://prodom.prabi.fr/prodom/current/cgi-bin/request.pl?question=DBEN&amp;query=$id',
            'example': 'PD10000',
            'name': 'ProDom',
            'pattern': '^PD\\d+$',
            'url': 'http://identifiers.org/prodom/'},
 'ProGlycProt': {'data_entry': 'http://www.proglycprot.org/detail.aspx?ProId=$id',
                 'example': 'AC119',
                 'name': 'ProGlycProt',
                 'pattern': '^[A-Z]C\\d{1,3}$',
                 'url': 'http://identifiers.org/proglyc/'},
 'ProtClustDB': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sites/entrez?Db=proteinclusters&amp;Cmd=DetailsSearch&amp;Term=$id',
                 'example': 'O80725',
                 'name': 'ProtClustDB',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/protclustdb/'},
 'Protein Affinity Reagents': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                               'example': 'PAR:0116',
                               'name': 'Protein Affinity Reagents',
                               'pattern': '^PAR:\\d+$',
                               'url': 'http://identifiers.org/psipar/'},
 'Protein Data Bank': {'data_entry': 'http://www.rcsb.org/pdb/explore/explore.do?structureId=$id',
                       'example': '2gc4',
                       'name': 'Protein Data Bank',
                       'pattern': '^[0-9][A-Za-z0-9]{3}$',
                       'url': 'http://identifiers.org/pdb/'},
 'Protein Data Bank Ligand': {'data_entry': 'http://www.rcsb.org/pdb/ligand/ligandsummary.do?hetId=$id',
                              'example': 'TRQ',
                              'name': 'Protein Data Bank Ligand',
                              'pattern': '^[A-Za-z0-9]+$',
                              'url': 'http://identifiers.org/pdb.ligand/'},
 'Protein Model Database': {'data_entry': 'https://bioinformatics.cineca.it/PMDB/user//search.php?idsearch=$id',
                            'example': 'PM0012345',
                            'name': 'Protein Model Database',
                            'pattern': '^PM\\d{7}',
                            'url': 'http://identifiers.org/pmdb/'},
 'Protein Modification Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                                   'example': 'MOD:00001',
                                   'name': 'Protein Modification Ontology',
                                   'pattern': '^MOD:\\d{5}',
                                   'url': 'http://identifiers.org/psimod/'},
 'Protein Ontology': {'data_entry': 'http://pir.georgetown.edu/cgi-bin/pro/entry_pro?id=$id',
                      'example': 'PR:000000024',
                      'name': 'Protein Ontology',
                      'pattern': '^PR\\:\\d+$',
                      'url': 'http://identifiers.org/pr/'},
 'ProteomeXchange': {'data_entry': 'http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=$id',
                     'example': 'PXD000500',
                     'name': 'ProteomeXchange',
                     'pattern': '^(R)?PXD\\d+{6}$',
                     'url': 'http://identifiers.org/proteomexchange/'},
 'ProteomicsDB Peptide': {'data_entry': 'https://www.proteomicsdb.org/#human/proteinDetails/$id/peptides/',
                          'example': '53504',
                          'name': 'ProteomicsDB Peptide',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/proteomicsdb.peptide/'},
 'ProteomicsDB Protein': {'data_entry': 'https://www.proteomicsdb.org/#human/proteinDetails/$id/summary',
                          'example': '53504',
                          'name': 'ProteomicsDB Protein',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/proteomicsdb.protein/'},
 'ProtoNet Cluster': {'data_entry': 'http://www.protonet.cs.huji.ac.il/requested/cluster_card.php?cluster=$id',
                      'example': '4349895',
                      'name': 'ProtoNet Cluster',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/protonet.cluster/'},
 'ProtoNet ProteinCard': {'data_entry': 'http://www.protonet.cs.huji.ac.il/requested/protein_card.php?protein_id=$id',
                          'example': '16941567',
                          'name': 'ProtoNet ProteinCard',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/protonet.proteincard/'},
 'Pseudomonas Genome Database': {'data_entry': 'http://v2.pseudomonas.com/getAnnotation.do?locusID=$id',
                                 'example': 'PSEEN0001',
                                 'name': 'Pseudomonas Genome Database',
                                 'pattern': '^P\\w+$',
                                 'url': 'http://identifiers.org/pseudomonas/'},
 'PubChem-bioassay': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/assay/assay.cgi?aid=$id',
                      'example': '1018',
                      'name': 'PubChem-bioassay',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/pubchem.bioassay/'},
 'PubChem-compound': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi?cid=$id',
                      'example': '100101',
                      'name': 'PubChem-compound',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/pubchem.compound/'},
 'PubChem-substance': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi?sid=$id',
                       'example': '100101',
                       'name': 'PubChem-substance',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/pubchem.substance/'},
 'PubMed': {'data_entry': 'http://www.ncbi.nlm.nih.gov/pubmed/$id',
            'example': '16333295',
            'name': 'PubMed',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/pubmed/'},
 'REBASE': {'data_entry': 'http://rebase.neb.com/rebase/enz/$id.html',
            'example': '101',
            'name': 'REBASE',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/rebase/'},
 'RESID': {'data_entry': 'http://pir0.georgetown.edu/cgi-bin/resid?id=$id',
           'example': 'AA0001',
           'name': 'RESID',
           'pattern': '^AA\\d{4}$',
           'url': 'http://identifiers.org/resid/'},
 'RFAM': {'data_entry': 'http://rfam.xfam.org/family/$id',
          'example': 'RF00230',
          'name': 'RFAM',
          'pattern': '^RF\\d{5}$',
          'url': 'http://identifiers.org/rfam/'},
 'RNA Modification Database': {'data_entry': 'http://mods.rna.albany.edu/mods/modifications/view/$id',
                               'example': '101',
                               'name': 'RNA Modification Database',
                               'pattern': '^\\d{3}$',
                               'url': 'http://identifiers.org/rnamods/'},
 'RRID': {'data_entry': 'https://scicrunch.org/resolver/$id',
          'example': 'RRID:AB_262044',
          'name': 'RRID',
          'pattern': '^RRID:[A-Z_a-z-0-9]+$',
          'url': 'http://identifiers.org/rrid/'},
 'Rat Genome Database': {'data_entry': 'http://rgd.mcw.edu/rgdweb/report/gene/main.html?id=$id',
                         'example': '2018',
                         'name': 'Rat Genome Database',
                         'pattern': '^\\d{4,7}$',
                         'url': 'http://identifiers.org/rgd/'},
 'Rat Genome Database qTL': {'data_entry': 'http://rgd.mcw.edu/rgdweb/report/qtl/main.html?id=$id',
                             'example': '1354581',
                             'name': 'Rat Genome Database qTL',
                             'pattern': '^\\d+$',
                             'url': 'http://identifiers.org/rgd.qtl/'},
 'Rat Genome Database strain': {'data_entry': 'http://rgd.mcw.edu/rgdweb/report/strain/main.html?id=$id',
                                'example': '5688061',
                                'name': 'Rat Genome Database strain',
                                'pattern': '^\\d+$',
                                'url': 'http://identifiers.org/rgd.strain/'},
 'Reactome': {'data_entry': 'http://www.reactome.org/PathwayBrowser/#$id',
              'example': 'R-HSA-201451',
              'name': 'Reactome',
              'pattern': '(^(REACTOME:)?R-[A-Z]{3}-[0-9]+(-[0-9]+)?$)|(^REACT_\\d+$)',
              'url': 'http://identifiers.org/reactome/'},
 'RefSeq': {'data_entry': 'http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=$id',
            'example': 'NP_012345',
            'name': 'RefSeq',
            'pattern': '^((AC|AP|NC|NG|NM|NP|NR|NT|NW|XM|XP|XR|YP|ZP)_\\d+|(NZ\\_[A-Z]{4}\\d+))(\\.\\d+)?$',
            'url': 'http://identifiers.org/refseq/'},
 'Relation Ontology': {'data_entry': 'http://www.obofoundry.org/ro/#$id',
                       'example': 'OBO_REL:is_a',
                       'name': 'Relation Ontology',
                       'pattern': '^OBO_REL:\\w+$',
                       'url': 'http://identifiers.org/ro/'},
 'Rhea': {'data_entry': 'http://www.rhea-db.org/reaction?id=$id',
          'example': '12345',
          'name': 'Rhea',
          'pattern': '^\\d{5}$',
          'url': 'http://identifiers.org/rhea/'},
 'Rice Genome Annotation Project': {'data_entry': 'http://rice.plantbiology.msu.edu/cgi-bin/ORF_infopage.cgi?&amp;orf=$id',
                                    'example': 'LOC_Os02g13300',
                                    'name': 'Rice Genome Annotation Project',
                                    'pattern': '^LOC\\_Os\\d{1,2}g\\d{5}$',
                                    'url': 'http://identifiers.org/ricegap/'},
 'Rouge': {'data_entry': 'http://www.kazusa.or.jp/rouge/gfpage/$id/',
           'example': 'mKIAA4200',
           'name': 'Rouge',
           'pattern': '^m\\w+$" restricted="true',
           'url': 'http://identifiers.org/rouge/'},
 'SABIO-RK EC Record': {'data_entry': 'http://sabiork.h-its.org/newSearch?q=ecnumber:$id',
                        'example': '2.7.1.1',
                        'name': 'SABIO-RK EC Record',
                        'pattern': '^((\\d+)|(\\d+\\.\\d+)|(\\d+\\.\\d+\\.\\d+)|(\\d+\\.\\d+\\.\\d+\\.\\d+))$',
                        'url': 'http://identifiers.org/sabiork.ec/'},
 'SABIO-RK Kinetic Record': {'data_entry': 'http://sabiork.h-its.org/kineticLawEntry.jsp?viewData=true&amp;kinlawid=$id',
                             'example': '5046',
                             'name': 'SABIO-RK Kinetic Record',
                             'pattern': '^\\d+$',
                             'url': 'http://identifiers.org/sabiork.kineticrecord/'},
 'SABIO-RK Reaction': {'data_entry': 'http://sabiork.h-its.org/newSearch?q=sabioreactionid:$id',
                       'example': '75',
                       'name': 'SABIO-RK Reaction',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/sabiork.reaction/'},
 'SBML RDF Vocabulary': {'data_entry': 'http://biomodels.net/rdf/vocabulary.rdf#$id',
                         'example': 'rateRule',
                         'name': 'SBML RDF Vocabulary',
                         'pattern': '^[A-Za-z]+$',
                         'url': 'http://identifiers.org/biomodels.vocabulary/'},
 'SCOP': {'data_entry': 'http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?sunid=$id',
          'example': '47419',
          'name': 'SCOP',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/scop/'},
 'SEED Compound': {'data_entry': 'http://seed-viewer.theseed.org/seedviewer.cgi?page=CompoundViewer&amp;compound=$id',
                   'example': 'cpd15380',
                   'name': 'SEED Compound',
                   'pattern': '^cpd\\d+$',
                   'url': 'http://identifiers.org/seed.compound/'},
 'SEED Subsystem': {'data_entry': 'http://seed-viewer.theseed.org/seedviewer.cgi?page=Subsystems&amp;subsystem=$id',
                    'example': 'Biotin_biosynthesis',
                    'name': 'SEED Subsystem',
                    'pattern': '^\\w+$',
                    'url': 'http://identifiers.org/seed/'},
 'SGD': {'data_entry': 'http://www.yeastgenome.org/cgi-bin/locus.fpl?dbid=$id',
         'example': 'S000028457',
         'name': 'SGD',
         'pattern': '^((S\\d+$)|(Y[A-Z]{2}\\d{3}[a-zA-Z](\\-[A-Z])?))$" restricted="true',
         'url': 'http://identifiers.org/sgd/'},
 'SIDER Drug': {'data_entry': 'http://sideeffects.embl.de/drugs/$id/',
                'example': '2244',
                'name': 'SIDER Drug',
                'pattern': '^\\d+$" restricted="true',
                'url': 'http://identifiers.org/sider.drug/'},
 'SIDER Side Effect': {'data_entry': 'http://sideeffects.embl.de/se/$id/',
                       'example': 'C0017565',
                       'name': 'SIDER Side Effect',
                       'pattern': '^C\\d+$" restricted="true',
                       'url': 'http://identifiers.org/sider.effect/'},
 'SMART': {'data_entry': 'http://smart.embl-heidelberg.de/smart/do_annotation.pl?DOMAIN=$id',
           'example': 'SM00015',
           'name': 'SMART',
           'pattern': '^SM\\d{5}$',
           'url': 'http://identifiers.org/smart/'},
 'SNOMED CT': {'data_entry': 'http://www.snomedbrowser.com/Codes/Details/$id',
               'example': '284196006',
               'name': 'SNOMED CT',
               'pattern': '^(\\w+)?\\d+$" restricted="true',
               'url': 'http://identifiers.org/snomedct/'},
 'SPIKE Map': {'data_entry': 'http://www.cs.tau.ac.il/~spike/maps/$id.html',
               'example': 'spike00001',
               'name': 'SPIKE Map',
               'pattern': '^spike\\d{5}$',
               'url': 'http://identifiers.org/spike.map/'},
 'SPLASH': {'data_entry': 'http://mona.fiehnlab.ucdavis.edu/#/spectra/splash/$id',
            'example': 'splash10-0zq2000000-77302b0326a418630a84',
            'name': 'SPLASH',
            'pattern': '^splash\\d[A-Z-a-z0-9]-[A-Za-z0-9]+-[A-Za-z0-9]+$',
            'url': 'http://identifiers.org/splash/'},
 'STAP': {'data_entry': 'http://psb.kobic.re.kr/STAP/refinement1/result.php?search=$id',
          'example': '1a24',
          'name': 'STAP',
          'pattern': '^[0-9][A-Za-z0-9]{3}$',
          'url': 'http://identifiers.org/stap/'},
 'STITCH': {'data_entry': 'http://stitch.embl.de/interactions/$id',
            'example': 'BQJCRHHNABKAKU',
            'name': 'STITCH',
            'pattern': '^\\w{14}$" restricted="true',
            'url': 'http://identifiers.org/stitch/'},
 'STRING': {'data_entry': 'http://string.embl.de/interactions/$id',
            'example': 'P53350',
            'name': 'STRING',
            'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])|([0-9][A-Za-z0-9]{3})$" restricted="true',
            'url': 'http://identifiers.org/string/'},
 'SUPFAM': {'data_entry': 'http://supfam.org/SUPERFAMILY/cgi-bin/scop.cgi?ipid=$id',
            'example': 'SSF57615',
            'name': 'SUPFAM',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/supfam/'},
 'SWISS-MODEL': {'data_entry': 'http://swissmodel.expasy.org/repository/smr.php?sptr_ac=$id',
                 'example': 'P23298',
                 'name': 'SWISS-MODEL',
                 'pattern': '^\\w+$" restricted="true',
                 'url': 'http://identifiers.org/swiss-model/'},
 'Saccharomyces genome database pathways': {'data_entry': 'http://pathway.yeastgenome.org/YEAST/new-image?type=PATHWAY&amp;object=$id',
                                            'example': 'PWY3O-214',
                                            'name': 'Saccharomyces genome database pathways',
                                            'pattern': '^PWY\\w{2}\\-\\d{3}$',
                                            'url': 'http://identifiers.org/sgd.pathways/'},
 'ScerTF': {'data_entry': 'http://stormo.wustl.edu/ScerTF/details/$id/',
            'example': 'RSC3',
            'name': 'ScerTF',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/scretf/'},
 'Science Signaling Pathway': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                               'example': 'CMP_18019',
                               'name': 'Science Signaling Pathway',
                               'pattern': '^CMP_\\d+$" restricted="true',
                               'url': 'http://identifiers.org/sciencesignaling.path/'},
 'Science Signaling Pathway-Dependent Component': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                                                   'example': 'CMN_15494',
                                                   'name': 'Science Signaling Pathway-Dependent Component',
                                                   'pattern': '^CMN_\\d+$" restricted="true',
                                                   'url': 'http://identifiers.org/sciencesignaling.pdc/'},
 'Science Signaling Pathway-Independent Component': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                                                     'example': 'CMC_15493',
                                                     'name': 'Science Signaling Pathway-Independent Component',
                                                     'pattern': '^CMC_\\d+$" restricted="true',
                                                     'url': 'http://identifiers.org/sciencesignaling.pic/'},
 'Sequence Ontology': {'data_entry': 'http://www.sequenceontology.org/miso/current_release/term/$id',
                       'example': 'SO:0000704',
                       'name': 'Sequence Ontology',
                       'pattern': '^SO:\\d{7}$',
                       'url': 'http://identifiers.org/so/'},
 'Sequence Read Archive': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sra/$id?&amp;report=full',
                           'example': 'SRX000007',
                           'name': 'Sequence Read Archive',
                           'pattern': '^[SED]R[APRSXZ]\\d{6}',
                           'url': 'http://identifiers.org/insdc.sra/'},
 'Signaling Gateway': {'data_entry': 'http://www.signaling-gateway.org/molecule/query?afcsid=$id',
                       'example': 'A001094',
                       'name': 'Signaling Gateway',
                       'pattern': 'A\\d{6}$',
                       'url': 'http://identifiers.org/signaling-gateway/'},
 'SitEx': {'data_entry': 'http://www-bionet.sscc.ru/sitex/index.php?siteid=$id',
           'example': '1000',
           'name': 'SitEx',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/sitex/'},
 'Small Molecule Pathway Database': {'data_entry': 'http://smpdb.ca/view/$id',
                                     'example': 'SMP00001',
                                     'name': 'Small Molecule Pathway Database',
                                     'pattern': '^SMP\\d{5}$',
                                     'url': 'http://identifiers.org/smpdb/'},
 'Sol Genomics Network': {'data_entry': 'http://solgenomics.net/phenome/locus_display.pl?locus_id=$id',
                          'example': '0001',
                          'name': 'Sol Genomics Network',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/sgn/'},
 'SoyBase': {'data_entry': 'http://soybeanbreederstoolbox.org/search/search_results.php?category=SNP&amp;search_term=$id',
             'example': 'BARC-013845-01256',
             'name': 'SoyBase',
             'pattern': '^\\w+(\\-)?\\w+(\\-)?\\w+$',
             'url': 'http://identifiers.org/soybase/'},
 'Spectral Database for Organic Compounds': {'data_entry': 'http://riodb01.ibase.aist.go.jp/sdbs/cgi-bin/cre_frame_disp.cgi?sdbsno=$id',
                                             'example': '4544',
                                             'name': 'Spectral Database for Organic Compounds',
                                             'pattern': '\\d+$" restricted="true',
                                             'url': 'http://identifiers.org/sdbs/'},
 'SubstrateDB': {'data_entry': 'http://substrate.burnham.org/protein/annotation/$id/html',
                 'example': '1915',
                 'name': 'SubstrateDB',
                 'pattern': '^\\d+$',
                 'url': 'http://identifiers.org/pmap.substratedb/'},
 'SubtiList': {'data_entry': 'http://genolist.pasteur.fr/SubtiList/genome.cgi?external_query+$id',
               'example': 'BG11523',
               'name': 'SubtiList',
               'pattern': '^BG\\d+$',
               'url': 'http://identifiers.org/subtilist/'},
 'SubtiWiki': {'data_entry': 'http://www.subtiwiki.uni-goettingen.de/wiki/index.php/$id',
               'example': 'BSU29180',
               'name': 'SubtiWiki',
               'pattern': '^BSU\\d{5}$',
               'url': 'http://identifiers.org/subtiwiki/'},
 'SwissLipids': {'data_entry': 'http://www.swisslipids.org/#/entity/$id/',
                 'example': 'SLM:000048885',
                 'name': 'SwissLipids',
                 'pattern': '^SLM:\\d+$',
                 'url': 'http://identifiers.org/swisslipid/'},
 'Systems Biology Ontology': {'data_entry': 'http://www.ebi.ac.uk/sbo/main/$id',
                              'example': 'SBO:0000262',
                              'name': 'Systems Biology Ontology',
                              'pattern': '^SBO:\\d{7}$',
                              'url': 'http://identifiers.org/biomodels.sbo/'},
 'T3DB': {'data_entry': 'http://www.t3db.org/toxins/$id',
          'example': 'T3D0001',
          'name': 'T3DB',
          'pattern': '^T3D\\d+$',
          'url': 'http://identifiers.org/t3db/'},
 'TAIR Gene': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?accession=$id',
               'example': 'Gene:2200934',
               'name': 'TAIR Gene',
               'pattern': '^Gene:\\d{7}$',
               'url': 'http://identifiers.org/tair.gene/'},
 'TAIR Locus': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?type=locus&amp;name=$id',
                'example': 'AT1G01030',
                'name': 'TAIR Locus',
                'pattern': '^AT[1-5]G\\d{5}$',
                'url': 'http://identifiers.org/tair.locus/'},
 'TAIR Protein': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?accession=$id',
                  'example': 'AASequence:1009107926',
                  'name': 'TAIR Protein',
                  'pattern': '^AASequence:\\d{10}$',
                  'url': 'http://identifiers.org/tair.protein/'},
 'TEDDY': {'data_entry': 'http://purl.bioontology.org/ontology/TEDDY/$id',
           'example': 'TEDDY_0000066',
           'name': 'TEDDY',
           'pattern': '^TEDDY_\\d{7}$',
           'url': 'http://identifiers.org/biomodels.teddy/'},
 'TIGRFAMS': {'data_entry': 'http://www.jcvi.org/cgi-bin/tigrfams/HmmReportPage.cgi?acc=$id',
              'example': 'TIGR00010',
              'name': 'TIGRFAMS',
              'pattern': '^TIGR\\d+$',
              'url': 'http://identifiers.org/tigrfam/'},
 'TOPDB': {'data_entry': 'http://topdb.enzim.hu/?m=show&amp;id=$id',
           'example': 'AP00378',
           'name': 'TOPDB',
           'pattern': '^[A-Z0-9]+$',
           'url': 'http://identifiers.org/topdb/'},
 'TTD Drug': {'data_entry': 'http://bidd.nus.edu.sg/group/TTD/ZFTTDDRUG.asp?ID=$id',
              'example': 'DAP000773',
              'name': 'TTD Drug',
              'pattern': '^DAP\\d+$',
              'url': 'http://identifiers.org/ttd.drug/'},
 'TTD Target': {'data_entry': 'http://bidd.nus.edu.sg/group/TTD/ZFTTDDetail.asp?ID=$id',
                'example': 'TTDS00056',
                'name': 'TTD Target',
                'pattern': '^TTDS\\d+$',
                'url': 'http://identifiers.org/ttd.target/'},
 'TarBase': {'data_entry': 'http://diana.imis.athena-innovation.gr/DianaTools/index.php?r=tarbase/index&amp;mirnas=$id',
             'example': 'hsa-let-7a-2-3p',
             'name': 'TarBase',
             'pattern': '^[a-z]{3}\\-(mir|let|lin)\\-\\w+(\\-\\w+\\-\\w+)?',
             'url': 'http://identifiers.org/tarbase/'},
 'Taxonomy': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?mode=Info&amp;id=$id',
              'example': '9606',
              'name': 'Taxonomy',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/taxonomy/'},
 'Tetrahymena Genome Database': {'data_entry': 'http://ciliate.org/index.php/feature/details/$id',
                                 'example': 'TTHERM_00648910',
                                 'name': 'Tetrahymena Genome Database',
                                 'pattern': '^TTHERM\\_\\d+$',
                                 'url': 'http://identifiers.org/tgd/'},
 'Tissue List': {'data_entry': 'http://www.uniprot.org/tissues/$id',
                 'example': 'TS-0285',
                 'name': 'Tissue List',
                 'pattern': '^TS-\\d{4}$',
                 'url': 'http://identifiers.org/tissuelist/'},
 'TopFind': {'data_entry': 'http://clipserve.clip.ubc.ca/topfind/proteins/$id',
             'example': 'Q9UKQ2',
             'name': 'TopFind',
             'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
             'url': 'http://identifiers.org/topfind/'},
 'ToxoDB': {'data_entry': 'http://toxodb.org/toxo/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
            'example': 'TGME49_053730',
            'name': 'ToxoDB',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/toxoplasma/'},
 'Transport Classification Database': {'data_entry': 'http://www.tcdb.org/search/result.php?tc=$id',
                                       'example': '5.A.1.1.1',
                                       'name': 'Transport Classification Database',
                                       'pattern': '^\\d+\\.[A-Z]\\.\\d+\\.\\d+\\.\\d+$',
                                       'url': 'http://identifiers.org/tcdb/'},
 'Tree of Life': {'data_entry': 'http://tolweb.org/$id',
                  'example': '98034',
                  'name': 'Tree of Life',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/tol/'},
 'TreeBASE': {'data_entry': 'http://purl.org/phylo/treebase/phylows/study/$id?format=html',
              'example': 'TB2:S1000',
              'name': 'TreeBASE',
              'pattern': '^TB[1,2]?:[A-Z][a-z]?\\d+$',
              'url': 'http://identifiers.org/treebase/'},
 'TreeFam': {'data_entry': 'http://www.treefam.org/family/$id',
             'example': 'TF101014',
             'name': 'TreeFam',
             'pattern': '^\\w{1,2}\\d+$',
             'url': 'http://identifiers.org/treefam/'},
 'TriTrypDB': {'data_entry': 'http://tritrypdb.org/tritrypdb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
               'example': 'Tb927.8.620',
               'name': 'TriTrypDB',
               'pattern': '^\\w+(\\.)?\\w+(\\.)?\\w+',
               'url': 'http://identifiers.org/tritrypdb/'},
 'TrichDB': {'data_entry': 'http://trichdb.org/trichdb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
             'example': 'TVAG_386080',
             'name': 'TrichDB',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/trichdb/'},
 'UBERON': {'data_entry': 'http://purl.bioontology.org/ontology/UBERON/$id',
            'example': 'UBERON:0008203',
            'name': 'UBERON',
            'pattern': '^UBERON\\:\\d+$',
            'url': 'http://identifiers.org/uberon/'},
 'UM-BBD Biotransformation Rule': {'data_entry': 'http://www.umbbd.ethz.ch/servlets/rule.jsp?rule=$id',
                                   'example': 'bt0001',
                                   'name': 'UM-BBD Biotransformation Rule',
                                   'pattern': '^bt\\d+$',
                                   'url': 'http://identifiers.org/umbbd.rule/'},
 'UM-BBD Compound': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=c&amp;compID=$id',
                     'example': 'c0001',
                     'name': 'UM-BBD Compound',
                     'pattern': '^c\\d+$',
                     'url': 'http://identifiers.org/umbbd.compound/'},
 'UM-BBD Enzyme': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=ep&amp;enzymeID=$id',
                   'example': 'e0333',
                   'name': 'UM-BBD Enzyme',
                   'pattern': '^e\\d+$',
                   'url': 'http://identifiers.org/umbbd.enzyme/'},
 'UM-BBD Pathway': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=p&amp;pathway_abbr=$id',
                    'example': 'ala',
                    'name': 'UM-BBD Pathway',
                    'pattern': '^\\w+$',
                    'url': 'http://identifiers.org/umbbd.pathway/'},
 'UM-BBD Reaction': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=r&amp;reacID=$id',
                     'example': 'r0001',
                     'name': 'UM-BBD Reaction',
                     'pattern': '^r\\d+$',
                     'url': 'http://identifiers.org/umbbd.reaction/'},
 'UMLS': {'data_entry': 'http://linkedlifedata.com/resource/umls/id/$id',
          'example': 'C0021390',
          'name': 'UMLS',
          'pattern': '^C\\d+$" restricted="true',
          'url': 'http://identifiers.org/umls/'},
 'UNII': {'data_entry': 'http://fdasis.nlm.nih.gov/srs/srsdirect.jsp?regno=$id',
          'example': '3G6A5W338E',
          'name': 'UNII',
          'pattern': '^[A-Z0-9]+$',
          'url': 'http://identifiers.org/unii/'},
 'USPTO': {'data_entry': 'http://patft.uspto.gov/netacgi/nph-Parser?Sect2=PTO1&amp;Sect2=HITOFF&amp;p=1&amp;u=/netahtml/PTO/search-bool.html&amp;r=1&amp;f=G&amp;l=50&amp;d=PALL&amp;RefSrch=yes&amp;Query=PN/$id',
           'example': '4145692',
           'name': 'USPTO',
           'pattern': '^(D|PP|R|T|H|X|AI)?\\d+$',
           'url': 'http://identifiers.org/uspto/'},
 'UniGene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/UniGene/clust.cgi?UGID=$id',
             'example': '4900',
             'name': 'UniGene',
             'pattern': '^\\d+$" restricted="true',
             'url': 'http://identifiers.org/unigene/'},
 'UniParc': {'data_entry': 'http://www.ebi.ac.uk/cgi-bin/dbfetch?db=uniparc&amp;id=$id',
             'example': 'UPI000000000A',
             'name': 'UniParc',
             'pattern': '^UPI[A-F0-9]{10}$',
             'url': 'http://identifiers.org/uniparc/'},
 'UniPathway Compound': {'data_entry': 'http://www.grenoble.prabi.fr/obiwarehouse/unipathway/upc?upid=$id',
                         'example': 'UPC04349',
                         'name': 'UniPathway Compound',
                         'pattern': '^UPC\\d{5}$" restricted="true',
                         'url': 'http://identifiers.org/unipathway.compound/'},
 'UniPathway Reaction': {'data_entry': 'http://www.grenoble.prabi.fr/obiwarehouse/unipathway/ucr?upid=$id',
                         'example': 'UCR00226',
                         'name': 'UniPathway Reaction',
                         'pattern': '^UCR\\d{5}$" restricted="true',
                         'url': 'http://identifiers.org/unipathway.reaction/'},
 'UniProt Isoform': {'data_entry': 'http://www.uniprot.org/uniprot/$id',
                     'example': 'Q5BJF6-3',
                     'name': 'UniProt Isoform',
                     'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(\\-\\d+)$" restricted="true',
                     'url': 'http://identifiers.org/uniprot.isoform/'},
 'UniProt Knowledgebase': {'data_entry': 'http://www.uniprot.org/uniprot/$id',
                           'example': 'P62158',
                           'name': 'UniProt Knowledgebase',
                           'pattern': '^([A-N,R-Z][0-9]([A-Z][A-Z, 0-9][A-Z, 0-9][0-9]){1,2})|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(\\.\\d+)?$',
                           'url': 'http://identifiers.org/uniprot/'},
 'UniSTS': {'data_entry': 'http://www.ncbi.nlm.nih.gov/genome/sts/sts.cgi?uid=$id',
            'example': '456789',
            'name': 'UniSTS',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/unists/'},
 'Unimod': {'data_entry': 'http://www.unimod.org/modifications_view.php?editid1=$id',
            'example': '1200',
            'name': 'Unimod',
            'pattern': '^\\d+$" restricted="true',
            'url': 'http://identifiers.org/unimod/'},
 'Unipathway': {'data_entry': 'http://www.grenoble.prabi.fr/obiwarehouse/unipathway/upa?upid=$id',
                'example': 'UPA00206',
                'name': 'Unipathway',
                'pattern': '^UPA\\d{5}$',
                'url': 'http://identifiers.org/unipathway/'},
 'Unit Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                   'example': 'UO:0000080',
                   'name': 'Unit Ontology',
                   'pattern': '^UO:\\d{7}?',
                   'url': 'http://identifiers.org/unit/'},
 'Unite': {'data_entry': 'http://unite.ut.ee/bl_forw.php?nimi=$id',
           'example': 'UDB000691',
           'name': 'Unite',
           'pattern': '^UDB\\d{6}$',
           'url': 'http://identifiers.org/unite/'},
 'VBRC': {'data_entry': 'http://vbrc.org/gene_detail.asp?gene_id=$id',
          'example': '35742',
          'name': 'VBRC',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/vbrc/'},
 'VFDB Gene': {'data_entry': 'http://www.mgc.ac.cn/cgi-bin/VFs/gene.cgi?GeneID=$id',
               'example': 'VFG2154',
               'name': 'VFDB Gene',
               'pattern': '^\\w+$',
               'url': 'http://identifiers.org/vfdb.gene/'},
 'VFDB Genus': {'data_entry': 'http://www.mgc.ac.cn/cgi-bin/VFs/genus.cgi?Genus=$id',
                'example': 'Chlamydia',
                'name': 'VFDB Genus',
                'pattern': '^\\w+$',
                'url': 'http://identifiers.org/vfdb.genus/'},
 'VIRsiRNA': {'data_entry': 'http://crdd.osdd.net/servers/virsirnadb/record.php?details=$id',
              'example': 'virsi1909',
              'name': 'VIRsiRNA',
              'pattern': '^virsi\\d+$',
              'url': 'http://identifiers.org/virsirna/'},
 'VariO': {'data_entry': 'http://www.variationontology.org/cgi-bin/amivario/term-details.cgi?term=$id',
           'example': 'VariO:0294',
           'name': 'VariO',
           'pattern': '^VariO:\\d+$',
           'url': 'http://identifiers.org/vario/'},
 'Vbase2': {'data_entry': 'http://www.vbase2.org/vgene.php?id=$id',
            'example': 'humIGHV025',
            'name': 'Vbase2',
            'pattern': '^\\w+$" restricted="true',
            'url': 'http://identifiers.org/vbase2/'},
 'VectorBase': {'data_entry': 'https://www.vectorbase.org/search/site/$id?&amp;site=&quot;Genome&quot;',
                'example': 'ISCW007415',
                'name': 'VectorBase',
                'pattern': '^\\D{4}\\d{6}(\\-\\D{2})?$',
                'url': 'http://identifiers.org/vectorbase/'},
 'ViPR Strain': {'data_entry': 'http://www.viprbrc.org/brc/viprStrainDetails.do?strainName=$id&amp;decorator=arena',
                 'example': 'BeAn 70563',
                 'name': 'ViPR Strain',
                 'pattern': '^[A-Za-z 0-9]+$',
                 'url': 'http://identifiers.org/vipr/'},
 'ViralZone': {'data_entry': 'http://viralzone.expasy.org/all_by_protein/$id.html',
               'example': '992',
               'name': 'ViralZone',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/viralzone/'},
 'WikiGenes': {'data_entry': 'http://www.wikigenes.org/e/gene/e/$id.html',
               'example': '3771877',
               'name': 'WikiGenes',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/wikigenes/'},
 'WikiPathways': {'data_entry': 'http://www.wikipathways.org/instance/$id',
                  'example': 'WP100',
                  'name': 'WikiPathways',
                  'pattern': 'WP\\d{1,5}(\\_r\\d+)?$',
                  'url': 'http://identifiers.org/wikipathways/'},
 'Wikidata': {'data_entry': 'https://www.wikidata.org/wiki/$id',
              'example': 'Q2207226',
              'name': 'Wikidata',
              'pattern': '^Q\\d+$',
              'url': 'http://identifiers.org/wikidata/'},
 'Wikipedia (En)': {'data_entry': 'http://en.wikipedia.org/wiki/$id',
                    'example': 'SM_UB-81',
                    'name': 'Wikipedia (En)',
                    'pattern': '^[A-Za-z-0-9_]+$" restricted="true',
                    'url': 'http://identifiers.org/wikipedia.en/'},
 'Worfdb': {'data_entry': 'http://worfdb.dfci.harvard.edu/index.php?search_type=name&amp;page=showresultrc&amp;race_query=$id',
            'example': 'T01B6.1',
            'name': 'Worfdb',
            'pattern': '^\\w+(\\.\\d+)?',
            'url': 'http://identifiers.org/worfdb/'},
 'WormBase': {'data_entry': 'http://www.wormbase.org/db/gene/gene?name=$id;class=Gene',
              'example': 'WBGene00000001',
              'name': 'WormBase',
              'pattern': '^(WBGene\\d{8}|([A-Z_a-z0-9]+(\\.)?(t)?(\\d+)?([a-z])?))$" restricted="true',
              'url': 'http://identifiers.org/wormbase/'},
 'WormBase RNAi': {'data_entry': 'http://www.wormbase.org/species/c_elegans/rnai/$id',
                   'example': 'WBRNAi00086878',
                   'name': 'WormBase RNAi',
                   'pattern': '^WBRNAi\\d{8}$',
                   'url': 'http://identifiers.org/wormbase.rnai/'},
 'Wormpep': {'data_entry': 'http://www.wormbase.org/db/seq/protein?name=WP:$id',
             'example': 'CE28239',
             'name': 'Wormpep',
             'pattern': '^CE\\d{5}$',
             'url': 'http://identifiers.org/wormpep/'},
 'Xenbase': {'data_entry': 'http://www.xenbase.org/gene/showgene.do?method=displayGeneSummary&amp;geneId=$id',
             'example': '922462',
             'name': 'Xenbase',
             'pattern': '^(XB-GENE-)?\\d+$',
             'url': 'http://identifiers.org/xenbase/'},
 'YDPM': {'data_entry': 'http://www-deletion.stanford.edu/cgi-bin/YDPM/YDPM_search.cgi?thelist=$id',
          'example': 'YAL001C',
          'name': 'YDPM',
          'pattern': '^Y[A-Z]{2}\\d+[CW]$',
          'url': 'http://identifiers.org/ydpm/'},
 'YRC PDR': {'data_entry': 'http://yeastrc.org/pdr/viewProtein.do?id=$id',
             'example': '2673500',
             'name': 'YRC PDR',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/yrcpdr/'},
 'YeTFasCo': {'data_entry': 'http://yetfasco.ccbr.utoronto.ca/showPFM.php?mot=$id',
              'example': 'YOR172W_571.0',
              'name': 'YeTFasCo',
              'pattern': '^\\w+\\_\\d+(\\.\\d+)?$',
              'url': 'http://identifiers.org/yetfasco/'},
 'Yeast Intron Database v3': {'data_entry': 'http://metarray.ucsc.edu/cgi-bin/intron/yirIntrondb?orfName=$id',
                              'example': 'SNR17A',
                              'name': 'Yeast Intron Database v3',
                              'pattern': '^[A-Z0-9]+$',
                              'url': 'http://identifiers.org/yid/'},
 'Yeast Intron Database v4.3': {'data_entry': 'http://intron.ucsc.edu/cgi-bin/yeast4.3/intronreports.pl?outputformat=full&amp;amp;orfName=$id',
                                'example': 'SNR17A',
                                'name': 'Yeast Intron Database v4.3',
                                'pattern': '^[A-Z0-9]+$',
                                'url': 'http://identifiers.org/yeastintron/'},
 'ZFIN Expression': {'data_entry': 'http://zfin.org/$id',
                     'example': 'ZDB-GENO-980202-899',
                     'name': 'ZFIN Expression',
                     'pattern': '^ZDB\\-GEN0\\-\\d+\\-\\d+$',
                     'url': 'http://identifiers.org/zfin.expression/'},
 'ZFIN Gene': {'data_entry': 'http://zfin.org/$id',
               'example': 'ZDB-GENE-041118-11',
               'name': 'ZFIN Gene',
               'pattern': 'ZDB\\-GENE\\-\\d+\\-\\d+',
               'url': 'http://identifiers.org/zfin/'},
 'ZFIN Phenotype': {'data_entry': 'http://zfin.org/$id',
                    'example': 'ZDB-GENO-980202-899',
                    'name': 'ZFIN Phenotype',
                    'pattern': '^ZDB\\-GEN0\\-\\d+\\-\\d+$',
                    'url': 'http://identifiers.org/zfin.phenotype/'},
 'ZINC': {'data_entry': 'http://zinc.docking.org/substance/$id',
          'example': 'ZINC1084',
          'name': 'ZINC',
          'pattern': '^(ZINC)?\\d+$',
          'url': 'http://identifiers.org/zinc/'},
 'arXiv': {'data_entry': 'http://arxiv.org/abs/$id',
           'example': '0807.4956v1',
           'name': 'arXiv',
           'pattern': '^(\\w+(\\-\\w+)?(\\.\\w+)?/)?\\d{4,7}(\\.\\d{4}(v\\d+)?)?$',
           'url': 'http://identifiers.org/arxiv/'},
 'dbEST': {'data_entry': 'http://www.ncbi.nlm.nih.gov/nucest/$id',
           'example': 'BP100000',
           'name': 'dbEST',
           'pattern': '^([A-Z]+)?\\d+(\\.\\d+)?$',
           'url': 'http://identifiers.org/dbest/'},
 'dbProbe': {'data_entry': 'http://www.ncbi.nlm.nih.gov/probe/?term=$id',
             'example': '1000000',
             'name': 'dbProbe',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/dbprobe/'},
 'dbSNP': {'data_entry': 'http://www.ncbi.nlm.nih.gov/projects/SNP/snp_ref.cgi?rs=$id',
           'example': '121909098',
           'name': 'dbSNP',
           'pattern': '^rs\\d+$',
           'url': 'http://identifiers.org/dbsnp/'},
 'eggNOG': {'data_entry': 'http://eggnog.embl.de/version_3.0/cgi/search.py?search_term_0=$id',
            'example': 'veNOG12876',
            'name': 'eggNOG',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/eggnog/'},
 'iRefWeb': {'data_entry': 'http://wodaklab.org/iRefWeb/interaction/show/$id',
             'example': '617102',
             'name': 'iRefWeb',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/irefweb/'},
 'miRBase Sequence': {'data_entry': 'http://www.mirbase.org/cgi-bin/mirna_entry.pl?acc=$id',
                      'example': 'MI0000001',
                      'name': 'miRBase Sequence',
                      'pattern': 'MI\\d{7}',
                      'url': 'http://identifiers.org/mirbase/'},
 'miRBase mature sequence': {'data_entry': 'http://www.mirbase.org/cgi-bin/mature.pl?mature_acc=$id',
                             'example': 'MIMAT0000001',
                             'name': 'miRBase mature sequence',
                             'pattern': 'MIMAT\\d{7}',
                             'url': 'http://identifiers.org/mirbase.mature/'},
 'miRNEST': {'data_entry': 'http://rhesus.amu.edu.pl/mirnest/copy/details.php?id=$id',
             'example': 'MNEST029358',
             'name': 'miRNEST',
             'pattern': '^MNEST\\d+$',
             'url': 'http://identifiers.org/mirnest/'},
 'miRTarBase': {'data_entry': 'http://mirtarbase.mbc.nctu.edu.tw/php/detail.php?mirtid=$id',
                'example': 'MIRT000002',
                'name': 'miRTarBase',
                'pattern': '^MIRT\\d{6}$',
                'url': 'http://identifiers.org/mirtarbase/'},
 'mirEX': {'data_entry': 'http://comgen.pl/mirex1/?page=results/record&amp;name=$id&amp;exref=pp2a&amp;limit=yes',
           'example': '165a',
           'name': 'mirEX',
           'pattern': '^\\d+(\\w+)?$',
           'url': 'http://identifiers.org/mirex/'},
 'nextProt': {'data_entry': 'http://www.nextprot.org/db/entry/$id',
              'example': 'NX_O00165',
              'name': 'nextProt',
              'pattern': '^NX_\\w+',
              'url': 'http://identifiers.org/nextprot/'},
 'uBio NameBank': {'data_entry': 'http://www.ubio.org/browser/details.php?namebankID=$id',
                   'example': '2555646',
                   'name': 'uBio NameBank',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/ubio.namebank/'}}
