# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CognitiveServicesAccountCreateParameters(Model):
    """The parameters to provide for the account.

    :param sku:
    :type sku: :class:`Sku <azure.mgmt.cognitiveservices.models.Sku>`
    :param kind: Required. Indicates the type of cognitive service account.
     Possible values include: 'ComputerVision', 'Emotion', 'Face', 'LUIS',
     'Recommendations', 'Speech', 'TextAnalytics', 'WebLM'
    :type kind: str or :class:`Kind
     <azure.mgmt.cognitiveservices.models.Kind>`
    :param location: Required. Gets or sets the location of the resource.
     This will be one of the supported and registered Azure Geo Regions (e.g.
     West US, East US, Southeast Asia, etc.). The geo region of a resource
     cannot be changed once it is created, but if an identical geo region is
     specified on update the request will succeed.
    :type location: str
    :param tags: Gets or sets a list of key value pairs that describe the
     resource. These tags can be used in viewing and grouping this resource
     (across resource groups). A maximum of 15 tags can be provided for a
     resource. Each tag must have a key no greater than 128 characters and
     value no greater than 256 characters.
    :type tags: dict
    :param properties: Must exist in the request. Must not be null.
    :type properties: object
    """ 

    _validation = {
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'Kind'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, sku, kind, location, properties, tags=None):
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.properties = properties
