# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TimerTriggerUpdateParameters(Model):
    """The properties for updating a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :param schedule: The CRON expression for the task schedule
    :type schedule: str
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_04_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TimerTriggerUpdateParameters, self).__init__(**kwargs)
        self.schedule = kwargs.get('schedule', None)
        self.status = kwargs.get('status', "Enabled")
        self.name = kwargs.get('name', None)
