# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RecommendedIndex(Resource):
    """Represents a database recommended index.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar id: Resource ID
    :vartype id: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar action: The proposed index action. You can create a missing index,
     drop an unused index, or rebuild an existing index to improve its
     performance. Possible values include: 'Create', 'Drop', 'Rebuild'
    :vartype action: str or :class:`RecommendedIndexActions
     <azure.mgmt.sql.models.RecommendedIndexActions>`
    :ivar state: The current recommendation state. Possible values include:
     'Active', 'Pending', 'Executing', 'Verifying', 'Pending Revert',
     'Reverting', 'Reverted', 'Ignored', 'Expired', 'Blocked', 'Success'
    :vartype state: str or :class:`RecommendedIndexStates
     <azure.mgmt.sql.models.RecommendedIndexStates>`
    :ivar created: The UTC datetime showing when this resource was created
     (ISO8601 format).
    :vartype created: datetime
    :ivar last_modified: The UTC datetime of when was this resource last
     changed (ISO8601 format).
    :vartype last_modified: datetime
    :ivar index_type: The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE,
     CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED',
     'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTERED COLUMNSTORE'
    :vartype index_type: str or :class:`RecommendedIndexTypes
     <azure.mgmt.sql.models.RecommendedIndexTypes>`
    :ivar schema: The schema where table to build index over resides
    :vartype schema: str
    :ivar table: The table on which to build index.
    :vartype table: str
    :ivar columns: Columns over which to build index
    :vartype columns: list of str
    :ivar included_columns: The list of column names to be included in the
     index
    :vartype included_columns: list of str
    :ivar index_script: The full build index script
    :vartype index_script: str
    :ivar estimated_impact: The estimated impact of doing recommended index
     action.
    :vartype estimated_impact: list of :class:`OperationImpact
     <azure.mgmt.sql.models.OperationImpact>`
    :ivar reported_impact: The values reported after index action is complete.
    :vartype reported_impact: list of :class:`OperationImpact
     <azure.mgmt.sql.models.OperationImpact>`
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'action': {'readonly': True},
        'state': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'index_type': {'readonly': True},
        'schema': {'readonly': True},
        'table': {'readonly': True},
        'columns': {'readonly': True},
        'included_columns': {'readonly': True},
        'index_script': {'readonly': True},
        'estimated_impact': {'readonly': True},
        'reported_impact': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'action': {'key': 'properties.action', 'type': 'RecommendedIndexActions'},
        'state': {'key': 'properties.state', 'type': 'RecommendedIndexStates'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'index_type': {'key': 'properties.indexType', 'type': 'RecommendedIndexTypes'},
        'schema': {'key': 'properties.schema', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'columns': {'key': 'properties.columns', 'type': '[str]'},
        'included_columns': {'key': 'properties.includedColumns', 'type': '[str]'},
        'index_script': {'key': 'properties.indexScript', 'type': 'str'},
        'estimated_impact': {'key': 'properties.estimatedImpact', 'type': '[OperationImpact]'},
        'reported_impact': {'key': 'properties.reportedImpact', 'type': '[OperationImpact]'},
    }

    def __init__(self, location, tags=None):
        super(RecommendedIndex, self).__init__(location=location, tags=tags)
        self.action = None
        self.state = None
        self.created = None
        self.last_modified = None
        self.index_type = None
        self.schema = None
        self.table = None
        self.columns = None
        self.included_columns = None
        self.index_script = None
        self.estimated_impact = None
        self.reported_impact = None
