/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared.protocol;

import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.protocol.HttpTransmitter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.List;

public class Transport {
    private Transport() {
    }

    public static void transfer(Object dataObject, HttpTransmitter httpTransmitter) {
        if (!httpTransmitter.isSecure()) {
            throw new SecurityException("applet service connection not trusted");
        }
        Class<?> dataClass = dataObject.getClass();
        Field[] fields = dataClass.getFields();
        try {
            Transport.inputValidation(dataObject, fields);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error: " + e.getMessage(), e);
        }
        Field bodyField = Transport.addHeaders(dataObject, httpTransmitter, fields);
        Transport.addBody(dataObject, httpTransmitter, bodyField);
    }

    private static void addBody(Object dataObject, HttpTransmitter httpTransmitter, Field bodyField) {
        if (null != bodyField) {
            byte[] body;
            Object bodyValue;
            try {
                bodyValue = bodyField.get(dataObject);
            }
            catch (Exception e) {
                throw new RuntimeException("error reading field: " + bodyField.getName());
            }
            if (bodyValue instanceof List) {
                List bodyList = (List)bodyValue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(baos);
                for (String bodyStr : bodyList) {
                    printStream.println(bodyStr);
                }
                body = baos.toByteArray();
            } else {
                body = (byte[])bodyValue;
            }
            httpTransmitter.addHeader("Content-Length", Integer.toString(body.length));
            httpTransmitter.setBody(body);
        } else {
            httpTransmitter.addHeader("Content-Length", "0");
        }
    }

    private static Field addHeaders(Object dataObject, HttpTransmitter httpTransmitter, Field[] fields) {
        Field bodyField = null;
        for (Field field : fields) {
            String httpHeaderValue;
            Object fieldValue;
            HttpHeader httpHeaderAnnotation;
            HttpBody httpBodyAnnotation = field.getAnnotation(HttpBody.class);
            if (null != httpBodyAnnotation) {
                if (null == bodyField) {
                    bodyField = field;
                } else {
                    throw new RuntimeException("multiple @HttpBody fields detected");
                }
            }
            if (null == (httpHeaderAnnotation = field.getAnnotation(HttpHeader.class))) continue;
            try {
                fieldValue = field.get(dataObject);
            }
            catch (Exception e) {
                throw new RuntimeException("error reading field: " + field.getName());
            }
            if (null == fieldValue) continue;
            String httpHeaderName = httpHeaderAnnotation.value();
            if (String.class.equals(field.getType())) {
                httpHeaderValue = (String)fieldValue;
            } else if (Integer.TYPE.equals(field.getType()) || Integer.class.equals(field.getType())) {
                httpHeaderValue = ((Integer)fieldValue).toString();
            } else if (Boolean.TYPE.equals(field.getType()) || Boolean.class.equals(field.getType())) {
                httpHeaderValue = ((Boolean)fieldValue).toString();
            } else if (field.getType().isEnum()) {
                httpHeaderValue = ((Enum)fieldValue).name();
            } else {
                throw new RuntimeException("unsupported field type: " + field.getType().getName());
            }
            httpTransmitter.addHeader(httpHeaderName, httpHeaderValue);
        }
        return bodyField;
    }

    private static void inputValidation(Object dataObject, Field[] fields) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : fields) {
            Object fieldValue;
            NotNull notEmptyAnnotation = field.getAnnotation(NotNull.class);
            if (null == notEmptyAnnotation || null != (fieldValue = field.get(dataObject))) continue;
            throw new IllegalArgumentException("input validation error: empty field: " + field.getName());
        }
    }
}

