/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared;

import be.fedict.eid.applet.shared.AbstractProtocolMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.annotation.Description;
import be.fedict.eid.applet.shared.annotation.HttpBody;
import be.fedict.eid.applet.shared.annotation.HttpHeader;
import be.fedict.eid.applet.shared.annotation.MessageDiscriminator;
import be.fedict.eid.applet.shared.annotation.NotNull;
import be.fedict.eid.applet.shared.annotation.PostConstruct;
import be.fedict.eid.applet.shared.annotation.ProtocolStateAllowed;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResponsesAllowed(value={FinishedMessage.class})
@ProtocolStateAllowed(value=ProtocolState.AUTHENTICATE)
public class AuthenticationDataMessage
extends AbstractProtocolMessage {
    @HttpHeader(value="X-AppletProtocol-Type")
    @MessageDiscriminator
    public static final String TYPE = AuthenticationDataMessage.class.getSimpleName();
    @HttpHeader(value="X-AppletProtocol-SignatureValueSize")
    @NotNull
    public Integer signatureValueSize;
    @HttpHeader(value="X-AppletProtocol-SaltValueSize")
    @NotNull
    public Integer saltValueSize;
    @HttpHeader(value="X-AppletProtocol-SessionIdSize")
    public Integer sessionIdSize;
    @HttpHeader(value="X-AppletProtocol-AuthnCertFileSize")
    @NotNull
    public Integer authnCertFileSize;
    @HttpHeader(value="X-AppletProtocol-CaCertFileSize")
    @NotNull
    public Integer caCertFileSize;
    @HttpHeader(value="X-AppletProtocol-RootCaCertFileSize")
    @NotNull
    public Integer rootCertFileSize;
    @HttpHeader(value="X-AppletProtocol-SignCertFileSize")
    public Integer signCertFileSize;
    @HttpHeader(value="X-AppletProtocol-IdentityFileSize")
    public Integer identityFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressFileSize")
    public Integer addressFileSize;
    @HttpHeader(value="X-AppletProtocol-PhotoFileSize")
    public Integer photoFileSize;
    @HttpHeader(value="X-AppletProtocol-IdentitySignatureFileSize")
    public Integer identitySignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-AddressSignatureFileSize")
    public Integer addressSignatureFileSize;
    @HttpHeader(value="X-AppletProtocol-NationalRegistryCertFileSize")
    public Integer rrnCertFileSize;
    @HttpHeader(value="X-AppletProtocol-ServerCertFileSize")
    public Integer serverCertFileSize;
    @HttpHeader(value="X-AppletProtocol-TransactionMessageSignatureSize")
    public Integer transactionMessageSignatureSize;
    @HttpBody
    @NotNull
    @Description(value="Contains concatenation of salt value, optional session id, signature value, and authn cert chain.")
    public byte[] body;
    public byte[] saltValue;
    public byte[] sessionId;
    public byte[] signatureValue;
    public X509Certificate authnCert;
    public X509Certificate citizenCaCert;
    public X509Certificate rootCaCert;
    public X509Certificate signCert;
    public byte[] identityData;
    public byte[] addressData;
    public byte[] photoData;
    public byte[] identitySignatureData;
    public byte[] addressSignatureData;
    public X509Certificate rrnCertificate;
    public X509Certificate serverCertificate;
    public byte[] transactionMessageSignature;

    public AuthenticationDataMessage() {
    }

    public AuthenticationDataMessage(byte[] saltValue, byte[] sessionId, byte[] signatureValue, byte[] authnCertFile, byte[] citCaCertFile, byte[] rootCaCertFile, byte[] signCertFile, byte[] identityData, byte[] addressData, byte[] photoData, byte[] identitySignatureData, byte[] addressSignatureData, byte[] rrnCertData, byte[] serverCertData, byte[] transactionMessageSignature) throws IOException, CertificateEncodingException {
        this.saltValueSize = saltValue.length;
        this.signatureValueSize = signatureValue.length;
        this.authnCertFileSize = authnCertFile.length;
        this.caCertFileSize = citCaCertFile.length;
        this.rootCertFileSize = rootCaCertFile.length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(saltValue);
        if (null != sessionId) {
            this.sessionIdSize = sessionId.length;
            baos.write(sessionId);
        }
        baos.write(signatureValue);
        baos.write(authnCertFile);
        baos.write(citCaCertFile);
        baos.write(rootCaCertFile);
        if (null != signCertFile) {
            this.signCertFileSize = signCertFile.length;
            baos.write(signCertFile);
        }
        if (null != identityData) {
            baos.write(identityData);
            this.identityFileSize = identityData.length;
        }
        if (null != addressData) {
            baos.write(addressData);
            this.addressFileSize = addressData.length;
        }
        if (null != photoData) {
            baos.write(photoData);
            this.photoFileSize = photoData.length;
        }
        if (null != identitySignatureData) {
            baos.write(identitySignatureData);
            this.identitySignatureFileSize = identitySignatureData.length;
        }
        if (null != addressSignatureData) {
            baos.write(addressSignatureData);
            this.addressSignatureFileSize = addressSignatureData.length;
        }
        if (null != rrnCertData) {
            baos.write(rrnCertData);
            this.rrnCertFileSize = rrnCertData.length;
        }
        if (null != serverCertData) {
            baos.write(serverCertData);
            this.serverCertFileSize = serverCertData.length;
        }
        if (null != transactionMessageSignature) {
            baos.write(transactionMessageSignature);
            this.transactionMessageSignatureSize = transactionMessageSignature.length;
        }
        this.body = baos.toByteArray();
    }

    public AuthenticationDataMessage(byte[] saltValue, byte[] sessionId, byte[] signatureValue, List<X509Certificate> authnCertChain, byte[] signCertFile, byte[] identityData, byte[] addressData, byte[] photoData, byte[] identitySignatureData, byte[] addressSignatureData, byte[] rrnCertData, byte[] serverCertData, byte[] transactionMessageSignature) throws IOException, CertificateEncodingException {
        this(saltValue, sessionId, signatureValue, authnCertChain.get(0).getEncoded(), authnCertChain.get(1).getEncoded(), authnCertChain.get(2).getEncoded(), signCertFile, identityData, addressData, photoData, identitySignatureData, addressSignatureData, rrnCertData, serverCertData, transactionMessageSignature);
    }

    private byte[] copy(byte[] source, int idx, int count) {
        byte[] result = new byte[count];
        System.arraycopy(source, idx, result, 0, count);
        return result;
    }

    @PostConstruct
    public void postConstruct() {
        int idx = 0;
        if (0 == this.saltValueSize) {
            throw new RuntimeException("salt bytes required");
        }
        this.saltValue = this.copy(this.body, idx, this.saltValueSize);
        idx += this.saltValueSize.intValue();
        if (null != this.sessionIdSize) {
            this.sessionId = this.copy(this.body, idx, this.sessionIdSize);
            idx += this.sessionIdSize.intValue();
        }
        this.signatureValue = this.copy(this.body, idx, this.signatureValueSize);
        byte[] authnCertFile = this.copy(this.body, idx += this.signatureValueSize.intValue(), this.authnCertFileSize);
        this.authnCert = this.getCertificate(authnCertFile);
        byte[] citizenCaCertFile = this.copy(this.body, idx += this.authnCertFileSize.intValue(), this.caCertFileSize);
        this.citizenCaCert = this.getCertificate(citizenCaCertFile);
        byte[] rootCaCertFile = this.copy(this.body, idx += this.caCertFileSize.intValue(), this.rootCertFileSize);
        idx += this.rootCertFileSize.intValue();
        this.rootCaCert = this.getCertificate(rootCaCertFile);
        if (null != this.signCertFileSize) {
            byte[] signCertFile = this.copy(this.body, idx, this.signCertFileSize);
            idx += this.signCertFileSize.intValue();
            this.signCert = this.getCertificate(signCertFile);
        }
        if (null != this.identityFileSize) {
            this.identityData = this.copy(this.body, idx, this.identityFileSize);
            idx += this.identityFileSize.intValue();
        }
        if (null != this.addressFileSize) {
            this.addressData = this.copy(this.body, idx, this.addressFileSize);
            idx += this.addressFileSize.intValue();
        }
        if (null != this.photoFileSize) {
            this.photoData = this.copy(this.body, idx, this.photoFileSize);
            idx += this.photoFileSize.intValue();
        }
        if (null != this.identitySignatureFileSize) {
            this.identitySignatureData = this.copy(this.body, idx, this.identitySignatureFileSize);
            idx += this.identitySignatureFileSize.intValue();
        }
        if (null != this.addressSignatureFileSize) {
            this.addressSignatureData = this.copy(this.body, idx, this.addressSignatureFileSize);
            idx += this.addressSignatureFileSize.intValue();
        }
        if (null != this.rrnCertFileSize) {
            byte[] rrnCertData = this.copy(this.body, idx, this.rrnCertFileSize);
            this.rrnCertificate = this.getCertificate(rrnCertData);
            idx += this.rrnCertFileSize.intValue();
        }
        if (null != this.serverCertFileSize) {
            byte[] serverCertData = this.copy(this.body, idx, this.serverCertFileSize);
            this.serverCertificate = this.getCertificate(serverCertData);
            idx += this.serverCertFileSize.intValue();
        }
        if (null != this.transactionMessageSignatureSize) {
            this.transactionMessageSignature = this.copy(this.body, idx, this.transactionMessageSignatureSize);
            idx += this.transactionMessageSignatureSize.intValue();
        }
    }

    private X509Certificate getCertificate(byte[] certData) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("cert factory error: " + e.getMessage(), e);
        }
        try {
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certData));
            return certificate;
        }
        catch (CertificateException e) {
            return null;
        }
    }
}

