#~ pyaeso is a python package that makes access to the Alberta, Canada's
#~ Electric System Operator's (AESO) Energy Trading System (ETS) easier.

#~ Copyright (C) 2009 Keegan Callin

#~ This program is free software: you can redistribute it and/or modify
#~ it under the terms of the GNU General Public License as published by
#~ the Free Software Foundation, either version 3 of the License, or
#~ (at your option) any later version.

#~ This program is distributed in the hope that it will be useful,
#~ but WITHOUT ANY WARRANTY; without even the implied warranty of
#~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#~ GNU General Public License for more details.

#~ You should have received a copy of the GNU General Public License
#~ along with this program.  If not, see
#~ <http://www.gnu.org/licenses/gpl-3.0.html>.

from distutils.core import setup

NAME = 'pybctc'
VERSION = '0.1.2'
DOWNLOAD_URL = 'http://pypi.python.org/pypi/pybctc'

def long_description():
    f = open('README.txt')
    text = f.read()
    f.close()
    return text


DESCRIPTION = "Pythonic access to the British Columbia[, Canada,] Transmission Corporation (BCTC) public electric data."
LONG_DESCRIPTION = long_description()
CLASSIFIERS = [
    "Programming Language :: Python",
    "Programming Language :: Python :: 2.4",
    "Programming Language :: Python :: 2.5",
    "Programming Language :: Python :: 2.6",
    "Development Status :: 3 - Alpha",
    "Intended Audience :: Developers",
    "Intended Audience :: Science/Research",
    "License :: OSI Approved :: GNU General Public License (GPL)",
    "Operating System :: OS Independent",
    "Topic :: Software Development :: Libraries :: Python Modules",
]


setup(
    name = NAME,
    packages = ['bctc'],
    version = VERSION,
    description = DESCRIPTION,
    author = "Keegan Callin",
    author_email = "kc@kcallin.net",
    url = "http://bitbucket.org/kc/pybctc/wiki/Home",
    download_url = DOWNLOAD_URL,
    keywords = [],
    license = 'GNU General Public License Version 3 (GPLv3)',
    requires=['pytz', 'xlrd'],
    classifiers = CLASSIFIERS,
    long_description = LONG_DESCRIPTION
)
