"""Here lie all the tests for small stuff that's changed in doctest2.

Global Directives
=================

The tests for these are found in DoctestGlobalDirectives.
Considering the nature of the test, in here all we'll do is make sure
the correct number of tests are executed.

    >>> from doctest2 import run_docstring_examples
    >>> results =  run_docstring_examples(DoctestGlobalDirectives, {})
    >>> results.attempted
    6
    >>> results2 =  run_docstring_examples(
    ...     DoctestGlobalDirectivePrecedence, {})
    >>> results2.attempted
    4

Just as a note, the intended use is far less arcane than these tests. The
tests are for the extremes. This is really just to specify some stuff that
will apply for the rest of the tests. Remember, readability matters.

Specifically, I'm aiming more for you to use it like this:

    >>> print(1, 2, 3, 4) #doctest: +!ELLIPSIS
    1 2 ... 4
    >>> print (3)
    3...
    >>> # ... more tests ...

Where before, maybe you used

    >>> print(1, 2, 3, 4) #doctest: +ELLIPSIS
    1 2 ... 4
    >>> print (3) #doctest: +ELLIPSIS
    3...
    >>> # ... more tests ...

It's important, by the way, to unset these things, because this entire
docstring is a whole suite.

    >>> pass #doctest: -!ELLIPSIS

Cram
====

Cram and the Mercurial Unified Test Format have a bunch of options I'm gonna
steal.

Globbing
--------

Cram offers the ability to have the expected output match a glob expression.
So now doctest does too!

    >>> print('abc') #doctest: +CRAM_GLOB
    a*c (glob)

For "regular" doctests, it's preferable to use the GLOB option, which
does not require that suffix.

    >>> print('abc') # doctest: +GLOB
    a*c

Also, unlike Cram/Mercurial, all of Python's fnmatch features are used.
In particular, character sets are supported.

    >>> print('abc') # doctest: +CRAM_GLOB
    [a][bc][bc] (glob)

Regular expressions
-------------------

Cram offers a regex utility much like its glob utility. It goes like this:

    >>> print('abc') # doctest: +CRAM_RE
    a.c (re)

In the spirit of keeping up the usual comment stuff, there's also the
regular REGEX flag.

    >>> print('abc') # doctest: +REGEX
    a.c

"""

class DoctestGlobalDirectives:
    """One feature that was added was the ability for directives to apply to
       more than just a single Example.
    
    There's a new syntax for it, and it works across an entire Doctest suite,
    but not in succeeding doctest suites. i.e. it'll only work
    within that docstring that it's found. The new syntax is::
    
        # doctest: +!OPT
    
    The ``!`` is what signals that it's global.
    You can also remove with ``-!``.
    
    e.g.::
        
        >>> x = 5
        >>> x = 4 # doctest: +!SKIP
        >>> x = 3
        >>> other_var = 12 # doctest: -!SKIP
        >>> x
        5
        >>> other_var
        12
        >>> # also, should be able to use global opts on their own line
        >>> # for readability, you know?
        >>> # at the moment we'll use pass. Maybe someday...
        >>> pass # doctest: +!SKIP
        >>> 1
        2
        >>> pass # doctest: -!SKIP
        >>> 1
        1
    """
    
class DoctestGlobalDirectivePrecedence:
    """There's also a matter of precedence: local optionflags should
    always counter global ones. For example:
    
        >>> 1 # doctest: +!SKIP -SKIP
        1
    
    That will be run. This won't:
        
        >>> 1
        2
    
    nor will this:
    
        >>> 1 # doctest: -!SKIP +SKIP
        2
    
    But this will:
    
        >>> 1
        1
    
    And here it is more expanded:
    
        >>> pass #doctest: +!SKIP
        >>> 1 #doctest: -SKIP
        1
        >>> 1
        2
        >>> pass #doctest: -!SKIP
        >>> 1 # doctest: +SKIP
        2
    """
