import sys
import os
from glob import glob

languages = []
def register_language(lang):
    if getattr(lang, 'active', True):
        languages.append(lang)

def _import_submod(modname):
    mod = __import__('doctest2.languages', fromlist=[modname])
    return getattr(mod, modname)

def _register_submodules(__file__):
    already_imported = set()
    modfilenames = sorted(glob(os.path.join(os.path.dirname(__file__), '*.*')))
    for modname in modfilenames:
        # not gonna exclude pyc, pyo
        modname = os.path.basename(modname)
        modname, _ = os.path.splitext(modname)
        
        if modname != '__init__' and modname not in already_imported:
            register_language(_import_submod(modname))
            already_imported.add(modname)

_register_submodules(__file__)
