#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
A collection of constants and useful static data for colors.
"""


rgb_min_val = 0
rgb_max_val = 255
rgb_min = (0, 0, 0)
rgb_max = (255, 255, 255)

web_colors = {
    (255, 192, 203): 'Pink',
    (255, 182, 193): 'LightPink',
    (255, 105, 180): 'HotPink',
    (255, 20, 147): 'DeepPink',
    (219, 112, 147): 'PaleVioletRed',
    (199, 21, 133): 'MediumVioletRed',
    (255, 160, 122): 'LightSalmon',
    (250, 128, 114): 'Salmon',
    (233, 150, 122): 'DarkSalmon',
    (240, 128, 128): 'LightCoral',
    (205, 92, 92): 'IndianRed',
    (220, 20, 60): 'Crimson',
    (178, 34, 34): 'FireBrick',
    (139, 0, 0): 'DarkRed',
    (255, 0, 0): 'Red',
    (255, 69, 0): 'OrangeRed',
    (255, 99, 71): 'Tomato',
    (255, 127, 80): 'Coral',
    (255, 140, 0): 'DarkOrange',
    (255, 165, 0): 'Orange',
    (255, 255, 0): 'Yellow',
    (255, 255, 224): 'LightYellow',
    (255, 250, 205): 'LemonChiffon',
    (250, 250, 210): 'LightGoldenrodYellow',
    (255, 239, 213): 'PapayaWhip',
    (255, 228, 181): 'Moccasin',
    (255, 218, 185): 'PeachPuff',
    (238, 232, 170): 'PaleGoldenrod',
    (240, 230, 140): 'Khaki',
    (189, 183, 107): 'DarkKhaki',
    (255, 215, 0): 'Gold',
    (255, 248, 220): 'Cornsilk',
    (255, 235, 205): 'BlanchedAlmond',
    (255, 228, 196): 'Bisque',
    (255, 222, 173): 'NavajoWhite',
    (245, 222, 179): 'Wheat',
    (222, 184, 135): 'BurlyWood',
    (210, 180, 140): 'Tan',
    (188, 143, 143): 'RosyBrown',
    (244, 164, 96): 'SandyBrown',
    (218, 165, 32): 'Goldenrod',
    (184, 134, 11): 'DarkGoldenrod',
    (205, 133, 63): 'Peru',
    (210, 105, 30): 'Chocolate',
    (139, 69, 19): 'SaddleBrown',
    (160, 82, 45): 'Sienna',
    (165, 42, 42): 'Brown',
    (128, 0, 0): 'Maroon',
    (85, 107, 47): 'DarkOliveGreen',
    (128, 128, 0): 'Olive',
    (107, 142, 35): 'OliveDrab',
    (154, 205, 50): 'YellowGreen',
    (50, 205, 50): 'LimeGreen',
    (0, 255, 0): 'Lime',
    (124, 252, 0): 'LawnGreen',
    (127, 255, 0): 'Chartreuse',
    (173, 255, 47): 'GreenYellow',
    (0, 255, 127): 'SpringGreen',
    (0, 250, 154): 'MediumSpringGreen',
    (144, 238, 144): 'LightGreen',
    (152, 251, 152): 'PaleGreen',
    (143, 188, 143): 'DarkSeaGreen',
    (60, 179, 113): 'MediumSeaGreen',
    (46, 139, 87): 'SeaGreen',
    (34, 139, 34): 'ForestGreen',
    (0, 128, 0): 'Green',
    (0, 100, 0): 'DarkGreen',
    (102, 205, 170): 'MediumAquamarine',
    (0, 255, 255): 'Aqua',
    (0, 255, 255): 'Cyan',
    (224, 255, 255): 'LightCyan',
    (175, 238, 238): 'PaleTurquoise',
    (127, 255, 212): 'Aquamarine',
    (64, 224, 208): 'Turquoise',
    (72, 209, 204): 'MediumTurquoise',
    (0, 206, 209): 'DarkTurquoise',
    (32, 178, 170): 'LightSeaGreen',
    (95, 158, 160): 'CadetBlue',
    (0, 139, 139): 'DarkCyan',
    (0, 128, 128): 'Teal',
    (176, 196, 222): 'LightSteelBlue',
    (176, 224, 230): 'PowderBlue',
    (173, 216, 230): 'LightBlue',
    (135, 206, 235): 'SkyBlue',
    (135, 206, 250): 'LightSkyBlue',
    (0, 191, 255): 'DeepSkyBlue',
    (30, 144, 255): 'DodgerBlue',
    (100, 149, 237): 'CornflowerBlue',
    (70, 130, 180): 'SteelBlue',
    (65, 105, 225): 'RoyalBlue',
    (0, 0, 255): 'Blue',
    (0, 0, 205): 'MediumBlue',
    (0, 0, 139): 'DarkBlue',
    (0, 0, 128): 'Navy',
    (25, 25, 112): 'MidnightBlue',
    (230, 230, 250): 'Lavender',
    (216, 191, 216): 'Thistle',
    (221, 160, 221): 'Plum',
    (238, 130, 238): 'Violet',
    (218, 112, 214): 'Orchid',
    (255, 0, 255): 'Fuchsia',
    (255, 0, 255): 'Magenta',
    (186, 85, 211): 'MediumOrchid',
    (147, 112, 219): 'MediumPurple',
    (138, 43, 226): 'BlueViolet',
    (148, 0, 211): 'DarkViolet',
    (153, 50, 204): 'DarkOrchid',
    (139, 0, 139): 'DarkMagenta',
    (128, 0, 128): 'Purple',
    (75, 0, 130): 'Indigo',
    (72, 61, 139): 'DarkSlateBlue',
    (102, 51, 153): 'RebeccaPurple',
    (106, 90, 205): 'SlateBlue',
    (123, 104, 238): 'MediumSlateBlue',
    (255, 255, 255): 'White',
    (255, 250, 250): 'Snow',
    (240, 255, 240): 'Honeydew',
    (245, 255, 250): 'MintCream',
    (240, 255, 255): 'Azure',
    (240, 248, 255): 'AliceBlue',
    (248, 248, 255): 'GhostWhite',
    (245, 245, 245): 'WhiteSmoke',
    (255, 245, 238): 'Seashell',
    (245, 245, 220): 'Beige',
    (253, 245, 230): 'OldLace',
    (255, 250, 240): 'FloralWhite',
    (255, 255, 240): 'Ivory',
    (250, 235, 215): 'AntiqueWhite',
    (250, 240, 230): 'Linen',
    (255, 240, 245): 'LavenderBlush',
    (255, 228, 225): 'MistyRose',
    (220, 220, 220): 'Gainsboro',
    (211, 211, 211): 'LightGrey',
    (192, 192, 192): 'Silver',
    (169, 169, 169): 'DarkGray',
    (128, 128, 128): 'Gray',
    (105, 105, 105): 'DimGray',
    (119, 136, 153): 'LightSlateGray',
    (112, 128, 144): 'SlateGray',
    (47, 79, 79): 'DarkSlateGray',
    (0, 0, 0): 'Black'
}

# Appends the reverse web_colors dictionary to web_colors, so reverse lookups are allowed
web_colors.update(dict([(_v.lower(), _k) for _k, _v in web_colors.items()]))