# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class App(Resource):
    """The IoT Central application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ARM resource identifier.
    :vartype id: str
    :ivar name: The ARM resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :ivar application_id: The ID of the application.
    :vartype application_id: str
    :param display_name: The display name of the application.
    :type display_name: str
    :param subdomain: The subdomain of the application.
    :type subdomain: str
    :param template: The ID of the application template, which is a blueprint
     that defines the characteristics and behaviors of an application.
     Optional; if not specified, defaults to a blank blueprint and allows the
     application to be defined from scratch.
    :type template: str
    :param sku: Required. A valid instance SKU.
    :type sku: ~azure.mgmt.iotcentral.models.AppSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,99}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'application_id': {'readonly': True},
        'display_name': {'pattern': r'^.{1,200}$'},
        'subdomain': {'pattern': r'^[a-z0-9-]{1,63}$'},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'application_id': {'key': 'properties.applicationId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'subdomain': {'key': 'properties.subdomain', 'type': 'str'},
        'template': {'key': 'properties.template', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AppSkuInfo'},
    }

    def __init__(self, **kwargs):
        super(App, self).__init__(**kwargs)
        self.application_id = None
        self.display_name = kwargs.get('display_name', None)
        self.subdomain = kwargs.get('subdomain', None)
        self.template = kwargs.get('template', None)
        self.sku = kwargs.get('sku', None)
