# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.4, generator: @autorest/python@6.4.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Iterator, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _format_url_section, raise_if_not_implemented

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_container_registry_check_docker_v2_support_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_container_registry_get_manifest_request(name: str, reference: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/manifests/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_container_registry_create_manifest_request(
    name: str, reference: str, *, content: IO, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/manifests/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, content=content, **kwargs)


def build_container_registry_delete_manifest_request(name: str, reference: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/manifests/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_container_registry_get_repositories_request(
    *, last: Optional[str] = None, n: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/_catalog"

    # Construct parameters
    if last is not None:
        _params["last"] = _SERIALIZER.query("last", last, "str")
    if n is not None:
        _params["n"] = _SERIALIZER.query("n", n, "int")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_get_properties_request(name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_delete_repository_request(name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_update_properties_request(name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_get_tags_request(
    name: str,
    *,
    last: Optional[str] = None,
    n: Optional[int] = None,
    orderby: Optional[str] = None,
    digest: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_tags"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if last is not None:
        _params["last"] = _SERIALIZER.query("last", last, "str")
    if n is not None:
        _params["n"] = _SERIALIZER.query("n", n, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")
    if digest is not None:
        _params["digest"] = _SERIALIZER.query("digest", digest, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_get_tag_properties_request(name: str, reference: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_tags/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_update_tag_attributes_request(name: str, reference: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_tags/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_delete_tag_request(name: str, reference: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_tags/{reference}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "reference": _SERIALIZER.url("reference", reference, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_get_manifests_request(
    name: str, *, last: Optional[str] = None, n: Optional[int] = None, orderby: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_manifests"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    if last is not None:
        _params["last"] = _SERIALIZER.query("last", last, "str")
    if n is not None:
        _params["n"] = _SERIALIZER.query("n", n, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_get_manifest_properties_request(name: str, digest: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_manifests/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_update_manifest_properties_request(name: str, digest: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["2021-07-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-07-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/acr/v1/{name}/_manifests/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_blob_get_blob_request(name: str, digest: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/v2/{name}/blobs/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_check_blob_exists_request(name: str, digest: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/blobs/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="HEAD", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_delete_blob_request(name: str, digest: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/v2/{name}/blobs/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_mount_blob_request(
    name: str, *, from_parameter: str, mount: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/blobs/uploads/"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["from"] = _SERIALIZER.query("from_parameter", from_parameter, "str")
    _params["mount"] = _SERIALIZER.query("mount", mount, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_container_registry_blob_get_upload_status_request(next_link: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{nextBlobUuidLink}"
    path_format_arguments = {
        "nextBlobUuidLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_upload_chunk_request(next_link: str, *, content: IO, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{nextBlobUuidLink}"
    path_format_arguments = {
        "nextBlobUuidLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, content=content, **kwargs)


def build_container_registry_blob_complete_upload_request(
    next_link: str, *, digest: str, content: Optional[IO] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{nextBlobUuidLink}"
    path_format_arguments = {
        "nextBlobUuidLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["digest"] = _SERIALIZER.query("digest", digest, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_container_registry_blob_cancel_upload_request(next_link: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{nextBlobUuidLink}"
    path_format_arguments = {
        "nextBlobUuidLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_start_upload_request(name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/blobs/uploads/"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_get_chunk_request(
    name: str, digest: str, *, range: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/v2/{name}/blobs/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Range"] = _SERIALIZER.header("range", range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_container_registry_blob_check_chunk_exists_request(
    name: str, digest: str, *, range: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/{name}/blobs/{digest}"
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, "str"),
        "digest": _SERIALIZER.url("digest", digest, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Range"] = _SERIALIZER.header("range", range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="HEAD", url=_url, headers=_headers, **kwargs)


class ContainerRegistryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~container_registry.ContainerRegistry`'s
        :attr:`container_registry` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def check_docker_v2_support(self, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_check_docker_v2_support_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def get_manifest(self, name: str, reference: str, **kwargs: Any) -> _models.ManifestWrapper:
        """Get the manifest identified by ``name`` and ``reference`` where ``reference`` can be a tag or
        digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :return: ManifestWrapper
        :rtype: ~container_registry.models.ManifestWrapper
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ManifestWrapper] = kwargs.pop("cls", None)

        request = build_container_registry_get_manifest_request(
            name=name,
            reference=reference,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ManifestWrapper", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def create_manifest(self, name: str, reference: str, payload: IO, **kwargs: Any) -> Any:
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be a tag or
        digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header. Required.
        :type payload: IO
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/vnd.docker.distribution.manifest.v2+json")
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        _content = payload

        request = build_container_registry_create_manifest_request(
            name=name,
            reference=reference,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def delete_manifest(  # pylint: disable=inconsistent-return-statements
        self, name: str, reference: str, **kwargs: Any
    ) -> None:
        """Delete the manifest identified by ``name`` and ``reference``. Note that a manifest can *only*
        be deleted by ``digest``.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Digest of a BLOB. Required.
        :type reference: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_delete_manifest_request(
            name=name,
            reference=reference,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def get_repositories(self, *, last: Optional[str] = None, n: Optional[int] = None, **kwargs: Any) -> Iterable[str]:
        """List repositories.

        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: query parameter for max number of items. Default value is None.
        :paramtype n: int
        :return: An iterator like instance of str
        :rtype: ~azure.core.paging.ItemPaged[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.Repositories] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_container_registry_get_repositories_request(
                    last=last,
                    n=n,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.Repositories, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.repositories
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_properties(self, name: str, **kwargs: Any) -> _models.ContainerRepositoryProperties:
        """Get repository attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: ContainerRepositoryProperties
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ContainerRepositoryProperties] = kwargs.pop("cls", None)

        request = build_container_registry_get_properties_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ContainerRepositoryProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def delete_repository(self, name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete the repository identified by ``name``.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_delete_repository_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def update_properties(
        self,
        name: str,
        value: Optional[_models.RepositoryWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Default value is None.
        :type value: ~container_registry.models.RepositoryWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ContainerRepositoryProperties
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_properties(
        self, name: str, value: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Default value is None.
        :type value: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ContainerRepositoryProperties
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_properties(
        self, name: str, value: Optional[Union[_models.RepositoryWriteableProperties, IO]] = None, **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Is either a RepositoryWriteableProperties type or a
         IO type. Default value is None.
        :type value: ~container_registry.models.RepositoryWriteableProperties or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: ContainerRepositoryProperties
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ContainerRepositoryProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(value, (IO, bytes)):
            _content = value
        else:
            if value is not None:
                _json = self._serialize.body(value, "RepositoryWriteableProperties")
            else:
                _json = None

        request = build_container_registry_update_properties_request(
            name=name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ContainerRepositoryProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_tags(
        self,
        name: str,
        *,
        last: Optional[str] = None,
        n: Optional[int] = None,
        orderby: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.TagAttributesBase"]:
        """List tags of a repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: query parameter for max number of items. Default value is None.
        :paramtype n: int
        :keyword orderby: orderby query parameter. Default value is None.
        :paramtype orderby: str
        :keyword digest: filter by digest. Default value is None.
        :paramtype digest: str
        :return: An iterator like instance of TagAttributesBase
        :rtype: ~azure.core.paging.ItemPaged[~container_registry.models.TagAttributesBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.TagList] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_container_registry_get_tags_request(
                    name=name,
                    last=last,
                    n=n,
                    orderby=orderby,
                    digest=digest,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.TagList, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.tag_attribute_bases
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_tag_properties(self, name: str, reference: str, **kwargs: Any) -> _models.ArtifactTagProperties:
        """Get tag attributes by tag.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :return: ArtifactTagProperties
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ArtifactTagProperties] = kwargs.pop("cls", None)

        request = build_container_registry_get_tag_properties_request(
            name=name,
            reference=reference,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ArtifactTagProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[_models.TagWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Default value is None.
        :type value: ~container_registry.models.TagWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactTagProperties
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Default value is None.
        :type value: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactTagProperties
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[Union[_models.TagWriteableProperties, IO]] = None,
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Is either a TagWriteableProperties type or a IO type.
         Default value is None.
        :type value: ~container_registry.models.TagWriteableProperties or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: ArtifactTagProperties
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ArtifactTagProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(value, (IO, bytes)):
            _content = value
        else:
            if value is not None:
                _json = self._serialize.body(value, "TagWriteableProperties")
            else:
                _json = None

        request = build_container_registry_update_tag_attributes_request(
            name=name,
            reference=reference,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ArtifactTagProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def delete_tag(  # pylint: disable=inconsistent-return-statements
        self, name: str, reference: str, **kwargs: Any
    ) -> None:
        """Delete tag.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_delete_tag_request(
            name=name,
            reference=reference,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def get_manifests(
        self,
        name: str,
        *,
        last: Optional[str] = None,
        n: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.ManifestAttributesBase"]:
        """List manifests of a repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: query parameter for max number of items. Default value is None.
        :paramtype n: int
        :keyword orderby: orderby query parameter. Default value is None.
        :paramtype orderby: str
        :return: An iterator like instance of ManifestAttributesBase
        :rtype: ~azure.core.paging.ItemPaged[~container_registry.models.ManifestAttributesBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.AcrManifests] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_container_registry_get_manifests_request(
                    name=name,
                    last=last,
                    n=n,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.AcrManifests, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.manifests
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_manifest_properties(self, name: str, digest: str, **kwargs: Any) -> _models.ArtifactManifestProperties:
        """Get manifest attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: ArtifactManifestProperties
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ArtifactManifestProperties] = kwargs.pop("cls", None)

        request = build_container_registry_get_manifest_properties_request(
            name=name,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ArtifactManifestProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[_models.ManifestWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Default value is None.
        :type value: ~container_registry.models.ManifestWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactManifestProperties
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Default value is None.
        :type value: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactManifestProperties
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[Union[_models.ManifestWriteableProperties, IO]] = None,
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Is either a ManifestWriteableProperties type or a IO
         type. Default value is None.
        :type value: ~container_registry.models.ManifestWriteableProperties or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: ArtifactManifestProperties
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ArtifactManifestProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(value, (IO, bytes)):
            _content = value
        else:
            if value is not None:
                _json = self._serialize.body(value, "ManifestWriteableProperties")
            else:
                _json = None

        request = build_container_registry_update_manifest_properties_request(
            name=name,
            digest=digest,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ArtifactManifestProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class ContainerRegistryBlobOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~container_registry.ContainerRegistry`'s
        :attr:`container_registry_blob` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_blob(self, name: str, digest: str, **kwargs: Any) -> Optional[Iterator[bytes]]:
        """Retrieve the blob from the registry identified by digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: Iterator of the response bytes or None
        :rtype: Iterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[Iterator[bytes]]] = kwargs.pop("cls", None)

        request = build_container_registry_blob_get_blob_request(
            name=name,
            digest=digest,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 307]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
            response_headers["Docker-Content-Digest"] = self._deserialize(
                "str", response.headers.get("Docker-Content-Digest")
            )

            deserialized = response.iter_bytes()

        if response.status_code == 307:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def check_blob_exists(  # pylint: disable=inconsistent-return-statements
        self, name: str, digest: str, **kwargs: Any
    ) -> None:
        """Same as GET, except only the headers are returned.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_check_blob_exists_request(
            name=name,
            digest=digest,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 307]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
            response_headers["Docker-Content-Digest"] = self._deserialize(
                "str", response.headers.get("Docker-Content-Digest")
            )

        if response.status_code == 307:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def delete_blob(self, name: str, digest: str, **kwargs: Any) -> Iterator[bytes]:
        """Removes an already uploaded blob.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: Iterator of the response bytes
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        request = build_container_registry_blob_delete_blob_request(
            name=name,
            digest=digest,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def mount_blob(  # pylint: disable=inconsistent-return-statements
        self, name: str, *, from_parameter: str, mount: str, **kwargs: Any
    ) -> None:
        """Mount a blob identified by the ``mount`` parameter from another repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword from_parameter: Name of the source repository. Required.
        :paramtype from_parameter: str
        :keyword mount: Digest of blob to mount from the source repository. Required.
        :paramtype mount: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_mount_blob_request(
            name=name,
            from_parameter=from_parameter,
            mount=mount,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def get_upload_status(  # pylint: disable=inconsistent-return-statements
        self, next_link: str, **kwargs: Any
    ) -> None:
        """Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to
        resolve the current status of a resumable upload.

        :param next_link: Link acquired from upload start or previous chunk. Note, do not include
         initial / (must do substring(1) ). Required.
        :type next_link: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_get_upload_status_request(
            next_link=next_link,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def upload_chunk(  # pylint: disable=inconsistent-return-statements
        self, next_link: str, value: IO, **kwargs: Any
    ) -> None:
        """Upload a stream of data without completing the upload.

        :param next_link: Link acquired from upload start or previous chunk. Note, do not include
         initial / (must do substring(1) ). Required.
        :type next_link: str
        :param value: Raw data of blob. Required.
        :type value: IO
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/octet-stream"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = value

        request = build_container_registry_blob_upload_chunk_request(
            next_link=next_link,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def complete_upload(  # pylint: disable=inconsistent-return-statements
        self, next_link: str, value: Optional[IO] = None, *, digest: str, **kwargs: Any
    ) -> None:
        """Complete the upload, providing all the data in the body, if necessary. A request without a body
        will just complete the upload with previously uploaded content.

        :param next_link: Link acquired from upload start or previous chunk. Note, do not include
         initial / (must do substring(1) ). Required.
        :type next_link: str
        :param value: Optional raw data of blob. Default value is None.
        :type value: IO
        :keyword digest: Digest of a BLOB. Required.
        :paramtype digest: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/octet-stream"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = value

        request = build_container_registry_blob_complete_upload_request(
            next_link=next_link,
            digest=digest,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def cancel_upload(self, next_link: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Cancel outstanding upload processes, releasing associated resources. If this is not called, the
        unfinished uploads will eventually timeout.

        :param next_link: Link acquired from upload start or previous chunk. Note, do not include
         initial / (must do substring(1) ). Required.
        :type next_link: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_cancel_upload_request(
            next_link=next_link,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def start_upload(self, name: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Initiate a resumable blob upload with an empty request body.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_start_upload_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def get_chunk(self, name: str, digest: str, *, range: str, **kwargs: Any) -> Iterator[bytes]:
        """Retrieve the blob from the registry identified by ``digest``. This endpoint may also support
        RFC7233 compliant range requests. Support can be detected by issuing a HEAD request. If the
        header ``Accept-Range: bytes`` is returned, range requests can be used to fetch partial
        content.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :keyword range: Format : bytes=:code:`<start>`-:code:`<end>`,  HTTP Range header specifying
         blob chunk. Required.
        :paramtype range: str
        :return: Iterator of the response bytes
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        request = build_container_registry_blob_get_chunk_request(
            name=name,
            digest=digest,
            range=range,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["Content-Range"] = self._deserialize("str", response.headers.get("Content-Range"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def check_chunk_exists(  # pylint: disable=inconsistent-return-statements
        self, name: str, digest: str, *, range: str, **kwargs: Any
    ) -> None:
        """Same as GET, except only the headers are returned.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :keyword range: Format : bytes=:code:`<start>`-:code:`<end>`,  HTTP Range header specifying
         blob chunk. Required.
        :paramtype range: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_container_registry_blob_check_chunk_exists_request(
            name=name,
            digest=digest,
            range=range,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["Content-Range"] = self._deserialize("str", response.headers.get("Content-Range"))

        if cls:
            return cls(pipeline_response, None, response_headers)


class AuthenticationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~container_registry.ContainerRegistry`'s
        :attr:`authentication` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        raise_if_not_implemented(
            self.__class__,
            [
                "exchange_aad_access_token_for_acr_refresh_token",
                "exchange_acr_refresh_token_for_acr_access_token",
            ],
        )
