## -*- coding: utf-8 -*-
# (C) 2013 Muthiah Annamalai
# 
# Implementation of Azhagi rules - தமிழ் எழுத்துக்கள்
# Ref: B. Viswanathan, http://www.mazhalaigal.com/tamil/learn/keys.php
# 
class Transliteration:
    table = {}
    # not implemented - many-to-one table

    # Azhagi has a many-to-one mapping - using a Tamil language model and Baye's conditional probabilities
    # to break the tie when two or more Tamil letters have the same English syllable. Currently 
    
    table["a"]=u"அ"
    table["aa"]=u"ஆ"
    table["A"]=u"ஆ"
    table["i"]=u"இ"
    table["ee"]=u"ஈ"
    table["I"]=u"ஈ"
    table["u"]=u"உ"
    table["oo"]=u"ஊ"
    table["U"]=u"ஊ"
    table["e"]=u"எ"
    table["E"]=u"ஏ"
    table["ae"]=u"ஏ"
    table["ai"]=u"ஐ"
    table["o"]=u"ஒ"
    table["O"]=u"ஓ"
    table["oe"]=u"ஓ"
    table["oa"]=u"ஓ"
    table["ou"]=u"ஔ"
    table["au"]=u"ஔ"
    table["ow"]=u"ஔ"
    table["q"]=u"ஃ"
    table["ga"]=u"க"
    table["ca"]=u"க"
    table["kha"]=u"க"
    table["gha"]=u"க"
    table["ka"]=u"க"
    table["Ka"]=u"க"
    table["kaa"]=u"கா"
    table["gaa"]=u"கா"
    table["caa"]=u"கா"
    table["khaa"]=u"கா"
    table["ghaa"]=u"கா"
    table["kA"]=u"கா"
    table["gA"]=u"கா"
    table["cA"]=u"கா"
    table["khA"]=u"கா"
    table["ghA"]=u"கா"
    table["ki"]=u"கி"
    table["gi"]=u"கி"
    table["ci"]=u"கி"
    table["khi"]=u"கி"
    table["ghi"]=u"கி"
    table["kii"]=u"கீ"
    table["kee"]=u"கீ"
    table["kI"]=u"கீ"
    table["gee"]=u"கீ"
    table["gI"]=u"கீ"
    table["gii"]=u"கீ"
    table["cee"]=u"கீ"
    table["cI"]=u"கீ"
    table["cii"]=u"கீ"
    table["khee"]=u"கீ"
    table["khI"]=u"கீ"
    table["khii"]=u"கீ"
    table["ghee"]=u"கீ"
    table["ghI"]=u"கீ"
    table["ghii"]=u"கீ"
    table["gu"]=u"கு"
    table["cu"]=u"கு"
    table["khu"]=u"கு"
    table["ghu"]=u"கு"
    table["ku"]=u"கு"
    table["koo"]=u"கூ"
    table["kU"]=u"கூ"
    table["goo"]=u"கூ"
    table["gU"]=u"கூ"
    table["guu"]=u"கூ"
    table["coo"]=u"கூ"
    table["cU"]=u"கூ"
    table["cuu"]=u"கூ"
    table["khoo"]=u"கூ"
    table["khU"]=u"கூ"
    table["khuu"]=u"கூ"
    table["ghoo"]=u"கூ"
    table["ghU"]=u"கூ"
    table["ghuu"]=u"கூ"
    table["kuu"]=u"கூ"
    table["ge"]=u"கெ"
    table["ce"]=u"கெ"
    table["khe"]=u"கெ"
    table["ghe"]=u"கெ"
    table["ke"]=u"கெ"
    table["kE"]=u"கே"
    table["gE"]=u"கே"
    table["gae"]=u"கே"
    table["cE"]=u"கே"
    table["cae"]=u"கே"
    table["khE"]=u"கே"
    table["khae"]=u"கே"
    table["ghE"]=u"கே"
    table["ghae"]=u"கே"
    table["kae"]=u"கே"
    table["gai"]=u"கை"
    table["cai"]=u"கை"
    table["khai"]=u"கை"
    table["ghai"]=u"கை"
    table["koa"]=u"கை"

    table["koh"]=u"கொ"
    table["ko"]=u"கொ"
    table["kO"]=u"கொ"
    table["kO"]=u"கொ"
    
    table["kho"]=u"கோ"
    table["kHO"]=u"கோ"
    
    table["kou"]=u"கௌ"
    table["kau"]=u"கௌ"
    table["gow"]=u"கௌ"
    table["gou"]=u"கௌ"
    table["gau"]=u"கௌ"
    table["cow"]=u"கௌ"
    table["cou"]=u"கௌ"
    table["cau"]=u"கௌ"
    table["khow"]=u"கௌ"
    table["khou"]=u"கௌ"
    table["khau"]=u"கௌ"
    table["ghow"]=u"கௌ"
    table["ghou"]=u"கௌ"
    table["ghau"]=u"கௌ"
    table["kow"]=u"கௌ"
    table["g"]=u"க்"
    table["c"]=u"க்"
    table["kh"]=u"க்"
    table["gh"]=u"க்"
    table["k"]=u"க்"
    table["nga"]=u"ங"
    table["nGa"]=u"ங"
    table["nGA"]=u"ஙா"
    table["ngaa"]=u"ஙா"
    table["ngA"]=u"ஙா"
    table["nGaa"]=u"ஙா"
    table["ngi"]=u"ஙி"
    table["nGi"]=u"ஙி"
    table["nGee"]=u"ஙீ"
    table["nGI"]=u"ஙீ"
    table["ngee"]=u"ஙீ"
    table["ngI"]=u"ஙீ"
    table["ngii"]=u"ஙீ"
    table["nGii"]=u"ஙீ"
    table["ngu"]=u"ஙு"
    table["nGu"]=u"ஙு"
    table["nGoo"]=u"ஙூ"
    table["nGU"]=u"ஙூ"
    table["ngoo"]=u"ஙூ"
    table["ngU"]=u"ஙூ"
    table["nguu"]=u"ஙூ"
    table["nGuu"]=u"ஙூ"
    table["nge"]=u"ஙெ"
    table["nGe"]=u"ஙெ"
    table["nGE"]=u"ஙே"
    table["ngE"]=u"ஙே"
    table["ngae"]=u"ஙே"
    table["nGae"]=u"ஙே"
    table["ngai"]=u"ஙை"
    table["nGai"]=u"ஙை"
    table["ngo"]=u"ஙொ"
    table["nGo"]=u"ஙொ"
    table["nGO"]=u"ஙோ"
    table["nGoe"]=u"ஙோ"
    table["ngO"]=u"ஙோ"
    table["ngoa"]=u"ஙோ"
    table["ngoe"]=u"ஙோ"
    table["nGoa"]=u"ஙோ"
    table["nGou"]=u"ஙௌ"
    table["nGau"]=u"ஙௌ"
    table["ngow"]=u"ஙௌ"
    table["ngou"]=u"ஙௌ"
    table["ngau"]=u"ஙௌ"
    table["nGow"]=u"ஙௌ"
    table["ng"]=u"ங்"
    table["nG"]=u"ங்"
    table["cha"]=u"ச"
    table["sa"]=u"ச"
    table["sA"]=u"சா"
    table["chaa"]=u"சா"
    table["chA"]=u"சா"
    table["saa"]=u"சா"
    table["chi"]=u"சி"
    table["si"]=u"சி"
    table["see"]=u"சீ"
    table["sI"]=u"சீ"
    table["chee"]=u"சீ"
    table["chI"]=u"சீ"
    table["chii"]=u"சீ"
    table["sii"]=u"சீ"
    table["chu"]=u"சு"
    table["su"]=u"சு"
    table["soo"]=u"சூ"
    table["sU"]=u"சூ"
    table["choo"]=u"சூ"
    table["chU"]=u"சூ"
    table["chuu"]=u"சூ"
    table["suu"]=u"சூ"
    table["che"]=u"செ"
    table["se"]=u"செ"
    table["sE"]=u"சே"
    table["chE"]=u"சே"
    table["chae"]=u"சே"
    table["sae"]=u"சே"
    table["chai"]=u"சை"
    table["sai"]=u"சை"
    table["cho"]=u"சொ"
    table["so"]=u"சொ"
    table["sO"]=u"சோ"
    table["soe"]=u"சோ"
    table["chO"]=u"சோ"
    table["choa"]=u"சோ"
    table["choe"]=u"சோ"
    table["soa"]=u"சோ"
    table["sou"]=u"சௌ"
    table["sau"]=u"சௌ"
    table["chow"]=u"சௌ"
    table["chou"]=u"சௌ"
    table["chau"]=u"சௌ"
    table["sow"]=u"சௌ"
    table["ch"]=u"ச்"
    table["s"]=u"ச்"
    table["gna"]=u"ஞ"
    table["nja"]=u"ஞ"
    table["Gna"]=u"ஞ"
    table["GnA"]=u"ஞா"
    table["gnaa"]=u"ஞா"
    table["gnA"]=u"ஞா"
    table["njaa"]=u"ஞா"
    table["njA"]=u"ஞா"
    table["Gnaa"]=u"ஞா"
    table["gni"]=u"ஞி"
    table["nji"]=u"ஞி"
    table["Gni"]=u"ஞி"
    table["Gnee"]=u"ஞீ"
    table["GnI"]=u"ஞீ"
    table["gnee"]=u"ஞீ"
    table["gnI"]=u"ஞீ"
    table["gnii"]=u"ஞீ"
    table["njee"]=u"ஞீ"
    table["njI"]=u"ஞீ"
    table["njii"]=u"ஞீ"
    table["Gnii"]=u"ஞீ"
    table["gnu"]=u"ஞு"
    table["nju"]=u"ஞு"
    table["Gnu"]=u"ஞு"
    table["Gnoo"]=u"ஞூ"
    table["GnU"]=u"ஞூ"
    table["gnoo"]=u"ஞூ"
    table["gnU"]=u"ஞூ"
    table["gnuu"]=u"ஞூ"
    table["njoo"]=u"ஞூ"
    table["njU"]=u"ஞூ"
    table["njuu"]=u"ஞூ"
    table["Gnuu"]=u"ஞூ"
    table["gne"]=u"ஞெ"
    table["nje"]=u"ஞெ"
    table["Gne"]=u"ஞெ"
    table["GnE"]=u"ஞே"
    table["gnE"]=u"ஞே"
    table["gnae"]=u"ஞே"
    table["njE"]=u"ஞே"
    table["njae"]=u"ஞே"
    table["Gnae"]=u"ஞே"
    table["gnai"]=u"ஞை"
    table["njai"]=u"ஞை"
    table["Gnai"]=u"ஞை"
    table["gno"]=u"ஞொ"
    table["njo"]=u"ஞொ"
    table["Gno"]=u"ஞொ"
    table["GnO"]=u"ஞோ"
    table["Gnoe"]=u"ஞோ"
    table["gnO"]=u"ஞோ"
    table["gnoa"]=u"ஞோ"
    table["gnoe"]=u"ஞோ"
    table["njO"]=u"ஞோ"
    table["njoa"]=u"ஞோ"
    table["njoe"]=u"ஞோ"
    table["Gnoa"]=u"ஞோ"
    table["Gnou"]=u"ஞௌ"
    table["Gnau"]=u"ஞௌ"
    table["gnow"]=u"ஞௌ"
    table["gnou"]=u"ஞௌ"
    table["gnau"]=u"ஞௌ"
    table["njow"]=u"ஞௌ"
    table["njou"]=u"ஞௌ"
    table["njau"]=u"ஞௌ"
    table["Gnow"]=u"ஞௌ"
    table["gn"]=u"ஞ்"
    table["nj"]=u"ஞ்"
    table["Gn"]=u"ஞ்"
    table["da"]=u"ட"
    table["ta"]=u"ட"
    table["tA"]=u"டா"
    table["daa"]=u"டா"
    table["dA"]=u"டா"
    table["taa"]=u"டா"
    table["di"]=u"டி"
    table["ti"]=u"டி"
    table["tee"]=u"டீ"
    table["tI"]=u"டீ"
    table["dee"]=u"டீ"
    table["dI"]=u"டீ"
    table["dii"]=u"டீ"
    table["tii"]=u"டீ"
    table["du"]=u"டு"
    table["tu"]=u"டு"
    table["too"]=u"டூ"
    table["tU"]=u"டூ"
    table["doo"]=u"டூ"
    table["dU"]=u"டூ"
    table["duu"]=u"டூ"
    table["tuu"]=u"டூ"
    table["de"]=u"டெ"
    table["te"]=u"டெ"
    table["tE"]=u"டே"
    table["dE"]=u"டே"
    table["dae"]=u"டே"
    table["tae"]=u"டே"
    table["dai"]=u"டை"
    table["tai"]=u"டை"
    table["do"]=u"டொ"
    table["to"]=u"டொ"
    table["tO"]=u"டோ"
    table["toe"]=u"டோ"
    table["dO"]=u"டோ"
    table["doa"]=u"டோ"
    table["doe"]=u"டோ"
    table["toa"]=u"டோ"
    table["tou"]=u"டௌ"
    table["tau"]=u"டௌ"
    table["dow"]=u"டௌ"
    table["dou"]=u"டௌ"
    table["dau"]=u"டௌ"
    table["tow"]=u"டௌ"
    table["d"]=u"ட்"
    table["T"]=u"ட்"
    table["t"]=u"ட்"
    table["nda"]=u"ண"
    table["Na"]=u"ண"
    table["NA"]=u"ணா"
    table["ndaa"]=u"ணா"
    table["Naa"]=u"ணா"
    table["ndi"]=u"ணி"
    table["Ni"]=u"ணி"
    table["Nee"]=u"ணீ"
    table["NI"]=u"ணீ"
    table["ndee"]=u"ணீ"
    table["ndI"]=u"ணீ"
    table["ndii"]=u"ணீ"
    table["Nii"]=u"ணீ"
    table["ndu"]=u"ணு"
    table["Nu"]=u"ணு"
    table["Noo"]=u"ணூ"
    table["NU"]=u"ணூ"
    table["ndoo"]=u"ணூ"
    table["ndU"]=u"ணூ"
    table["nduu"]=u"ணூ"
    table["Nuu"]=u"ணூ"
    table["nde"]=u"ணெ"
    table["Ne"]=u"ணெ"
    table["NE"]=u"ணே"
    table["ndE"]=u"ணே"
    table["ndae"]=u"ணே"
    table["Nae"]=u"ணே"
    table["ndai"]=u"ணை"
    table["Nai"]=u"ணை"
    table["ndo"]=u"ணொ"
    table["No"]=u"ணொ"
    table["NO"]=u"ணோ"
    table["Noe"]=u"ணோ"
    table["ndO"]=u"ணோ"
    table["ndoa"]=u"ணோ"
    table["ndoe"]=u"ணோ"
    table["Noa"]=u"ணோ"
    table["Nou"]=u"ணௌ"
    table["Nau"]=u"ணௌ"
    table["ndow"]=u"ணௌ"
    table["ndou"]=u"ணௌ"
    table["ndau"]=u"ணௌ"
    table["Now"]=u"ணௌ"
    table["nd"]=u"ண்"
    table["N"]=u"ண்"
    table["dha"]=u"த"
    table["tha"]=u"த"
    table["thA"]=u"தா"
    table["dhaa"]=u"தா"
    table["dhA"]=u"தா"
    table["thaa"]=u"தா"
    table["dhi"]=u"தி"
    table["thi"]=u"தி"
    table["thee"]=u"தீ"
    table["thI"]=u"தீ"
    table["dhee"]=u"தீ"
    table["dhI"]=u"தீ"
    table["dhii"]=u"தீ"
    table["thii"]=u"தீ"
    table["dhu"]=u"து"
    table["thu"]=u"து"
    table["thoo"]=u"தூ"
    table["thU"]=u"தூ"
    table["dhoo"]=u"தூ"
    table["dhU"]=u"தூ"
    table["dhuu"]=u"தூ"
    table["thuu"]=u"தூ"
    table["dhe"]=u"தெ"
    table["the"]=u"தெ"
    table["thE"]=u"தே"
    table["dhE"]=u"தே"
    table["dhae"]=u"தே"
    table["thae"]=u"தே"
    table["dhai"]=u"தை"
    table["thai"]=u"தை"
    table["dho"]=u"தொ"
    table["tho"]=u"தொ"
    table["thO"]=u"தோ"
    table["thoe"]=u"தோ"
    table["dhO"]=u"தோ"
    table["dhoa"]=u"தோ"
    table["dhoe"]=u"தோ"
    table["thoa"]=u"தோ"
    table["thou"]=u"தௌ"
    table["thau"]=u"தௌ"
    table["dhow"]=u"தௌ"
    table["dhou"]=u"தௌ"
    table["dhau"]=u"தௌ"
    table["thow"]=u"தௌ"
    table["dh"]=u"த்"
    table["th"]=u"த்"
    table["na"]=u"ந"
    table["ndha"]=u"ந"
    table["ntha"]=u"ந"
    table["nha"]=u"ந"
    table["nhA"]=u"நா"
    table["naa"]=u"நா"
    table["nA"]=u"நா"
    table["ndhA"]=u"நா"
    table["ndhaa"]=u"நா"
    table["nthaa"]=u"நா"
    table["nthA"]=u"நா"
    table["nhaa"]=u"நா"
    table["ni"]=u"நி"
    table["ndhi"]=u"நி"
    table["nthi"]=u"நி"
    table["nhi"]=u"நி"
    table["nhee"]=u"நீ"
    table["nhI"]=u"நீ"
    table["nee"]=u"நீ"
    table["nI"]=u"நீ"
    table["nii"]=u"நீ"
    table["ndhee"]=u"நீ"
    table["ndhI"]=u"நீ"
    table["ndhii"]=u"நீ"
    table["nthee"]=u"நீ"
    table["nthi"]=u"நீ"
    table["nthii"]=u"நீ"
    table["nhii"]=u"நீ"
    table["nu"]=u"நு"
    table["ndhu"]=u"நு"
    table["nthu"]=u"நு"
    table["'"]=u"நு"
    table["this"]=u"நு"
    table["event"]=u"நு"
    table["nhu"]=u"நு"
    table["nhoo"]=u"நூ"
    table["nhU"]=u"நூ"
    table["noo"]=u"நூ"
    table["nU"]=u"நூ"
    table["nuu"]=u"நூ"
    table["ndhoo"]=u"நூ"
    table["ndhU"]=u"நூ"
    table["ndhuu"]=u"நூ"
    table["nthoo"]=u"நூ"
    table["nthU"]=u"நூ"
    table["nthuu"]=u"நூ"
    table["nhuu"]=u"நூ"
    table["ne"]=u"நெ"
    table["ndhe"]=u"நெ"
    table["nthe"]=u"நெ"
    table["nhe"]=u"நெ"
    table["nhE"]=u"நே"
    table["nE"]=u"நே"
    table["nae"]=u"நே"
    table["ndhE"]=u"நே"
    table["ndhae"]=u"நே"
    table["nthE"]=u"நே"
    table["nthae"]=u"நே"
    table["nhae"]=u"நே"
    table["nai"]=u"நை"
    table["ndhai"]=u"நை"
    table["nthai"]=u"நை"
    table["nhai"]=u"நை"
    table["no"]=u"நொ"
    table["ndho"]=u"நொ"
    table["ntho"]=u"நொ"
    table["nho"]=u"நொ"
    table["nhO"]=u"நோ"
    table["nhoe"]=u"நோ"
    table["nO"]=u"நோ"
    table["noa"]=u"நோ"
    table["noe"]=u"நோ"
    table["ndhO"]=u"நோ"
    table["ndhoa"]=u"நோ"
    table["ndhoe"]=u"நோ"
    table["nthO"]=u"நோ"
    table["nthoa"]=u"நோ"
    table["nthoe"]=u"நோ"
    table["nhoa"]=u"நோ"
    table["nhou"]=u"நௌ"
    table["nhau"]=u"நௌ"
    table["now"]=u"நௌ"
    table["nou"]=u"நௌ"
    table["nau"]=u"நௌ"
    table["ndhow"]=u"நௌ"
    table["ndhou"]=u"நௌ"
    table["ndhau"]=u"நௌ"
    table["nthow"]=u"நௌ"
    table["nthou"]=u"நௌ"
    table["nthau"]=u"நௌ"
    table["nhow"]=u"நௌ"
    table["n"]=u"ந்"
    table["ndh"]=u"ந்"
    table["nth"]=u"ந்"
    table["nh"]=u"ந்"
    table["ba"]=u"ப"
    table["bha"]=u"ப"
    table["fa"]=u"ப"
    table["pha"]=u"ப"
    table["pa"]=u"ப"
    table["pA"]=u"பா"
    table["baa"]=u"பா"
    table["bA"]=u"பா"
    table["bhaa"]=u"பா"
    table["bhA"]=u"பா"
    table["fA"]=u"பா"
    table["faa"]=u"பா"
    table["phA"]=u"பா"
    table["phaa"]=u"பா"
    table["paa"]=u"பா"
    table["bi"]=u"பி"
    table["bhi"]=u"பி"
    table["fi"]=u"பி"
    table["phi"]=u"பி"
    table["pi"]=u"பி"
    table["pee"]=u"பீ"
    table["pI"]=u"பீ"
    table["bee"]=u"பீ"
    table["bI"]=u"பீ"
    table["bii"]=u"பீ"
    table["bhee"]=u"பீ"
    table["bhI"]=u"பீ"
    table["bhii"]=u"பீ"
    table["fee"]=u"பீ"
    table["fI"]=u"பீ"
    table["fii"]=u"பீ"
    table["phee"]=u"பீ"
    table["phI"]=u"பீ"
    table["phii"]=u"பீ"
    table["pii"]=u"பீ"
    table["bu"]=u"பு"
    table["bhu"]=u"பு"
    table["fu"]=u"பு"
    table["phu"]=u"பு"
    table["pu"]=u"பு"
    table["poo"]=u"பூ"
    table["pU"]=u"பூ"
    table["boo"]=u"பூ"
    table["bU"]=u"பூ"
    table["buu"]=u"பூ"
    table["bhoo"]=u"பூ"
    table["bhU"]=u"பூ"
    table["bhuu"]=u"பூ"
    table["foo"]=u"பூ"
    table["fU"]=u"பூ"
    table["fuu"]=u"பூ"
    table["phoo"]=u"பூ"
    table["phU"]=u"பூ"
    table["phuu"]=u"பூ"
    table["puu"]=u"பூ"
    table["be"]=u"பெ"
    table["bhe"]=u"பெ"
    table["fe"]=u"பெ"
    table["phe"]=u"பெ"
    table["pe"]=u"பெ"
    table["pE"]=u"பே"
    table["bE"]=u"பே"
    table["bae"]=u"பே"
    table["bhE"]=u"பே"
    table["bhae"]=u"பே"
    table["fE"]=u"பே"
    table["fae"]=u"பே"
    table["phE"]=u"பே"
    table["phae"]=u"பே"
    table["pae"]=u"பே"
    table["bai"]=u"பை"
    table["bhai"]=u"பை"
    table["fai"]=u"பை"
    table["phai"]=u"பை"
    table["pai"]=u"பை"
    table["bo"]=u"பொ"
    table["bho"]=u"பொ"
    table["fo"]=u"பொ"
    table["pho"]=u"பொ"
    table["po"]=u"பொ"
    table["pO"]=u"போ"
    table["poe"]=u"போ"
    table["bO"]=u"போ"
    table["boa"]=u"போ"
    table["boe"]=u"போ"
    table["bhO"]=u"போ"
    table["bhoa"]=u"போ"
    table["bhoe"]=u"போ"
    table["fO"]=u"போ"
    table["foa"]=u"போ"
    table["foe"]=u"போ"
    table["phO"]=u"போ"
    table["phoa"]=u"போ"
    table["phoe"]=u"போ"
    table["poa"]=u"போ"
    table["pou"]=u"பௌ"
    table["pau"]=u"பௌ"
    table["bow"]=u"பௌ"
    table["bou"]=u"பௌ"
    table["bau"]=u"பௌ"
    table["bhow"]=u"பௌ"
    table["bhou"]=u"பௌ"
    table["bhau"]=u"பௌ"
    table["fow"]=u"பௌ"
    table["fou"]=u"பௌ"
    table["fau"]=u"பௌ"
    table["phow"]=u"பௌ"
    table["phou"]=u"பௌ"
    table["phau"]=u"பௌ"
    table["pow"]=u"பௌ"
    table["b"]=u"ப்"
    table["bh"]=u"ப்"
    table["f"]=u"ப்"
    table["ph"]=u"ப்"
    table["p"]=u"ப்"
    table["ma"]=u"ம"
    table["mA"]=u"மா"
    table["maa"]=u"மா"
    table["mi"]=u"மி"
    table["mee"]=u"மீ"
    table["mI"]=u"மீ"
    table["mii"]=u"மீ"
    table["mu"]=u"மு"
    table["moo"]=u"மூ"
    table["mU"]=u"மூ"
    table["muu"]=u"மூ"
    table["me"]=u"மெ"
    table["mE"]=u"மே"
    table["mae"]=u"மே"
    table["mai"]=u"மை"
    table["mo"]=u"மொ"
    table["mO"]=u"மோ"
    table["moe"]=u"மோ"
    table["moa"]=u"மோ"
    table["mou"]=u"மௌ"
    table["mau"]=u"மௌ"
    table["mow"]=u"மௌ"
    table["m"]=u"ம்"
    table["ya"]=u"ய"
    table["yA"]=u"யா"
    table["yaa"]=u"யா"
    table["yi"]=u"யி"
    table["yee"]=u"யீ"
    table["yI"]=u"யீ"
    table["yii"]=u"யீ"
    table["yu"]=u"யு"
    table["yoo"]=u"யூ"
    table["yU"]=u"யூ"
    table["yuu"]=u"யூ"
    table["ye"]=u"யெ"
    table["yE"]=u"யே"
    table["yae"]=u"யே"
    table["yai"]=u"யை"
    table["yo"]=u"யொ"
    table["yO"]=u"யோ"
    table["yoe"]=u"யோ"
    table["yoa"]=u"யோ"
    table["you"]=u"யௌ"
    table["yau"]=u"யௌ"
    table["yow"]=u"யௌ"
    table["y"]=u"ய்"
    table["ra"]=u"ர"
    table["rA"]=u"ரா"
    table["raa"]=u"ரா"
    table["ri"]=u"ரி"
    table["ree"]=u"ரீ"
    table["rI"]=u"ரீ"
    table["rii"]=u"ரீ"
    table["ru"]=u"ரு"
    table["roo"]=u"ரூ"
    table["rU"]=u"ரூ"
    table["ruu"]=u"ரூ"
    table["re"]=u"ரெ"
    table["rE"]=u"ரே"
    table["rae"]=u"ரே"
    table["rai"]=u"ரை"
    table["ro"]=u"ரொ"
    table["rO"]=u"ரோ"
    table["roe"]=u"ரோ"
    table["roa"]=u"ரோ"
    table["rou"]=u"ரௌ"
    table["rau"]=u"ரௌ"
    table["row"]=u"ரௌ"
    table["r"]=u"ர்"
    table["la"]=u"ல"
    table["lA"]=u"லா"
    table["laa"]=u"லா"
    table["li"]=u"லி"
    table["lee"]=u"லீ"
    table["lI"]=u"லீ"
    table["lii"]=u"லீ"
    table["lu"]=u"லு"
    table["loo"]=u"லூ"
    table["lU"]=u"லூ"
    table["luu"]=u"லூ"
    table["le"]=u"லெ"
    table["lE"]=u"லே"
    table["lae"]=u"லே"
    table["lai"]=u"லை"
    table["lo"]=u"லொ"
    table["lO"]=u"லோ"
    table["loe"]=u"லோ"
    table["loa"]=u"லோ"
    table["lou"]=u"லௌ"
    table["lau"]=u"லௌ"
    table["low"]=u"லௌ"
    table["l"]=u"ல்"
    table["wa"]=u"வ"
    table["va"]=u"வ"
    table["vA"]=u"வா"
    table["waa"]=u"வா"
    table["wA"]=u"வா"
    table["vaa"]=u"வா"
    table["wi"]=u"வி"
    table["vi"]=u"வி"
    table["vee"]=u"வீ"
    table["vI"]=u"வீ"
    table["wee"]=u"வீ"
    table["wI"]=u"வீ"
    table["wii"]=u"வீ"
    table["vii"]=u"வீ"
    table["wu"]=u"வு"
    table["vu"]=u"வு"
    table["voo"]=u"வூ"
    table["vU"]=u"வூ"
    table["woo"]=u"வூ"
    table["wU"]=u"வூ"
    table["wuu"]=u"வூ"
    table["vuu"]=u"வூ"
    table["we"]=u"வெ"
    table["ve"]=u"வெ"
    table["vE"]=u"வே"
    table["wE"]=u"வே"
    table["wae"]=u"வே"
    table["vae"]=u"வே"
    table["wai"]=u"வை"
    table["vai"]=u"வை"
    table["wo"]=u"வொ"
    table["vo"]=u"வொ"
    table["vO"]=u"வோ"
    table["voe"]=u"வோ"
    table["wO"]=u"வோ"
    table["woa"]=u"வோ"
    table["woe"]=u"வோ"
    table["voa"]=u"வோ"
    table["vou"]=u"வௌ"
    table["vau"]=u"வௌ"
    table["wow"]=u"வௌ"
    table["wou"]=u"வௌ"
    table["wau"]=u"வௌ"
    table["vow"]=u"வௌ"
    table["w"]=u"வ்"
    table["v"]=u"வ்"
    table["zha"]=u"ழ"
    table["za"]=u"ழ"
    table["zA"]=u"ழா"
    table["zhaa"]=u"ழா"
    table["zhA"]=u"ழா"
    table["zaa"]=u"ழா"
    table["zhi"]=u"ழி"
    table["zi"]=u"ழி"
    table["zee"]=u"ழீ"
    table["zI"]=u"ழீ"
    table["zhee"]=u"ழீ"
    table["zhI"]=u"ழீ"
    table["zhii"]=u"ழீ"
    table["zii"]=u"ழீ"
    table["zhu"]=u"ழு"
    table["zu"]=u"ழு"
    table["zoo"]=u"ழூ"
    table["zU"]=u"ழூ"
    table["zhoo"]=u"ழூ"
    table["zhU"]=u"ழூ"
    table["zhuu"]=u"ழூ"
    table["zuu"]=u"ழூ"
    table["zhe"]=u"ழெ"
    table["ze"]=u"ழெ"
    table["zE"]=u"ழே"
    table["zhE"]=u"ழே"
    table["zhae"]=u"ழே"
    table["zae"]=u"ழே"
    table["zhai"]=u"ழை"
    table["zai"]=u"ழை"
    table["zho"]=u"ழொ"
    table["zo"]=u"ழொ"
    table["zO"]=u"ழோ"
    table["zoe"]=u"ழோ"
    table["zhO"]=u"ழோ"
    table["zhoa"]=u"ழோ"
    table["zhoe"]=u"ழோ"
    table["zoa"]=u"ழோ"
    table["zou"]=u"ழௌ"
    table["zau"]=u"ழௌ"
    table["zhow"]=u"ழௌ"
    table["zhou"]=u"ழௌ"
    table["zhau"]=u"ழௌ"
    table["zow"]=u"ழௌ"
    table["zh"]=u"ழ்"
    table["z"]=u"ழ்"
    table["La"]=u"ள"
    table["LA"]=u"ளா"
    table["Laa"]=u"ளா"
    table["Li"]=u"ளி"
    table["Lee"]=u"ளீ"
    table["LI"]=u"ளீ"
    table["Lii"]=u"ளீ"
    table["Lu"]=u"ளு"
    table["Loo"]=u"ளூ"
    table["LU"]=u"ளூ"
    table["Luu"]=u"ளூ"
    table["Le"]=u"ளெ"
    table["LE"]=u"ளே"
    table["Lae"]=u"ளே"
    table["Lai"]=u"ளை"
    table["Lo"]=u"ளொ"
    table["LO"]=u"ளோ"
    table["Loe"]=u"ளோ"
    table["Loa"]=u"ளோ"
    table["Lou"]=u"ளௌ"
    table["Lau"]=u"ளௌ"
    table["Low"]=u"ளௌ"
    table["L"]=u"ள்"
    table["tra"]=u"ற"
    table["dra"]=u"ற"
    table["Ra"]=u"ற"
    table["RA"]=u"றா"
    table["traa"]=u"றா"
    table["trA"]=u"றா"
    table["draa"]=u"றா"
    table["drA"]=u"றா"
    table["Raa"]=u"றா"
    table["tri"]=u"றி"
    table["dri"]=u"றி"
    table["Ri"]=u"றி"
    table["Ree"]=u"றீ"
    table["RI"]=u"றீ"
    table["tree"]=u"றீ"
    table["trI"]=u"றீ"
    table["trii"]=u"றீ"
    table["dree"]=u"றீ"
    table["drI"]=u"றீ"
    table["drii"]=u"றீ"
    table["Rii"]=u"றீ"
    table["tru"]=u"று"
    table["dru"]=u"று"
    table["Ru"]=u"று"
    table["Roo"]=u"றூ"
    table["RU"]=u"றூ"
    table["troo"]=u"றூ"
    table["trU"]=u"றூ"
    table["truu"]=u"றூ"
    table["droo"]=u"றூ"
    table["drU"]=u"றூ"
    table["druu"]=u"றூ"
    table["Ruu"]=u"றூ"
    table["tre"]=u"றெ"
    table["dre"]=u"றெ"
    table["Re"]=u"றெ"
    table["RE"]=u"றே"
    table["trE"]=u"றே"
    table["trae"]=u"றே"
    table["drE"]=u"றே"
    table["drae"]=u"றே"
    table["Rae"]=u"றே"
    table["trai"]=u"றை"
    table["drai"]=u"றை"
    table["Rai"]=u"றை"
    table["tro"]=u"றொ"
    table["dro"]=u"றொ"
    table["Ro"]=u"றொ"
    table["RO"]=u"றோ"
    table["Roe"]=u"றோ"
    table["trO"]=u"றோ"
    table["troa"]=u"றோ"
    table["troe"]=u"றோ"
    table["drO"]=u"றோ"
    table["droa"]=u"றோ"
    table["droe"]=u"றோ"
    table["Roa"]=u"றோ"
    table["Rou"]=u"றௌ"
    table["Rau"]=u"றௌ"
    table["trow"]=u"றௌ"
    table["trou"]=u"றௌ"
    table["trau"]=u"றௌ"
    table["drow"]=u"றௌ"
    table["drou"]=u"றௌ"
    table["drau"]=u"றௌ"
    table["Row"]=u"றௌ"
    table["tr"]=u"ற்"
    table["dr"]=u"ற்"
    table["R"]=u"ற்"
    table["nHa"]=u"ன"
    table["na"]=u"ன"
    table["nA"]=u"னா"
    table["nHaa"]=u"னா"
    table["nHA"]=u"னா"
    table["naa"]=u"னா"
    table["nHi"]=u"னி"
    table["ni"]=u"னி"
    table["nee"]=u"னீ"
    table["nI"]=u"னீ"
    table["nHee"]=u"னீ"
    table["nHI"]=u"னீ"
    table["nHii"]=u"னீ"
    table["nii"]=u"னீ"
    table["nHu"]=u"னு"
    table["nu"]=u"னு"
    table["noo"]=u"னூ"
    table["nU"]=u"னூ"
    table["nHoo"]=u"னூ"
    table["nHU"]=u"னூ"
    table["nHuu"]=u"னூ"
    table["nuu"]=u"னூ"
    table["nHe"]=u"னெ"
    table["ne"]=u"னெ"
    table["nE"]=u"னே"
    table["nHE"]=u"னே"
    table["nHae"]=u"னே"
    table["nae"]=u"னே"
    table["nHai"]=u"னை"
    table["nai"]=u"னை"
    table["nHo"]=u"னொ"
    table["no"]=u"னொ"
    table["nO"]=u"னோ"
    table["noe"]=u"னோ"
    table["nHO"]=u"னோ"
    table["nHoa"]=u"னோ"
    table["nHoe"]=u"னோ"
    table["noa"]=u"னோ"
    table["nou"]=u"னௌ"
    table["nau"]=u"னௌ"
    table["nHow"]=u"னௌ"
    table["nHou"]=u"னௌ"
    table["nHau"]=u"னௌ"
    table["now"]=u"னௌ"
    table["n"]=u"ன்"
    table["nH"]=u"ன்"
    table["La"]=u"ள"
    table["Laa"]=u"ளா"
    table["LA"]=u"ளா"
    table["Li"]=u"ளி"
    table["Lee"]=u"ளீ"
    table["LI"]=u"ளீ"
    table["Lii"]=u"ளீ"
    table["Lu"]=u"ளு"
    table["Luu"]=u"ளூ"
    table["Loo"]=u"ளூ"
    table["LU"]=u"ளூ"
    table["Le"]=u"ளெ"
    table["LE"]=u"ளே"
    table["Lae"]=u"ளே"
    table["Lai"]=u"ளை"
    table["Lo"]=u"ளொ"
    table["Loa"]=u"ளோ"
    table["LO"]=u"ளோ"
    table["Loe"]=u"ளோ"
    table["Low"]=u"ளௌ"
    table["Lou"]=u"ளௌ"
    table["Lau"]=u"ளௌ"
    table["ja"]=u"ஜ"
    table["jaa"]=u"ஜா"
    table["ji"]=u"ஜி"
    table["jii"]=u"ஜீ"
    table["ju"]=u"ஜு"
    table["juu"]=u"ஜூ"
    table["je"]=u"ஜெ"
    table["jae"]=u"ஜே"
    table["jai"]=u"ஜை"
    table["jo"]=u"ஜொ"
    table["joa"]=u"ஜோ"
    table["jow"]=u"ஜௌ"
    table["j"]=u"ஜ்"
    table["sha"]=u"ஷ"
    table["shaa"]=u"ஷா"
    table["shi"]=u"ஷி"
    table["shii"]=u"ஷீ"
    table["shu"]=u"ஷு"
    table["shuu"]=u"ஷூ"
    table["she"]=u"ஷெ"
    table["shae"]=u"ஷே"
    table["shai"]=u"ஷை"
    table["sho"]=u"ஷொ"
    table["shoa"]=u"ஷோ"
    table["show"]=u"ஷௌ"
    table["sh"]=u"ஷ்"
    table["Sa"]=u"ஸ"
    table["Saa"]=u"ஸா"
    table["Si"]=u"ஸி"
    table["Sii"]=u"ஸீ"
    table["Su"]=u"ஸு"
    table["Suu"]=u"ஸூ"
    table["Se"]=u"ஸெ"
    table["Sae"]=u"ஸே"
    table["Sai"]=u"ஸை"
    table["So"]=u"ஸொ"
    table["Soa"]=u"ஸோ"
    table["Sow"]=u"ஸௌ"
    table["S"]=u"ஸ்"
    table["ha"]=u"ஹ"
    table["haa"]=u"ஹா"
    table["hi"]=u"ஹி"
    table["hii"]=u"ஹீ"
    table["hu"]=u"ஹு"
    table["huu"]=u"ஹூ"
    table["he"]=u"ஹெ"
    table["hae"]=u"ஹே"
    table["hai"]=u"ஹை"
    table["ho"]=u"ஹொ"
    table["hoa"]=u"ஹோ"
    table["how"]=u"ஹௌ"
    table["h"]=u"ஹ்"
    table["ksha"]=u"க்ஷ"
    table["kshaa"]=u"க்ஷா"
    table["kshi"]=u"க்ஷி"
    table["kshii"]=u"க்ஷீ"
    table["kshu"]=u"க்ஷு"
    table["kshuu"]=u"க்ஷூ"
    table["kshe"]=u"க்ஷெ"
    table["kshae"]=u"க்ஷே"
    table["kshai"]=u"க்ஷை"
    table["ksho"]=u"க்ஷொ"
    table["kshoa"]=u"க்ஷோ"
    table["kshow"]=u"க்ஷௌ"
    table["ksh"]=u"க்ஷ்"
    table["sri"]=u"ஸ்ரீ"
    table["sree"]=u"ஸ்ரீ"
    table["shree"]=u"ஸ்ரீ"
    table["shri"]=u"ஸ்ரீ"
    table["fa"]=u"ஃப"
    table["faa"]=u"ஃபா"
    table["fi"]=u"ஃபி"
    table["fii"]=u"ஃபீ"
    table["fu"]=u"ஃபு"
    table["fuu"]=u"ஃபூ"
    table["fe"]=u"ஃபெ"
    table["fae"]=u"ஃபே"
    table["fai"]=u"ஃபை"
    table["fo"]=u"ஃபொ"
    table["foa"]=u"ஃபோ"
    table["fow"]=u"ஃபௌ"
    table["f"]=u"ஃப்"
    table["Za"]=u"ஃஜ"
    table["Zaa"]=u"ஃஜா"
    table["Zi"]=u"ஃஜி"
    table["Zii"]=u"ஃஜீ"
    table["Zu"]=u"ஃஜு"
    table["Zuu"]=u"ஃஜூ"
    table["Ze"]=u"ஃஜெ"
    table["Zae"]=u"ஃஜே"
    table["Zai"]=u"ஃஜை"
    table["Zo"]=u"ஃஜொ"
    table["Zoa"]=u"ஃஜோ"
    table["Zow"]=u"ஃஜௌ"
    table["Z"]=u"ஃஜ்"
    table["xa"]=u"ஃஸ"
    table["xaa"]=u"ஃஸா"
    table["xi"]=u"ஃஸி"
    table["xu"]=u"ஃஸு"
    table["xuu"]=u"ஃஸூ"
    table["xe"]=u"ஃஸெ"
    table["xae"]=u"ஃஸே"
    table["xai"]=u"ஃஸை"
    table["xo"]=u"ஃஸொ"
    table["xoa"]=u"ஃஸோ"
    table["xow"]=u"ஃஸௌ"
    table["x"]=u"ஃஸ்"
    table["1"]=u"௧"
    table["2"]=u"௨"
    table["3"]=u"௩"
    table["4"]=u"௪"
    table["5"]=u"௫"
    table["6"]=u"௬"
    table["7"]=u"௭"
    table["8"]=u"௮"
    table["9"]=u"௯"
    table["10"]=u"௰"
    table["1000"]=u"௲"
