# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobCollectionDefinition(Model):
    """JobCollectionDefinition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Gets the job collection resource identifier.
    :vartype id: str
    :ivar type: Gets the job collection resource type.
    :vartype type: str
    :param name: Gets or sets the job collection resource name.
    :type name: str
    :param location: Gets or sets the storage account location.
    :type location: str
    :param tags: Gets or sets the tags.
    :type tags: dict
    :param properties: Gets or sets the job collection properties.
    :type properties: :class:`JobCollectionProperties
     <azure.mgmt.scheduler.models.JobCollectionProperties>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'JobCollectionProperties'},
    }

    def __init__(self, name=None, location=None, tags=None, properties=None):
        self.id = None
        self.type = None
        self.name = name
        self.location = location
        self.tags = tags
        self.properties = properties
