import numpy as np
from numpy.testing import assert_almost_equal, assert_
#import statsmodels.api as sm
from statsmodels.nonparametric.smoothers_lowess import lowess


class  TestLowess(object):

    def test_import(self):
        #this doesn't work
        #from statsmodels.api.nonparametric import lowess as lowess1
        import statsmodels.api as sm
        lowess1 = sm.nonparametric.lowess
        assert_(lowess is lowess1)
        #backwards compatible for 0.4
        from statsmodels.nonparametric.lowess import lowess as lowess2
        assert_(lowess is lowess2)

    def test_simple(self):

        x = np.arange(20, dtype='float32')
        #standard normal noise
        noise = np.array([-0.76741118, -0.30754369,
                            0.39950921, -0.46352422, -1.67081778,
                            0.6595567 ,  0.66367639, -2.04388585,
                            0.8123281 ,  1.45977518,
                            1.21428038,  1.29296866,  0.78028477,
                            -0.2402853 , -0.21721302,
                            0.24549405,  0.25987014, -0.90709034,
                            -1.45688216, -0.31780505])
        y = x + noise

        # R output
        out = [-0.6260344553, 0.565071712, 1.759627189,
                2.9579633258, 4.1560636154, 5.3473396937,
                6.522298218, 7.708159388, 8.8759055519,
                9.9409758603, 10.8981138458, 11.7851424728,
                12.6188717297, 13.4098497374, 14.1516996585,
                14.9180658147, 15.6956600199, 16.4783034134,
                17.2617441531, 18.0459201716]

        expected_lowess = np.array([x, out]).T

        actual_lowess = lowess(y,x)

        assert_almost_equal(expected_lowess, actual_lowess)

    def test_iter(self):

        x = np.arange(20, dtype='float32')
        #cauchy noise
        noise = np.array([ 1.86299605, -0.10816866,  1.87761229,
                        -3.63442237,  0.30249022,
                        1.03560416,  0.21163349,  1.14167809,
                        -0.00368175, -2.08808987,
                        0.13065417, -1.8052207 ,  0.60404596,
                        -2.30908204,  1.7081412 ,
                        -0.54633243, -0.93107948,  1.79023999,
                        1.05822445, -1.04530564])

        y = x + noise

        # R output
        out = [0.6264479483, 1.5008396363, 2.3861761926, 3.2716390242,
               4.1397266375, 4.9926614002, 5.9062225, 6.8541464784,
               7.8163358136, 8.6684661827, 9.5321215273, 10.4655376106,
               11.469691774, 12.612670578, 13.8080457514, 14.9355218409,
               16.0491183613, 17.1604998952, 18.2739171976, 19.3834268539]


        expected_lowess_no_iter = np.array([x, out]).T

        out = [1.1091939965, 1.9662338415, 2.8223436958, 3.6741660675,
               4.5153163696, 5.3483205165, 6.2127611584, 7.0371035909,
               7.8823844068, 8.7036783127, 9.5698728732, 10.5011237563,
               11.4924301926, 12.6180333554, 13.8056705213, 14.9280791108,
               16.0363681325, 17.1426206341, 18.2516511313, 19.3581200948]

        expected_lowess_3_iter = np.array([x, out]).T

        actual_lowess_no_iter = lowess(y,x,it=0)
        actual_lowess_3_iter = lowess(y,x,it=3)

        assert_almost_equal(expected_lowess_no_iter, actual_lowess_no_iter)
        assert_almost_equal(expected_lowess_3_iter, actual_lowess_3_iter)

    def test_frac(self):

        #linspace from -2*pi to 2*pi with 30 points
        x = np.array([-6.28318531, -5.84986218,
                        -5.41653906, -4.98321593, -4.54989281,
                        -4.11656968, -3.68324656, -3.24992343,
                        -2.81660031, -2.38327719,
                        -1.94995406, -1.51663094, -1.08330781,
                        -0.64998469, -0.21666156,
                        0.21666156,  0.64998469,  1.08330781,
                        1.51663094,  1.94995406,
                        2.38327719,  2.81660031,  3.24992343,
                        3.68324656,  4.11656968,
                        4.54989281,  4.98321593,  5.41653906,
                        5.84986218,  6.28318531],
                        dtype='float32')

        #normal noise
        noise = np.array([ 1.62379338, -1.11849371,  1.60085673,
                            0.41996348,  0.70896754,
                            0.19271408,  0.04972776, -0.22411356,
                            0.18154882, -0.63651971,
                            0.64942414, -2.26509826,  0.80018964,
                            0.89826857, -0.09136105,
                            0.80482898,  1.54504686, -1.23734643,
                            -1.16572754,  0.28027691,
                            -0.85191583,  0.20417445,  0.61034806,
                            0.68297375,  1.45707167,
                            0.45157072, -1.13669622, -0.08552254,
                            -0.28368514, -0.17326155])

        y = np.sin(x) + noise

        # R output
        out = [1.8046611448, 1.6131161806, 1.4261750243, 1.2456232437,
               1.0726525743, 0.9078886862, 0.7508382846, 0.5995025425,
               0.4498245781, 0.2967048843, 0.2087946661, 0.140876587,
               0.0962675821, 0.0786932125, 0.0909461638, 0.1283179371,
               0.1792307713, 0.2229799061, 0.2420129212, 0.2271040447,
               0.1825971814, 0.0922474353, 0.00966894, -0.0694426067,
               -0.1487375865, -0.2304165138, -0.3160020917, -0.4060221341,
               -0.5000353633, -0.5970108165]

        expected_lowess_23 = np.array([x, out]).T

        out = [1.7442204356, 1.780854241, 1.8244230184, 1.7748683429,
               1.3903143795, 1.000014232, 0.5485738577, 0.0610231515,
               -0.3171727715, -0.486231173, -0.4514649389, -0.2481318403,
               -0.0237961837, 0.1049980654, 0.3973354411, 0.3637284562,
               0.2334379481, 0.0891119258, -0.0380804274, 0.1144301171,
               0.3015145173, 0.3382750669, 0.3708704952, 0.2975254453,
               -0.0025753083, -0.3315491452, -0.604601953, -0.7476857901,
               -0.5589514161, -0.3081313621]

        expected_lowess_15 = np.array([x, out]).T

        actual_lowess_23 = lowess(y,x,frac=2./3)
        actual_lowess_15 = lowess(y,x,frac=1./5)

        assert_almost_equal(expected_lowess_23, actual_lowess_23)
        #not sure why I get lower precision on the last test
        assert_almost_equal(expected_lowess_15, actual_lowess_15, decimal=6)


if __name__ == "__main__":
    import nose
    nose.runmodule(argv=[__file__, '-vvs', '-x', '--pdb'], exit=False)

