# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessModeSettings(_serialization.Model):
    """Properties that define the scope private link mode settings.

    All required parameters must be populated in order to send to Azure.

    :ivar query_access_mode: Specifies the default access mode of queries through associated
     private endpoints in scope. If not specified default value is 'Open'. You can override this
     default setting for a specific private endpoint connection by adding an exclusion in the
     'exclusions' array. Required. Known values are: "Open" and "PrivateOnly".
    :vartype query_access_mode: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
    :ivar ingestion_access_mode: Specifies the default access mode of ingestion through associated
     private endpoints in scope. If not specified default value is 'Open'. You can override this
     default setting for a specific private endpoint connection by adding an exclusion in the
     'exclusions' array. Required. Known values are: "Open" and "PrivateOnly".
    :vartype ingestion_access_mode: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
    :ivar exclusions: List of exclusions that override the default access mode settings for
     specific private endpoint connections.
    :vartype exclusions:
     list[~$(python-base-namespace).v2021_07_01_preview.models.AccessModeSettingsExclusion]
    """

    _validation = {
        "query_access_mode": {"required": True},
        "ingestion_access_mode": {"required": True},
    }

    _attribute_map = {
        "query_access_mode": {"key": "queryAccessMode", "type": "str"},
        "ingestion_access_mode": {"key": "ingestionAccessMode", "type": "str"},
        "exclusions": {"key": "exclusions", "type": "[AccessModeSettingsExclusion]"},
    }

    def __init__(
        self,
        *,
        query_access_mode: Union[str, "_models.AccessMode"],
        ingestion_access_mode: Union[str, "_models.AccessMode"],
        exclusions: Optional[List["_models.AccessModeSettingsExclusion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query_access_mode: Specifies the default access mode of queries through associated
         private endpoints in scope. If not specified default value is 'Open'. You can override this
         default setting for a specific private endpoint connection by adding an exclusion in the
         'exclusions' array. Required. Known values are: "Open" and "PrivateOnly".
        :paramtype query_access_mode: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
        :keyword ingestion_access_mode: Specifies the default access mode of ingestion through
         associated private endpoints in scope. If not specified default value is 'Open'. You can
         override this default setting for a specific private endpoint connection by adding an exclusion
         in the 'exclusions' array. Required. Known values are: "Open" and "PrivateOnly".
        :paramtype ingestion_access_mode: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
        :keyword exclusions: List of exclusions that override the default access mode settings for
         specific private endpoint connections.
        :paramtype exclusions:
         list[~$(python-base-namespace).v2021_07_01_preview.models.AccessModeSettingsExclusion]
        """
        super().__init__(**kwargs)
        self.query_access_mode = query_access_mode
        self.ingestion_access_mode = ingestion_access_mode
        self.exclusions = exclusions


class AccessModeSettingsExclusion(_serialization.Model):
    """Properties that define the scope private link mode settings exclusion item. This setting
    applies to a specific private endpoint connection and overrides the default settings for that
    private endpoint connection.

    :ivar private_endpoint_connection_name: The private endpoint connection name associated to the
     private endpoint on which we want to apply the specific access mode settings.
    :vartype private_endpoint_connection_name: str
    :ivar query_access_mode: Specifies the access mode of queries through the specified private
     endpoint connection in the exclusion. Known values are: "Open" and "PrivateOnly".
    :vartype query_access_mode: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
    :ivar ingestion_access_mode: Specifies the access mode of ingestion through the specified
     private endpoint connection in the exclusion. Known values are: "Open" and "PrivateOnly".
    :vartype ingestion_access_mode: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
    """

    _attribute_map = {
        "private_endpoint_connection_name": {"key": "privateEndpointConnectionName", "type": "str"},
        "query_access_mode": {"key": "queryAccessMode", "type": "str"},
        "ingestion_access_mode": {"key": "ingestionAccessMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint_connection_name: Optional[str] = None,
        query_access_mode: Optional[Union[str, "_models.AccessMode"]] = None,
        ingestion_access_mode: Optional[Union[str, "_models.AccessMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint_connection_name: The private endpoint connection name associated to
         the private endpoint on which we want to apply the specific access mode settings.
        :paramtype private_endpoint_connection_name: str
        :keyword query_access_mode: Specifies the access mode of queries through the specified private
         endpoint connection in the exclusion. Known values are: "Open" and "PrivateOnly".
        :paramtype query_access_mode: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
        :keyword ingestion_access_mode: Specifies the access mode of ingestion through the specified
         private endpoint connection in the exclusion. Known values are: "Open" and "PrivateOnly".
        :paramtype ingestion_access_mode: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.AccessMode
        """
        super().__init__(**kwargs)
        self.private_endpoint_connection_name = private_endpoint_connection_name
        self.query_access_mode = query_access_mode
        self.ingestion_access_mode = ingestion_access_mode


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AzureMonitorPrivateLinkScope(TrackedResource):
    """An Azure Monitor PrivateLinkScope definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: System data.
    :vartype system_data: ~$(python-base-namespace).v2021_07_01_preview.models.SystemData
    :ivar provisioning_state: Current state of this PrivateLinkScope: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
    :vartype provisioning_state: str
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointConnection]
    :ivar access_mode_settings: Access mode settings. Required.
    :vartype access_mode_settings:
     ~$(python-base-namespace).v2021_07_01_preview.models.AccessModeSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "access_mode_settings": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "access_mode_settings": {"key": "properties.accessModeSettings", "type": "AccessModeSettings"},
    }

    def __init__(
        self,
        *,
        location: str,
        access_mode_settings: "_models.AccessModeSettings",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword access_mode_settings: Access mode settings. Required.
        :paramtype access_mode_settings:
         ~$(python-base-namespace).v2021_07_01_preview.models.AccessModeSettings
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.private_endpoint_connections = None
        self.access_mode_settings = access_mode_settings


class AzureMonitorPrivateLinkScopeListResult(_serialization.Model):
    """Describes the list of Azure Monitor PrivateLinkScope resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of Azure Monitor PrivateLinkScope definitions. Required.
    :vartype value:
     list[~$(python-base-namespace).v2021_07_01_preview.models.AzureMonitorPrivateLinkScope]
    :ivar next_link: The URI to get the next set of Azure Monitor PrivateLinkScope definitions if
     too many PrivateLinkScopes where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureMonitorPrivateLinkScope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AzureMonitorPrivateLinkScope"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Monitor PrivateLinkScope definitions. Required.
        :paramtype value:
         list[~$(python-base-namespace).v2021_07_01_preview.models.AzureMonitorPrivateLinkScope]
        :keyword next_link: The URI to get the next set of Azure Monitor PrivateLinkScope definitions
         if too many PrivateLinkScopes where returned in the result set.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DefaultErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~$(python-base-namespace).v2021_07_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~$(python-base-namespace).v2021_07_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~$(python-base-namespace).v2021_07_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~$(python-base-namespace).v2021_07_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class OperationStatus(_serialization.Model):
    """The status of operation.

    :ivar id: The operation Id.
    :vartype id: str
    :ivar name: The operation name.
    :vartype name: str
    :ivar start_time: Start time of the job in standard ISO8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the job in standard ISO8601 format.
    :vartype end_time: ~datetime.datetime
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The error detail of the operation if any.
    :vartype error: ~$(python-base-namespace).v2021_07_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The operation Id.
        :paramtype id: str
        :keyword name: The operation name.
        :paramtype name: str
        :keyword start_time: Start time of the job in standard ISO8601 format.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the job in standard ISO8601 format.
        :paramtype end_time: ~datetime.datetime
        :keyword status: The status of the operation.
        :paramtype status: str
        :keyword error: The error detail of the operation if any.
        :paramtype error: ~$(python-base-namespace).v2021_07_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~$(python-base-namespace).v2021_07_01_preview.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint:
         ~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~$(python-base-namespace).v2021_07_01_preview.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value:
     list[~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value:
         list[~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~$(python-base-namespace).v2021_07_01_preview.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value:
         list[~$(python-base-namespace).v2021_07_01_preview.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ScopedResource(ProxyResource):
    """A private link scoped resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: System data.
    :vartype system_data: ~$(python-base-namespace).v2021_07_01_preview.models.SystemData
    :ivar linked_resource_id: The resource id of the scoped Azure monitor resource.
    :vartype linked_resource_id: str
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "linked_resource_id": {"key": "properties.linkedResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, linked_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword linked_resource_id: The resource id of the scoped Azure monitor resource.
        :paramtype linked_resource_id: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.linked_resource_id = linked_resource_id
        self.provisioning_state = None


class ScopedResourceListResult(_serialization.Model):
    """A list of scoped resources in a private link scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~$(python-base-namespace).v2021_07_01_preview.models.ScopedResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScopedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~$(python-base-namespace).v2021_07_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~$(python-base-namespace).v2021_07_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    PrivateLinkScope instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
