/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.util.text.StrMatcher;
import org.ow2.proactive.scheduler.common.util.text.StrSubstitutor;
import org.ow2.proactive.scripting.Script;

public class VariableSubstitutor {
    public static final String SUBSITUTE_PREFIX = "${";
    public static final String SUBSITUTE_PREFIX_SIMPLE = "$";
    public static final String SUBSTITUTE_SUFFIX = "}";
    private static final char DOLLAR = '$';
    private static final char LCB = '{';
    private static final char RCB = '}';
    private static final char DASH = '-';
    private static final char DOT = '.';
    private static final char UND = '_';

    private VariableSubstitutor() {
    }

    public static Map<String, String> filterAndUpdate(Map<String, String> input, Map<String, ? extends Serializable> variables) {
        HashMap<String, String> result = new HashMap<String, String>(variables.size());
        for (Map.Entry<String, String> entry : input.entrySet()) {
            result.put(entry.getKey(), VariableSubstitutor.filterAndUpdate(entry.getValue(), variables));
        }
        return result;
    }

    public static Map<String, Serializable> resolveVariables(Map<String, Serializable> variables, Map<String, Serializable> dictionary) {
        StrSubstitutor substitutor = VariableSubstitutor.buildSubstitutor(dictionary);
        HashMap<String, Serializable> resolvedVariables = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : variables.entrySet()) {
            if (entry.getValue() instanceof String) {
                resolvedVariables.put(entry.getKey(), (Serializable)((Object)substitutor.replace((String)((Object)entry.getValue()))));
                continue;
            }
            resolvedVariables.put(entry.getKey(), entry.getValue());
        }
        return resolvedVariables;
    }

    public static String filterAndUpdate(String input, Map<? extends Serializable, ? extends Serializable> variables) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String output = input;
        StrSubstitutor substitutor = VariableSubstitutor.buildSubstitutor(variables);
        output = VariableSubstitutor.replaceRecursively(output, substitutor);
        return output;
    }

    private static String replaceRecursively(String value, StrSubstitutor substitutor) {
        return substitutor.replace(value);
    }

    public static void filterAndUpdate(Script<?> script, Map<? extends Serializable, ? extends Serializable> variables) {
        script.setScript(VariableSubstitutor.filterAndUpdate(script.getScript(), variables));
        Serializable[] params = script.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                params[i] = VariableSubstitutor.filterAndUpdate(params[i].toString(), variables);
            }
        }
    }

    public static StrSubstitutor buildSubstitutor(Map<? extends Serializable, ? extends Serializable> variables) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (variables != null) {
            for (Map.Entry<? extends Serializable, ? extends Serializable> variable : variables.entrySet()) {
                if (variable.getValue() == null) continue;
                String key = variable.getKey().toString();
                String value = variable.getValue().toString();
                replacements.put(key, value);
                replacements.put(key.toUpperCase().replace(".", "_"), value);
            }
        }
        StrSubstitutor substitutor = new StrSubstitutor(replacements, SUBSITUTE_PREFIX, SUBSTITUTE_SUFFIX, '\u0000');
        substitutor.setVariablePrefixMatcher(new StrMatcher(){

            @Override
            public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
                if (pos + 1 == bufferEnd) {
                    return -1;
                }
                char firstChar = buffer[pos];
                char secondChar = buffer[pos + 1];
                if (firstChar == '$') {
                    if (secondChar == '{') {
                        return 2;
                    }
                    if (Character.isLetterOrDigit(secondChar)) {
                        return 1;
                    }
                    switch (secondChar) {
                        case '-': 
                        case '.': 
                        case '_': {
                            return 1;
                        }
                    }
                }
                return -1;
            }
        });
        substitutor.setVariableSuffixMatcher(new StrMatcher(){

            @Override
            public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
                char aChar = buffer[pos];
                if (pos == bufferEnd) {
                    return 0;
                }
                if (Character.isLetterOrDigit(aChar)) {
                    return -1;
                }
                switch (aChar) {
                    case '-': 
                    case '.': 
                    case '_': {
                        return -1;
                    }
                }
                if (aChar == '}') {
                    return 1;
                }
                return 0;
            }
        });
        substitutor.setEnableSubstitutionInVariables(true);
        return substitutor;
    }
}

